/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import lsedit.HiGraph;
import lsedit.HiGraphException;

public class HiArc {
    private HiGraph m_from;
    private HiGraph m_to;
    private boolean m_inclusion;
    private boolean m_reversed = false;
    private int m_cutvalue = 0;
    private int m_weight = 0;
    private int m_minlength = 0;
    int m_fromX;
    int m_fromY;
    int m_toX;
    int m_toY;

    HiArc(HiGraph from_node, HiGraph to_node, boolean inclusion) {
        this.m_from = from_node;
        this.m_to = to_node;
        this.m_inclusion = inclusion;
    }

    HiArc(HiGraph from_node, HiGraph to_node) {
        this(from_node, to_node, false);
    }

    public String toString() {
        String s = "";
        s = "(weight=" + this.m_weight + " minlength=" + this.m_minlength + ")";
        if (this.m_from == null || this.m_to == null) {
            System.out.println("Broken arc");
        }
        String operator = this.m_inclusion ? "=" : "-";
        s = this.m_reversed ? s + this.m_from.label() + "<" + operator + this.m_to.label() : s + this.m_from.label() + operator + ">" + this.m_to.label();
        return s;
    }

    public HiGraph from() {
        return this.m_from;
    }

    void from(HiGraph value) {
        this.m_from = value;
    }

    public HiGraph to() {
        return this.m_to;
    }

    public boolean onSide() {
        return false;
    }

    public boolean inclusion() {
        return this.m_inclusion;
    }

    void reverse(boolean flag) {
        this.m_reversed = flag;
    }

    void reverse() {
        HiGraph temp = this.m_from;
        this.m_from = this.m_to;
        this.m_to = temp;
        this.m_reversed = !this.m_reversed;
    }

    boolean reversed() {
        return this.m_reversed;
    }

    void cutValue(int value) {
        this.m_cutvalue = value;
    }

    int cutValue() {
        return this.m_cutvalue;
    }

    public void setWeight(int value) {
        this.m_weight = value;
    }

    int getWeight() {
        return this.m_weight;
    }

    void setMinlength(int value) {
        this.m_minlength = value;
    }

    int getMinlength() {
        return this.m_minlength;
    }

    void dispose() throws HiGraphException {
        if (this.m_from == null) {
            throw new HiGraphException("Removing a non-existant arc");
        }
        this.m_from = null;
        this.m_to = null;
    }
}

