/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JComponent;
import lsedit.Diagram;
import lsedit.EditModeHandler;
import lsedit.EntityComponent;
import lsedit.EntityInstance;
import lsedit.LandscapeModeHandler;
import lsedit.RelationInstance;

public class GroupModeHandler
extends LandscapeModeHandler {
    protected static final int NONE = 0;
    protected static final int SINGLE_MOVE = 1;
    protected EditModeHandler m_parent;
    protected DrawOutline m_drawOutline;
    protected Vector m_groupList = null;
    protected int m_grpLayoutX;
    protected int m_grpLayoutY;
    protected int m_grpLayoutWidth;
    protected int m_grpLayoutHeight;
    protected int m_shiftX;
    protected int m_shiftY;
    protected int m_groupMode = 0;
    protected int m_dx;
    protected int m_dy;
    private boolean m_seen_motion;

    protected boolean moveOverlaps(Vector group, EntityInstance container) {
        int i = group.size();
        while (--i >= 0) {
            EntityInstance e = (EntityInstance)group.elementAt(i);
            if (!e.overlaps(container)) continue;
            return true;
        }
        return false;
    }

    protected void moveGroupInto(EntityInstance container, int dx, int dy, Diagram diagram) {
        Vector groupList = this.m_groupList;
        int grid = diagram.getHardGrid();
        EntityInstance e = (EntityInstance)this.m_groupList.firstElement();
        EntityInstance parent = e.getContainedBy();
        if (parent == container) {
            EntityComponent parentComponent = parent.getEntityComponent();
            double xShift = (double)dx / (double)parentComponent.getWidth();
            double yShift = (double)dy / (double)parentComponent.getHeight();
            int i = groupList.size();
            while (--i >= 0) {
                e = (EntityInstance)groupList.elementAt(i);
                double xRelLocal = e.xRelLocal();
                if (xShift != 0.0) {
                    if ((xRelLocal += xShift) < 0.0) {
                        xRelLocal = 0.0;
                    } else {
                        double widthRelLocal = e.widthRelLocal();
                        if (xRelLocal + widthRelLocal > 1.0) {
                            xRelLocal = 1.0 - widthRelLocal;
                        }
                    }
                }
                double yRelLocal = e.yRelLocal();
                if (yShift != 0.0) {
                    if ((yRelLocal += yShift) < 0.0) {
                        yRelLocal = 0.0;
                    } else {
                        double heightRelLocal = e.heightRelLocal();
                        if (yRelLocal + heightRelLocal > 1.0) {
                            yRelLocal = 1.0 - heightRelLocal;
                        }
                    }
                }
                diagram.updateLocationRelLocal(e, xRelLocal, yRelLocal);
            }
        } else {
            if (!this.moveOverlaps(groupList, container)) {
                int i = groupList.size();
                while (--i >= 0) {
                    e = (EntityInstance)groupList.elementAt(i);
                    diagram.updateMoveEntityContainment(container, e);
                }
            } else {
                int i = groupList.size();
                while (--i >= 0) {
                    e = (EntityInstance)groupList.elementAt(i);
                    diagram.updateMovePlaceEntityContainment(container, e);
                }
            }
            diagram.prepostorder();
        }
    }

    protected void selectEntity(EntityInstance e) {
        Diagram diagram = this.m_ls.getDiagram();
        if (e.getGroupFlag()) {
            if (e != diagram.getKeyEntity()) {
                diagram.setKeyEntity(e);
            }
        } else {
            EntityInstance old_ke = diagram.getKeyEntity();
            if (old_ke != null) {
                boolean cleared = diagram.clearFlags(false);
                diagram.setKeyEntity(e);
                if (cleared) {
                    diagram.revalidate();
                }
            } else {
                diagram.setKeyEntity(e);
            }
        }
        this.m_ls.show_groupList();
    }

    protected void toggleMembership(EntityInstance e) {
        Diagram diagram = this.m_ls.getDiagram();
        if (e.getGroupFlag()) {
            if (e == diagram.getKeyEntity()) {
                int size = diagram.getGroupedEntitiesCount();
                if (size == 1) {
                    diagram.clearGroupFlags();
                } else {
                    diagram.clearKeyEntity();
                }
            } else {
                diagram.clearEntityGroupFlag(e);
            }
            e.repaint();
        } else {
            int size = diagram.getGroupedEntitiesCount();
            if (size > 0 && diagram.getGroupedEntitiesContainer() != e.getContainedBy()) {
                this.selectEntity(e);
                return;
            }
            diagram.setKeyEntity(e);
        }
        this.m_ls.show_groupList();
    }

    protected void reportShift() {
        String type = this.m_groupList.size() == 1 ? "entity" : "group";
        this.m_ls.doFeedback("Moving " + type + "(" + this.m_shiftX + ", " + this.m_shiftY + ")");
    }

    protected boolean moveGroupStart(MouseEvent ev, int x, int y) {
        Vector groupList;
        Diagram diagram = this.m_ls.getDiagram();
        this.m_groupList = groupList = diagram.getGroupedEntities();
        this.m_seen_motion = false;
        if (groupList == null) {
            return false;
        }
        EntityInstance pe = ((EntityInstance)this.m_groupList.firstElement()).getContainedBy();
        if (pe == null) {
            return false;
        }
        int minY = Integer.MAX_VALUE;
        int minX = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxX = Integer.MIN_VALUE;
        int i = groupList.size();
        while (--i >= 0) {
            EntityInstance e = (EntityInstance)groupList.elementAt(i);
            EntityComponent entityComponent = e.getEntityComponent();
            int diagramX = entityComponent.getDiagramX();
            int diagramY = entityComponent.getDiagramY();
            if (diagramX < minX) {
                minX = diagramX;
            }
            if (diagramY < minY) {
                minY = diagramY;
            }
            diagramY += entityComponent.getHeight();
            if ((diagramX += entityComponent.getWidth()) > maxX) {
                maxX = diagramX;
            }
            if (diagramY <= maxY) continue;
            maxY = diagramY;
        }
        this.m_grpLayoutX = this.m_shiftX = minX;
        this.m_grpLayoutY = this.m_shiftY = minY;
        this.m_grpLayoutWidth = maxX - minX;
        this.m_grpLayoutHeight = maxY - minY;
        this.m_drawOutline.setBounds(this.m_shiftX, this.m_shiftY, this.m_grpLayoutWidth + 1, this.m_grpLayoutHeight + 1);
        diagram.add((Component)this.m_drawOutline, 0);
        this.m_dx = x - this.m_grpLayoutX;
        this.m_dy = y - this.m_grpLayoutY;
        this.reportShift();
        return true;
    }

    protected void moveGroupMotion(MouseEvent ev, int x, int y) {
        int bound;
        int nx = x - this.m_dx;
        int ny = y - this.m_dy;
        Diagram diagram = this.m_ls.getDiagram();
        int grid = diagram.getHardGrid();
        EntityInstance drawRoot = diagram.getDrawRoot();
        int drawRootX = drawRoot.getDiagramX();
        int drawRootY = drawRoot.getDiagramY();
        int drawRootWidth = drawRoot.getWidth();
        int drawRootHeight = drawRoot.getHeight();
        EntityInstance e = (EntityInstance)this.m_groupList.firstElement();
        EntityComponent entityComponent = e.getEntityComponent();
        EntityComponent parentComponent = (EntityComponent)entityComponent.getParent();
        int px = parentComponent.getDiagramX();
        int py = parentComponent.getDiagramY();
        if (!this.m_seen_motion) {
            this.m_seen_motion = true;
        }
        if (grid != 1) {
            nx -= px;
            ny -= py;
            nx = nx / grid * grid;
            ny = ny / grid * grid;
            nx += px;
            ny += py;
        }
        if (nx < (bound = drawRootX)) {
            nx = bound;
        }
        if (ny < (bound = drawRootY)) {
            ny = bound;
        }
        if (nx > (bound = drawRootX + drawRootWidth - this.m_grpLayoutWidth)) {
            nx = bound;
        }
        if (ny > (bound = drawRootY + drawRootHeight - this.m_grpLayoutHeight)) {
            ny = bound;
        }
        this.m_shiftX = nx;
        this.m_shiftY = ny;
        this.reportShift();
        this.m_drawOutline.setLocation(nx, ny);
        this.m_drawOutline.repaint();
    }

    protected void moveGroupEnd(MouseEvent ev) {
        this.m_ls.clearFeedback();
        if (this.m_seen_motion) {
            EntityInstance container;
            int dx = this.m_shiftX - this.m_grpLayoutX;
            int dy = this.m_shiftY - this.m_grpLayoutY;
            Diagram diagram = this.m_ls.getDiagram();
            EntityInstance drawRoot = diagram.getDrawRoot();
            EntityInstance ke = diagram.getKeyEntity();
            EntityComponent component = ke.getEntityComponent();
            int keX = component.getDiagramX() + dx;
            int keY = component.getDiagramY() + dy;
            int keWidth = component.getWidth();
            int keHeight = component.getHeight();
            Vector groupList = this.m_groupList;
            for (container = drawRoot.containing(keX, keY, keWidth, keHeight); container != null && groupList.contains(container); container = container.getContainedBy()) {
            }
            if (container == null) {
                this.m_ls.error("Failed to find container");
                this.cleanup();
                return;
            }
            boolean changeParent = container != ke.getContainedBy();
            diagram.beginUndoRedo("Group Move");
            this.moveGroupInto(container, dx, dy, diagram);
            if (changeParent) {
                this.m_ls.doFeedback("Group move into: " + container.getEntityLabel());
            }
            diagram.endUndoRedo();
        }
        this.cleanup();
    }

    public GroupModeHandler(EditModeHandler parent) {
        super(parent.m_ls);
        this.m_parent = parent;
        this.m_drawOutline = new DrawOutline();
    }

    @Override
    public void cleanup() {
        Diagram diagram = this.m_ls.getDiagram();
        diagram.remove(this.m_drawOutline);
        this.m_ls.setCursor(0);
        this.m_groupMode = 0;
    }

    public void moveGroup(int key) {
        Diagram diagram = this.m_ls.getDiagram();
        int grid = diagram.getHardGrid();
        this.m_groupList = diagram.getGroupedEntities();
        if (this.m_groupList == null) {
            return;
        }
        EntityInstance e = diagram.getKeyEntity();
        EntityComponent entityComponent = e.getEntityComponent();
        EntityComponent parentComponent = (EntityComponent)entityComponent.getParent();
        EntityInstance pe = parentComponent.getEntityInstance();
        int dx = 0;
        int dy = 0;
        switch (key) {
            case 38: {
                dy = -grid;
                break;
            }
            case 40: {
                dy = grid;
                break;
            }
            case 39: {
                dx = grid;
                break;
            }
            case 37: {
                dx = -grid;
            }
        }
        if (grid != 1) {
            if (dx != 0) {
                int px = entityComponent.getX();
                dx += px;
                dx = dx / grid * grid;
                dx -= px;
            }
            if (dy != 0) {
                int py = entityComponent.getY();
                dy += py;
                dy = dy / grid * grid;
                dy -= py;
            }
        }
        this.moveGroupInto(pe, dx, dy, diagram);
    }

    @Override
    public void entityPressed(MouseEvent ev, EntityInstance e, int x, int y) {
        Diagram diagram = this.m_ls.getDiagram();
        if (ev.isShiftDown()) {
            if (!e.isDrawRoot()) {
                this.toggleMembership(e);
            }
        } else {
            this.selectEntity(e);
            if (!e.isDrawRoot() && !e.isClientOrSupplier()) {
                this.m_ls.setCursor(13);
                this.m_groupMode = 1;
                if (this.moveGroupStart(ev, x, y)) {
                    this.m_parent.setSubHandler(this);
                }
                return;
            }
        }
        this.m_groupMode = 0;
    }

    @Override
    public void entityDragged(MouseEvent ev, EntityInstance e, int x, int y) {
        if (this.m_groupMode == 1) {
            this.moveGroupMotion(ev, x, y);
        }
    }

    @Override
    public void entityReleased(MouseEvent ev, EntityInstance e, int x, int y) {
        if (this.m_groupMode == 1) {
            this.moveGroupEnd(ev);
            this.m_parent.cleanup();
        }
    }

    @Override
    public void relationPressed(MouseEvent ev, RelationInstance ri, int x, int y) {
        this.m_ls.getDiagram().setGroupAndHighlightFlag(ri);
        this.m_parent.cleanup();
    }

    protected class DrawOutline
    extends JComponent {
        public DrawOutline() {
            this.setForeground(Color.BLACK);
        }

        @Override
        public void paintComponent(Graphics g) {
            if (GroupModeHandler.this.m_seen_motion) {
                Vector groupList = GroupModeHandler.this.m_groupList;
                int i = groupList.size();
                while (--i >= 0) {
                    EntityInstance e = (EntityInstance)groupList.elementAt(i);
                    EntityComponent entityComponent = e.getEntityComponent();
                    g.drawRect(entityComponent.getDiagramX() - GroupModeHandler.this.m_grpLayoutX, entityComponent.getDiagramY() - GroupModeHandler.this.m_grpLayoutY, entityComponent.getWidth(), entityComponent.getHeight());
                }
            }
        }
    }
}

