/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import lsedit.FontCache;
import lsedit.LandscapeEditorCore;
import lsedit.Option;
import lsedit.Options;
import lsedit.Util;

public class FontChooser
extends JDialog
implements ItemListener,
ActionListener {
    private static final int m_fontPanelWidth = 150;
    private static final int m_fontPanelHeight = 100;
    private static final int m_fontPanelXMargin = 5;
    private static final int m_fontPanelYMargin = 10;
    private static final String[] m_targetnames = new String[]{"ALL FONTS", "CLOSED LABEL", "OPEN LABEL", "OPEN CLASS LABEL", "CLIENT/SUPPIER LABEL", "CARDINALS", "RESULTS TITLE", "RESULTS TEXT", "LEGEND TITLE", "LEGEND TEXT", "QUERY TITLE", "QUERY TEXT", "TOC", "UNDO", "HISTORY", "MAP", "TITLE", "TEXTBOX", "FEEDBACK", "MENU", "DIALOG", "CLIPBOARD", "ATTR BOX TEXT", "RELATION LABEL", "VIEWS", "TABS"};
    private static final String[] m_targetDescription = new String[]{"***ALL***", "closed label", "small label", "open class label", "client/supplier", "cardinal", "results title", "results text", "legend title", "legend text", "query title", "query text", "TOC", "undo", "history", "map", "title", "text box", "feedback", "menu", "dialog", "clipboard", "attribute text", "relation label", "views", "tabs"};
    private static final String[] m_stylenames = new String[]{"DEFAULT", "PLAIN", "BOLD", "ITALIC", "BOLD & ITALIC"};
    private static final String[] m_sizenames = new String[]{"DEFAULT", "4", "5", "6", "7", "8", "9", "10", "12", "14", "16", "18", "20", "22", "24", "26", "28", "30"};
    private static GraphicsEnvironment m_gEnv = null;
    private static String[] m_envfonts = null;
    private int m_target;
    private String m_targetname;
    private Font m_font;
    private String m_fontname;
    private int m_style;
    private int m_size;
    private boolean m_name_default;
    private boolean m_style_default;
    private boolean m_size_default;
    private FontPanel m_fontPanel;
    private JComboBox m_targets;
    private JComboBox m_fonts;
    private JComboBox m_sizes;
    private JComboBox m_styles;
    public static final String[] g_optionchoices = new String[]{"Reset", "Default", "Landscape", "Current"};
    protected JComboBox m_optionchoices = new JComboBox<String>(g_optionchoices);
    protected Option m_current = new Option("Fontchooser");
    protected static final int BUTTON_OK = 0;
    protected static final int BUTTON_CANCEL = 1;
    protected static final int BUTTON_LOAD = 2;
    protected static final int BUTTON_SAVE = 3;
    protected static final int BUTTON_CLEAR = 4;
    protected static final String[] m_button_titles = new String[]{"Ok", "Cancel", "Load", "Save", "Clear"};
    protected static final String[] m_button_tips = new String[]{"Set fonts as changed", "Change nothing", "Load fonts from specified option", "Set specified options to fonts", "Clear the font cache"};
    protected JButton[] m_buttons;

    protected void newFont(Font font) {
        this.m_font = font;
        this.m_fontname = font.getFamily();
        this.m_style = font.getStyle();
        this.m_size = font.getSize();
    }

    protected void newFont() {
        this.newFont(FontCache.get(this.m_fontname, this.m_style, this.m_size));
    }

    protected Option getTarget() {
        switch (this.m_optionchoices.getSelectedIndex()) {
            case 1: {
                return Options.getDefaultOptions();
            }
            case 2: {
                return Options.getLandscapeOptions();
            }
            case 3: {
                return Options.getDiagramOptions();
            }
        }
        return null;
    }

    protected void setTarget(int index) {
        int i;
        Option option = this.getTarget();
        Font font = option == null ? Option.getDefaultFont(index) : option.getTargetFont(index);
        if (font == null) {
            return;
        }
        this.m_target = index;
        this.m_targetname = m_targetDescription[index];
        this.newFont(font);
        this.m_targets.setSelectedIndex(index);
        this.m_name_default = true;
        for (i = 1; i < m_envfonts.length; ++i) {
            if (!this.m_fontname.equalsIgnoreCase(m_envfonts[i])) continue;
            this.m_fonts.setSelectedIndex(i);
            this.m_name_default = false;
            break;
        }
        if (this.m_name_default) {
            this.m_fonts.setSelectedIndex(0);
        }
        if (this.m_style < 4) {
            this.m_style_default = true;
            this.m_styles.setSelectedIndex(0);
        } else {
            this.m_style_default = false;
            this.m_styles.setSelectedIndex(this.m_style + 1);
        }
        String s = "" + this.m_size;
        this.m_size_default = true;
        for (i = 1; i < m_sizenames.length; ++i) {
            if (!s.equals(m_sizenames[i])) continue;
            this.m_sizes.setSelectedIndex(i);
            this.m_size_default = false;
            break;
        }
        if (this.m_size_default) {
            this.m_sizes.setSelectedIndex(0);
        }
    }

    public FontChooser(JFrame frame) {
        super(frame, "Select font for target", true);
        int i;
        Container contentPane = this.getContentPane();
        Font font = FontCache.getDialogFont();
        Font bold = font.deriveFont(1);
        contentPane.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        JPanel targetPanel = new JPanel();
        JPanel fontPanel = new JPanel();
        JPanel sizePanel = new JPanel();
        JPanel stylePanel = new JPanel();
        JPanel sizeAndStylePanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        targetPanel.setLayout(new GridLayout(2, 1));
        fontPanel.setLayout(new GridLayout(2, 1));
        sizePanel.setLayout(new GridLayout(2, 1));
        stylePanel.setLayout(new GridLayout(2, 1));
        sizeAndStylePanel.setLayout(new BorderLayout());
        sizeAndStylePanel.add("Center", stylePanel);
        sizeAndStylePanel.add("East", sizePanel);
        topPanel.add("West", targetPanel);
        topPanel.add("Center", fontPanel);
        topPanel.add("East", sizeAndStylePanel);
        contentPane.add("North", topPanel);
        JLabel label = new JLabel();
        label.setText("Target");
        label.setFont(bold);
        label.setHorizontalAlignment(0);
        targetPanel.add(label);
        label = new JLabel();
        label.setText("Fonts");
        label.setFont(bold);
        label.setHorizontalAlignment(0);
        fontPanel.add(label);
        label = new JLabel();
        label.setText("Styles");
        label.setFont(bold);
        label.setHorizontalAlignment(0);
        stylePanel.add(label);
        label = new JLabel();
        label.setText("Sizes");
        label.setFont(bold);
        label.setHorizontalAlignment(0);
        sizePanel.add(label);
        this.m_targets = new JComboBox<String>(m_targetnames);
        this.m_targetname = "target";
        this.m_targets.setFont(bold);
        this.m_targets.setSelectedIndex(0);
        this.m_targets.setMaximumRowCount(9);
        this.m_targets.addItemListener(this);
        targetPanel.add(this.m_targets);
        if (m_gEnv == null) {
            m_gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        }
        if (m_envfonts == null) {
            m_envfonts = m_gEnv.getAvailableFontFamilyNames();
            String[] augmented = new String[i + 1];
            for (i = m_envfonts.length; i > 0; --i) {
                augmented[i] = m_envfonts[i - 1];
            }
            augmented[0] = "DEFAULT";
            m_envfonts = augmented;
        }
        this.m_fonts = new JComboBox<String>(m_envfonts);
        this.m_fonts.setFont(bold);
        this.m_fonts.setMaximumRowCount(9);
        this.m_fonts.addItemListener(this);
        fontPanel.add(this.m_fonts);
        this.m_styles = new JComboBox<String>(m_stylenames);
        this.m_styles.setFont(bold);
        this.m_styles.setMaximumRowCount(9);
        this.m_styles.addItemListener(this);
        stylePanel.add(this.m_styles);
        this.m_sizes = new JComboBox<String>(m_sizenames);
        this.m_sizes.setFont(bold);
        this.m_sizes.setMaximumRowCount(9);
        this.m_sizes.addItemListener(this);
        sizePanel.add(this.m_sizes);
        this.m_fontPanel = new FontPanel();
        this.m_fontPanel.setBackground(Color.white);
        contentPane.add("Center", this.m_fontPanel);
        this.m_current.setFontsTo(Options.getDiagramOptions());
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new FlowLayout(1, 15, 15));
        this.m_optionchoices.setFont(bold);
        this.m_optionchoices.setSelectedIndex(3);
        this.m_optionchoices.addActionListener(this);
        bottomPanel.add(this.m_optionchoices);
        this.m_buttons = new JButton[m_button_titles.length];
        for (i = 0; i < m_button_titles.length; ++i) {
            JButton button;
            this.m_buttons[i] = button = new JButton(m_button_titles[i]);
            button.setFont(bold);
            String tip = m_button_tips[i];
            if (tip != null) {
                button.setToolTipText(tip);
            }
            button.addActionListener(this);
            bottomPanel.add(button);
        }
        contentPane.add("South", bottomPanel);
        this.setLocation(20, 20);
        this.m_name_default = false;
        this.m_style_default = false;
        this.m_size_default = false;
        this.setTarget(0);
        this.pack();
        this.setVisible(true);
    }

    public Font getFontChoice() {
        return this.m_font;
    }

    protected void loadValues() {
        this.setTarget(this.m_targets.getSelectedIndex());
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            Object list = e.getSource();
            if (list == this.m_targets) {
                this.loadValues();
            } else {
                if (list == this.m_fonts) {
                    int index = this.m_fonts.getSelectedIndex();
                    if (index == 0) {
                        this.m_name_default = true;
                        this.m_fontname = Option.getDefaultFontName(this.m_target);
                    } else {
                        this.m_name_default = false;
                        this.m_fontname = (String)this.m_fonts.getSelectedItem();
                    }
                } else if (list == this.m_styles) {
                    int index = this.m_styles.getSelectedIndex();
                    if (index == 0) {
                        this.m_style_default = true;
                        this.m_style = Option.getDefaultFontStyle(this.m_target);
                    } else {
                        this.m_style_default = false;
                        this.m_style = --index;
                    }
                } else {
                    int index = this.m_sizes.getSelectedIndex();
                    if (index == 0) {
                        this.m_size_default = true;
                        this.m_size = Option.getDefaultFontSize(this.m_target);
                    } else {
                        String sizename = (String)this.m_sizes.getSelectedItem();
                        Integer newSize = new Integer(sizename);
                        this.m_size = newSize;
                        this.m_size_default = false;
                    }
                }
                this.newFont();
            }
            this.m_fontPanel.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        int state = -1;
        if (source == this.m_optionchoices) {
            this.m_buttons[3].setEnabled(this.m_optionchoices.getSelectedIndex() != 0);
            this.loadValues();
            return;
        }
        for (int i = 0; i < m_button_titles.length; ++i) {
            if (source != this.m_buttons[i]) continue;
            state = i;
            break;
        }
        Option current = this.m_current;
        switch (state) {
            case 1: {
                break;
            }
            case 2: {
                current.setFontsTo(this.getTarget());
                return;
            }
            case 3: {
                Option target = this.getTarget();
                if (target != null) {
                    target.setFontsTo(current);
                }
                return;
            }
            case 0: {
                current.setTargetFont(this.m_target, this.m_font, this.m_name_default, this.m_style_default, this.m_size_default);
                Option target = Options.getDiagramOptions();
                target.setFontsTo(current);
                break;
            }
            case 4: {
                int cnt = FontCache.size();
                FontCache.clear();
                JOptionPane.showMessageDialog(this, cnt + " fonts have been removed from the cache");
            }
            default: {
                return;
            }
        }
        this.setVisible(false);
    }

    public static void create(LandscapeEditorCore ls) {
        Option option = Options.getDiagramOptions();
        Option oldOptions = new Option("Old fontchooser");
        oldOptions.setFontsTo(option);
        FontChooser fontChooser = new FontChooser(ls.getFrame());
        fontChooser.dispose();
        ls.fontsChanged(oldOptions, option);
    }

    class FontPanel
    extends JPanel {
        @Override
        public Dimension getPreferredSize() {
            return new Dimension(150, 100);
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setColor(Color.darkGray);
            g.setFont(FontChooser.this.m_font);
            String change = "Set " + FontChooser.this.m_targetname + " font " + FontChooser.this.m_fontname + " ";
            change = FontChooser.this.m_style < 4 ? change + m_stylenames[FontChooser.this.m_style + 1] : change + "style " + FontChooser.this.m_style;
            change = change + " size " + FontChooser.this.m_size;
            int width = FontChooser.this.getWidth();
            Util.drawStringWrapped(g, change, 5.0, 10.0, width - 10, 90.0, true, false, false);
        }
    }
}

