/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.MenuElement;
import lsedit.Options;

public class FontCache {
    protected static Font m_menuFont = null;
    protected static Font m_dialogFont = null;
    private static final int m_initialCapacity = 50;
    private static final float m_loadFactor = 0.75f;
    private static Entry[] m_table = null;
    private static int m_count = 0;
    private static int m_threshold = 37;

    public static int size() {
        return m_count;
    }

    public static boolean isEmpty() {
        return m_count == 0;
    }

    public static void clear() {
        Entry[] tab = m_table;
        if (tab != null) {
            int index = tab.length;
            while (--index >= 0) {
                tab[index] = null;
            }
        }
        m_count = 0;
    }

    protected static int hashCode(String name, int style, int size) {
        return name.hashCode() ^ style ^ size;
    }

    protected static void rehash() {
        Entry[] oldMap = m_table;
        int oldCapacity = oldMap.length;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newMap = new Entry[newCapacity];
        m_threshold = (int)((float)newCapacity * 0.75f);
        m_table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry old = oldMap[i];
            while (old != null) {
                Entry e = old;
                old = old.m_next;
                int index = (e.m_value.hashCode() & Integer.MAX_VALUE) % newCapacity;
                e.m_next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    protected static void put(Font font, int index) {
        Entry[] table = m_table;
        if (m_count >= m_threshold) {
            FontCache.rehash();
            table = m_table;
            index = (font.hashCode() & Integer.MAX_VALUE) % table.length;
        }
        table[index] = new Entry(font, table[index]);
        ++m_count;
    }

    public static Font get(String name, int style, int size) {
        Font font;
        int index;
        Entry[] tab = m_table;
        int hash = FontCache.hashCode(name, style, size);
        if (tab == null) {
            m_table = new Entry[50];
            index = (hash & Integer.MAX_VALUE) % m_table.length;
        } else {
            index = (hash & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[index];
            while (e != null) {
                font = e.m_value;
                if (name.equals(font.getName()) && style == font.getStyle() && size == font.getSize()) {
                    return font;
                }
                e = e.m_next;
            }
        }
        font = new Font(name, style, size);
        FontCache.put(font, index);
        return font;
    }

    public static Font getDialogFont() {
        Font dialogFont = m_dialogFont;
        if (dialogFont == null) {
            m_dialogFont = dialogFont = Options.getTargetFont(20);
        }
        return dialogFont;
    }

    public static void setDialogFont(Font font) {
        m_dialogFont = font;
    }

    public static Font getMenuFont() {
        Font menuFont = m_menuFont;
        if (menuFont == null) {
            m_menuFont = menuFont = Options.getTargetFont(19);
        }
        return menuFont;
    }

    public static void setMenuFont(Font font) {
        m_menuFont = font;
    }

    public static void setMenuFont(MenuElement element, Font font) {
        MenuElement[] subelements = element.getSubElements();
        ((JComponent)((Object)element)).setFont(font);
        if (subelements != null) {
            for (int i = 0; i < subelements.length; ++i) {
                FontCache.setMenuFont(subelements[i], font);
            }
        }
    }

    public static void setMenuTreeFont(MenuElement element) {
        FontCache.setMenuFont(element, FontCache.getMenuFont());
    }

    static class Entry {
        public Font m_value;
        public Entry m_next;

        protected Entry(Font font, Entry next) {
            this.m_value = font;
            this.m_next = next;
        }
    }
}

