/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.util.Enumeration;
import java.util.Vector;
import java.util.regex.Matcher;
import lsedit.EntityClass;
import lsedit.EntityInstance;
import lsedit.FindRules;

public class Find {
    protected Vector m_results = new Vector();
    protected int m_ind = 0;

    protected void find(EntityInstance e, FindRules rules) {
        EntityInstance ce;
        Enumeration en = e.getChildren();
        while (en.hasMoreElements()) {
            Matcher m;
            ce = (EntityInstance)en.nextElement();
            if (rules.m_pattern != null && !(m = rules.m_pattern.matcher(ce.getEntityLabel())).matches()) continue;
            Vector entityClasses = rules.m_entityClasses;
            if (entityClasses != null) {
                Object ec1;
                EntityClass ec = ce.getEntityClass();
                int i = entityClasses.size();
                while (--i >= 0 && ec != (ec1 = entityClasses.elementAt(i))) {
                }
                if (i < 0) continue;
            }
            if ((rules.m_in_edges_min > 0 || rules.m_in_edges_max >= 0) && !ce.hasActiveInEdges(rules.m_in_edges, rules.m_in_edges_min, rules.m_in_edges_max) || (rules.m_out_edges_min > 0 || rules.m_out_edges_max >= 0) && !ce.hasActiveOutEdges(rules.m_out_edges, rules.m_out_edges_min, rules.m_out_edges_max)) continue;
            this.m_results.addElement(ce);
        }
        en = e.getChildren();
        while (en.hasMoreElements()) {
            ce = (EntityInstance)en.nextElement();
            this.find(ce, rules);
        }
    }

    public Find(EntityInstance root, FindRules rules) {
        this.find(root, rules);
    }

    public void clear() {
        this.m_results.clear();
    }

    public boolean isEmpty() {
        return this.m_results.isEmpty();
    }

    public boolean atEnd() {
        return this.m_ind >= this.m_results.size();
    }

    public boolean atBeginning() {
        return this.m_ind <= 0;
    }

    public void reset() {
        this.m_ind = 0;
    }

    public Vector nextResult() {
        if (this.m_ind < 0 || this.m_ind >= this.m_results.size()) {
            return null;
        }
        Vector<EntityInstance> v = new Vector<EntityInstance>();
        EntityInstance e = (EntityInstance)this.m_results.elementAt(this.m_ind);
        EntityInstance pe = e.getContainedBy();
        while (this.m_ind < this.m_results.size() && (e = (EntityInstance)this.m_results.elementAt(this.m_ind)).getContainedBy() == pe) {
            v.addElement(e);
            ++this.m_ind;
        }
        return v;
    }

    public boolean regress() {
        if (this.m_ind > 0) {
            int orgInd = this.m_ind--;
            EntityInstance e = (EntityInstance)this.m_results.elementAt(this.m_ind);
            EntityInstance pe = e.getContainedBy();
            while (--this.m_ind >= 0) {
                e = (EntityInstance)this.m_results.elementAt(this.m_ind);
                if (e.getContainedBy() == pe) continue;
                pe = e.getContainedBy();
                while (--this.m_ind >= 0 && (e = (EntityInstance)this.m_results.elementAt(this.m_ind)).getContainedBy() == pe) {
                }
                ++this.m_ind;
                return true;
            }
            this.m_ind = orgInd;
        }
        return false;
    }

    public boolean entityCut() {
        int newsize;
        int size = newsize = this.m_results.size();
        int i = 0;
        while (i < newsize) {
            EntityInstance e = (EntityInstance)this.m_results.elementAt(i);
            if (e.isMarked(0x2000000)) {
                this.m_results.remove(i);
                --newsize;
                continue;
            }
            ++i;
        }
        if (this.m_ind > newsize) {
            this.m_ind = newsize;
        }
        return size != newsize;
    }
}

