/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import lsedit.ColorCache;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.FontCache;
import lsedit.LandscapeEditorCore;
import lsedit.LandscapeLayouter;
import lsedit.ToolBarEventHandler;
import lsedit.Util;

public class ExpandLayout
extends LandscapeLayouter
implements ToolBarEventHandler {
    protected static final int XBORDER = 0;
    protected static final int YBORDER = 1;
    protected static final String[] m_textfield_tags = new String[]{"expand:xborder", "expand:yborder"};
    protected static final String[] m_textfield_titles = new String[]{"X Border fraction of total:", "Y Border fraction of total:"};
    protected static final String[] m_textfield_resets = new String[]{"0.05", "0.05"};
    protected static String[] m_textfield_defaults = new String[]{"0.05", "0.05"};
    protected static String[] m_textfield_currents = new String[]{"0.05", "0.05"};
    protected static double m_xborder = 0.05;
    protected static double m_yborder = 0.05;
    protected static final int HORIZONTALLY = 0;
    protected static final int VERTICALLY = 1;
    protected static final String[] m_checkbox_tags = new String[]{"expand:horizontally", "expand:vertically"};
    protected static final String[] m_checkbox_titles = new String[]{"Expand horizontally:", "Expand vertically:"};
    protected static final boolean[] m_checkbox_resets = new boolean[]{true, true};
    protected static boolean[] m_checkbox_defaults = new boolean[]{true, true};
    protected static boolean[] m_checkbox_currents = new boolean[]{true, true};
    protected static final int BUTTON_OK = 0;
    protected static final int BUTTON_CANCEL = 1;
    protected static final int BUTTON_HELP = 2;
    protected static final int BUTTON_UNDO = 3;
    protected static final int BUTTON_DEFAULT = 4;
    protected static final int BUTTON_SET = 5;
    protected static final int BUTTON_RESET = 6;
    protected static final String[] m_button_titles = new String[]{"Ok", "Cancel", "Help", null, "Default", "Set", "Reset"};
    protected static final String[] m_button_tips = new String[]{null, null, null, "Enable/disable undo", "Use remembered default", "Set default to current", "Set default to initial"};

    protected void setParameter(int i, String string) {
        string = string.trim();
        try {
            double dval = Double.parseDouble(string);
            switch (i) {
                case 0: {
                    m_xborder = dval;
                    break;
                }
                case 1: {
                    m_yborder = dval;
                }
            }
            ExpandLayout.m_textfield_currents[i] = string;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected static boolean parameterBoolean(int i) {
        return m_checkbox_currents[i];
    }

    @Override
    public String getTag() {
        return "expand:";
    }

    @Override
    public void reset() {
        int i;
        String[] textfield_resets = m_textfield_resets;
        String[] textfield_defaults = m_textfield_defaults;
        String[] textfield_currents = m_textfield_currents;
        boolean[] checkbox_resets = m_checkbox_resets;
        boolean[] checkbox_defaults = m_checkbox_defaults;
        boolean[] checkbox_currents = m_checkbox_currents;
        for (i = 0; i < textfield_resets.length; ++i) {
            String string;
            textfield_defaults[i] = string = textfield_resets[i];
            textfield_currents[i] = string;
        }
        for (i = 0; i < checkbox_resets.length; ++i) {
            boolean bool;
            checkbox_defaults[i] = bool = checkbox_resets[i];
            checkbox_currents[i] = bool;
        }
    }

    @Override
    public void loadLayoutOption(int mode, String attribute, String value) {
        int i;
        String[] textfield_tags = m_textfield_tags;
        for (i = 0; i < textfield_tags.length; ++i) {
            if (!attribute.startsWith(textfield_tags[i])) continue;
            switch (mode) {
                case 0: {
                    ExpandLayout.m_textfield_defaults[i] = value;
                }
                case 1: {
                    this.setParameter(i, value);
                }
            }
            return;
        }
        String[] checkbox_tags = m_checkbox_tags;
        for (i = 0; i < checkbox_tags.length; ++i) {
            if (!attribute.equals(checkbox_tags[i])) continue;
            boolean bool = value.charAt(0) == 't';
            switch (mode) {
                case 0: {
                    ExpandLayout.m_checkbox_defaults[i] = bool;
                }
                case 1: {
                    ExpandLayout.m_checkbox_currents[i] = bool;
                }
            }
            return;
        }
    }

    @Override
    public void saveLayoutOptions(int mode, PrintWriter ps) {
        int i;
        boolean[] emit_booleans;
        String[] emit_strings;
        boolean[] prior_booleans;
        String[] prior_strings;
        switch (mode) {
            case 0: {
                prior_strings = m_textfield_resets;
                prior_booleans = m_checkbox_resets;
                emit_strings = m_textfield_defaults;
                emit_booleans = m_checkbox_defaults;
                break;
            }
            case 1: {
                prior_strings = m_textfield_defaults;
                prior_booleans = m_checkbox_defaults;
                emit_strings = m_textfield_currents;
                emit_booleans = m_checkbox_currents;
                break;
            }
            default: {
                return;
            }
        }
        for (i = 0; i < m_textfield_tags.length; ++i) {
            String string = emit_strings[i];
            if (string.equals(prior_strings[i])) continue;
            ps.println(m_textfield_tags[i] + "=" + string);
        }
        for (i = 0; i < m_checkbox_tags.length; ++i) {
            boolean bool = emit_booleans[i];
            if (bool == prior_booleans[i]) continue;
            ps.println(m_checkbox_tags[i] + "=" + (bool ? "true" : "false"));
        }
    }

    public ExpandLayout(LandscapeEditorCore ls, LandscapeLayouter fallback) {
        super(ls, fallback);
    }

    @Override
    public String getName() {
        return "Expand";
    }

    @Override
    public String getMenuLabel() {
        return "Expand layout to fill area";
    }

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    public boolean isLayouter() {
        return true;
    }

    @Override
    public boolean configure(LandscapeEditorCore ls) {
        ExpandConfigure configure = new ExpandConfigure();
        boolean ok = configure.ok();
        configure.dispose();
        return ok;
    }

    @Override
    public boolean doLayout1(Vector selectedBoxes, EntityInstance container) {
        double yRel;
        double diff;
        double xRel;
        EntityInstance ce;
        int i;
        double max;
        double min;
        double xborder = m_xborder;
        double yborder = m_yborder;
        boolean xexpand = ExpandLayout.parameterBoolean(0);
        boolean yexpand = ExpandLayout.parameterBoolean(1);
        if (!xexpand && !yexpand) {
            return true;
        }
        int size = selectedBoxes.size();
        if (size == 0) {
            return true;
        }
        Diagram diagram = this.m_ls.getDiagram();
        double xshift = 0.0;
        double xscale = 1.0;
        double yshift = 0.0;
        double yscale = 1.0;
        if (xexpand) {
            min = Double.MAX_VALUE;
            max = Double.MIN_VALUE;
            i = size;
            while (--i >= 0) {
                ce = (EntityInstance)selectedBoxes.elementAt(i);
                xRel = ce.xRelLocal();
                if (xRel < min) {
                    min = xRel;
                }
                if (!((xRel += ce.widthRelLocal()) > max)) continue;
                max = xRel;
            }
            diff = max - min;
            if (diff != 0.0) {
                xscale = (1.0 - xborder) / diff;
                xshift = xborder * 0.5 - (1.0 - xborder) * min / diff;
            }
        }
        if (yexpand) {
            min = Double.MAX_VALUE;
            max = Double.MIN_VALUE;
            i = size;
            while (--i >= 0) {
                ce = (EntityInstance)selectedBoxes.elementAt(i);
                yRel = ce.yRelLocal();
                if (yRel < min) {
                    min = yRel;
                }
                if (!((yRel += ce.heightRelLocal()) > max)) continue;
                max = yRel;
            }
            diff = max - min;
            if (diff != 0.0) {
                yscale = (1.0 - yborder) / diff;
                yshift = yborder * 0.5 - (1.0 - yborder) * min / diff;
            }
        }
        i = size;
        while (--i >= 0) {
            ce = (EntityInstance)selectedBoxes.elementAt(i);
            xRel = ce.xRelLocal() * xscale + xshift;
            double widthRel = ce.widthRelLocal() * xscale;
            yRel = ce.yRelLocal() * yscale + yshift;
            double heightRel = ce.heightRelLocal() * yscale;
            diagram.updateRelLocal(ce, xRel, yRel, widthRel, heightRel);
        }
        return true;
    }

    @Override
    public String doLayout(Diagram diagram) {
        LandscapeEditorCore ls = this.m_ls;
        ls.setLayouter(this);
        Vector selectedBoxes = diagram.getClusterGroup();
        if (selectedBoxes == null) {
            Util.beep();
            return "No group selected";
        }
        String msg = this.allInDiagram(selectedBoxes);
        if (msg != null) {
            return msg;
        }
        EntityInstance parent = this.parentOfSet(selectedBoxes);
        if (parent == null) {
            return "Expand algorithm requires that all things laid out share same parent";
        }
        ls.doLayout1(this, selectedBoxes, parent, false);
        return "Graph redrawn using Expand algorithm";
    }

    @Override
    public void processKeyEvent(int key, int modifiers, Object object) {
        Diagram diagram = this.m_ls.getDiagram();
        if (diagram != null) {
            String rmsg = this.doLayout(diagram);
            this.m_ls.doFeedback(rmsg);
        }
    }

    class ExpandConfigure
    extends JDialog
    implements ActionListener,
    ItemListener {
        protected JTextField[] m_textfields;
        protected JCheckBox[] m_checkboxes;
        protected ExpandImage m_expandImage;
        protected JButton[] m_buttons;
        protected JLabel m_message;
        protected boolean m_ret;

        public ExpandConfigure() {
            JLabel label;
            int i;
            super(ExpandLayout.this.getLs().getFrame(), "Expand Configuration", true);
            this.m_ret = false;
            Font font = FontCache.getDialogFont();
            Font bold = font.deriveFont(1);
            this.setForeground(ColorCache.get(0, 0, 0));
            this.setBackground(ColorCache.get(192, 192, 192));
            this.setFont(font);
            JPanel topPanel = new JPanel();
            JPanel labelPanel = new JPanel();
            JPanel valuePanel = new JPanel();
            topPanel.setLayout(new BorderLayout());
            GridLayout gridLayout = new GridLayout(4, 1, 0, 10);
            labelPanel.setLayout(gridLayout);
            gridLayout = new GridLayout(4, 1, 0, 10);
            valuePanel.setLayout(gridLayout);
            this.m_textfields = new JTextField[m_textfield_tags.length];
            for (i = 0; i < m_textfield_tags.length; ++i) {
                JTextField textfield;
                label = new JLabel(m_textfield_titles[i], 4);
                label.setFont(bold);
                labelPanel.add(label);
                this.m_textfields[i] = textfield = new JTextField(m_textfield_currents[i], 20);
                textfield.setFont(font);
                textfield.addActionListener(this);
                valuePanel.add(textfield);
            }
            this.m_checkboxes = new JCheckBox[m_checkbox_tags.length];
            for (i = 0; i < m_checkbox_tags.length; ++i) {
                JCheckBox checkbox;
                label = new JLabel(m_checkbox_titles[i], 4);
                label.setFont(bold);
                labelPanel.add(label);
                this.m_checkboxes[i] = checkbox = new JCheckBox("", m_checkbox_currents[i]);
                checkbox.setFont(font);
                checkbox.addActionListener(this);
                valuePanel.add(checkbox);
            }
            topPanel.add("West", labelPanel);
            topPanel.add("East", valuePanel);
            Container contentPane = this.getContentPane();
            contentPane.add("North", topPanel);
            JPanel centerPanel = new JPanel();
            centerPanel.setLayout(new BorderLayout());
            this.m_expandImage = new ExpandImage();
            centerPanel.add("North", this.m_expandImage);
            this.m_expandImage.revalidate();
            this.m_message = new JLabel(" ", 0);
            this.m_message.setFont(font);
            this.m_message.setForeground(Color.RED);
            this.m_message.setSize(400, 50);
            this.m_message.setPreferredSize(new Dimension(400, 50));
            centerPanel.add("South", this.m_message);
            contentPane.add("Center", centerPanel);
            JPanel bottomPanel = new JPanel();
            bottomPanel.setLayout(new FlowLayout(1, 15, 15));
            this.m_buttons = new JButton[m_button_titles.length];
            for (i = 0; i < m_button_titles.length; ++i) {
                JButton button;
                String string = m_button_titles[i];
                if (string == null) {
                    string = ExpandLayout.this.undoLabel();
                }
                this.m_buttons[i] = button = new JButton(string);
                button.setFont(bold);
                String tip = m_button_tips[i];
                if (tip != null) {
                    button.setToolTipText(tip);
                }
                button.addActionListener(this);
                bottomPanel.add(button);
            }
            contentPane.add("South", bottomPanel);
            this.pack();
            this.setVisible(true);
        }

        public boolean ok() {
            return this.m_ret;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            int i;
            Object source = ev.getSource();
            int state = -1;
            for (i = 0; i < m_button_titles.length; ++i) {
                if (source != this.m_buttons[i]) continue;
                state = i;
                break;
            }
            switch (state) {
                case 6: {
                    for (i = 0; i < m_textfield_tags.length; ++i) {
                        ExpandLayout.m_textfield_defaults[i] = m_textfield_resets[i];
                    }
                    for (i = 0; i < m_checkbox_tags.length; ++i) {
                        ExpandLayout.m_checkbox_defaults[i] = m_checkbox_resets[i];
                    }
                }
                case 4: {
                    for (i = 0; i < m_textfield_tags.length; ++i) {
                        this.m_textfields[i].setText(m_textfield_defaults[i]);
                    }
                    for (i = 0; i < m_checkbox_tags.length; ++i) {
                        this.m_checkboxes[i].setSelected(m_checkbox_defaults[i]);
                    }
                    break;
                }
                case 5: {
                    for (i = 0; i < m_textfield_tags.length; ++i) {
                        ExpandLayout.m_textfield_defaults[i] = this.m_textfields[i].getText();
                    }
                    for (i = 0; i < m_checkbox_tags.length; ++i) {
                        ExpandLayout.m_checkbox_defaults[i] = this.m_checkboxes[i].isSelected();
                    }
                    break;
                }
                case 3: {
                    LandscapeEditorCore ls = ExpandLayout.this.m_ls;
                    ls.invertUndo();
                    this.m_buttons[state].setText(ExpandLayout.this.undoLabel());
                    this.m_message.setText("");
                    return;
                }
                case 2: {
                    JOptionPane.showMessageDialog(ExpandLayout.this.m_ls.getFrame(), "Expands/Contracts the visible area of the diagram\nto produce the specified horizontal and vertical\nborders", "Help", 0);
                    return;
                }
                default: {
                    for (i = 0; i < m_textfield_tags.length; ++i) {
                        JTextField textfield = this.m_textfields[i];
                        if (source != textfield && state != 0) continue;
                        String string = textfield.getText();
                        string = string.trim();
                        String name = m_textfield_titles[i];
                        try {
                            double dval = Double.parseDouble(string);
                            if (!(dval < 0.0) && !(dval >= 1.0)) continue;
                            this.m_message.setText(name + " must be in the range 0 to 1.0");
                            return;
                        }
                        catch (Throwable exception) {
                            this.m_message.setText(name + " not a double precision value");
                            return;
                        }
                    }
                }
            }
            switch (state) {
                case 0: {
                    for (i = 0; i < m_textfield_tags.length; ++i) {
                        ExpandLayout.this.setParameter(i, this.m_textfields[i].getText());
                    }
                    for (i = 0; i < m_checkbox_tags.length; ++i) {
                        ExpandLayout.m_checkbox_currents[i] = this.m_checkboxes[i].isSelected();
                    }
                    this.m_ret = true;
                }
                case 1: {
                    break;
                }
                default: {
                    this.m_expandImage.repaint();
                    return;
                }
            }
            this.setVisible(false);
        }

        @Override
        public void itemStateChanged(ItemEvent ev) {
            this.m_expandImage.repaint();
        }

        class ExpandImage
        extends JComponent {
            public ExpandImage() {
                Dimension dimension = new Dimension(400, 240);
                this.setLayout(null);
                this.setPreferredSize(dimension);
                this.setMinimumSize(dimension);
                this.setMaximumSize(dimension);
                this.setSize(dimension);
                this.setVisible(true);
            }

            @Override
            public void paintComponent(Graphics g) {
                double xborder = m_xborder;
                double yborder = m_yborder;
                boolean horizontal = ExpandLayout.parameterBoolean(0);
                boolean vertical = ExpandLayout.parameterBoolean(1);
                int w = this.getWidth();
                int h = this.getHeight();
                int indentx = (int)((double)w * (xborder / 2.0));
                int indenty = (int)((double)h * (yborder / 2.0));
                int indentw = (int)((double)w * (1.0 - xborder));
                int indenth = (int)((double)h * (1.0 - yborder));
                g.setColor(Color.black);
                g.drawRect(0, 0, w - 1, h - 1);
                g.setColor(Color.blue);
                if (horizontal) {
                    g.drawLine(indentx, indenty, indentx, indenty + indenth);
                    g.drawLine(indentx + indentw, indenty, indentx + indentw, indenty + indenth);
                }
                if (vertical) {
                    g.drawLine(indentx, indenty, indentx + indentw, indenty);
                    g.drawLine(indentx, indenty + indenth, indentx + indentw, indenty + indenth);
                }
            }
        }
    }
}

