/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.io.PrintWriter;
import lsedit.Attribute;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.ExecuteConfigure;
import lsedit.LandscapeEditorCore;
import lsedit.LandscapeObject;
import lsedit.RelationInstance;
import lsedit.ViewSource;

public class ExecuteAction {
    public static final int COMMANDS = 8;
    private static String[] m_tags = new String[]{"execute:command[", "execute:parm["};
    public static String[] m_commands = new String[8];
    public static String[] m_rules = new String[8];

    public static void loadIni(String attribute, String value) {
        for (int i = 0; i < m_tags.length; ++i) {
            int at;
            int index;
            String tag = m_tags[i];
            if (!attribute.startsWith(tag) || (index = attribute.charAt(at = tag.length()) - 48) < 0 || index > 8) continue;
            switch (i) {
                case 0: {
                    ExecuteAction.m_commands[index] = value;
                    ExecuteAction.m_rules[index] = "";
                    return;
                }
                case 1: {
                    int n = index;
                    m_rules[n] = m_rules[n] + value + "\n";
                    return;
                }
            }
        }
    }

    public static void saveOptions(PrintWriter ps) {
        for (int index = 0; index < 8; ++index) {
            String rules = m_rules[index];
            block5: for (int i = 0; i < m_tags.length; ++i) {
                switch (i) {
                    case 0: {
                        String string = m_commands[index];
                        if (string == null || string.length() <= 0) continue block5;
                        ps.println(m_tags[i] + index + "]=" + string);
                        continue block5;
                    }
                    case 1: {
                        String string;
                        rules = m_rules[index];
                        if (rules == null) continue block5;
                        int at = 0;
                        while (true) {
                            int j;
                            if ((j = rules.indexOf(10, at)) < 0) {
                                string = rules.substring(at);
                                if (string.length() <= 0) continue block5;
                                ps.println(m_tags[i] + index + "]=" + string);
                                continue block5;
                            }
                            string = rules.substring(at, j);
                            if (string.length() > 0) {
                                ps.println(m_tags[i] + index + "]=" + string);
                            }
                            at = j + 1;
                            at = j + 1;
                        }
                    }
                }
            }
        }
    }

    public static void configure(LandscapeEditorCore ls, int index) {
        ExecuteConfigure configure = new ExecuteConfigure(ls, index);
        configure.dispose();
    }

    protected static String getValue(LandscapeObject object, String name) {
        int index = object.getLsAttributeOffset(name);
        String value = null;
        if (index >= 0) {
            Object item = object.getLsAttributeValueAt(index);
            if (item != null) {
                value = item.toString();
            }
        } else {
            Attribute attr = object.getLsAttribute(name);
            if (attr != null && attr.countValues() == 1) {
                value = attr.parseString();
            }
        }
        if (value != null) {
            value = value.replace('\r', ' ');
            value = value.replace('\n', ' ');
        }
        return value;
    }

    protected static LandscapeObject getParent(LandscapeObject object) {
        if (object instanceof RelationInstance) {
            RelationInstance ri = (RelationInstance)object;
            if (ri.isMarked(0x200000)) {
                return ri.getDst();
            }
            return ri.getSrc();
        }
        if (object instanceof EntityInstance) {
            return ((EntityInstance)object).getOriginalContainedBy();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected static String expand(LandscapeObject object, String rules, int start, boolean optional) {
        String ret = "";
        int lth = rules.length();
        int i = start;
        while (true) {
            block30: {
                String ret1;
                int c;
                block31: {
                    if (i >= lth) {
                        return ret;
                    }
                    c = rules.charAt(i);
                    switch (rules.charAt(i)) {
                        case '\\': {
                            if (i >= lth - 1) break;
                            c = rules.charAt(++i);
                            break;
                        }
                        case '$': {
                            if (i > lth - 3) break;
                            c = rules.charAt(i + 1);
                            if (c == 123) {
                                c = 125;
                            } else {
                                if (c != 40) break;
                                c = 41;
                            }
                            String name = null;
                            int j = rules.indexOf(c, i + 2);
                            if (j < 0) break;
                            name = rules.substring(i + 2, j);
                            String value = ExecuteAction.getValue(object, name);
                            if (value == null) {
                                if (optional) {
                                    return null;
                                }
                            } else {
                                LandscapeObject parent = object;
                                int lth1 = value.length();
                                while (lth1 != 0 && value.charAt(0) == '.') {
                                    parent = ExecuteAction.getParent(parent);
                                    int pos = 1;
                                    if (lth1 > 1 && value.charAt(1) == '.') {
                                        pos = 2;
                                        if (parent != null) {
                                            parent = ExecuteAction.getParent(parent);
                                        }
                                    }
                                    if (parent == null) break;
                                    String value1 = ExecuteAction.getValue(parent, name);
                                    if (value1 == null) continue;
                                    if (value1.endsWith("/") && value.length() > pos && value.charAt(pos) == '/') {
                                        ++pos;
                                    }
                                    value = value1 + value.substring(pos);
                                    lth1 = value.length();
                                }
                                ret = ret + value;
                            }
                            i = j;
                            break block30;
                        }
                        case ']': 
                        case '|': {
                            if (!optional) break;
                            return ret;
                        }
                        case '[': {
                            break block31;
                        }
                    }
                    ret = ret + (char)c;
                    break block30;
                }
                block14: do {
                    ret1 = ExecuteAction.expand(object, rules, ++i, true);
                    int depth = 1;
                    while (i < lth) {
                        block32: {
                            c = rules.charAt(i);
                            switch (c) {
                                case 92: {
                                    if (i < lth - 1) {
                                        ++i;
                                    }
                                    break block32;
                                }
                                case 124: {
                                    if (depth == 1 && ret1 == null) {
                                        break;
                                    }
                                    break block32;
                                }
                                case 91: {
                                    ++depth;
                                    break block32;
                                }
                                case 93: {
                                    break;
                                }
                                default: {
                                    break block32;
                                }
                            }
                            if (--depth == 0) continue block14;
                        }
                        ++i;
                    }
                } while (c == 124);
                if (ret1 != null) {
                    ret = ret + ret1;
                } else if (optional) {
                    return null;
                }
            }
            ++i;
        }
    }

    protected static String contract(String expanded) {
        int lth = expanded.length();
        boolean whitespace = true;
        String ret = "";
        int j = 0;
        int i = 0;
        block4: while (true) {
            char c = i >= lth ? (char)'\u0000' : expanded.charAt(i);
            switch (c) {
                case '\u0000': 
                case '\n': {
                    if (!whitespace) {
                        ret = ret + expanded.substring(j, i) + '\n';
                    }
                    if (c == '\u0000') break block4;
                    whitespace = true;
                }
                case '\t': 
                case '\r': 
                case ' ': {
                    break;
                }
                default: {
                    if (!whitespace) break;
                    j = i;
                    whitespace = false;
                }
            }
            ++i;
        }
        return ret;
    }

    protected static int count(String expanded) {
        int lth = expanded.length();
        int cnt = 0;
        for (int i = 0; i < lth; ++i) {
            if (expanded.charAt(i) != '\n') continue;
            ++cnt;
        }
        return cnt;
    }

    protected static void fill(String expanded, String[] parameters) {
        int lth = expanded.length();
        boolean cnt = false;
        int k = 0;
        int j = 0;
        for (int i = 0; i < lth; ++i) {
            char c = expanded.charAt(i);
            switch (c) {
                case '\n': 
                case '\r': {
                    char c1;
                    parameters[++k] = expanded.substring(j, i);
                    if (i < lth - 1 && (c1 = expanded.charAt(i + 1)) != c) {
                        switch (c1) {
                            case '\n': 
                            case '\r': {
                                ++i;
                            }
                        }
                    }
                    j = i + 1;
                }
            }
        }
    }

    public static void onObject(LandscapeEditorCore ls, int index, LandscapeObject object) {
        String[] argv;
        String rules;
        String command;
        Diagram diagram;
        if (ls.isApplet()) {
            ls.error("Applets can't open source files");
            return;
        }
        if (object == null && (diagram = ls.getDiagram()) != null) {
            object = diagram.targetEntity(object);
        }
        if (object == null) {
            ls.error("No object specified");
            return;
        }
        if (!(object instanceof LandscapeObject)) {
            ls.error(object + " not a LandscapeObject");
            return;
        }
        if (index < 0 || index >= 8) {
            index = 0;
        }
        if ((command = m_commands[index]) == null) {
            ExecuteAction.configure(ls, index);
            command = m_commands[index];
            if (command == null) {
                return;
            }
        }
        if ((rules = m_rules[index]) == null) {
            argv = new String[1];
        } else {
            String expanded = ExecuteAction.expand(object, rules, 0, false);
            expanded = ExecuteAction.contract(expanded);
            int cnt = ExecuteAction.count(expanded);
            argv = new String[cnt + 1];
            if (cnt != 0) {
                ExecuteAction.fill(expanded, argv);
            }
        }
        argv[0] = command;
        ViewSource viewSource = new ViewSource(ls, argv);
        new Thread(viewSource).start();
    }
}

