/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.PrintWriter;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import lsedit.Attribute;
import lsedit.AttributeValue;
import lsedit.ClientSet;
import lsedit.ClientSupplierSet;
import lsedit.ClusterMetrics;
import lsedit.ColorCache;
import lsedit.Diagram;
import lsedit.EdgePoint;
import lsedit.EntityBelow;
import lsedit.EntityCache;
import lsedit.EntityChildren;
import lsedit.EntityChildrenShown;
import lsedit.EntityClass;
import lsedit.EntityComponent;
import lsedit.EntityPosition;
import lsedit.FontCache;
import lsedit.LandscapeClassObject;
import lsedit.LandscapeEditorCore;
import lsedit.LandscapeObject3D;
import lsedit.Option;
import lsedit.Options;
import lsedit.RelationClass;
import lsedit.RelationComponent;
import lsedit.RelationInstance;
import lsedit.ResultBox;
import lsedit.SupplierSet;
import lsedit.Ta;
import lsedit.TaFeedback;
import lsedit.Util;
import lsedit.Version;
import lsedit.View;

public final class EntityInstance
extends LandscapeObject3D
implements Icon,
MouseListener,
MouseMotionListener {
    public static final int SMALL_FONT = 0;
    public static final int REG_FONT = 1;
    public static final String LABEL_ID = "label";
    public static final String XRELPOSITION_ID = "xrel";
    public static final String YRELPOSITION_ID = "yrel";
    public static final String WIDTHREL_ID = "widthrel";
    public static final String HEIGHTREL_ID = "heightrel";
    public static final String IN_ELISION_ID = "elision";
    public static final String OUT_ELISION_ID = "outelision";
    public static final String CLIENT_ELISION_ID = "clientelision";
    public static final String SUPPLIER_ELISION_ID = "supplierelision";
    public static final String INTERNAL_ELISION_ID = "internalelision";
    public static final String CLOSED_ELISION_ID = "open";
    public static final String NAVLINK_ID = "navlink";
    public static final String INPOINT_ID = "inpoints";
    public static final String OUTPOINT_ID = "outpoints";
    public static final String LEFTPOINT_ID = "leftpoints";
    public static final String RIGHTPOINT_ID = "rightpoints";
    public static final String DESC_ID = "description";
    public static final String TITLE_ID = "title";
    public static final String FONTDELTA_ID = "fontdelta";
    public static final int ID_ATTR = 0;
    public static final int CLASS_ATTR = 1;
    public static final int LABEL_ATTR = 2;
    public static final int DESC_ATTR = 3;
    public static final int COLOR_ATTR = 4;
    public static final int LABEL_COLOR_ATTR = 5;
    public static final int OPEN_COLOR_ATTR = 6;
    public static final int XRELPOSITION_ATTR = 7;
    public static final int YRELPOSITION_ATTR = 8;
    public static final int WIDTHREL_ATTR = 9;
    public static final int HEIGHTREL_ATTR = 10;
    public static final int FONTDELTA_ATTR = 11;
    public static final int ATTRS = 12;
    public static final String[] attributeName = new String[]{"id", "class", "label", "description", "color", "labelcolor", "opencolor", "xrel", "yrel", "widthrel", "heightrel", "fontdelta"};
    public static final int[] attributeType = new int[]{3, 15, 3, 12, 8, 8, 8, 2, 2, 2, 2, 1};
    public static final String NAVNEXT_ATTR = "LSEDIT_NAVNEXT";
    public static final String NAVPREV_ATTR = "LSEDIT_NAVPREV";
    public static final String NAVNEXT_DRAWROOT_ATTR = "LSEDIT_NAVNEXT_DRAWROOT";
    public static final String NAVPREV_DRAWROOT_ATTR = "LSEDIT_NAVPREV_DRAWROOT";
    public static final int RSZ_NONE = -1;
    private static final int RSZ_NW = 0;
    private static final int RSZ_N = 1;
    private static final int RSZ_NE = 2;
    private static final int RSZ_E = 3;
    private static final int RSZ_SE = 4;
    private static final int RSZ_S = 5;
    private static final int RSZ_SW = 6;
    private static final int RSZ_W = 7;
    private static final double TAB_HEIGHT = 16.0;
    private static final int MOUSE_NEAR_EDGE_THRESHOLD = 4;
    private static final int SEP_THRESHOLD = 8;
    private static final int MARGIN = 5;
    private static final int MIN_HEIGHT = 10;
    private static final int MIN_WIDTH = 30;
    private static final int CONTENTS_FLAG_DIM = 8;
    public static final int DIAGRAM_MARK = 1;
    public static final int CLIENT_MARK = 2;
    public static final int SUPPLIER_MARK = 4;
    public static final int HIDDEN_MARK = 8;
    public static final int DRAWROOT_MARK = 16;
    public static final int UNDER_DRAWROOT_MARK = 64;
    public static final int LEGEND_MARK = 128;
    public static final int OMNIPRESENT_LIBRARY = 256;
    public static final int OMNIPRESENT_CLIENT = 512;
    public static final int OMNIPRESENT_SUPPLIER = 1024;
    public static final int TRACED_MARK = 2048;
    public static final int REDBOX_MARK = 32768;
    public static final int GROUP_MARK = 65536;
    public static final int GROUPKEY_MARK = 131072;
    public static final int OPEN_MARK = 262144;
    public static final int CLOSED_MARK = 524288;
    public static final int NOT_IN_FOREST_MARK = 0x100000;
    public static final int IN_GRAPH_MARK = 0x200000;
    public static final int HOVER_SCALE_MARK = 0x400000;
    public static final int COMPACT_MARK = 0x800000;
    public static final int HAS_LABEL_MARK = 0x1000000;
    public static final int DELETED_MARK = 0x2000000;
    public static final int SPRING_MARK = 0x4000000;
    public static final int IN_SET_MARK = 0x8000000;
    public static final int SHADING_KNOWN_MARK = 0x10000000;
    public static final int SHADES_MARK = 0x20000000;
    public static final int EXPANDED_TOC_MARK = 0x40000000;
    public static final int CLIENT_SUPPLIER = 6;
    public static final int IN_DIAGRAM = 7;
    public static final int PRESENTATION_MARKS = 231424;
    public static final int OMNIPRESENT_CS = 1536;
    public static final int OMNIPRESENT = 1792;
    public static final int PERMANENT_MARKS = 50333456;
    public static final double WIDTHRELLOCAL_DEFAULT = 0.9375;
    public static final double HEIGHTRELLOCAL_DEFAULT = 0.9375;
    private static Font m_closedFont = null;
    private static Font m_openFont = null;
    private static Font m_smallFont = null;
    private static EntityInstance m_currentDescEntity = null;
    private int m_mark = 0;
    public static final int DST_ELISION = 0;
    public static final int SRC_ELISION = 1;
    public static final int ENTERING_ELISION = 2;
    public static final int EXITING_ELISION = 3;
    public static final int INTERNAL_ELISION = 4;
    public static final int CLOSED_ELISION = 5;
    public static final int ELISIONS = 6;
    public static final int BOX_ELISION = 7;
    private BitSet m_elisions;
    private EdgePoint[] m_edgePoints;
    protected short m_xRelLocal = Short.MIN_VALUE;
    protected short m_yRelLocal = Short.MIN_VALUE;
    protected short m_widthRelLocal = Short.MIN_VALUE;
    protected short m_heightRelLocal = Short.MIN_VALUE;
    protected EntityPosition[] m_positions = null;
    private int m_fontDelta = 0;
    private int m_preorder;
    private int m_postorder;
    private EntityInstance m_drawEntity;
    private Vector m_srcRelList = null;
    private Vector m_dstRelList = null;
    private EntityComponent m_entityComponent = null;
    private RelationInstance m_containedByRelation = null;

    @Override
    public String toString() {
        return this.getEntityLabel();
    }

    public int getWidth() {
        if (this.m_entityComponent == null) {
            return 0;
        }
        return this.m_entityComponent.getWidth();
    }

    public int getHeight() {
        if (this.m_entityComponent == null) {
            return 0;
        }
        return this.m_entityComponent.getHeight();
    }

    public void setVisible(boolean value) {
        if (value) {
            EntityComponent entityComponent = this.neededComponent();
            entityComponent.setVisible(true);
        } else {
            EntityComponent entityComponent = this.m_entityComponent;
            if (entityComponent != null) {
                entityComponent.setVisible(false);
            }
        }
    }

    protected String getExtendedDescription() {
        String temp;
        RelationClass rc;
        String ret = this.getDescription();
        if (this.m_containedByRelation != null && (rc = this.m_containedByRelation.getRelationClass()) != null && rc.getContainsClassOffset() > 0 && (temp = rc.getLabel()) != null) {
            temp = "(" + temp + ")";
            if (ret != null) {
                temp = temp + " " + ret;
            }
            ret = temp;
        }
        return ret;
    }

    public void setToolTipText(EntityComponent entityComponent) {
        String text;
        if (this.isDrawRoot()) {
            text = null;
        } else {
            text = this.getExtendedDescription();
            if (text == null) {
                text = this.getFullEntityLabel();
            }
        }
        entityComponent.setToolTipText(text);
    }

    public void setToolTipText() {
        EntityComponent component = this.m_entityComponent;
        if (component != null) {
            this.setToolTipText(component);
        }
    }

    public void repaint() {
        EntityComponent entityComponent = this.m_entityComponent;
        if (entityComponent != null) {
            entityComponent.repaint();
        }
    }

    public void revalidate() {
        EntityComponent entityComponent = this.m_entityComponent;
        if (entityComponent != null) {
            entityComponent.revalidate();
        }
    }

    @Override
    public JComponent getSwingObject() {
        return this.m_entityComponent;
    }

    public int getDiagramX() {
        return this.m_entityComponent.getDiagramX();
    }

    public int getDiagramY() {
        return this.m_entityComponent.getDiagramY();
    }

    public Rectangle getDiagramBounds() {
        return this.m_entityComponent.getDiagramBounds();
    }

    public double getEdgePointX(EdgePoint edgePoint) {
        EntityComponent entityComponent = this.m_entityComponent;
        double wf = this.isDrawRoot() ? edgePoint.getWidthFactor() : edgePoint.getAdjustedWidthFactor();
        return (double)entityComponent.getDiagramX() + (double)entityComponent.getWidth() * wf;
    }

    public double getEdgePointY(EdgePoint edgePoint) {
        EntityComponent entityComponent = this.m_entityComponent;
        double hf = this.isDrawRoot() ? edgePoint.getHeightFactor() : edgePoint.getAdjustedHeightFactor();
        return (double)entityComponent.getDiagramY() + (double)entityComponent.getHeight() * hf;
    }

    public void refillEdges() {
        this.m_entityComponent.refillEdges();
    }

    public void computeShading() {
        this.m_entityComponent.computeShading();
    }

    public void paintMap(Graphics g, int x, int y, int width, int height, EntityInstance onPath, int depth) {
        EntityComponent entityComponent = this.neededComponent();
        entityComponent.paintMap(g, x, y, width, height, onPath, depth);
    }

    public void addContainment(EntityInstance e) {
        if (this.isMarked(80)) {
            e.orMark(64);
        }
        if (this.inDiagram()) {
            EntityComponent entityComponent = this.m_entityComponent;
            EntityComponent childComponent = e.neededComponent();
            this.openStatusUnknown();
            entityComponent.add(childComponent);
            if (this.isOpen()) {
                e.orMark(7);
            }
        }
    }

    public void removeContainment(EntityInstance e) {
        EntityComponent childComponent;
        EntityComponent entityComponent = this.m_entityComponent;
        if (entityComponent != null && (childComponent = e.getEntityComponent()) != null) {
            entityComponent.remove(childComponent);
        }
        e.m_mark &= 0x3000710;
    }

    public void resizeDstCardinals(int numRelations) {
        this.m_entityComponent.resizeDstCardinals(numRelations);
    }

    public void resizeSrcCardinals(int numRelations) {
        this.m_entityComponent.resizeSrcCardinals(numRelations);
    }

    public void resetDstCardinals() {
        this.m_entityComponent.resetDstCardinals();
    }

    public void resetSrcCardinals() {
        this.m_entityComponent.resetSrcCardinals();
    }

    public void calcDstEdgeCardinals() {
        this.m_entityComponent.calcDstEdgeCardinals();
    }

    public void calcSrcEdgeCardinals() {
        this.m_entityComponent.calcSrcEdgeCardinals();
    }

    public void showDstCardinals() {
        this.m_entityComponent.showDstCardinals(this.getDiagram());
    }

    public void showSrcCardinals() {
        this.m_entityComponent.showSrcCardinals(this.getDiagram());
    }

    public EntityInstance(EntityClass parentClass, String id) {
        if (m_openFont == null) {
            m_openFont = Options.getTargetFont(3);
        }
        if (m_closedFont == null) {
            m_closedFont = Options.getTargetFont(1);
        }
        if (m_smallFont == null) {
            m_smallFont = Options.getTargetFont(2);
        }
        this.setParentClass(parentClass);
        super.setLabel(id);
        this.setId(id);
    }

    public static void setOpenFont(Font font) {
        m_openFont = font;
    }

    public static void setClosedFont(Font font) {
        m_closedFont = font;
    }

    public static Font getSmallFont() {
        return m_smallFont;
    }

    public static void setSmallFont(Font font) {
        m_smallFont = font;
    }

    public EntityClass getEntityClass() {
        return (EntityClass)this.getParentClass();
    }

    @Override
    public String getStyleName(int style) {
        return EntityClass.getEntityStyleName(style);
    }

    public String getNavNext() {
        Attribute attribute = this.getLsAttribute(NAVNEXT_ATTR);
        if (attribute != null) {
            return attribute.parseString();
        }
        return null;
    }

    public void putNavNext(String value) {
        this.putAttribute(NAVNEXT_ATTR, EntityInstance.qt(value));
    }

    public String getNavNextDrawRoot() {
        Attribute attribute = this.getLsAttribute(NAVNEXT_DRAWROOT_ATTR);
        if (attribute != null) {
            return attribute.parseString();
        }
        return null;
    }

    public void putNavNextDrawRoot(String value) {
        this.putAttribute(NAVNEXT_DRAWROOT_ATTR, EntityInstance.qt(value));
    }

    public String getNavPrev() {
        Attribute attribute = this.getLsAttribute(NAVPREV_ATTR);
        if (attribute != null) {
            return attribute.parseString();
        }
        Diagram diagram = this.getDiagram();
        EntityInstance root = diagram.getRootInstance();
        if (root != this) {
            return root.getNavPrev();
        }
        return null;
    }

    public void putNavPrev(String value) {
        this.putAttribute(NAVPREV_ATTR, EntityInstance.qt(value));
    }

    public String getNavPrevDrawRoot() {
        Attribute attribute = this.getLsAttribute(NAVPREV_DRAWROOT_ATTR);
        if (attribute != null) {
            return attribute.parseString();
        }
        Diagram diagram = this.getDiagram();
        EntityInstance root = diagram.getRootInstance();
        if (root != this) {
            return root.getNavPrevDrawRoot();
        }
        return null;
    }

    public void putNavPrevDrawRoot(String value) {
        this.putAttribute(NAVPREV_DRAWROOT_ATTR, EntityInstance.qt(value));
    }

    public void orMark(int val) {
        this.m_mark |= val;
    }

    public void andMark(int val) {
        this.m_mark &= val;
    }

    public void nandMark(int val) {
        this.m_mark &= ~val;
    }

    public boolean isMarked(int val) {
        return (this.m_mark & val) != 0;
    }

    public boolean isAllMarked(int val) {
        return (this.m_mark & val) == val;
    }

    public int getMark() {
        return this.m_mark;
    }

    public int getOmnipresent() {
        return this.m_mark & 0x700;
    }

    public boolean isClient() {
        return this.isMarked(2);
    }

    public boolean isSupplier() {
        return this.isMarked(4);
    }

    public boolean isClientOrSupplier() {
        return this.isMarked(6);
    }

    public boolean isShown() {
        if (this.isMarked(16)) {
            return true;
        }
        return this.getEntityClass().isShown();
    }

    public void markDeleted() {
        this.m_mark |= 0x2000000;
    }

    public void clearDeleted() {
        this.m_mark &= 0xFDFFFFFF;
    }

    public Color getBackgroundWhenOpen() {
        Color c = this.getInheritedColorWhenOpen();
        if (c == null) {
            int v = 191;
            EntityInstance b = this;
            EntityInstance root = this.getDrawRoot();
            if (!root.hasDescendant(this)) {
                root = root.commonAncestor(this);
            }
            while (b != root) {
                if ((v -= 13) <= 0) {
                    return Color.lightGray;
                }
                b = b.getContainedBy();
            }
            c = ColorCache.get(v, v, v);
        }
        return c;
    }

    public Color getCurrentObjectColor() {
        Color c = this.isOpen() ? this.getBackgroundWhenOpen() : this.getInheritedObjectColor();
        return c;
    }

    public Color getCurrentLabelColor() {
        Color c;
        Option option = Options.getDiagramOptions();
        if (option.isLabelInvertForeground()) {
            c = this.getCurrentObjectColor();
            if (!option.isLabelInvertBackground()) {
                c = ColorCache.getInverse(c.getRGB());
            }
        } else {
            c = this.getInheritedLabelColor();
        }
        if (option.isLabelBlackWhite()) {
            c = ColorCache.getBW(c);
        }
        return c;
    }

    public void notInForest(boolean switching) {
        Vector dstRelList = this.m_dstRelList;
        this.orMark(0x100000);
        if (dstRelList != null) {
            Enumeration en = dstRelList.elements();
            while (en.hasMoreElements()) {
                RelationInstance ri = (RelationInstance)en.nextElement();
                if (!ri.isMarked(0x100000)) continue;
                if (switching) {
                    this.savePositioning(ri.getRelationClass());
                }
                ri.nandMark(0x100000);
            }
        }
    }

    public void tryToAddToForest(RelationClass containsClass, TaFeedback taFeedback) {
        Vector dstRelList = this.m_dstRelList;
        int seen = 0;
        if (dstRelList != null) {
            int i = dstRelList.size();
            while (--i >= 0) {
                RelationInstance ri = (RelationInstance)dstRelList.elementAt(i);
                if (ri.getParentClass() != containsClass) continue;
                ++seen;
                if (!this.isMarked(0x100000)) continue;
                EntityInstance parent = ri.getSrc();
                while (!parent.isMarked(0x100000)) {
                    parent = parent.getContainedBy();
                }
                if (parent == this) {
                    taFeedback.showCycle(ri);
                    continue;
                }
                this.nandMark(0x100000);
                this.setContainedByRelation(ri);
            }
        }
        if (seen > 0 && seen > 1) {
            taFeedback.hasMultipleParents(containsClass, this);
        }
    }

    public Font getAdjustedClosedFont(Font font) {
        int size1;
        int size = size1 = font.getSize();
        size1 += this.m_fontDelta;
        if ((this.m_mark & 0x400000) != 0) {
            size1 = (int)((double)size1 * Options.getHoverScale());
        }
        if (size1 != size) {
            String fontname = font.getFamily();
            int style = font.getStyle();
            if (size1 < 1) {
                size1 = 1;
            }
            font = FontCache.get(fontname, style, size1);
        }
        return font;
    }

    protected void setFont(Graphics g, int type) {
        Font font = type == 0 ? m_smallFont : this.getAdjustedClosedFont(m_closedFont);
        g.setFont(font);
    }

    public int getFontDelta() {
        return this.m_fontDelta;
    }

    public void setFontDelta(int value) {
        this.m_fontDelta = value;
    }

    public String getTitle() {
        Attribute attribute = this.getLsAttribute(TITLE_ID);
        if (attribute != null) {
            return attribute.parseString();
        }
        return null;
    }

    @Override
    public String getLabel() {
        if (this.isMarked(0x1000000)) {
            return super.getLabel();
        }
        return null;
    }

    @Override
    public void setLabel(String value) {
        if (value == null || Util.isBlank(value)) {
            if (this.isMarked(0x1000000)) {
                super.setLabel(this.getId());
                this.m_mark &= 0xFEFFFFFF;
            }
        } else {
            super.setLabel(value);
            this.orMark(0x1000000);
        }
    }

    public String getEntityLabel() {
        return super.getLabel();
    }

    public String getFullEntityLabel() {
        if (this.isMarked(0x1000000)) {
            return super.getLabel();
        }
        return super.getId();
    }

    public Font getEntityLabelFont() {
        Font font = this.isOpen() ? (this.getInheritedStyle() == 6 ? m_openFont : m_smallFont) : (!this.isMarked(6) ? this.getAdjustedClosedFont(m_closedFont) : ClientSupplierSet.getClientSupplierFont());
        return font;
    }

    public String getClassLabel() {
        return this.getEntityClass().getLabel();
    }

    public Dimension getLabelDim(Graphics g, int type, boolean wParent) {
        EntityInstance pe;
        String str = this.getEntityLabel();
        this.setFont(g, type);
        if (wParent && (pe = this.getContainedBy()) != null) {
            str = pe.getEntityLabel() + " |\n" + str;
        }
        return Util.stringWrappedDim(g, str);
    }

    public Dimension getLabelDim(Graphics g, int type) {
        return this.getLabelDim(g, type, false);
    }

    public int getMinFitWidth(Graphics graphics) {
        Dimension ld = this.getLabelDim(graphics, 1);
        int minWidth = ld.width + 10;
        if (this.hasChildren()) {
            minWidth += 11;
        }
        return minWidth;
    }

    public Dimension getFitDim(Graphics g, int font_type, boolean wParent) {
        Dimension dim = this.getLabelDim(g, font_type, wParent);
        if (this.hasChildren() && !this.isStateOpen()) {
            dim.width += 8;
        }
        dim.width += 15;
        dim.height += 7;
        return dim;
    }

    public Dimension getFitDim(Graphics g, int font_type) {
        return this.getFitDim(g, font_type, false);
    }

    private int trueWidth() {
        return this.m_widthRelLocal + Short.MAX_VALUE;
    }

    private int trueHeight() {
        return this.m_heightRelLocal + Short.MAX_VALUE;
    }

    public double xRelLocal() {
        double ret = Util.shortToRelative(this.m_xRelLocal);
        if ((this.m_mark & 0x400000) != 0 && (ret += Util.shortToRelative(this.m_widthRelLocal) * (1.0 - Options.getHoverScale()) / 2.0) < 0.0) {
            ret = 0.0;
        }
        return ret;
    }

    public void setXRelLocal(double xRelLocal) {
        this.m_xRelLocal = Util.relativeToShort(xRelLocal);
    }

    public void setXRelLocalBounded(short xRelLocal) {
        this.m_xRelLocal = xRelLocal;
    }

    public double yRelLocal() {
        double ret = Util.shortToRelative(this.m_yRelLocal);
        if ((this.m_mark & 0x400000) != 0 && (ret += Util.shortToRelative(this.m_heightRelLocal) * (1.0 - Options.getHoverScale()) / 2.0) < 0.0) {
            ret = 0.0;
        }
        return ret;
    }

    public void setYRelLocal(double yRelLocal) {
        this.m_yRelLocal = Util.relativeToShort(yRelLocal);
    }

    public void setYRelLocalBounded(short yRelLocal) {
        this.m_yRelLocal = yRelLocal;
    }

    public double widthRelLocal() {
        double ret = Util.shortToRelative(this.m_widthRelLocal);
        if ((this.m_mark & 0x400000) != 0 && (ret *= Options.getHoverScale()) > 1.0) {
            ret = 1.0;
        }
        return ret;
    }

    public void setWidthRelLocal(double widthRelLocal) {
        this.m_widthRelLocal = Util.relativeToShort(widthRelLocal);
    }

    public void setWidthRelLocalBounded(short widthRelLocal) {
        int truewidth = widthRelLocal + Short.MAX_VALUE;
        int rightPoint = this.m_xRelLocal + truewidth;
        if (rightPoint > Short.MAX_VALUE) {
            this.m_xRelLocal = (short)(Short.MAX_VALUE - truewidth);
        }
        this.m_widthRelLocal = widthRelLocal;
    }

    public double heightRelLocal() {
        double ret = Util.shortToRelative(this.m_heightRelLocal);
        if ((this.m_mark & 0x400000) != 0 && (ret *= Options.getHoverScale()) > 1.0) {
            ret = 1.0;
        }
        return ret;
    }

    public void setHeightRelLocal(double heightRelLocal) {
        this.m_heightRelLocal = Util.relativeToShort(heightRelLocal);
    }

    public void setHeightRelLocalBounded(short heightRelLocal) {
        int trueheight = heightRelLocal + Short.MAX_VALUE;
        int bottomEnd = this.m_yRelLocal + trueheight;
        if (bottomEnd > Short.MAX_VALUE) {
            this.m_yRelLocal = (short)(Short.MAX_VALUE - trueheight);
        }
        this.m_heightRelLocal = heightRelLocal;
    }

    public void setRelLocal(short x, short y, short width, short height) {
        this.m_xRelLocal = x;
        this.m_yRelLocal = y;
        this.m_widthRelLocal = width;
        this.m_heightRelLocal = height;
    }

    public void setRelLocal(double x, double y, double width, double height) {
        this.setXRelLocal(x);
        this.setYRelLocal(y);
        this.setWidthRelLocal(width);
        this.setHeightRelLocal(height);
    }

    public void setRelLocal(EntityInstance e) {
        this.m_xRelLocal = e.m_xRelLocal;
        this.m_yRelLocal = e.m_yRelLocal;
        this.m_widthRelLocal = e.m_widthRelLocal;
        this.m_heightRelLocal = e.m_heightRelLocal;
    }

    protected boolean overlaps(EntityInstance container) {
        short xrel1 = this.m_xRelLocal;
        short yrel1 = this.m_yRelLocal;
        int xendrel1 = xrel1 + this.trueWidth();
        int yendrel1 = yrel1 + this.trueHeight();
        Enumeration en = container.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en.nextElement();
            short xrel2 = e.m_xRelLocal;
            short yrel2 = e.m_yRelLocal;
            int xendrel2 = xrel2 + e.trueWidth();
            int yendrel2 = yrel2 + e.trueHeight();
            if (xrel2 > xendrel1 || yrel2 > yendrel1 || xendrel2 < xrel1 || yendrel2 < yrel1) continue;
            return true;
        }
        return false;
    }

    protected void getEdgePoints(short[] xpoints, short[] ypoints) {
        xpoints[0] = xpoints[3] = this.m_xRelLocal;
        ypoints[0] = ypoints[1] = this.m_yRelLocal;
        xpoints[1] = xpoints[2] = (short)(this.m_xRelLocal + this.trueWidth());
        ypoints[2] = ypoints[3] = (short)(this.m_yRelLocal + this.trueHeight());
    }

    protected static void getFramePoints(short[] xpoints, short[] ypoints) {
        ypoints[1] = -32767;
        ypoints[0] = -32767;
        xpoints[3] = -32767;
        xpoints[0] = -32767;
        ypoints[3] = Short.MAX_VALUE;
        ypoints[2] = Short.MAX_VALUE;
        xpoints[2] = Short.MAX_VALUE;
        xpoints[1] = Short.MAX_VALUE;
    }

    protected void setInitialLocation(EntityInstance container) {
        short y;
        short x;
        int bestheight;
        int bestwidth;
        int besty;
        int bestx;
        EntityInstance child;
        EntityInstance[] children = new EntityInstance[container.numChildren()];
        short[] xpoints1 = new short[4];
        short[] ypoints1 = new short[4];
        short[] xpoints2 = new short[4];
        short[] ypoints2 = new short[4];
        int size = 0;
        Enumeration en = container.getChildren();
        while (en.hasMoreElements()) {
            child = (EntityInstance)en.nextElement();
            if (child == this || !Util.defined(child.m_xRelLocal) || !Util.defined(child.m_yRelLocal) || !Util.defined(child.m_widthRelLocal) || !Util.defined(child.m_heightRelLocal)) continue;
            children[size++] = child;
        }
        if (size == 0) {
            bestx = -32767;
            besty = -32767;
            bestwidth = 65534;
            bestheight = 65534;
        } else {
            bestx = -32767;
            besty = -32767;
            bestwidth = 0;
            bestheight = 0;
            int bestarea = 0;
            for (int i = 0; i <= size; ++i) {
                if (i < size) {
                    child = children[i];
                    child.getEdgePoints(xpoints1, ypoints1);
                } else {
                    EntityInstance.getFramePoints(xpoints1, ypoints1);
                }
                for (int j = i; j <= size; ++j) {
                    if (j < size) {
                        child = children[j];
                        child.getEdgePoints(xpoints2, ypoints2);
                    } else {
                        EntityInstance.getFramePoints(xpoints2, ypoints2);
                    }
                    for (int i1 = 0; i1 < 4; ++i1) {
                        int j1;
                        short xpoint1 = xpoints1[i1];
                        short ypoint1 = ypoints1[i1];
                        int n = j1 = i == j ? i1 + 1 : 0;
                        while (j1 < 4) {
                            short ypoint2;
                            int height;
                            short xpoint2 = xpoints2[j1];
                            int width = xpoint2 - xpoint1;
                            if (width != 0 && (height = (ypoint2 = ypoints2[j1]) - ypoint1) != 0) {
                                int area;
                                if (width < 0) {
                                    x = xpoint2;
                                    width = -width;
                                } else {
                                    x = xpoint1;
                                }
                                if (height < 0) {
                                    y = ypoint2;
                                    height = -height;
                                } else {
                                    y = ypoint1;
                                }
                                short xend = (short)(x + width);
                                short yend = (short)(y + height);
                                int k = size;
                                while (k > 0) {
                                    short y1end;
                                    short y1;
                                    short x1end;
                                    child = children[--k];
                                    short x1 = child.m_xRelLocal;
                                    if (x1 >= xend || (x1end = (short)(x1 + child.trueWidth())) <= x || (y1 = child.m_yRelLocal) >= yend || (y1end = (short)(y1 + child.trueHeight())) <= y) continue;
                                    ++k;
                                    break;
                                }
                                if (k == 0 && (area = width * height) > bestarea) {
                                    bestx = x;
                                    besty = y;
                                    bestarea = area;
                                    bestwidth = width;
                                    bestheight = height;
                                }
                            }
                            ++j1;
                        }
                    }
                }
            }
        }
        x = (short)(bestx + (bestwidth /= 2) / 2);
        y = (short)(besty + (bestheight /= 2) / 2);
        this.setRelLocal(x, y, (short)(bestwidth -= Short.MAX_VALUE), (short)(bestheight -= Short.MAX_VALUE));
    }

    public EntityComponent getEntityComponent() {
        return this.m_entityComponent;
    }

    public void setEntityComponent(EntityComponent entityComponent) {
        this.m_entityComponent = entityComponent;
    }

    public EntityComponent neededPlainComponent() {
        EntityComponent entityComponent = this.m_entityComponent;
        if (entityComponent == null) {
            entityComponent = new EntityComponent(this);
        }
        return entityComponent;
    }

    public EntityComponent neededComponent() {
        EntityComponent entityComponent = this.m_entityComponent;
        if (entityComponent == null) {
            entityComponent = new EntityComponent(this);
            this.setToolTipText(entityComponent);
            entityComponent.addMouseListener(this);
            entityComponent.addMouseMotionListener(this);
        }
        return entityComponent;
    }

    public Vector getSrcRelList() {
        return this.m_srcRelList;
    }

    public void addSrcRelation(RelationInstance ri) {
        Vector<RelationInstance> srcRelList = this.m_srcRelList;
        if (srcRelList == null) {
            this.m_srcRelList = srcRelList = new Vector<RelationInstance>();
        }
        srcRelList.addElement(ri);
    }

    public void addSrcRelationIfAbsent(RelationInstance ri) {
        Vector srcRelList = this.m_srcRelList;
        if (srcRelList == null) {
            this.m_srcRelList = srcRelList = new Vector();
        } else if (srcRelList.contains(ri)) {
            return;
        }
        this.m_srcRelList.addElement(ri);
    }

    public boolean removeSrcRelation(RelationInstance ri) {
        Vector srcRelList = this.m_srcRelList;
        boolean ret = false;
        if (srcRelList != null) {
            ret = srcRelList.removeElement(ri);
            if (srcRelList.isEmpty()) {
                this.m_srcRelList = null;
            }
        }
        return ret;
    }

    public Enumeration srcRelationElements() {
        Vector srcRelList = this.m_srcRelList;
        if (srcRelList != null) {
            return srcRelList.elements();
        }
        return null;
    }

    public Vector getDstRelList() {
        return this.m_dstRelList;
    }

    public void addDstRelation(RelationInstance ri) {
        Vector<RelationInstance> dstRelList = this.m_dstRelList;
        if (dstRelList == null) {
            this.m_dstRelList = dstRelList = new Vector<RelationInstance>();
        }
        dstRelList.addElement(ri);
    }

    public void addDstRelationIfAbsent(RelationInstance ri) {
        Vector<RelationInstance> dstRelList = this.m_dstRelList;
        if (dstRelList == null) {
            this.m_dstRelList = dstRelList = new Vector<RelationInstance>();
        } else if (dstRelList.contains(ri)) {
            return;
        }
        dstRelList.addElement(ri);
    }

    public boolean removeDstRelation(RelationInstance ri) {
        Vector dstRelList = this.m_dstRelList;
        boolean ret = false;
        if (dstRelList != null) {
            ret = dstRelList.removeElement(ri);
            if (dstRelList.isEmpty()) {
                dstRelList = null;
            }
        }
        return ret;
    }

    public Enumeration dstRelationElements() {
        Vector dstRelList = this.m_dstRelList;
        if (dstRelList != null) {
            return dstRelList.elements();
        }
        return null;
    }

    public Vector getSrcLiftedList() {
        EntityComponent entityComponent = this.m_entityComponent;
        if (entityComponent != null) {
            return entityComponent.getSrcLiftedList();
        }
        return null;
    }

    public Vector getDstLiftedList() {
        EntityComponent entityComponent = this.m_entityComponent;
        if (entityComponent != null) {
            return this.m_entityComponent.getDstLiftedList();
        }
        return null;
    }

    public Enumeration srcLiftedRelationElements() {
        Vector srcLiftedList = this.getSrcLiftedList();
        if (srcLiftedList != null) {
            return srcLiftedList.elements();
        }
        return null;
    }

    public Enumeration dstLiftedRelationElements() {
        Vector dstLiftedList = this.getDstLiftedList();
        if (dstLiftedList != null) {
            return dstLiftedList.elements();
        }
        return null;
    }

    public RelationInstance getRelationTo(RelationClass rc, EntityInstance dst) {
        Vector srcRelList = this.m_srcRelList;
        if (srcRelList != null) {
            Enumeration en = srcRelList.elements();
            while (en.hasMoreElements()) {
                RelationInstance ri = (RelationInstance)en.nextElement();
                if (ri.getRelationClass() != rc || ri.getDst() != dst) continue;
                return ri;
            }
        }
        return null;
    }

    public void compact() {
        Vector v = this.m_srcRelList;
        if (v != null) {
            v.trimToSize();
        }
        if ((v = this.m_dstRelList) != null) {
            v.trimToSize();
        }
    }

    public boolean hasChildren() {
        Vector srcRelList = this.m_srcRelList;
        if (srcRelList != null) {
            int i = srcRelList.size();
            while (--i >= 0) {
                RelationInstance ri = (RelationInstance)srcRelList.elementAt(i);
                if (!ri.isMarked(0x100000)) continue;
                return true;
            }
        }
        return false;
    }

    public int numChildren() {
        Vector srcRelList = this.m_srcRelList;
        int ret = 0;
        if (srcRelList != null) {
            int i = srcRelList.size();
            while (--i >= 0) {
                RelationInstance ri = (RelationInstance)srcRelList.elementAt(i);
                if (!ri.isMarked(0x100000)) continue;
                ++ret;
            }
        }
        return ret;
    }

    public EntityInstance getFirstChild() {
        Vector srcRelList = this.m_srcRelList;
        if (srcRelList != null) {
            int size = srcRelList.size();
            for (int i = 0; i < size; ++i) {
                RelationInstance ri = (RelationInstance)srcRelList.elementAt(i);
                if (!ri.isMarked(0x100000)) continue;
                return ri.getDst();
            }
        }
        return null;
    }

    public EntityInstance getChild(int index) {
        Vector srcRelList = this.m_srcRelList;
        if (srcRelList != null) {
            int size = srcRelList.size();
            for (int i = 0; i < size; ++i) {
                RelationInstance ri = (RelationInstance)srcRelList.elementAt(i);
                if (!ri.isMarked(0x100000)) continue;
                if (index == 0) {
                    return ri.getDst();
                }
                --index;
            }
        }
        return null;
    }

    public int getIndexOfChild(Object child) {
        Vector srcRelList = this.m_srcRelList;
        if (srcRelList != null) {
            int size = srcRelList.size();
            int index = 0;
            for (int i = 0; i < size; ++i) {
                RelationInstance ri = (RelationInstance)srcRelList.elementAt(i);
                if (!ri.isMarked(0x100000)) continue;
                if (ri.getDst() == child) {
                    return index;
                }
                ++index;
            }
        }
        return -1;
    }

    public Enumeration getChildren() {
        return new EntityChildren(this.m_srcRelList);
    }

    public Enumeration getChildrenShown() {
        return new EntityChildrenShown(this.m_srcRelList);
    }

    public void addChildren(Vector v) {
        Vector srcRelList = this.m_srcRelList;
        if (srcRelList != null) {
            int size = srcRelList.size();
            for (int i = 0; i < size; ++i) {
                RelationInstance ri = (RelationInstance)srcRelList.elementAt(i);
                if (!ri.isMarked(0x100000)) continue;
                v.add(ri.getDst());
            }
        }
    }

    public Enumeration getBelow(RelationClass rc) {
        return new EntityBelow(this.m_srcRelList, rc);
    }

    public RelationInstance getContainedByRelation() {
        return this.m_containedByRelation;
    }

    public void setContainedByRelation(RelationInstance spanning) {
        spanning.orMark(0x100000);
        this.m_containedByRelation = spanning;
        this.restorePositioning(spanning.getRelationClass());
    }

    public EntityInstance getContainedBy() {
        RelationInstance ri = this.getContainedByRelation();
        if (ri != null) {
            return ri.getSrc();
        }
        return null;
    }

    public EntityInstance getOriginalContainedBy() {
        Diagram diagram = this.getDiagram();
        RelationClass contains = diagram.getDefaultContainsClass();
        Vector v = this.m_dstRelList;
        int i = 2;
        while (true) {
            if (v != null) {
                int j = v.size();
                while (--j >= 0) {
                    RelationInstance ri = (RelationInstance)v.elementAt(j);
                    if (ri.getParentClass() != contains) continue;
                    if (i == 2) {
                        if (ri.isMarked(0x200000)) continue;
                        return ri.getSrc();
                    }
                    if (!ri.isMarked(0x200000)) continue;
                    return ri.getDst();
                }
            }
            if (--i <= 0) break;
            v = this.m_srcRelList;
        }
        return null;
    }

    public boolean isRoot() {
        return this.getContainedBy() == null;
    }

    public boolean inDiagram() {
        return this.isMarked(7);
    }

    public int prepostorder(int value) {
        this.m_preorder = value;
        Enumeration en = this.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en.nextElement();
            value = e.prepostorder(value + 1);
        }
        this.m_postorder = value;
        return value;
    }

    public int getPreorder() {
        return this.m_preorder;
    }

    public int nodesInSubtree() {
        return this.m_postorder - this.m_preorder + 1;
    }

    public boolean hasAncestor(EntityInstance e) {
        return e.m_preorder < this.m_preorder && this.m_postorder <= e.m_postorder;
    }

    public boolean hasDescendant(EntityInstance e) {
        return this.m_preorder < e.m_preorder && e.m_postorder <= this.m_postorder;
    }

    public boolean hasDescendantOrSelf(EntityInstance e) {
        return this.m_preorder <= e.m_preorder && e.m_postorder <= this.m_postorder;
    }

    public boolean hasDescendantsOrSelf(Vector v) {
        int cnt = v.size();
        for (int i = 0; i < cnt; ++i) {
            EntityInstance e = (EntityInstance)v.elementAt(i);
            if (this.hasDescendantOrSelf(e)) continue;
            return false;
        }
        return true;
    }

    public EntityInstance commonAncestor(EntityInstance e) {
        EntityInstance e1;
        for (e1 = this.getContainedBy(); e1 != null && !e1.hasDescendant(e); e1 = e1.getContainedBy()) {
        }
        return e1;
    }

    public EntityInstance commonAncestorOrSelf(EntityInstance e) {
        EntityInstance e1;
        for (e1 = this; e1 != null && !e1.hasDescendantOrSelf(e); e1 = e1.getContainedBy()) {
        }
        return e1;
    }

    public void removeAllEdges() {
        RelationInstance ri;
        int i;
        Vector srcRelList = this.m_srcRelList;
        Vector dstRelList = this.m_dstRelList;
        if (srcRelList != null) {
            i = srcRelList.size();
            while (--i >= 0) {
                ri = (RelationInstance)srcRelList.elementAt(i);
                ri.removeEdge();
            }
        }
        if (dstRelList != null) {
            i = dstRelList.size();
            while (--i >= 0) {
                ri = (RelationInstance)dstRelList.elementAt(i);
                ri.removeEdge();
            }
        }
    }

    public void setDefaultOpenStatus() {
        if (this.numChildren() == 1) {
            Enumeration en = this.getChildren();
            while (en.hasMoreElements()) {
                EntityInstance child = (EntityInstance)en.nextElement();
                child.setStateOpen();
            }
        }
    }

    protected EntityInstance getDrawRoot() {
        return this.getDiagram().getDrawRoot();
    }

    public boolean isDrawRoot() {
        return this.isMarked(16);
    }

    public int overResizeTab(int x1, int y1) {
        int pos;
        int xLeft = this.getDiagramX();
        if (x1 < xLeft) {
            return -1;
        }
        if (x1 <= xLeft + 6) {
            pos = 0;
        } else {
            int xRight = xLeft + this.getWidth();
            if (x1 > xRight) {
                return -1;
            }
            if (x1 >= xRight - 6) {
                pos = 2;
            } else {
                int xMid = (xLeft + xRight) / 2;
                if (x1 < xMid - 3 || x1 > xMid + 3) {
                    return -1;
                }
                pos = 1;
            }
        }
        int yTop = this.getDiagramY();
        if (y1 < yTop) {
            return -1;
        }
        if (y1 > yTop + 6) {
            int yBottom = yTop + this.getHeight();
            if (y1 > yBottom) {
                return -1;
            }
            if (y1 >= yBottom - 6) {
                pos += 6;
            } else {
                int yMid = (yTop + yBottom) / 2;
                if (y1 < yMid - 3 || y1 > yMid + 3) {
                    return -1;
                }
                pos += 3;
            }
        }
        switch (pos) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 7;
            }
            case 5: {
                return 3;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 5;
            }
            case 8: {
                return 4;
            }
        }
        return -1;
    }

    protected int numRelationClasses() {
        return this.getTa().numRelationClasses();
    }

    protected RelationClass numToRelationClass(int i) {
        return this.getTa().numToRelationClass(i);
    }

    protected EdgePoint[] needEdgePoints() {
        EdgePoint[] edgePoints = this.m_edgePoints;
        int needed = this.numRelationClasses() * 4;
        if (edgePoints == null) {
            edgePoints = new EdgePoint[needed];
            this.m_edgePoints = edgePoints;
        } else {
            int have = this.m_edgePoints.length;
            if (have < needed) {
                EdgePoint[] old = edgePoints;
                edgePoints = new EdgePoint[needed];
                this.m_edgePoints = edgePoints;
                for (int i = 0; i < have; ++i) {
                    edgePoints[i] = old[i];
                }
                old = null;
            }
        }
        return edgePoints;
    }

    public void refreshIOpoints(RelationClass rc, EdgePoint oldPoint, EdgePoint newPoint) {
        Vector liftedList = this.getSrcLiftedList();
        for (int j = 0; j < 2; ++j) {
            if (liftedList != null) {
                int size = liftedList.size();
                for (int i = 0; i < size; ++i) {
                    RelationComponent relationComponent;
                    RelationInstance ri = (RelationInstance)liftedList.elementAt(i);
                    if (rc != null && ri.getRelationClass() != rc || (relationComponent = ri.getRelationComponent()) == null) continue;
                    relationComponent.switchEdgePoint(oldPoint, newPoint);
                }
            }
            liftedList = this.getDstLiftedList();
        }
    }

    public EdgePoint setFactors(RelationInstance relationInstance, EdgePoint edgePoint, double factorX, double factorY) {
        int index;
        RelationClass rc = relationInstance.getRelationClass();
        EntityClass ec = this.getEntityClass();
        int startindex = rc.getNid() * 4;
        int endindex = startindex + 4;
        if (this.m_edgePoints != null) {
            int size = this.m_edgePoints.length;
            if (endindex > size) {
                endindex = size;
            }
            for (index = startindex; index < endindex; ++index) {
                if (edgePoint != this.m_edgePoints[index]) continue;
                edgePoint.setFactors(ec, factorX, factorY);
                return edgePoint;
            }
        }
        if ((index = ec.getEdgePointIndex(startindex, endindex, edgePoint)) < 0) {
            System.out.println("EntityInstance: Missing edgePoint");
            return edgePoint;
        }
        EdgePoint[] edgePoints = this.needEdgePoints();
        EdgePoint oldPoint = ec.getPoint(index);
        EdgePoint newPoint = new EdgePoint();
        newPoint.setFactors(ec, factorX, factorY);
        edgePoints[index] = newPoint;
        this.refreshIOpoints(rc, oldPoint, newPoint);
        return newPoint;
    }

    public void resetIOpoints() {
        EntityClass ec;
        if (this.m_edgePoints != null && (ec = this.getEntityClass()).isActive()) {
            int size = this.m_edgePoints.length;
            boolean change = false;
            Diagram diagram = null;
            for (int index = 0; index < size; ++index) {
                RelationClass rc1;
                EdgePoint oldPoint = this.m_edgePoints[index];
                if (oldPoint == null) continue;
                int nic = index / 4;
                if (diagram == null) {
                    diagram = this.getDiagram();
                }
                if (!(rc1 = diagram.numToRelationClass(nic)).isActive()) continue;
                int side = index % 4;
                EdgePoint newPoint = ec.getPoint(rc1, side);
                this.m_edgePoints[index] = null;
                this.refreshIOpoints(null, oldPoint, newPoint);
                change = true;
            }
            if (change) {
                this.revalidateAllMyEdgesForClass(null);
            }
        }
        Enumeration en = this.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en.nextElement();
            e.resetIOpoints();
        }
    }

    protected void adjustEdgePoints() {
        EdgePoint[] edgePoints = this.m_edgePoints;
        if (edgePoints != null) {
            for (EdgePoint edgePoint : edgePoints) {
                if (edgePoint == null) continue;
                edgePoint.adjustEdgePoint(this.getEntityClass());
            }
        }
    }

    public boolean isPointOverIO(EdgePoint pt, int x, int y) {
        int x1 = (int)(this.getEdgePointX(pt) + 0.5);
        int y1 = (int)(this.getEdgePointY(pt) + 0.5);
        return x1 - 3 < x && x < x1 + 3 && y1 - 3 < y && y < y1 + 3;
    }

    public EdgePoint getPoint(RelationClass rc, int side) {
        int index;
        EdgePoint edgePoint;
        EdgePoint[] edgePoints = this.m_edgePoints;
        if (edgePoints != null && (edgePoint = edgePoints[index = rc.getNid() * 4 + side]) != null) {
            return edgePoint;
        }
        return this.getEntityClass().getPoint(rc, side);
    }

    public EdgePoint getOutPoint(RelationClass rc, int edge_mode, Rectangle srcLyt, Rectangle dstLyt) {
        if (edge_mode >= 0) {
            return this.getPoint(rc, edge_mode);
        }
        if (dstLyt.y - (srcLyt.y + srcLyt.height) > 8) {
            return this.getPoint(rc, 1);
        }
        if (srcLyt.y - (dstLyt.y + dstLyt.height) > 8) {
            return this.getPoint(rc, 0);
        }
        if (dstLyt.x - (srcLyt.x + srcLyt.width) > 8) {
            return this.getPoint(rc, 3);
        }
        if (srcLyt.x - (dstLyt.x + dstLyt.width) > 8) {
            return this.getPoint(rc, 2);
        }
        if (dstLyt.y > srcLyt.y + srcLyt.height) {
            return this.getPoint(rc, 1);
        }
        return this.getPoint(rc, 0);
    }

    public EdgePoint getLeftOutPoint(RelationInstance ri) {
        RelationClass rc = ri.getRelationClass();
        return this.getPoint(rc, 2);
    }

    public EdgePoint getRightOutPoint(RelationInstance ri) {
        RelationClass rc = ri.getRelationClass();
        return this.getPoint(rc, 3);
    }

    public EdgePoint getTopOutPoint(RelationInstance ri) {
        RelationClass rc = ri.getRelationClass();
        return this.getPoint(rc, 0);
    }

    public EdgePoint getBottomOutPoint(RelationInstance ri) {
        RelationClass rc = ri.getRelationClass();
        return this.getPoint(rc, 1);
    }

    protected EdgePoint getMouseOverIO(int x, int y) {
        EdgePoint[] edgePoints = this.m_edgePoints;
        if (edgePoints != null) {
            for (EdgePoint pt : edgePoints) {
                if (pt == null || !this.isPointOverIO(pt, x, y)) continue;
                return pt;
            }
        }
        return null;
    }

    public void elisionsChanged() {
        EntityComponent entityComponent = this.m_entityComponent;
        if (entityComponent != null) {
            entityComponent.elisionsChanged();
        }
    }

    public int getOpenBit() {
        return this.m_containedByRelation == null ? 0 : this.m_containedByRelation.getRelationClass().getNid() * 6 + 5;
    }

    private BitSet needElisions() {
        BitSet bitset = this.m_elisions;
        if (bitset == null) {
            this.m_elisions = bitset = new BitSet(6 * this.numRelationClasses());
        }
        return bitset;
    }

    public boolean getElision(int bit) {
        BitSet elisions = this.m_elisions;
        if (elisions != null) {
            return elisions.get(bit);
        }
        return false;
    }

    public void clearElision(int bit) {
        BitSet elisions = this.m_elisions;
        if (elisions != null && elisions.get(bit)) {
            elisions.clear(bit);
            if (elisions.isEmpty()) {
                this.m_elisions = null;
            }
        }
    }

    public void setElision(int bit) {
        BitSet elisions = this.needElisions();
        elisions.set(bit);
    }

    public boolean getElision(int type, int nid) {
        return this.getElision(nid * 6 + type);
    }

    public int getElisions(RelationClass rc) {
        int nid = rc.getNid();
        int mask = 1;
        int ret = 0;
        for (int i = 0; i < 6; ++i) {
            if (this.getElision(i, nid)) {
                ret |= mask;
            }
            mask <<= 1;
        }
        return ret;
    }

    public void clearElision(int type, int nid) {
        this.clearElision(nid * 6 + type);
    }

    public void setElision(int type, int nid) {
        this.setElision(nid * 6 + type);
    }

    private void toggleElision(int bit) {
        if (this.getElision(bit)) {
            this.clearElision(bit);
            return;
        }
        this.setElision(bit);
    }

    private void toggleElision(int type, int nid) {
        this.toggleElision(nid * 6 + type);
    }

    public void toggleElision(int type, Enumeration relationClasses) {
        while (relationClasses.hasMoreElements()) {
            RelationClass rc = (RelationClass)relationClasses.nextElement();
            if (!rc.isShown()) continue;
            this.toggleElision(type, rc.getNid());
        }
        this.elisionsChanged();
    }

    public int clearElisions() {
        BitSet elisions = this.m_elisions;
        int ret = 0;
        if (elisions != null) {
            int index = -1;
            boolean seen = false;
            while (true) {
                ++index;
                if ((index = elisions.nextSetBit(index)) < 0) break;
                if (index % 6 == 5) {
                    seen = true;
                    continue;
                }
                elisions.clear(index);
                ret = 1;
            }
            if (!seen) {
                this.m_elisions = null;
            }
        }
        this.elisionsChanged();
        Enumeration en = this.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en.nextElement();
            ret += e.clearElisions();
        }
        return ret;
    }

    public void setOpen() {
        if (!this.isMarked(262144)) {
            this.nandMark(524288);
            this.orMark(262144);
        }
    }

    public void setClosed() {
        if (!this.isMarked(524288)) {
            this.nandMark(262144);
            this.orMark(524288);
        }
    }

    public void openStatusUnknown() {
        this.nandMark(786432);
    }

    public boolean isStateOpen() {
        return this.getElision(this.getOpenBit());
    }

    public boolean setStateClosed() {
        int openBit = this.getOpenBit();
        if (this.getElision(openBit)) {
            this.clearElision(openBit);
            this.nandMark(262144);
            this.orMark(524288);
            return true;
        }
        return false;
    }

    public void setStateOpen() {
        int openBit = this.getOpenBit();
        if (!this.getElision(openBit)) {
            this.setElision(openBit);
            this.openStatusUnknown();
        }
    }

    public boolean isOpen() {
        if (this.isMarked(16)) {
            return true;
        }
        if (!this.isMarked(786432)) {
            if (!this.hasChildren() || this.getWidth() <= 0 || this.getHeight() <= 0) {
                this.setClosed();
            } else if (this.isStateOpen()) {
                this.setOpen();
            } else {
                this.setClosed();
            }
        }
        return this.isMarked(262144);
    }

    public boolean closedWithChildren() {
        return !this.isOpen() && this.hasChildren();
    }

    public boolean red_closed() {
        return this.isMarked(32768) && !this.isOpen();
    }

    public boolean red_open() {
        return this.isMarked(0x408000) && this.isOpen();
    }

    public int closeDescendants() {
        Enumeration en = this.getChildren();
        int ret = 0;
        if (en.hasMoreElements()) {
            BitSet elisions = this.needElisions();
            if (this.isStateOpen()) {
                this.setStateClosed();
                ret = 1;
            }
            while (en.hasMoreElements()) {
                EntityInstance e = (EntityInstance)en.nextElement();
                ret += e.closeDescendants();
            }
        }
        return ret;
    }

    public int openDescendants() {
        Enumeration en = this.getChildren();
        int ret = 0;
        if (en.hasMoreElements()) {
            BitSet elisions = this.m_elisions;
            if (!this.isStateOpen()) {
                this.setStateOpen();
                ret = 1;
            }
            while (en.hasMoreElements()) {
                EntityInstance e = (EntityInstance)en.nextElement();
                ret += e.openDescendants();
            }
        }
        return ret;
    }

    public EntityInstance getMouseOver(int x, int y) {
        EntityComponent entityComponent = this.m_entityComponent;
        if (entityComponent != null && entityComponent.contains(x, y)) {
            if (this.isOpen()) {
                Enumeration en = this.getChildrenShown();
                while (en.hasMoreElements()) {
                    EntityInstance e = (EntityInstance)en.nextElement();
                    EntityInstance over = e.getMouseOver(x, y);
                    if (over == null) continue;
                    return over;
                }
            }
            return this;
        }
        return null;
    }

    public boolean containsRectangle(int x, int y, int width, int height) {
        int x1 = this.getDiagramX();
        int y1 = this.getDiagramY();
        if (x1 > x) {
            return false;
        }
        if (y1 > y) {
            return false;
        }
        if (x + width > x1 + this.getWidth()) {
            return false;
        }
        return y + height <= y1 + this.getHeight();
    }

    public EntityInstance containing(int x, int y, int width, int height) {
        if (this.containsRectangle(x, y, width, height)) {
            if (this.hasChildren() && this.isOpen()) {
                Enumeration en = this.getChildrenShown();
                while (en.hasMoreElements()) {
                    EntityInstance e = (EntityInstance)en.nextElement();
                    EntityInstance oe = e.containing(x, y, width, height);
                    if (oe == null) continue;
                    return oe;
                }
            }
            return this;
        }
        return null;
    }

    public boolean getGroupFlag() {
        return this.isMarked(65536);
    }

    public boolean getGroupKeyFlag() {
        return this.isMarked(131072);
    }

    public void removeTreeFromCache(EntityCache entityCache) {
        entityCache.remove(this);
        Enumeration children = this.getChildren();
        while (children.hasMoreElements()) {
            EntityInstance child = (EntityInstance)children.nextElement();
            child.removeTreeFromCache(entityCache);
        }
    }

    public void addTreeToCache(EntityCache entityCache) {
        entityCache.put(this);
        Enumeration children = this.getChildren();
        while (children.hasMoreElements()) {
            EntityInstance child = (EntityInstance)children.nextElement();
            child.addTreeToCache(entityCache);
        }
    }

    protected void assignDimensions() {
        int total = this.numChildren();
        int rows = (int)Math.sqrt(total);
        double relWidth = 0.9375 * (double)rows / (double)(2 * total);
        double relHeight = 0.9375 * (double)rows / (double)(2 * total);
        Enumeration en = this.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en.nextElement();
            if (!Util.defined(e.m_widthRelLocal)) {
                e.setWidthRelLocal(relWidth);
            }
            if (Util.defined(e.m_heightRelLocal)) continue;
            e.setHeightRelLocal(relHeight);
        }
    }

    private void resizeEntity(EntityComponent parentComponent) {
        EntityComponent component;
        double widthRel = this.widthRelLocal();
        double heightRel = this.heightRelLocal();
        if (widthRel < 0.0 || heightRel < 0.0) {
            EntityInstance parent = parentComponent.getEntityInstance();
            parent.assignDimensions();
            widthRel = this.widthRelLocal();
            heightRel = this.heightRelLocal();
        }
        if ((component = this.neededComponent()).getParent() != parentComponent) {
            parentComponent.add(component);
        }
        int width = (int)(widthRel * (double)parentComponent.getWidth());
        int height = (int)(heightRel * (double)parentComponent.getHeight());
        if (width <= 0 || height <= 0) {
            height = 0;
            width = 0;
        }
        if (width == 0) {
            this.setClosed();
        } else {
            this.openStatusUnknown();
        }
        component.setSize(width, height);
        this.resizeChildren(component);
    }

    public void resizeChildren(EntityComponent entityComponent) {
        Vector srcRelList;
        if (this.isOpen() && (srcRelList = this.m_srcRelList) != null) {
            int i = srcRelList.size();
            while (--i >= 0) {
                EntityInstance child;
                RelationInstance ri = (RelationInstance)srcRelList.elementAt(i);
                if (!ri.isMarked(0x100000) || !(child = ri.getDst()).isShown()) continue;
                child.resizeEntity(entityComponent);
            }
        }
    }

    public void setEntitySize(int width, int height, Container above) {
        EntityComponent entityComponent = this.neededComponent();
        if (entityComponent.getParent() != above) {
            above.add(entityComponent);
        }
        if (width <= 0 || height <= 0) {
            height = 0;
            width = 0;
        }
        entityComponent.setBounds(0, 0, width, height);
        if (!this.isMarked(16)) {
            if (width == 0) {
                this.setClosed();
            } else {
                this.openStatusUnknown();
            }
        }
        this.resizeChildren(entityComponent);
    }

    protected void assignLocations() {
        Vector<EntityInstance> v = null;
        Enumeration en = this.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en.nextElement();
            if (Util.defined(e.m_xRelLocal) && Util.defined(e.m_yRelLocal)) continue;
            if (v == null) {
                v = new Vector<EntityInstance>();
            }
            v.add(e);
        }
        if (v != null) {
            Diagram diagram = this.getDiagram();
            LandscapeEditorCore ls = diagram.getLs();
            EntityComponent entityComponent = this.getEntityComponent();
            boolean undo = diagram.undoEnabled();
            if (undo) {
                diagram.setUndoEnabled(false);
            }
            diagram.disableTaListeners();
            ls.doLayout1(ls.getLayouter(), v, this, true);
            this.resizeChildren(entityComponent);
            diagram.enableTaListeners();
            if (undo) {
                diagram.setUndoEnabled(true);
            }
            v = null;
        }
    }

    public void relocateEntity(EntityComponent parentComponent) {
        double xRel = this.xRelLocal();
        double yRel = this.yRelLocal();
        if (xRel < 0.0 || yRel < 0.0) {
            EntityInstance parent = parentComponent.getEntityInstance();
            parent.assignLocations();
            xRel = this.xRelLocal();
            yRel = this.yRelLocal();
        }
        EntityComponent component = this.getEntityComponent();
        int x = (int)(xRel * (double)parentComponent.getWidth());
        int y = (int)(yRel * (double)parentComponent.getHeight());
        component.setLocation(x, y);
        this.relocateChildren(component);
    }

    public void relocateChildren(EntityComponent entityComponent) {
        Vector srcRelList;
        if (this.isOpen() && (srcRelList = this.m_srcRelList) != null) {
            int i = srcRelList.size();
            while (--i >= 0) {
                EntityInstance child;
                RelationInstance ri = (RelationInstance)srcRelList.elementAt(i);
                if (!ri.isMarked(0x100000) || !(child = ri.getDst()).isShown()) continue;
                child.relocateEntity(entityComponent);
            }
        }
    }

    public void setDiagramLocation(int diagramX, int diagramY) {
        this.m_entityComponent.setDiagramLocation(diagramX, diagramY);
    }

    public void setEntityLocation(int x, int y) {
        EntityComponent entityComponent = this.m_entityComponent;
        entityComponent.setLocation(x, y);
        this.relocateChildren(entityComponent);
    }

    public void setEntityBounds() {
        if (this.m_entityComponent != null) {
            this.m_entityComponent.setEntityBounds();
        }
    }

    private void setPositionArraySize(int lth) {
        EntityPosition[] positions = this.m_positions;
        if (positions == null) {
            this.m_positions = positions = new EntityPosition[lth];
        } else if (positions.length < lth) {
            EntityPosition[] oldpositions = positions;
            this.m_positions = positions = new EntityPosition[lth];
            int i = oldpositions.length;
            while (--i >= 0) {
                positions[i] = oldpositions[i];
            }
        }
    }

    public void savePositioning(RelationClass rc) {
        if (Util.defined(this.m_xRelLocal) || Util.defined(this.m_yRelLocal) || Util.defined(this.m_widthRelLocal) || Util.defined(this.m_heightRelLocal)) {
            int index = rc.computeCIndex();
            this.setPositionArraySize(index + 1);
            EntityPosition[] positions = this.m_positions;
            EntityPosition position = positions[index];
            if (position == null) {
                positions[index] = position = new EntityPosition();
            }
            position.m_xRelLocal = this.m_xRelLocal;
            position.m_yRelLocal = this.m_yRelLocal;
            position.m_widthRelLocal = this.m_widthRelLocal;
            position.m_heightRelLocal = this.m_heightRelLocal;
        }
    }

    public void restorePositioning(RelationClass rc) {
        EntityPosition position;
        int index = rc.computeCIndex();
        EntityPosition[] positions = this.m_positions;
        if (positions == null && index == 0) {
            return;
        }
        if (positions == null || positions.length <= index || (position = positions[index]) == null) {
            this.m_xRelLocal = Util.undefined();
            this.m_yRelLocal = Util.undefined();
            this.m_widthRelLocal = Util.undefined();
            this.m_heightRelLocal = Util.undefined();
        } else {
            this.m_xRelLocal = position.m_xRelLocal;
            this.m_yRelLocal = position.m_yRelLocal;
            this.m_widthRelLocal = position.m_widthRelLocal;
            this.m_heightRelLocal = position.m_heightRelLocal;
        }
    }

    public void shapeChanges(EntityClass ec) {
        Vector srcRelList = this.getSrcRelList();
        if (ec == this.getParentClass()) {
            this.adjustEdgePoints();
            this.revalidateAllMyEdges();
            this.repaint();
        }
        if (srcRelList != null) {
            int i = srcRelList.size();
            while (--i >= 0) {
                RelationInstance ri = (RelationInstance)srcRelList.elementAt(i);
                if (!ri.isMarked(0x100000)) continue;
                EntityInstance e = ri.getDst();
                e.shapeChanges(ec);
            }
        }
    }

    public void entityAppearanceChanges(EntityClass ec) {
        Vector srcRelList = this.getSrcRelList();
        if (ec == this.getParentClass()) {
            this.repaint();
        }
        if (this.isMarked(7) && !this.isOpen()) {
            return;
        }
        if (srcRelList != null) {
            int i = srcRelList.size();
            while (--i >= 0) {
                RelationInstance ri = (RelationInstance)srcRelList.elementAt(i);
                if (!ri.isMarked(0x100000)) continue;
                EntityInstance e = ri.getDst();
                e.entityAppearanceChanges(ec);
            }
        }
    }

    public void entityIconChanges(EntityClass ec) {
        Vector srcRelList = this.getSrcRelList();
        if (ec == null || ec == this.getParentClass()) {
            EntityComponent entityComponent = this.m_entityComponent;
            if (entityComponent != null) {
                entityComponent.clearScaledIcon();
            }
            this.repaint();
        }
        if (this.isMarked(7) && !this.isOpen()) {
            return;
        }
        if (srcRelList != null) {
            int i = srcRelList.size();
            while (--i >= 0) {
                RelationInstance ri = (RelationInstance)srcRelList.elementAt(i);
                if (!ri.isMarked(0x100000)) continue;
                EntityInstance e = ri.getDst();
                e.entityIconChanges(ec);
            }
        }
    }

    public void edgeAppearanceChanges(RelationClass rc) {
        RelationInstance ri;
        int i;
        Vector list = this.getSrcLiftedList();
        if (list != null) {
            i = list.size();
            while (--i >= 0) {
                ri = (RelationInstance)list.elementAt(i);
                if (ri.getRelationClass() != rc) continue;
                ri.repaint();
            }
        }
        if (this.isMarked(7) && !this.isOpen()) {
            return;
        }
        list = this.getSrcRelList();
        if (list != null) {
            i = list.size();
            while (--i >= 0) {
                ri = (RelationInstance)list.elementAt(i);
                if (!ri.isMarked(0x100000)) continue;
                EntityInstance e = ri.getDst();
                e.edgeAppearanceChanges(rc);
            }
        }
    }

    public void clearValidatedMark() {
        RelationInstance ri;
        Enumeration en;
        Vector relList = this.m_dstRelList;
        if (relList != null) {
            en = relList.elements();
            while (en.hasMoreElements()) {
                ri = (RelationInstance)en.nextElement();
                ri.nandMark(16384);
            }
        }
        if ((relList = this.m_srcRelList) != null) {
            en = relList.elements();
            while (en.hasMoreElements()) {
                ri = (RelationInstance)en.nextElement();
                ri.nandMark(16384);
            }
            en = this.getChildren();
            while (en.hasMoreElements()) {
                EntityInstance e = (EntityInstance)en.nextElement();
                e.clearValidatedMark();
            }
        }
    }

    public void revalidateAllMyEdgesForClass(RelationClass rc) {
        RelationInstance ri;
        int i;
        Vector liftedList = this.getSrcLiftedList();
        if (liftedList != null) {
            i = liftedList.size();
            while (--i >= 0) {
                ri = (RelationInstance)liftedList.elementAt(i);
                if (rc != null && ri.getRelationClass() != rc) continue;
                if (ri.drawSrc() != this) {
                    System.out.println("revalidateAllMyEdges() " + this + " drawsrc " + ri.drawSrc());
                    continue;
                }
                ri.validate();
            }
        }
        if ((liftedList = this.getDstLiftedList()) != null) {
            i = liftedList.size();
            while (--i >= 0) {
                ri = (RelationInstance)liftedList.elementAt(i);
                if (rc != null && ri.getRelationClass() != rc) continue;
                if (ri.drawDst() != this) {
                    System.out.println("revalidateAllMyEdges() " + this + " drawdst " + ri.drawDst());
                    continue;
                }
                ri.validate();
            }
        }
    }

    public void revalidateAllMyEdges() {
        RelationInstance ri;
        int i;
        Vector liftedList = this.getSrcLiftedList();
        if (liftedList != null) {
            i = liftedList.size();
            while (--i >= 0) {
                ri = (RelationInstance)liftedList.elementAt(i);
                ri.validate();
            }
        }
        if ((liftedList = this.getDstLiftedList()) != null) {
            i = liftedList.size();
            while (--i >= 0) {
                ri = (RelationInstance)liftedList.elementAt(i);
                ri.validate();
            }
        }
    }

    public void invalidateAllEdges() {
        RelationInstance ri;
        Enumeration en = this.srcLiftedRelationElements();
        if (en != null) {
            while (en.hasMoreElements()) {
                ri = (RelationInstance)en.nextElement();
                ri.invalidateEdge();
            }
        }
        if ((en = this.dstLiftedRelationElements()) != null) {
            while (en.hasMoreElements()) {
                ri = (RelationInstance)en.nextElement();
                ri.invalidateEdge();
            }
        }
    }

    public EntityInstance getDrawEntity() {
        return this.m_drawEntity;
    }

    public void setDrawEntity(EntityInstance drawEntity) {
        this.m_drawEntity = drawEntity;
    }

    public void clearLiftedEdges(int flags, boolean liftEdges, boolean hide) {
        Vector srcRelList = this.m_srcRelList;
        EntityComponent entityComponent = this.m_entityComponent;
        this.m_drawEntity = null;
        if (entityComponent != null) {
            entityComponent.clearLiftedEdges();
        }
        this.andMark(50564880);
        if (hide && !this.isMarked(2048)) {
            this.orMark(8);
        }
        if (flags != 0) {
            this.orMark(flags);
            if (!liftEdges && !this.isStateOpen()) {
                flags = 0;
            }
        } else if (this.isMarked(16)) {
            this.setOpen();
            flags = 64;
        }
        if (entityComponent != null) {
            entityComponent.removeAll();
        }
        if (srcRelList != null) {
            int i = srcRelList.size();
            while (--i >= 0) {
                RelationInstance ri = (RelationInstance)srcRelList.elementAt(i);
                ri.clearRelationMark();
                if (!ri.isMarked(0x100000)) continue;
                ri.getDst().clearLiftedEdges(flags, liftEdges, hide);
            }
        }
    }

    public void findClientsSuppliers(ClientSet clientSet, SupplierSet supplierSet, EntityInstance drawRoot, EntityInstance found, boolean visibleEntities, boolean visibleEdges, boolean liftEdges) {
        EntityInstance e;
        RelationClass rc;
        RelationInstance ri;
        int i;
        if (this == drawRoot) {
            return;
        }
        Vector srcRelList = this.getSrcRelList();
        EntityInstance found1 = found;
        if (!this.hasDescendant(drawRoot)) {
            Vector dstRelList;
            if (visibleEntities && !this.isShown()) {
                return;
            }
            if (!(supplierSet == null || found1 != null && found1.isMarked(4) || (dstRelList = this.m_dstRelList) == null)) {
                i = dstRelList.size();
                while (--i >= 0) {
                    ri = (RelationInstance)dstRelList.elementAt(i);
                    if (visibleEdges && !(rc = ri.getRelationClass()).isShown() || !(e = ri.getSrc()).isMarked(80)) continue;
                    if (found1 == null) {
                        found1 = this;
                    }
                    found1.orMark(4);
                    supplierSet.seenMember();
                    break;
                }
            }
            if (!(srcRelList == null || clientSet == null || found1 != null && found1.isMarked(2))) {
                i = srcRelList.size();
                while (--i >= 0) {
                    ri = (RelationInstance)srcRelList.elementAt(i);
                    if (visibleEdges && !(rc = ri.getRelationClass()).isShown() || !(e = ri.getDst()).isMarked(80)) continue;
                    if (found1 == null) {
                        found1 = this;
                    }
                    found1.orMark(2);
                    clientSet.seenMember();
                    break;
                }
            }
        }
        if (srcRelList != null && (liftEdges || this.isStateOpen() || this.hasDescendant(drawRoot)) && (found1 == null || !found1.isAllMarked(6))) {
            i = srcRelList.size();
            while (--i >= 0) {
                ri = (RelationInstance)srcRelList.elementAt(i);
                if (!ri.isMarked(0x100000) || visibleEdges && !(rc = ri.getRelationClass()).isShown()) continue;
                e = ri.getDst();
                e.findClientsSuppliers(clientSet, supplierSet, drawRoot, found1, visibleEntities, visibleEdges, liftEdges);
            }
        }
        if (found != found1) {
            if (this.isMarked(4)) {
                supplierSet.addMember(this);
            } else {
                clientSet.addMember(this);
            }
        }
    }

    public void computeDrawEntity(EntityInstance closedEntity, int mark, boolean visibleEntities, boolean liftEdges) {
        Vector srcRelList = this.m_srcRelList;
        if (visibleEntities && !this.isShown()) {
            return;
        }
        if (closedEntity == null) {
            this.orMark(mark);
            this.m_drawEntity = this;
            if (!this.isOpen()) {
                if (!liftEdges) {
                    return;
                }
                closedEntity = this;
                mark = 0;
            }
        } else {
            this.m_drawEntity = closedEntity;
            this.m_entityComponent = null;
        }
        if (srcRelList != null) {
            int i = srcRelList.size();
            while (--i >= 0) {
                RelationInstance ri = (RelationInstance)srcRelList.elementAt(i);
                if (!ri.isMarked(0x100000)) continue;
                ri.getDst().computeDrawEntity(closedEntity, mark, visibleEntities, liftEdges);
            }
        }
    }

    protected void liftDst(RelationInstance ri) {
        Vector dstLiftedList = this.m_entityComponent.getNeededDstLiftedList();
        dstLiftedList.add(ri);
    }

    protected void liftSrc(RelationInstance ri, EntityInstance dst) {
        Vector srcLiftedList = this.m_entityComponent.getNeededSrcLiftedList();
        if (!ri.isMarked(329728)) {
            int i = srcLiftedList.size();
            while (--i >= 0) {
                RelationInstance other = (RelationInstance)srcLiftedList.elementAt(i);
                if (dst != other.drawDst() || ri.getParentClass() != other.getParentClass()) continue;
                other.incrementFrequency(ri);
                return;
            }
        }
        ri.initFrequency();
        srcLiftedList.add(ri);
        dst.liftDst(ri);
    }

    public void liftAllDiagramEdges(EntityInstance drawRoot, boolean liftEdges) {
        EntityInstance drawSrc;
        EntityInstance drawDst;
        RelationInstance ri;
        int i;
        Vector srcRelList = this.m_srcRelList;
        Vector dstRelList = this.m_dstRelList;
        if (dstRelList != null) {
            i = dstRelList.size();
            while (--i >= 0) {
                EntityInstance src;
                ri = (RelationInstance)dstRelList.elementAt(i);
                if (ri.isMarked(32768)) continue;
                ri.orMark(32768);
                if (ri.isMarked(0x100000) || (drawDst = ri.drawDst()) == null) continue;
                if (!this.isMarked(16) && drawRoot.hasAncestor(src = ri.getSrc())) {
                    src.m_drawEntity = drawRoot;
                    drawRoot.liftSrc(ri, drawDst);
                    continue;
                }
                drawSrc = ri.drawSrc();
                if (drawSrc == null || !drawSrc.isMarked(3) || drawSrc == drawDst && (drawSrc != ri.getSrc() || drawDst != ri.getDst())) continue;
                drawSrc.liftSrc(ri, drawDst);
            }
        }
        if (srcRelList != null) {
            i = srcRelList.size();
            while (--i >= 0) {
                ri = (RelationInstance)srcRelList.elementAt(i);
                if (ri.isMarked(32768)) continue;
                ri.orMark(32768);
                if (ri.isMarked(0x100000) || (drawSrc = ri.drawSrc()) == null || (drawDst = ri.drawDst()) == null || !drawDst.isMarked(5) || drawSrc == drawDst && (drawSrc != ri.getSrc() || drawDst != ri.getDst())) continue;
                drawSrc.liftSrc(ri, drawDst);
            }
        }
        if (!liftEdges && !this.isOpen()) {
            return;
        }
        if (srcRelList != null) {
            i = srcRelList.size();
            while (--i >= 0) {
                ri = (RelationInstance)srcRelList.elementAt(i);
                if (!ri.isMarked(0x100000)) continue;
                EntityInstance dst = ri.getDst();
                dst.liftAllDiagramEdges(drawRoot, liftEdges);
            }
        }
    }

    public void computeAvgX() {
        Option diagramOptions = Options.getDiagramOptions();
        EntityComponent ec = this.neededComponent();
        double x = 0.0;
        int n = 0;
        int edgeMode = diagramOptions.getEdgeMode();
        if (edgeMode == 2) {
            RelationInstance ri;
            Enumeration en = this.srcLiftedRelationElements();
            if (en != null) {
                while (en.hasMoreElements()) {
                    ri = (RelationInstance)en.nextElement();
                    EntityInstance dst = ri.drawDst();
                    x += (double)(dst.getDiagramX() + dst.getWidth() / 2);
                    ++n;
                }
            }
            if ((en = this.dstLiftedRelationElements()) != null) {
                while (en.hasMoreElements()) {
                    ri = (RelationInstance)en.nextElement();
                    EntityInstance src = ri.drawSrc();
                    x += (double)(src.getDiagramX() + src.getWidth() / 2);
                    ++n;
                }
            }
        } else {
            double f;
            RelationInstance ri;
            Enumeration en = this.srcLiftedRelationElements();
            if (en != null) {
                while (en.hasMoreElements()) {
                    ri = (RelationInstance)en.nextElement();
                    EntityInstance dst = ri.drawDst();
                    f = ri.getRelationClass().getRelativeIOfactor();
                    x += (double)dst.getDiagramX() + (double)dst.getWidth() * f;
                    ++n;
                }
            }
            if ((en = this.dstLiftedRelationElements()) != null) {
                while (en.hasMoreElements()) {
                    ri = (RelationInstance)en.nextElement();
                    EntityInstance src = ri.drawSrc();
                    f = ri.getRelationClass().getRelativeIOfactor();
                    x += (double)src.getDiagramX() + (double)src.getWidth() * f;
                    ++n;
                }
            }
        }
        double avg = n > 0 ? x / (double)n : -1.0;
        ec.setAvgX(avg);
    }

    public double getAvgX() {
        EntityComponent ec = this.neededComponent();
        return ec.getAvgX();
    }

    public void drawAllEdges(Diagram diagram, boolean normal) {
        if (!this.isMarked(8) || this.isMarked(16)) {
            RelationInstance ri;
            int i;
            Vector list = this.getSrcLiftedList();
            if (list != null) {
                i = list.size();
                while (--i >= 0) {
                    ri = (RelationInstance)list.elementAt(i);
                    if (!normal && (!ri.getHighlightFlag() || !ri.getRelationClass().isActive())) continue;
                    ri.drawRelation(diagram, normal);
                }
            }
            if ((list = this.getDstLiftedList()) != null) {
                i = list.size();
                while (--i >= 0) {
                    ri = (RelationInstance)list.elementAt(i);
                    if (!normal && (!ri.getHighlightFlag() || !ri.getRelationClass().isActive())) continue;
                    ri.drawRelation(diagram, normal);
                }
            }
            if (this.isOpen() && (list = this.m_srcRelList) != null) {
                i = list.size();
                while (--i >= 0) {
                    EntityInstance child;
                    ri = (RelationInstance)list.elementAt(i);
                    if (!ri.isMarked(0x100000) || !(child = ri.getDst()).isShown()) continue;
                    child.drawAllEdges(diagram, normal);
                }
            }
        }
    }

    @Override
    public int getPrimaryAttributeCount() {
        return 12;
    }

    @Override
    public String getLsAttributeNameAt(int index) {
        String name = index < 12 ? attributeName[index] : super.getLsAttributeNameAt(index);
        return name;
    }

    @Override
    public int getLsAttributeTypeAt(int index) {
        int ret = index < 12 ? attributeType[index] : super.getLsAttributeTypeAt(index);
        return ret;
    }

    @Override
    public Object getLsAttributeValueAt(int index) {
        Object value;
        switch (index) {
            case 0: {
                value = this.getId();
                break;
            }
            case 1: {
                LandscapeClassObject parentClass = this.getParentClass();
                if (parentClass == null) {
                    value = null;
                    break;
                }
                value = parentClass.getLabelId();
                break;
            }
            case 2: {
                value = this.getLabel();
                break;
            }
            case 3: {
                value = this.getDescription();
                break;
            }
            case 4: {
                value = this.getObjectColor();
                break;
            }
            case 5: {
                value = this.getLabelColor();
                break;
            }
            case 6: {
                value = this.getColorWhenOpen();
                break;
            }
            case 7: {
                value = new Double(this.xRelLocal());
                break;
            }
            case 8: {
                value = new Double(this.yRelLocal());
                break;
            }
            case 9: {
                value = new Double(this.widthRelLocal());
                break;
            }
            case 10: {
                value = new Double(this.heightRelLocal());
                break;
            }
            case 11: {
                value = new Integer(this.m_fontDelta);
                break;
            }
            default: {
                value = super.getLsAttributeValueAt(index);
            }
        }
        return value;
    }

    @Override
    public boolean processFirstOrder(String id, String value) {
        if (super.processFirstOrder(id, value)) {
            return true;
        }
        if (id.equals(XRELPOSITION_ID)) {
            if (value != null) {
                if (value.charAt(0) != '(') {
                    this.setXRelLocalBounded(Util.parseRelativeValue(value));
                } else {
                    int values = Attribute.countValues(value);
                    if (values > 0) {
                        this.setPositionArraySize(values);
                        AttributeValue.parseXEntityPositions(value, this.m_positions);
                        this.setXRelLocalBounded(this.m_positions[0].m_xRelLocal);
                    }
                }
            }
            return true;
        }
        if (id.equals(YRELPOSITION_ID)) {
            if (value != null) {
                if (value.charAt(0) != '(') {
                    this.setYRelLocalBounded(Util.parseRelativeValue(value));
                } else {
                    int values = Attribute.countValues(value);
                    if (values > 0) {
                        this.setPositionArraySize(values);
                        AttributeValue.parseYEntityPositions(value, this.m_positions);
                        this.setYRelLocalBounded(this.m_positions[0].m_yRelLocal);
                    }
                }
            }
            return true;
        }
        if (id.equals(WIDTHREL_ID)) {
            if (value != null) {
                if (value.charAt(0) != '(') {
                    this.setWidthRelLocalBounded(Util.parseRelativeValue(value));
                } else {
                    int values = Attribute.countValues(value);
                    if (values > 0) {
                        this.setPositionArraySize(values);
                        AttributeValue.parseWidthEntityPositions(value, this.m_positions);
                        this.setWidthRelLocalBounded(this.m_positions[0].m_widthRelLocal);
                    }
                }
            }
            return true;
        }
        if (id.equals(HEIGHTREL_ID)) {
            if (value != null) {
                if (value.charAt(0) != '(') {
                    this.setHeightRelLocalBounded(Util.parseRelativeValue(value));
                } else {
                    int values = Attribute.countValues(value);
                    if (values > 0) {
                        this.setPositionArraySize(values);
                        AttributeValue.parseHeightEntityPositions(value, this.m_positions);
                        this.setHeightRelLocalBounded(this.m_positions[0].m_heightRelLocal);
                    }
                }
            }
            return true;
        }
        if (id.equals(LABEL_ID)) {
            if (value != null) {
                this.setLabel(Attribute.parseStringValue(value));
            }
            return true;
        }
        if (id.equals(DESC_ID)) {
            if (value != null) {
                this.setDescription(Attribute.parseStringValue(value));
            }
            return true;
        }
        if (id.equals(FONTDELTA_ID)) {
            if (value != null) {
                this.setFontDelta(Attribute.parseIntValue(value));
            }
            return true;
        }
        if (id.equals(IN_ELISION_ID)) {
            if (value != null) {
                Attribute.parseElisionsValue(value, this.getTa(), 0, this.needElisions());
            }
            return true;
        }
        if (id.equals(OUT_ELISION_ID)) {
            if (value != null) {
                Attribute.parseElisionsValue(value, this.getTa(), 1, this.needElisions());
            }
            return true;
        }
        if (id.equals(CLIENT_ELISION_ID)) {
            if (value != null) {
                Attribute.parseElisionsValue(value, this.getTa(), 2, this.needElisions());
            }
            return true;
        }
        if (id.equals(SUPPLIER_ELISION_ID)) {
            if (value != null) {
                Attribute.parseElisionsValue(value, this.getTa(), 3, this.needElisions());
            }
            return true;
        }
        if (id.equals(INTERNAL_ELISION_ID)) {
            if (value != null) {
                Attribute.parseElisionsValue(value, this.getTa(), 4, this.needElisions());
            }
            return true;
        }
        if (id.equals(CLOSED_ELISION_ID)) {
            if (value != null) {
                Attribute.parseElisionsValue(value, this.getTa(), 5, this.needElisions());
            }
            return true;
        }
        if (id.equals(INPOINT_ID)) {
            if (value != null) {
                EdgePoint[] edgePoints = this.needEdgePoints();
                AttributeValue.parsePoints(value, this, 0, edgePoints);
            }
            return true;
        }
        if (id.equals(OUTPOINT_ID)) {
            if (value != null) {
                EdgePoint[] edgePoints = this.needEdgePoints();
                AttributeValue.parsePoints(value, this, 1, edgePoints);
            }
            return true;
        }
        if (id.equals(LEFTPOINT_ID)) {
            if (value != null) {
                EdgePoint[] edgePoints = this.needEdgePoints();
                AttributeValue.parsePoints(value, this, 2, edgePoints);
            }
            return true;
        }
        if (id.equals(RIGHTPOINT_ID)) {
            if (value != null) {
                EdgePoint[] edgePoints = this.needEdgePoints();
                AttributeValue.parsePoints(value, this, 3, edgePoints);
            }
            return true;
        }
        if (id.startsWith("view_") && this.getId().equals("$ROOT")) {
            Diagram diagram = this.getDiagram();
            diagram.addRootView(id, value);
            return true;
        }
        return false;
    }

    public void writeInstance(PrintWriter ps) {
        ps.println("$INSTANCE " + EntityInstance.qt(this.getId()) + " " + EntityInstance.qt(this.getParentClass().getId()));
    }

    public void writeInstances(PrintWriter ps) {
        this.writeInstance(ps);
        Enumeration en = this.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance child = (EntityInstance)en.nextElement();
            child.writeInstances(ps);
        }
    }

    public void writeRelations(PrintWriter ps) {
        Vector srcRelList = this.m_srcRelList;
        if (srcRelList != null) {
            Enumeration en = srcRelList.elements();
            while (en.hasMoreElements()) {
                RelationInstance ri = (RelationInstance)en.nextElement();
                ri.writeRelation(ps);
            }
            en = this.getChildren();
            while (en.hasMoreElements()) {
                EntityInstance child = (EntityInstance)en.nextElement();
                child.writeRelations(ps);
            }
        }
    }

    protected String writeElision(PrintWriter ps, String nodeId, Vector rcs, BitSet elisions, int type, String id) {
        int index = -1;
        String value = null;
        while (true) {
            int nid;
            RelationClass rc;
            ++index;
            if ((index = elisions.nextSetBit(index)) < 0) break;
            if (index % 6 != type || (rc = (RelationClass)rcs.elementAt(nid = index / 6)) == null) continue;
            value = value == null ? "" : value + " ";
            value = value + rc.getId();
        }
        if (value != null) {
            nodeId = EntityInstance.writeAttribute(ps, nodeId, id, "(" + value + ")");
        }
        return nodeId;
    }

    protected String writeElisions(PrintWriter ps, String id) {
        BitSet elisions = this.m_elisions;
        if (elisions != null) {
            Ta ta = this.getTa();
            Vector rcs = ta.getRelationClasses();
            id = this.writeElision(ps, id, rcs, elisions, 0, IN_ELISION_ID);
            id = this.writeElision(ps, id, rcs, elisions, 1, OUT_ELISION_ID);
            id = this.writeElision(ps, id, rcs, elisions, 2, CLIENT_ELISION_ID);
            id = this.writeElision(ps, id, rcs, elisions, 3, SUPPLIER_ELISION_ID);
            id = this.writeElision(ps, id, rcs, elisions, 4, INTERNAL_ELISION_ID);
            id = this.writeElision(ps, id, rcs, elisions, 5, CLOSED_ELISION_ID);
        }
        return id;
    }

    protected String writePoints(PrintWriter ps, String nodeId, EdgePoint[] edgePoints, Vector rcs, int side, String name) {
        EdgePoint edgePoint;
        int i;
        int rcIndex = 1;
        String value = "";
        int start = rcIndex * 4 + side;
        int length = edgePoints.length;
        for (i = start; i < length && (edgePoint = edgePoints[i]) == null; i += 4) {
        }
        if (i < length) {
            for (i = start; i < length; i += 4) {
                edgePoint = edgePoints[i];
                if (edgePoint != null) {
                    value = value + edgePoint.getString((RelationClass)rcs.elementAt(rcIndex));
                }
                ++rcIndex;
            }
            if (value.length() > 0) {
                nodeId = EntityInstance.writeAttribute(ps, nodeId, name, "(" + value + ")");
            }
        }
        return nodeId;
    }

    protected String writePoints(PrintWriter ps, String nodeId) {
        EdgePoint[] edgePoints = this.m_edgePoints;
        if (edgePoints != null) {
            Ta ta = this.getTa();
            Vector rcs = ta.getRelationClasses();
            int rcsSize = rcs.size();
            int rcIndex = -1;
            int side = 4;
            RelationClass rc = null;
            int cnt = 0;
            for (int i = 0; i < edgePoints.length; ++i) {
                EdgePoint edgePoint = edgePoints[i];
                if (side == 4) {
                    rc = ++rcIndex < rcsSize ? (RelationClass)rcs.elementAt(rcIndex) : null;
                    side = 0;
                }
                if (edgePoint != null) {
                    if (rc == null || edgePoint.isDefault(rc)) {
                        edgePoints[i] = null;
                    } else {
                        ++cnt;
                    }
                }
                ++side;
            }
            if (cnt == 0) {
                this.m_edgePoints = null;
            } else {
                nodeId = this.writePoints(ps, nodeId, edgePoints, rcs, 0, INPOINT_ID);
                nodeId = this.writePoints(ps, nodeId, edgePoints, rcs, 1, OUTPOINT_ID);
                nodeId = this.writePoints(ps, nodeId, edgePoints, rcs, 2, LEFTPOINT_ID);
                nodeId = this.writePoints(ps, nodeId, edgePoints, rcs, 3, RIGHTPOINT_ID);
            }
        }
        return nodeId;
    }

    public void writeOptionsAttributes(PrintWriter ps) {
        String description;
        String label;
        LandscapeClassObject parentClass = this.getParentClass();
        Diagram diagram = this.getDiagram();
        EntityInstance drawRoot = diagram.getDrawRoot();
        Option diagramOptions = Options.getDiagramOptions();
        Vector views = diagram.getViews();
        String nodeId = EntityInstance.qt(this.getId());
        nodeId = EntityInstance.writeAttribute(ps, nodeId, "version", Version.InternalNumber());
        if (drawRoot != null) {
            nodeId = this.writeColorAttributes(ps, nodeId, parentClass);
            nodeId = EntityInstance.writeAttribute(ps, nodeId, "diagram:drawroot", drawRoot.getId());
            if (diagramOptions.getZoomX() != 1.0 || diagramOptions.getZoomY() != 1.0) {
                JScrollPane scrollPane = diagram.getLs().m_scrollDiagram;
                JViewport viewport = scrollPane.getViewport();
                Point point = viewport.getViewPosition();
                nodeId = EntityInstance.writeAttribute(ps, nodeId, "diagram:viewx", point.x);
                nodeId = EntityInstance.writeAttribute(ps, nodeId, "diagram:viewy", point.y);
            }
        }
        diagramOptions.saveOptions(ps, true);
        if (views != null) {
            int size = views.size();
            for (int i = 0; i < size; ++i) {
                View view = (View)views.elementAt(i);
                ps.print("view_" + i + "=\"");
                view.write(ps);
                ps.println("\"");
            }
        }
        if ((label = this.getLabel()) == null) {
            label = this.getEntityLabel();
        }
        if (label != null) {
            ps.println("label = " + EntityInstance.qt(label));
        }
        if ((description = this.getDescription()) != null) {
            ps.println("description = " + EntityInstance.qt(description));
        }
        ps.println("}");
    }

    public void writeAttribute(PrintWriter ps, RelationClass containsClass) {
        String description;
        int style;
        String label;
        LandscapeClassObject parentClass = this.getParentClass();
        String nodeId = this.getId();
        if (containsClass != null) {
            EntityPosition position;
            int last;
            EntityPosition[] positions = this.m_positions;
            if (positions != null || containsClass.getCIndex() != 0) {
                this.savePositioning(containsClass);
                positions = this.m_positions;
            }
            if (positions == null) {
                last = -1;
            } else {
                last = positions.length;
                while (!(--last < 0 || (position = positions[last]) != null && (Util.defined(position.m_xRelLocal) || Util.defined(position.m_yRelLocal) || Util.defined(position.m_widthRelLocal) || Util.defined(position.m_heightRelLocal)))) {
                }
            }
            if (last < 0) {
                short value = this.m_xRelLocal;
                if (Util.defined(value)) {
                    nodeId = EntityInstance.writeAttribute(ps, nodeId, "xrel     ", value);
                }
                if (Util.defined(value = this.m_yRelLocal)) {
                    nodeId = EntityInstance.writeAttribute(ps, nodeId, "yrel     ", value);
                }
                if (Util.defined(value = this.m_widthRelLocal)) {
                    nodeId = EntityInstance.writeAttribute(ps, nodeId, "widthrel ", value);
                }
                if (Util.defined(value = this.m_heightRelLocal)) {
                    nodeId = EntityInstance.writeAttribute(ps, nodeId, HEIGHTREL_ID, value);
                }
            } else {
                short value;
                int i;
                String temp = "(";
                for (i = 0; i <= last; ++i) {
                    if (i != 0) {
                        temp = temp + " ";
                    }
                    value = (position = positions[i]) == null ? Util.undefined() : position.m_xRelLocal;
                    temp = temp + value;
                }
                temp = temp + ")";
                nodeId = EntityInstance.writeAttribute(ps, nodeId, "xrel     ", temp);
                temp = "(";
                for (i = 0; i <= last; ++i) {
                    if (i != 0) {
                        temp = temp + " ";
                    }
                    value = (position = positions[i]) == null ? Util.undefined() : position.m_yRelLocal;
                    temp = temp + value;
                }
                temp = temp + ")";
                nodeId = EntityInstance.writeAttribute(ps, nodeId, "yrel     ", temp);
                temp = "(";
                for (i = 0; i <= last; ++i) {
                    if (i != 0) {
                        temp = temp + " ";
                    }
                    value = (position = positions[i]) == null ? Util.undefined() : position.m_widthRelLocal;
                    temp = temp + value;
                }
                temp = temp + ")";
                nodeId = EntityInstance.writeAttribute(ps, nodeId, "widthrel ", temp);
                temp = "(";
                for (i = 0; i <= last; ++i) {
                    if (i != 0) {
                        temp = temp + " ";
                    }
                    value = (position = positions[i]) == null ? Util.undefined() : position.m_heightRelLocal;
                    temp = temp + value;
                }
                temp = temp + ")";
                nodeId = EntityInstance.writeAttribute(ps, nodeId, HEIGHTREL_ID, temp);
            }
        }
        if ((label = this.getLabel()) != null) {
            nodeId = EntityInstance.writeAttribute(ps, nodeId, LABEL_ID, EntityInstance.qt(label));
        }
        if ((style = this.getStyle()) >= 0 && (parentClass == null || parentClass.getInheritedStyle() != style)) {
            nodeId = EntityInstance.writeAttribute(ps, nodeId, "style", style);
        }
        if ((description = this.getDescription()) != null && (this.isRoot() || !parentClass.defaultValue(DESC_ID, description))) {
            nodeId = EntityInstance.writeAttribute(ps, nodeId, DESC_ID, EntityInstance.qt(description));
        }
        nodeId = this.writeElisions(ps, nodeId);
        nodeId = this.writePoints(ps, nodeId);
        if (this.m_fontDelta != 0) {
            nodeId = EntityInstance.writeAttribute(ps, nodeId, FONTDELTA_ID, this.m_fontDelta);
        }
        if ((nodeId = super.writeAttributes(ps, nodeId, parentClass, false)) == null) {
            ps.println("}");
        }
    }

    public void writeAttributes(PrintWriter ps, RelationClass containsClass) {
        Vector srcRelList = this.m_srcRelList;
        this.writeAttribute(ps, containsClass);
        if (srcRelList != null) {
            RelationInstance ri;
            int i;
            int size = srcRelList.size();
            for (i = 0; i < size; ++i) {
                ri = (RelationInstance)srcRelList.elementAt(i);
                ri.writeAttributes(ps);
            }
            for (i = 0; i < size; ++i) {
                ri = (RelationInstance)srcRelList.elementAt(i);
                if (!ri.isMarked(0x100000)) continue;
                EntityInstance child = ri.getDst();
                child.writeAttributes(ps, ri.getRelationClass());
            }
        }
    }

    public void recomputeCounts() {
        Vector srcRelList = this.m_srcRelList;
        this.incrementClassMembers();
        if (srcRelList != null) {
            Enumeration en = srcRelList.elements();
            while (en.hasMoreElements()) {
                RelationInstance ri = (RelationInstance)en.nextElement();
                RelationClass rc = ri.getRelationClass();
                rc.incrementMembers();
                if (!ri.isMarked(0x100000)) continue;
                EntityInstance child = ri.getDst();
                child.recomputeCounts();
            }
        }
    }

    public boolean isFramedBy(Rectangle frame) {
        int myX = this.getDiagramX();
        int myY = this.getDiagramY();
        if (frame.x > myX || frame.y > myY) {
            return false;
        }
        if (frame.x + frame.width < (myX += this.getWidth())) {
            return false;
        }
        if (frame.y + frame.height < (myY += this.getHeight())) {
            return false;
        }
        return this.isShown();
    }

    public static void reportFirstOrderAttributes(ResultBox resultBox) {
        resultBox.addText(XRELPOSITION_ID);
        resultBox.addText(YRELPOSITION_ID);
        resultBox.addText(WIDTHREL_ID);
        resultBox.addText(HEIGHTREL_ID);
        resultBox.addText(LABEL_ID);
        resultBox.addText(DESC_ID);
        resultBox.addText(TITLE_ID);
        resultBox.addText(FONTDELTA_ID);
        resultBox.addText("color");
        resultBox.addText("opencolor");
        resultBox.addText("labelcolor");
        resultBox.addText(IN_ELISION_ID);
        resultBox.addText(OUT_ELISION_ID);
        resultBox.addText(CLIENT_ELISION_ID);
        resultBox.addText(SUPPLIER_ELISION_ID);
        resultBox.addText(INTERNAL_ELISION_ID);
        resultBox.addText(INPOINT_ID);
        resultBox.addText(OUTPOINT_ID);
        resultBox.addText(LEFTPOINT_ID);
        resultBox.addText(RIGHTPOINT_ID);
    }

    public int validateEntityAttributes(Vector v, Vector[] a, ResultBox resultBox) {
        EntityClass ec1 = this.getEntityClass();
        int ret = 0;
        Attribute[] attributes = this.m_attributes;
        if (attributes != null) {
            int attributes_length = attributes.length;
            int size = v.size();
            for (int i = 0; i < size; ++i) {
                if (ec1 != v.elementAt(i)) continue;
                Vector valid_attributes = a[i];
                if (valid_attributes == null) {
                    a[i] = valid_attributes = ec1.getValidAttributes();
                }
                boolean seen = false;
                block1: for (int j = 0; j < attributes_length; ++j) {
                    Attribute attribute1;
                    Attribute attribute = attributes[j];
                    if (attribute == null) continue;
                    String id = attribute.m_id;
                    int k = valid_attributes.size();
                    do {
                        if (--k < 0) {
                            if (!seen) {
                                resultBox.addResultEntity(this, resultBox.getLeftShowAncestors());
                                seen = true;
                                ++ret;
                            }
                            resultBox.addResultAttribute(attribute);
                            continue block1;
                        }
                        attribute1 = (Attribute)valid_attributes.elementAt(k);
                    } while (!id.equals(attribute1.m_id));
                }
            }
        }
        Enumeration en = this.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance child = (EntityInstance)en.nextElement();
            ret += child.validateEntityAttributes(v, a, resultBox);
        }
        return ret;
    }

    public int validateRelationAttributes(Vector v, Vector[] a, ResultBox resultBox) {
        Vector srcRelList = this.m_srcRelList;
        int ret = 0;
        if (srcRelList != null) {
            int size = v.size();
            Enumeration en1 = srcRelList.elements();
            block0: while (en1.hasMoreElements()) {
                RelationInstance ri = (RelationInstance)en1.nextElement();
                RelationClass rc = ri.getRelationClass();
                for (int i = 0; i < size; ++i) {
                    if (rc != v.elementAt(i)) continue;
                    Vector valid_attributes = a[i];
                    if (valid_attributes == null) {
                        a[i] = valid_attributes = rc.getValidAttributes();
                    }
                    boolean seen = false;
                    Attribute[] attributes = ri.m_attributes;
                    if (attributes == null) continue;
                    block2: for (Attribute attribute : attributes) {
                        Attribute attribute1;
                        if (attribute == null) continue;
                        String id = attribute.m_id;
                        int k = valid_attributes.size();
                        do {
                            if (--k < 0) {
                                if (!seen) {
                                    resultBox.addRelation(ri);
                                    seen = true;
                                    ++ret;
                                }
                                resultBox.addResultAttribute(attribute);
                                continue block2;
                            }
                            attribute1 = (Attribute)valid_attributes.elementAt(k);
                        } while (!id.equals(attribute1.m_id));
                    }
                    continue block0;
                }
            }
            Enumeration en = this.getChildren();
            while (en.hasMoreElements()) {
                EntityInstance child = (EntityInstance)en.nextElement();
                ret += child.validateRelationAttributes(v, a, resultBox);
            }
        }
        return ret;
    }

    public int validateRelations(Vector v, boolean[][][] a, ResultBox resultBox, EntityInstance root) {
        Vector relList = this.m_srcRelList;
        int ret = 0;
        int size = v.size();
        for (int phase = 0; phase < 2; ++phase) {
            if (relList != null) {
                Enumeration en1 = relList.elements();
                block1: while (en1.hasMoreElements()) {
                    RelationInstance ri = (RelationInstance)en1.nextElement();
                    if (ri.isMarked(16384)) continue;
                    ri.orMark(16384);
                    RelationClass rc = ri.getRelationClass();
                    for (int i = 0; i < size; ++i) {
                        if (rc != v.elementAt(i)) continue;
                        boolean[][] relationArray = a[i];
                        if (relationArray == null) {
                            relationArray = rc.getInheritedRelationArray();
                            a[i] = relationArray;
                        }
                        EntityInstance s = ri.getSrc();
                        EntityInstance d = ri.getDst();
                        if (s == root || d == root) continue block1;
                        EntityClass src = s.getEntityClass();
                        EntityClass dst = d.getEntityClass();
                        if (relationArray[src.getOrderedId()][dst.getOrderedId()]) continue block1;
                        resultBox.addRelation("", ri);
                        ++ret;
                        continue block1;
                    }
                }
            }
            relList = this.m_dstRelList;
        }
        Enumeration en = this.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance child = (EntityInstance)en.nextElement();
            ret += child.validateRelations(v, a, resultBox, root);
        }
        return ret;
    }

    public boolean hasNoEdges() {
        RelationInstance ri;
        Enumeration en;
        Vector relList = this.m_dstRelList;
        if (relList != null) {
            en = relList.elements();
            while (en.hasMoreElements()) {
                ri = (RelationInstance)en.nextElement();
                if (ri.isMarked(0x100000)) continue;
                return false;
            }
        }
        if ((relList = this.m_srcRelList) != null) {
            en = relList.elements();
            while (en.hasMoreElements()) {
                ri = (RelationInstance)en.nextElement();
                if (!ri.isMarked(0x100000)) {
                    return false;
                }
                EntityInstance child = ri.getDst();
                if (child.hasNoEdges()) continue;
                return false;
            }
        }
        return true;
    }

    private boolean hasActiveEdges(Vector list, RelationClass edges, int min, int max) {
        if (list == null) {
            if (min > 0) {
                return false;
            }
        } else {
            int cnt = 0;
            int i = list.size();
            while (--i >= 0) {
                RelationInstance ri = (RelationInstance)list.elementAt(i);
                RelationClass rc = ri.getRelationClass();
                if (rc != edges && (edges != null || ri.isMarked(0x100000) || !rc.isActive()) || ++cnt < min) continue;
                if (max == -1) break;
                if (cnt <= max) continue;
                return false;
            }
            if (cnt < min) {
                return false;
            }
        }
        return true;
    }

    public boolean hasActiveInEdges(RelationClass inEdges, int min, int max) {
        return this.hasActiveEdges(this.m_dstRelList, inEdges, min, max);
    }

    public boolean hasActiveOutEdges(RelationClass outEdges, int min, int max) {
        return this.hasActiveEdges(this.m_srcRelList, outEdges, min, max);
    }

    public void clusterMetrics(ClusterMetrics dialog, int depth) {
        Vector srcRelList = this.m_srcRelList;
        dialog.seenEntity(this, depth);
        if (srcRelList != null) {
            Enumeration en = srcRelList.elements();
            while (en.hasMoreElements()) {
                RelationInstance ri = (RelationInstance)en.nextElement();
                dialog.seenRelation(ri);
                if (!ri.isMarked(0x100000)) continue;
                EntityInstance child = ri.getDst();
                child.clusterMetrics(dialog, depth + 1);
            }
        }
    }

    public void gatherLeaves(Vector v) {
        EntityInstance child = null;
        Enumeration en = this.getChildrenShown();
        while (en.hasMoreElements()) {
            child = (EntityInstance)en.nextElement();
            child.gatherLeaves(v);
        }
        if (child == null) {
            v.add(this);
        }
    }

    public void noEdges() {
        this.m_srcRelList = null;
        this.m_dstRelList = null;
        if (this.m_entityComponent != null) {
            this.m_entityComponent.clearLiftedEdges();
        }
    }

    public void checkRefcnts(ResultBox resultBox) {
        Enumeration en;
        Attribute attr;
        if (this.isShown() && (attr = this.getLsAttribute("refcnt")) != null) {
            RelationInstance ri;
            Vector dstRelList = this.m_dstRelList;
            int refcnt = attr.parseInt();
            int cnt = 0;
            if (dstRelList != null) {
                en = dstRelList.elements();
                while (en.hasMoreElements()) {
                    ri = (RelationInstance)en.nextElement();
                    if (ri.isMarked(0x100000)) continue;
                    ++cnt;
                }
            }
            if (cnt != refcnt) {
                resultBox.addResultEntity(this, resultBox.getLeftShowAncestors());
                en = dstRelList.elements();
                while (en.hasMoreElements()) {
                    ri = (RelationInstance)en.nextElement();
                    if (ri.isMarked(0x100000)) continue;
                    resultBox.addRelation("    ", ri);
                }
                String title = this.getTitle();
                if (title == null) {
                    title = "";
                }
                resultBox.addText("    " + title + " Refcnt = " + refcnt + " but actual cnt = " + cnt);
            }
        }
        en = this.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en.nextElement();
            e.checkRefcnts(resultBox);
        }
    }

    public void dump(int indent) {
        for (int i = 0; i < indent; ++i) {
            System.out.print(" ");
        }
        System.out.println(this);
        Enumeration en = this.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en.nextElement();
            e.dump(indent + 2);
        }
    }

    public void startHover() {
        this.m_mark |= 0x400000;
        if (!this.isDrawRoot() && this.m_entityComponent != null) {
            Diagram diagram = this.getDiagram();
            diagram.beginUpdates();
            diagram.signalEntityChanged(this, 28);
            diagram.endUpdates();
        }
    }

    public boolean endHover() {
        boolean ret;
        boolean bl = ret = (this.m_mark & 0x400000) != 0;
        if (ret) {
            this.m_mark &= 0xFFBFFFFF;
            if (!this.isDrawRoot() && this.m_entityComponent != null) {
                Diagram diagram = this.getDiagram();
                diagram.beginUpdates();
                diagram.signalEntityChanged(this, 28);
                diagram.endUpdates();
            }
        }
        return ret;
    }

    @Override
    public int getIconWidth() {
        return this.getWidth();
    }

    @Override
    public int getIconHeight() {
        return this.getHeight();
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        EntityComponent entityComponent = this.neededComponent();
        entityComponent.paintIcon(c, g, x, y);
    }

    @Override
    public void mouseClicked(MouseEvent ev) {
    }

    @Override
    public void mouseEntered(MouseEvent ev) {
    }

    @Override
    public void mouseExited(MouseEvent ev) {
    }

    @Override
    public void mousePressed(MouseEvent ev) {
        if (ev.isAltDown()) {
            this.startHover();
        } else {
            Diagram diagram = this.getDiagram();
            int x = ev.getX();
            int y = ev.getY();
            EntityComponent entityComponent = this.m_entityComponent;
            int width = entityComponent.getWidth();
            int height = entityComponent.getHeight();
            if (x <= 11) {
                if (y <= 17 && x >= 3 && y >= 9 && width > 11 && height > 17 && this.closedWithChildren()) {
                    LandscapeEditorCore ls = diagram.getLs();
                    ls.processKey(99, 0, this);
                    return;
                }
            } else if (!(x < width - 24 || y > 24 && y < height - 24 || this.isMarked(128) || 48 > width || 48 > height)) {
                EntityClass ec = this.getEntityClass();
                int image = ec.getImage();
                if (y <= 24) {
                    if ((image & 0x80) != 0) {
                        LandscapeEditorCore ls = diagram.getLs();
                        ls.processKey(106, 2, this);
                        return;
                    }
                } else if ((image & 0x100) != 0) {
                    LandscapeEditorCore ls = diagram.getLs();
                    ls.processKey(107, 2, this);
                    return;
                }
            }
            diagram.entityPressed(ev, this, ev.getX() + this.getDiagramX(), ev.getY() + this.getDiagramY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
        if (!this.endHover()) {
            this.getDiagram().entityReleased(ev, this, ev.getX() + this.getDiagramX(), ev.getY() + this.getDiagramY());
        }
    }

    @Override
    public void mouseDragged(MouseEvent ev) {
        this.getDiagram().entityDragged(ev, this, ev.getX() + this.getDiagramX(), ev.getY() + this.getDiagramY());
    }

    @Override
    public void mouseMoved(MouseEvent ev) {
        Diagram diagram = this.getDiagram();
        if (this != g_infoShown) {
            int modifiers;
            LandscapeEditorCore ls = diagram.getLs();
            if (g_infoShown instanceof RelationInstance) {
                ((RelationInstance)g_infoShown).repaint();
            }
            if (((modifiers = ev.getModifiers()) & 1) == 0) {
                ls.infoShown(this);
            }
            String str = this.getEntityLabel();
            EntityInstance pe = this.getContainedBy();
            if (pe != null) {
                str = pe.getEntityLabel() + " . " + str;
            }
            ls.showInfo(str);
            if (m_currentDescEntity != this && !this.isOpen() && this.getEntityClass() != null) {
                String label = this.getEntityLabel();
                String title = this.getTitle();
                String desc = this.getDescription();
                if (desc == null) {
                    desc = "The " + label + " " + this.getClassLabel() + ".";
                }
                String topline = " (" + this.getClassLabel() + (this.hasChildren() ? " - " + this.numChildren() + " items)" : ")");
                topline = title != null ? title + topline : label + topline;
                ls.setRightTextBox(topline, desc);
                m_currentDescEntity = this;
            }
        }
        diagram.movedOverThing(ev, this, ev.getX() + this.getDiagramX(), ev.getY() + this.getDiagramY());
    }
}

