/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import lsedit.Cardinal;
import lsedit.ColorCache;
import lsedit.Diagram;
import lsedit.EntityClass;
import lsedit.EntityInstance;
import lsedit.IconCache;
import lsedit.LandscapeEditorCore;
import lsedit.NavNext_Button;
import lsedit.NavPrev_Button;
import lsedit.Option;
import lsedit.Options;
import lsedit.PaintShapeHelper;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.SrcCardinal;
import lsedit.Util;

public class EntityComponent
extends JComponent
implements PaintShapeHelper,
Icon {
    public static final int MARGIN = 5;
    public static final int MIN_FLAP_HT = 3;
    public static final int MAX_FLAP_HT = 8;
    public static final int FLAP_MARGIN = 4;
    public static final int TINY_FLAP_WD = 10;
    public static final int MIN_FLAP_WD = 75;
    public static final int NAV_WIDTH = 24;
    public static final int CONTENTS_FLAG_X = 3;
    public static final int CONTENTS_FLAG_Y = 9;
    public static final int CONTENTS_FLAG_DIM = 8;
    public static final int CONTENTS_FLAG_X_RESERVE = 11;
    public static final int CONTENTS_FLAG_Y_RESERVE = 17;
    private EntityInstance m_entityInstance;
    private double m_avgX;
    private static int[] m_xp = null;
    private static int[] m_yp = null;
    private int m_diagramX = 0;
    private int m_diagramY = 0;
    private Vector m_srcLiftedList = null;
    private Vector m_dstLiftedList = null;
    private Cardinal[] m_dstCardinals;
    private SrcCardinal[] m_srcCardinals;
    private Icon m_scaledIcon = null;

    @Override
    public String toString() {
        return "EntityComponent: " + this.m_entityInstance.toString();
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        int oldX = this.getX();
        int oldY = this.getY();
        int oldWidth = this.getWidth();
        int oldHeight = this.getHeight();
        super.setBounds(x, y, width, height);
        if (x != oldX || y != oldY) {
            this.shiftDiagramLocations(x - oldX, y - oldY);
        } else if (width == oldWidth && height == oldHeight) {
            return;
        }
        this.refillEdges();
        this.moveCardinals(this.m_entityInstance.getDiagram());
    }

    @Override
    public Component add(Component child) {
        EntityComponent ec = (EntityComponent)child;
        EntityInstance e = ec.getEntityInstance();
        if (!e.isMarked(8)) {
            double area = e.widthRelLocal() * e.heightRelLocal();
            int size = this.getComponentCount();
            for (int i = 0; i < size; ++i) {
                EntityComponent ec1 = (EntityComponent)this.getComponent(i);
                EntityInstance e1 = ec1.getEntityInstance();
                double area1 = e1.widthRelLocal() * e1.heightRelLocal();
                if (!(area1 > area)) continue;
                return this.add(child, i);
            }
            return super.add(child);
        }
        return null;
    }

    @Override
    public void paintComponent(Graphics g) {
        int grid;
        Option option = Options.getDiagramOptions();
        EntityInstance entityInstance = this.m_entityInstance;
        EntityClass entityClass = entityInstance.getEntityClass();
        boolean isDrawRoot = entityInstance.isDrawRoot();
        boolean isOpen = entityInstance.isOpen();
        boolean x = false;
        boolean y = false;
        int width = this.getWidth();
        int height = this.getHeight();
        int margin = 5;
        boolean offset = false;
        String label1 = entityInstance.getEntityLabel();
        Color labelColor = entityInstance.getCurrentLabelColor();
        Color backgroundColor = entityInstance.getCurrentObjectColor();
        Color foregroundColor = Color.black;
        if (!isDrawRoot && entityInstance.isMarked(0x20000000)) {
            int max;
            int shadow_size = option.getShadowSize();
            if (shadow_size > (max = (width > height ? height : width) >> 1)) {
                shadow_size = max;
            }
            if (shadow_size > 0) {
                Color shadow = backgroundColor == null ? Color.GRAY : backgroundColor;
                shadow = shadow.darker();
                EntityComponent.paintShape(g, this, entityClass, shadow_size, shadow_size, width -= shadow_size, height -= shadow_size, false, isOpen, foregroundColor, shadow);
            }
        }
        if (entityInstance.red_open()) {
            foregroundColor = Color.red.darker();
        }
        EntityComponent.paintShape(g, this, entityClass, 0, 0, width, height, isDrawRoot, isOpen, foregroundColor, backgroundColor);
        Diagram diagram = entityInstance.getDiagram();
        LandscapeEditorCore ls = diagram.getLs();
        if (option.isShowGrid() && isDrawRoot && (grid = option.getGridSize()) > 1) {
            int i;
            g.setColor(option.getGridColor());
            for (i = grid; i < height; i += grid) {
                g.drawLine(0, i, width - 1, i);
            }
            for (i = grid; i < width; i += grid) {
                g.drawLine(i, 0, i, height - 1);
            }
        }
        if (entityInstance.closedWithChildren() && width > 11 && height > 17) {
            Color color1 = entityInstance.getInheritedObjectColor();
            color1 = color1 != null ? ColorCache.getInverse(color1.getRGB()) : Color.BLACK;
            g.setColor(color1);
            g.drawRect(3, 9, 8, 8);
            g.drawLine(4, 13, 10, 13);
            g.drawLine(7, 10, 7, 16);
            margin += 11;
        }
        g.setColor(labelColor);
        int labelWidth = width - 5 - margin;
        int labelHeight = height - 10;
        block0 : switch (entityInstance.getInheritedStyle()) {
            case 8: {
                Util.drawGroupBoxLabel(g, 0, 0, width, label1);
                break;
            }
            default: {
                EntityInstance pe;
                Font font = entityInstance.getEntityLabelFont();
                g.setFont(font);
                if (isOpen) {
                    switch (entityInstance.getInheritedStyle()) {
                        case 4: {
                            int fw = (int)((double)width * 0.4);
                            int fh = Math.max(3, Math.min(8, (int)((double)height * 0.2)));
                            if (fw < 75) {
                                fw += fw / 2;
                            }
                            if (fw < 10) {
                                fw = Math.min(fw + 4, width - width / 3);
                            }
                            margin = 4 + fh / 2 + 2;
                            break;
                        }
                        case 6: {
                            break;
                        }
                    }
                    Util.drawStringWrapped(g, label1, margin, 5.0, labelWidth, labelHeight, false, false, option.isLabelInvertBackground());
                    break;
                }
                int icon_rule = this.m_scaledIcon == null ? 0 : option.getIconRule();
                if (icon_rule == 1) break;
                if (entityInstance.isMarked(6) && (pe = entityInstance.getContainedBy()) != null) {
                    label1 = pe.getEntityLabel() + " .\n" + label1;
                }
                switch (icon_rule) {
                    case 3: 
                    case 4: {
                        FontMetrics fm = g.getFontMetrics();
                        labelHeight = fm.getHeight();
                        int labelY = icon_rule == 4 ? 0 : height - labelHeight;
                        Util.drawStringClipped(g, label1, 0.0, labelY, width, labelHeight, true, false, option.isLabelInvertBackground());
                        break block0;
                    }
                }
                Util.drawStringWrapped(g, label1, margin, 5.0, labelWidth, labelHeight, true, false, option.isLabelInvertBackground());
            }
        }
        if (!entityInstance.isMarked(128)) {
            int image = entityClass.getImage();
            if (!isOpen) {
                switch (option.getShowClassType()) {
                    case 2: {
                        if ((image & 0x20) == 0) break;
                    }
                    case 1: {
                        label1 = entityClass.getLabel();
                        Util.drawStringClipped(g, label1, margin, 5.0, labelWidth, labelHeight, false, false, option.isLabelInvertBackground());
                    }
                }
                switch (option.getShowSpanType()) {
                    case 2: {
                        if ((image & 0x40) == 0) break;
                    }
                    case 1: {
                        RelationInstance r = entityInstance.getContainedByRelation();
                        if (r == null) break;
                        label1 = r.getRelationLabel();
                        Util.drawStringBottomClipped(g, label1, margin, 5.0, labelWidth, labelHeight, false, false, option.isLabelInvertBackground());
                    }
                }
            }
            if (48 <= width && 48 <= height) {
                switch (option.getShowNavNext()) {
                    case 2: {
                        if ((image & 0x80) == 0) break;
                    }
                    case 1: {
                        label1 = entityInstance.getNavNext();
                        if (label1 == null) break;
                        g.setColor(labelColor);
                        NavNext_Button.paintIcon(g, 0, 0, width, height, 24, 24);
                    }
                }
                switch (option.getShowNavPrev()) {
                    case 2: {
                        if ((image & 0x100) == 0) break;
                    }
                    case 1: {
                        label1 = entityInstance.getNavPrev();
                        if (label1 == null) break;
                        g.setColor(labelColor);
                        NavPrev_Button.paintIcon(g, 0, 0, width, height, 24, 24);
                    }
                }
            }
        }
        if (this.m_entityInstance.isMarked(32768)) {
            Util.drawOutlineRedBox(g, 0, 0, width, height);
        }
        if (entityInstance.getGroupFlag()) {
            int pdim;
            g.setColor(entityInstance.getInheritedLabelColor());
            int n = pdim = height < 20 ? 4 : 6;
            if (entityInstance.getGroupKeyFlag()) {
                g.fillRect(1, 1, pdim, pdim);
                g.fillRect(width / 2 - pdim / 2, 1, pdim, pdim);
                g.fillRect(width - pdim, 1, pdim, pdim);
                g.fillRect(1, height / 2 - pdim / 2, pdim, pdim);
                g.fillRect(width - pdim, height / 2 - pdim / 2, pdim, pdim);
                g.fillRect(1, height - pdim, pdim, pdim);
                g.fillRect(width / 2 - pdim / 2, height - pdim, pdim, pdim);
                g.fillRect(width - pdim, height - pdim, pdim, pdim);
            } else {
                g.drawRect(1, 1, pdim, pdim);
                g.drawRect(width / 2 - pdim / 2, 1, pdim, pdim);
                g.drawRect(width - pdim - 1, 1, pdim, pdim);
                g.drawRect(1, height / 2 - pdim / 2, pdim, pdim);
                g.drawRect(width - pdim - 1, height / 2 - pdim / 2, pdim, pdim);
                g.drawRect(1, height - pdim - 1, pdim, pdim);
                g.drawRect(width / 2 - pdim / 2, height - pdim - 1, pdim, pdim);
                g.drawRect(width - pdim - 1, height - pdim - 1, pdim, pdim);
            }
        }
    }

    private static int[] getXp() {
        if (m_xp == null) {
            m_xp = new int[21];
        }
        return m_xp;
    }

    private static int[] getYp() {
        if (m_yp == null) {
            m_yp = new int[21];
        }
        return m_yp;
    }

    public EntityComponent(EntityInstance entityInstance) {
        this.setLayout(null);
        this.m_entityInstance = entityInstance;
        entityInstance.setEntityComponent(this);
        if (m_xp == null) {
            m_xp = new int[21];
            m_yp = new int[21];
        }
    }

    public EntityInstance getEntityInstance() {
        return this.m_entityInstance;
    }

    public Vector getSrcLiftedList() {
        return this.m_srcLiftedList;
    }

    public Vector getDstLiftedList() {
        return this.m_dstLiftedList;
    }

    public Vector getNeededSrcLiftedList() {
        Vector srcLiftedList = this.m_srcLiftedList;
        if (srcLiftedList == null) {
            this.m_srcLiftedList = srcLiftedList = new Vector();
        }
        return srcLiftedList;
    }

    public Vector getNeededDstLiftedList() {
        Vector dstLiftedList = this.m_dstLiftedList;
        if (dstLiftedList == null) {
            this.m_dstLiftedList = dstLiftedList = new Vector();
        }
        return dstLiftedList;
    }

    public void clearLiftedEdges() {
        this.m_srcLiftedList = null;
        this.m_dstLiftedList = null;
    }

    protected void shiftDiagramLocations(int shiftX, int shiftY) {
        this.m_diagramX += shiftX;
        this.m_diagramY += shiftY;
        int i = this.getComponentCount();
        while (--i >= 0) {
            Component component = this.getComponent(i);
            if (!(component instanceof EntityComponent)) continue;
            ((EntityComponent)component).shiftDiagramLocations(shiftX, shiftY);
        }
    }

    public void setDiagramLocation(int diagramX, int diagramY) {
        this.m_diagramX = diagramX;
        this.m_diagramY = diagramY;
        int i = this.getComponentCount();
        while (--i >= 0) {
            Component component = this.getComponent(i);
            if (!(component instanceof EntityComponent)) continue;
            ((EntityComponent)component).setDiagramLocation(diagramX + component.getX(), diagramY + component.getY());
        }
    }

    public int getDiagramX() {
        return this.m_diagramX;
    }

    public int getDiagramY() {
        return this.m_diagramY;
    }

    public Rectangle getDiagramBounds() {
        return new Rectangle(this.m_diagramX, this.m_diagramY, this.getWidth(), this.getHeight());
    }

    public boolean shades(EntityComponent base) {
        int basey;
        int y;
        int basex;
        int x = this.getX();
        return x >= (basex = base.getX()) && (y = this.getY()) >= (basey = base.getY()) && (x += this.getWidth()) <= (basex += base.getWidth()) && (y += this.getHeight()) <= (basey += base.getHeight());
    }

    public void computeShading() {
        EntityComponent ec1;
        int i;
        EntityInstance e = this.m_entityInstance;
        int size = this.getComponentCount();
        if (!e.isMarked(0x10000000)) {
            block0: for (i = 0; i < size; ++i) {
                EntityComponent ec2;
                ec1 = (EntityComponent)this.getComponent(i);
                EntityInstance child = ec1.getEntityInstance();
                int j = size;
                do {
                    if (--j != i) continue;
                    child.nandMark(0x20000000);
                    continue block0;
                } while (!ec1.shades(ec2 = (EntityComponent)this.getComponent(j)));
                child.orMark(0x20000000);
            }
            e.orMark(0x10000000);
        }
        for (i = 0; i < size; ++i) {
            ec1 = (EntityComponent)this.getComponent(i);
            ec1.computeShading();
        }
    }

    public void resizeDstCardinals(int numRelations) {
        int i;
        Cardinal[] cardinals = this.m_dstCardinals;
        if (cardinals == null) {
            if (numRelations > 0) {
                this.m_dstCardinals = new Cardinal[numRelations];
            }
        } else if (numRelations == 0) {
            this.m_dstCardinals = null;
        } else if (cardinals.length != numRelations) {
            i = cardinals.length;
            if (i > numRelations) {
                i = numRelations;
            }
            Cardinal[] newCardinals = new Cardinal[numRelations];
            this.m_dstCardinals = newCardinals;
            while (--i >= 0) {
                newCardinals[i] = cardinals[i];
            }
        }
        i = this.getComponentCount();
        while (--i >= 0) {
            EntityComponent child = (EntityComponent)this.getComponent(i);
            child.resizeDstCardinals(numRelations);
        }
    }

    public void resizeSrcCardinals(int numRelations) {
        int i;
        SrcCardinal[] cardinals = this.m_srcCardinals;
        if (cardinals == null) {
            if (numRelations > 0) {
                this.m_srcCardinals = new SrcCardinal[numRelations];
            }
        } else if (numRelations == 0) {
            this.m_srcCardinals = null;
        } else if (cardinals.length != numRelations) {
            i = cardinals.length;
            if (i > numRelations) {
                i = numRelations;
            }
            SrcCardinal[] newCardinals = new SrcCardinal[numRelations];
            this.m_srcCardinals = newCardinals;
            while (--i >= 0) {
                newCardinals[i] = cardinals[i];
            }
        }
        i = this.getComponentCount();
        while (--i >= 0) {
            EntityComponent child = (EntityComponent)this.getComponent(i);
            child.resizeSrcCardinals(numRelations);
        }
    }

    public void resetDstCardinals() {
        int i;
        Cardinal[] cardinals = this.m_dstCardinals;
        if (cardinals != null) {
            i = cardinals.length;
            while (--i >= 0) {
                Cardinal cardinal = cardinals[i];
                if (cardinal == null) continue;
                cardinal.reset();
            }
        }
        i = this.getComponentCount();
        while (--i >= 0) {
            EntityComponent child = (EntityComponent)this.getComponent(i);
            child.resetDstCardinals();
        }
    }

    public void resetSrcCardinals() {
        int i;
        SrcCardinal[] cardinals = this.m_srcCardinals;
        if (cardinals != null) {
            i = cardinals.length;
            while (--i >= 0) {
                SrcCardinal cardinal = cardinals[i];
                if (cardinal == null) continue;
                cardinal.reset();
            }
        }
        i = this.getComponentCount();
        while (--i >= 0) {
            EntityComponent child = (EntityComponent)this.getComponent(i);
            child.resetSrcCardinals();
        }
    }

    public void calcDstEdgeCardinals() {
        int i;
        Vector dstLiftedList = this.getDstLiftedList();
        if (dstLiftedList != null) {
            Cardinal[] cardinals = this.m_dstCardinals;
            i = dstLiftedList.size();
            while (--i >= 0) {
                RelationInstance ri = (RelationInstance)dstLiftedList.elementAt(i);
                RelationClass rc = ri.getRelationClass();
                int ind = rc.getNid();
                Cardinal cardinal = cardinals[ind];
                if (cardinal == null) {
                    cardinals[ind] = cardinal = new Cardinal();
                }
                cardinal.sum(ri);
            }
        }
        i = this.getComponentCount();
        while (--i >= 0) {
            EntityComponent child = (EntityComponent)this.getComponent(i);
            child.calcDstEdgeCardinals();
        }
    }

    public void calcSrcEdgeCardinals() {
        int i;
        Vector srcLiftedList = this.getSrcLiftedList();
        if (srcLiftedList != null) {
            SrcCardinal[] cardinals = this.m_srcCardinals;
            i = srcLiftedList.size();
            while (--i >= 0) {
                RelationInstance ri = (RelationInstance)srcLiftedList.elementAt(i);
                RelationClass rc = ri.getRelationClass();
                int ind = rc.getNid();
                SrcCardinal cardinal = cardinals[ind];
                if (cardinal == null) {
                    cardinals[ind] = cardinal = new SrcCardinal();
                }
                cardinal.sum(ri);
            }
        }
        i = this.getComponentCount();
        while (--i >= 0) {
            EntityComponent child = (EntityComponent)this.getComponent(i);
            child.calcSrcEdgeCardinals();
        }
    }

    private void moveCardinals(Diagram diagram) {
        int width = this.getWidth();
        int height = this.getHeight();
        if (width > 0 && height > 0) {
            RelationClass rc;
            Cardinal cardinal;
            int i;
            int diagramX = this.getDiagramX();
            int diagramY = this.getDiagramY();
            Cardinal[] cardinals = this.m_dstCardinals;
            if (cardinals != null) {
                i = cardinals.length;
                while (i > 0) {
                    if ((cardinal = cardinals[--i]) == null) continue;
                    rc = diagram.numToRelationClass(i);
                    cardinal.setCenterTop(diagramX, diagramY, width, height, rc);
                }
            }
            if ((cardinals = this.m_srcCardinals) != null) {
                i = cardinals.length;
                while (i > 0) {
                    if ((cardinal = cardinals[--i]) == null) continue;
                    rc = diagram.numToRelationClass(i);
                    cardinal.setCenterTop(diagramX, diagramY, width, height, rc);
                }
            }
            i = this.getComponentCount();
            while (--i >= 0) {
                EntityComponent child = (EntityComponent)this.getComponent(i);
                child.moveCardinals(diagram);
            }
        }
    }

    public void showDstCardinals(Diagram diagram) {
        int width = this.getWidth();
        int height = this.getHeight();
        if (width > 0 && height > 0) {
            int i;
            Cardinal[] cardinals = this.m_dstCardinals;
            if (cardinals != null) {
                int diagramX = this.getDiagramX();
                int diagramY = this.getDiagramY();
                i = cardinals.length;
                while (i > 0) {
                    RelationClass rc;
                    int cnt;
                    Cardinal cardinal;
                    if ((cardinal = cardinals[--i]) == null || (cnt = cardinal.getCnt()) <= 0 || !(rc = diagram.numToRelationClass(i)).isShown()) continue;
                    cardinal.setBackground(rc.getInheritedObjectColor());
                    cardinal.setCenterTop(diagramX, diagramY, width, height, rc);
                    diagram.add(cardinal);
                }
            }
            i = this.getComponentCount();
            while (--i >= 0) {
                EntityComponent child = (EntityComponent)this.getComponent(i);
                child.showDstCardinals(diagram);
            }
        }
    }

    public void showSrcCardinals(Diagram diagram) {
        int width = this.getWidth();
        int height = this.getHeight();
        if (width > 0 && height > 0) {
            int i;
            SrcCardinal[] cardinals = this.m_srcCardinals;
            if (cardinals != null) {
                int diagramX = this.getDiagramX();
                int diagramY = this.getDiagramY();
                i = cardinals.length;
                while (i > 0) {
                    RelationClass rc;
                    int cnt;
                    SrcCardinal cardinal;
                    if ((cardinal = cardinals[--i]) == null || (cnt = cardinal.getCnt()) <= 0 || !(rc = diagram.numToRelationClass(i)).isShown()) continue;
                    cardinal.setBackground(rc.getInheritedObjectColor());
                    cardinal.setCenterTop(diagramX, diagramY, width, height, rc);
                    diagram.add(cardinal);
                }
            }
            i = this.getComponentCount();
            while (--i >= 0) {
                EntityComponent child = (EntityComponent)this.getComponent(i);
                child.showSrcCardinals(diagram);
            }
        }
    }

    public void setAvgX(double avgX) {
        this.m_avgX = avgX;
    }

    public double getAvgX() {
        return this.m_avgX;
    }

    public void refillEdges() {
        int i;
        Vector liftedList = this.m_srcLiftedList;
        for (int dir = 0; dir < 2; ++dir) {
            if (liftedList != null) {
                i = liftedList.size();
                while (--i >= 0) {
                    RelationInstance ri = (RelationInstance)liftedList.elementAt(i);
                    ri.nandMark(524288);
                }
            }
            liftedList = this.m_dstLiftedList;
        }
        i = this.getComponentCount();
        while (--i >= 0) {
            EntityComponent component = (EntityComponent)this.getComponent(i);
            component.refillEdges();
        }
    }

    private void entitySizeChanged() {
        int j;
        Container parent = this.getParent();
        if (!(parent instanceof EntityComponent)) {
            return;
        }
        int size = parent.getComponentCount();
        int i = 0;
        while (true) {
            if (i == size) {
                return;
            }
            if (this == parent.getComponent(i)) break;
            ++i;
        }
        EntityInstance e = this.getEntityInstance();
        if (e.isMarked(0x400000)) {
            j = 0;
        } else {
            EntityComponent ec;
            EntityInstance e1;
            double area1;
            double area = e.widthRelLocal() * e.heightRelLocal();
            for (j = i - 1; j >= 0 && !((area1 = (e1 = (ec = (EntityComponent)parent.getComponent(j)).getEntityInstance()).widthRelLocal() * e1.heightRelLocal()) <= area); --j) {
            }
            if (++j == i) {
                for (j = i + 1; j < size && !((area1 = (e1 = (ec = (EntityComponent)parent.getComponent(j)).getEntityInstance()).widthRelLocal() * e1.heightRelLocal()) >= area); ++j) {
                }
                --j;
            }
        }
        if (j != i) {
            parent.remove(i);
            parent.add((Component)this, j);
        }
    }

    public void setEntityBounds(EntityComponent parentComponent) {
        boolean sameSize;
        int newHeight;
        int newWidth;
        int newY;
        int newX;
        EntityInstance e = this.m_entityInstance;
        EntityInstance parent = parentComponent.getEntityInstance();
        double parentWidth = parentComponent.getWidth();
        double parentHeight = parentComponent.getHeight();
        int oldX = this.getX();
        int oldY = this.getY();
        int oldWidth = this.getWidth();
        int oldHeight = this.getHeight();
        parent.nandMark(0x10000000);
        if (parentWidth <= 0.0 || parentHeight <= 0.0) {
            newX = oldX;
            newY = oldY;
            newWidth = 0;
            newHeight = 0;
        } else {
            newX = (int)(e.xRelLocal() * parentWidth);
            newY = (int)(e.yRelLocal() * parentHeight);
            newWidth = (int)(e.widthRelLocal() * parentWidth);
            newHeight = (int)(e.heightRelLocal() * parentHeight);
        }
        boolean bl = sameSize = oldWidth == newWidth && oldHeight == newHeight;
        if (sameSize && oldX == newX && oldY == newY) {
            return;
        }
        this.setBounds(newX, newY, newWidth, newHeight);
        if (!sameSize) {
            this.entitySizeChanged();
            int i = this.getComponentCount();
            while (--i >= 0) {
                EntityComponent child = (EntityComponent)this.getComponent(i);
                child.setEntityBounds(this);
            }
        }
    }

    public void setEntityBounds() {
        Container parent = this.getParent();
        if (parent != null && parent instanceof EntityComponent) {
            this.setEntityBounds((EntityComponent)parent);
        }
    }

    public static void paintImage(Graphics g, int image, int x, int y, int width, int height, boolean force) {
        block11: for (int i = 256; i != 0; i >>= 1) {
            if ((i & image) == 0) continue;
            switch (i) {
                case 1: {
                    int min = width;
                    if (height < min) {
                        min = height;
                    }
                    int centerx = x + width / 2;
                    int centery = y + height / 2;
                    g.drawOval(centerx - min / 10, centery - 7 * min / 20, min / 5, min / 5);
                    g.drawLine(centerx, centery - 3 * min / 20, centerx, centery + 3 * min / 20);
                    g.drawLine(centerx - min / 4, centery - min / 20, centerx + min / 4, centery - min / 20);
                    g.drawLine(centerx, centery + 3 * min / 20, centerx - min / 5, centery + 2 * min / 5);
                    g.drawLine(centerx, centery + 3 * min / 20, centerx + min / 5, centery + 2 * min / 5);
                    continue block11;
                }
                case 2: {
                    g.drawOval(x, y, width, height);
                    continue block11;
                }
                case 4: {
                    g.drawRect(x, y, width - 1, height - 1);
                    continue block11;
                }
                case 8: {
                    int arc_w = width / 5;
                    int arc_h = height / 5;
                    int arc = Math.min(arc_w, arc_h);
                    g.drawRoundRect(x, y, width - 1, height - 1, arc, arc);
                    continue block11;
                }
                case 16: {
                    int min = width;
                    if (height < min) {
                        min = height;
                    }
                    int centerx = x + width / 2;
                    int centery = y + height / 2;
                    g.drawLine(centerx - min / 4, centery - min / 4, centerx + min / 4, centery + min / 4);
                    g.drawLine(centerx + min / 4, centery - min / 4, centerx - min / 4, centery + min / 4);
                    continue block11;
                }
                case 32: {
                    if (!force) continue block11;
                    Util.drawStringClipped(g, "CLASS", x, y, width, height, false, false, false);
                    continue block11;
                }
                case 64: {
                    if (!force) continue block11;
                    Util.drawStringBottomClipped(g, "SPAN", x, y, width, height, false, false, false);
                    continue block11;
                }
                case 128: {
                    if (!force) continue block11;
                    NavNext_Button.paintIcon(g, x, y, width, height, 16, 16);
                    continue block11;
                }
                case 256: {
                    if (!force) continue block11;
                    NavPrev_Button.paintIcon(g, x, y, width, height, 16, 16);
                }
            }
        }
    }

    private static void draw3DRectRaised(Graphics g, Color c, Color fill, int x, int y, int width, int height) {
        Option option = Options.getDiagramOptions();
        Color brighter = Color.white;
        Color darker = Color.darkGray;
        int pixels3D = option.getPixels3D();
        if (!option.isBlackWhite3D()) {
            brighter = c.brighter();
            darker = c.darker();
        }
        if (fill != null) {
            g.setColor(fill);
            g.fillRect(x + pixels3D, y + pixels3D, width - 2 * pixels3D, height - 2 * pixels3D);
        }
        g.setColor(brighter);
        g.fillRect(x, y, pixels3D, height);
        g.fillRect(x + pixels3D, y, width - pixels3D, pixels3D);
        g.setColor(darker);
        g.fillRect(x + pixels3D, y + height - pixels3D, width - pixels3D, pixels3D);
        g.fillRect(x + width - pixels3D, y, pixels3D, height);
        g.setColor(Color.black);
        g.drawLine(x, y, x + pixels3D - 1, y + pixels3D - 1);
    }

    private static void draw3DRectSunken(Graphics g, Color c, Color fill, int x, int y, int width, int height) {
        Option option = Options.getDiagramOptions();
        Color brighter = Color.white;
        Color darker = Color.darkGray;
        int pixels3D = option.getPixels3D();
        if (!option.isBlackWhite3D()) {
            brighter = c.brighter();
            darker = c.darker();
        }
        if (fill != null) {
            g.setColor(fill);
            g.fillRect(x + pixels3D, y + pixels3D, width - 2 * pixels3D, height - 2 * pixels3D);
        }
        g.setColor(darker);
        g.fillRect(x, y, pixels3D, height);
        g.fillRect(x + pixels3D, y, width - pixels3D, pixels3D);
        g.setColor(brighter);
        g.fillRect(x + pixels3D, y + height - pixels3D, width - pixels3D, pixels3D);
        g.fillRect(x + width - pixels3D, y, pixels3D, height);
        g.setColor(Color.black);
        g.drawLine(x + width - pixels3D, y + height - pixels3D, x + width - 1, y + height - 1);
    }

    public void clearScaledIcon() {
        this.m_scaledIcon = null;
    }

    public void elisionsChanged() {
        if (this.m_scaledIcon instanceof JLabel) {
            this.clearScaledIcon();
            this.repaint();
        }
    }

    private static Icon computeScaledIcon(PaintShapeHelper helper, int width, int height) {
        int scaledWidth;
        int scaledHeight;
        Icon scaledIcon = helper.getScaledIcon();
        if (scaledIcon == null) {
            scaledHeight = -1;
            scaledWidth = -1;
        } else {
            scaledWidth = scaledIcon.getIconWidth();
            scaledHeight = scaledIcon.getIconHeight();
            if (scaledIcon instanceof JLabel) {
                if (width != scaledWidth || height != scaledHeight) {
                    ((JLabel)((Object)scaledIcon)).setSize(width, height);
                }
                return scaledIcon;
            }
        }
        if (scaledWidth != width || scaledHeight != height) {
            Icon unscaledIcon = helper.getUnscaledIcon();
            if (unscaledIcon == null) {
                scaledIcon = null;
            } else {
                int unscaledWidth = unscaledIcon.getIconWidth();
                int unscaledHeight = unscaledIcon.getIconHeight();
                if (unscaledWidth == width && unscaledHeight == height) {
                    scaledIcon = unscaledIcon;
                } else {
                    Option option = Options.getDiagramOptions();
                    int desiredWidth = width;
                    int desiredHeight = height;
                    if (option.isIconFixedShape() && (desiredHeight = (int)((double)unscaledHeight * (double)width / (double)unscaledWidth)) > height) {
                        desiredWidth = (int)((double)unscaledWidth * (double)height / (double)unscaledHeight);
                        desiredHeight = height;
                    }
                    if (unscaledWidth == desiredWidth && unscaledHeight == desiredHeight) {
                        scaledIcon = unscaledIcon;
                    } else if (scaledWidth != desiredWidth || scaledHeight != desiredHeight) {
                        BufferedImage resizedImg = new BufferedImage(desiredWidth, desiredHeight, 1);
                        Graphics2D g2 = resizedImg.createGraphics();
                        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                        g2.drawImage(((ImageIcon)unscaledIcon).getImage(), 0, 0, desiredWidth, desiredHeight, null);
                        g2.dispose();
                        scaledIcon = new ImageIcon(resizedImg);
                    }
                }
            }
            helper.setScaledIcon(scaledIcon);
        }
        return scaledIcon;
    }

    public static void paintShape(Graphics g, PaintShapeHelper helper, EntityClass entityClass, int x, int y, int width, int height, boolean isDrawRoot, boolean isOpen, Color foregroundColor, Color backgroundColor) {
        if (width > 0 && height > 0) {
            int direction;
            int style;
            int[] xp = m_xp;
            int[] yp = m_yp;
            int polygon_dimension = 0;
            int regular_dimension = 0;
            Option option = Options.getDiagramOptions();
            int icon_rule = option.getIconRule();
            int image = 0;
            if (isDrawRoot) {
                style = 0;
                direction = 0;
            } else {
                style = entityClass.getInheritedStyle();
                direction = entityClass.getDirection();
                if (!isOpen) {
                    image = entityClass.getImage();
                    if (icon_rule != 0) {
                        String label;
                        int iconY = y;
                        int iconHeight = height;
                        if (icon_rule != 1 && ((label = helper.getEntityLabel()) == null || label.length() == 0)) {
                            icon_rule = 1;
                        }
                        switch (icon_rule) {
                            case 3: 
                            case 4: {
                                FontMetrics fm = g.getFontMetrics();
                                int fontHeight = fm.getHeight();
                                if (fontHeight >= height) break;
                                iconHeight = height - fontHeight;
                                if (icon_rule != 4) break;
                                iconY = y + fontHeight;
                                break;
                            }
                        }
                        Icon scaledIcon = EntityComponent.computeScaledIcon(helper, width, iconHeight);
                        if (scaledIcon != null) {
                            int scaledWidth = scaledIcon.getIconWidth();
                            int scaledHeight = scaledIcon.getIconHeight();
                            scaledIcon.paintIcon(null, g, x + (width - scaledWidth >>> 1), iconY + (iconHeight - scaledHeight >>> 1));
                            style = -1;
                        }
                        if (option.isIconFixedShape()) {
                            g.setColor(backgroundColor);
                            Util.drawOutlineBox(g, x, y, width, height);
                        }
                    }
                }
            }
            switch (style) {
                case 0: {
                    EntityComponent.draw3DRectRaised(g, foregroundColor, backgroundColor, x, y, width - 1, height - 1);
                    break;
                }
                case 24: {
                    EntityComponent.draw3DRectSunken(g, foregroundColor, backgroundColor, x, y, width - 1, height - 1);
                    break;
                }
                case 1: {
                    if (backgroundColor != null) {
                        g.setColor(backgroundColor);
                        g.fillRect(x, y, width, height);
                    }
                    g.setColor(foregroundColor);
                    g.drawRect(x, y, width - 1, height - 1);
                    break;
                }
                case 2: {
                    int fd = Math.min(Math.min(width, height) / 2, 16);
                    xp[0] = x;
                    yp[0] = y;
                    xp[1] = x + width - fd;
                    yp[1] = y;
                    xp[2] = x + width - 1;
                    yp[2] = y + fd;
                    xp[3] = xp[2];
                    yp[3] = y + height - 1;
                    xp[4] = x;
                    yp[4] = yp[3];
                    xp[5] = xp[0];
                    yp[5] = yp[0];
                    if (backgroundColor != null) {
                        g.setColor(backgroundColor);
                        g.fillPolygon(xp, yp, 6);
                    }
                    g.setColor(foregroundColor);
                    g.drawPolygon(xp, yp, 6);
                    xp[0] = xp[1];
                    yp[0] = yp[2];
                    xp[3] = xp[0];
                    yp[3] = yp[0];
                    g.drawPolygon(xp, yp, 4);
                    break;
                }
                case 3: {
                    int ad = Math.min(Math.min(width, height) / 2, 8);
                    if (backgroundColor != null) {
                        g.setColor(backgroundColor);
                        g.fillRect(x, y + ad / 2, width, height - ad);
                        g.fillOval(x, y, width, ad);
                        g.fillOval(x, y + height - ad, width, ad);
                    }
                    g.setColor(foregroundColor);
                    if (isOpen) {
                        g.drawArc(x, y, width, ad, 180, -180);
                    } else {
                        g.drawOval(x, y, width, ad);
                    }
                    g.drawArc(x, y + height - ad - 1, width, ad, 180, 180);
                    g.drawLine(x, y + ad / 2, x, y + height - ad / 2);
                    g.drawLine(x + width - 1, y + ad / 2, x + width - 1, y + height - ad / 2);
                    break;
                }
                case 4: {
                    int fw = (int)((double)width * 0.4);
                    int fh = Math.max(3, Math.min(8, (int)((double)height * 0.2)));
                    int fm = 4;
                    if (fw < 75) {
                        fw += fw / 2;
                    }
                    if (fw < 10) {
                        fw = Math.min(fw + 4, width - width / 3);
                        fm = 0;
                    }
                    if (backgroundColor != null) {
                        g.setColor(backgroundColor);
                        g.fillRect(x, y, width - 1, height - 1);
                    }
                    g.setColor(foregroundColor);
                    g.drawRect(x, y, width - 1, height - 1);
                    int x0 = x;
                    int y0 = y + fh;
                    int x5 = x + width - 1;
                    int y5 = y0;
                    if (isOpen) {
                        g.drawLine(x0, y0, x5, y5);
                        break;
                    }
                    int x1 = x + fm;
                    int y1 = y + fh;
                    g.drawLine(x0, y0, x1, y1);
                    int x2 = x1 + fh / 2;
                    int y2 = y;
                    g.drawLine(x1, y1, x2, y2);
                    int x3 = x + fw;
                    int y3 = y2;
                    g.drawLine(x2, y2, x3, y3);
                    int x4 = x3 + fh / 2;
                    int y4 = y0;
                    g.drawLine(x3, y3, x4, y4);
                    g.drawLine(x4, y4, x5, y5);
                    break;
                }
                case 5: {
                    if (backgroundColor != null) {
                        g.setColor(backgroundColor);
                        g.fillOval(x, y, width, height);
                    }
                    g.setColor(foregroundColor);
                    g.drawOval(x, y, width, height);
                    break;
                }
                case 6: {
                    int arc_w = width / 4;
                    int arc_h = height / 4;
                    int arc = Math.min(arc_w, arc_h);
                    if (backgroundColor != null) {
                        g.setColor(backgroundColor);
                        g.fillRoundRect(x, y, width - 1, height - 1, arc, arc);
                    }
                    g.setColor(foregroundColor);
                    g.drawRoundRect(x, y, width - 1, height - 1, arc, arc);
                    break;
                }
                case 7: {
                    g.setColor(backgroundColor);
                    Util.drawOutlineBox(g, x, y, width, height);
                    break;
                }
                case 8: {
                    String label = helper.getEntityLabel();
                    g.setColor(backgroundColor);
                    Util.drawGroupBox(g, x, y, width, height, label);
                    break;
                }
                case 9: {
                    switch (direction) {
                        case 0: {
                            xp[0] = x;
                            yp[0] = y + height - 1;
                            xp[1] = x + width / 2;
                            yp[1] = y;
                            xp[2] = x + width - 1;
                            yp[2] = yp[0];
                            break;
                        }
                        case 1: {
                            xp[0] = x;
                            yp[0] = y;
                            xp[1] = x + width - 1;
                            yp[1] = y + height / 2;
                            xp[2] = xp[0];
                            yp[2] = y + height - 1;
                            break;
                        }
                        case 2: {
                            xp[0] = x;
                            yp[0] = y;
                            xp[1] = x + width - 1;
                            yp[1] = yp[0];
                            xp[2] = x + width / 2;
                            yp[2] = y + height - 1;
                            break;
                        }
                        case 3: {
                            xp[0] = x + width - 1;
                            yp[0] = y;
                            xp[1] = x;
                            yp[1] = y + height / 2;
                            xp[2] = xp[0];
                            yp[2] = y + height - 1;
                        }
                    }
                    polygon_dimension = 4;
                    break;
                }
                case 10: {
                    switch (direction) {
                        case 0: {
                            xp[0] = x;
                            yp[0] = y + height - 1;
                            xp[1] = x + width / 5;
                            yp[1] = y;
                            xp[2] = x + width - 1;
                            yp[2] = y;
                            xp[3] = x + width * 4 / 5;
                            yp[3] = y + height - 1;
                            break;
                        }
                        case 1: {
                            xp[0] = x;
                            yp[0] = y;
                            xp[1] = x + width - 1;
                            yp[1] = y + height / 5;
                            xp[2] = xp[1];
                            yp[2] = y + height - 1;
                            xp[3] = xp[0];
                            yp[3] = y + 4 * height / 5;
                            break;
                        }
                        case 2: {
                            xp[0] = x + width / 5;
                            yp[0] = y + height - 1;
                            xp[1] = x;
                            yp[1] = y;
                            xp[2] = x + 4 * width / 5;
                            yp[2] = y;
                            xp[3] = x + width - 1;
                            yp[3] = y + height - 1;
                            break;
                        }
                        case 3: {
                            xp[0] = x;
                            yp[0] = y + height / 5;
                            xp[1] = x + width - 1;
                            yp[1] = y;
                            xp[2] = xp[1];
                            yp[2] = y + 4 * height / 5;
                            xp[3] = xp[0];
                            yp[3] = y + height - 1;
                        }
                    }
                    polygon_dimension = 5;
                    break;
                }
                case 11: {
                    switch (direction) {
                        case 0: {
                            xp[0] = x;
                            yp[0] = y + height - 1;
                            xp[1] = x + width / 5;
                            yp[1] = y;
                            xp[2] = x + 4 * width / 5;
                            yp[2] = yp[1];
                            xp[3] = x + width - 1;
                            yp[3] = yp[0];
                            break;
                        }
                        case 1: {
                            xp[0] = x;
                            yp[0] = y;
                            xp[1] = x + width - 1;
                            yp[1] = y + height / 5;
                            xp[2] = xp[1];
                            yp[2] = y + 4 * height / 5;
                            xp[3] = xp[0];
                            yp[3] = y + height - 1;
                            break;
                        }
                        case 2: {
                            xp[0] = x;
                            yp[0] = y;
                            xp[1] = x + width - 1;
                            yp[1] = yp[0];
                            xp[2] = x + 4 * width / 5;
                            yp[2] = y + height - 1;
                            xp[3] = x + width / 5;
                            yp[3] = yp[2];
                            break;
                        }
                        case 3: {
                            xp[0] = x + width - 1;
                            yp[0] = y;
                            xp[1] = x;
                            yp[1] = y + height / 5;
                            xp[2] = xp[1];
                            yp[2] = y + 4 * height / 5;
                            xp[3] = xp[0];
                            yp[3] = y + height - 1;
                        }
                    }
                    polygon_dimension = 5;
                    break;
                }
                case 12: {
                    regular_dimension = 3;
                    break;
                }
                case 13: {
                    regular_dimension = 4;
                    break;
                }
                case 14: {
                    regular_dimension = 5;
                    break;
                }
                case 15: {
                    regular_dimension = 6;
                    break;
                }
                case 16: {
                    regular_dimension = 8;
                    break;
                }
                case 17: {
                    regular_dimension = 10;
                    break;
                }
                case 18: {
                    regular_dimension = 12;
                    break;
                }
                case 19: {
                    regular_dimension = 14;
                    break;
                }
                case 20: {
                    regular_dimension = 16;
                    break;
                }
                case 21: {
                    regular_dimension = 18;
                    break;
                }
                case 22: {
                    regular_dimension = 20;
                    break;
                }
                case 23: {
                    int baseline = y + height * 4 / 5;
                    xp[0] = x + 3 * width / 8;
                    yp[0] = baseline;
                    xp[1] = xp[0];
                    yp[1] = y + 193 * height / 200;
                    xp[2] = x + 2 * width / 3;
                    yp[2] = baseline;
                    xp[3] = xp[0];
                    yp[3] = yp[0];
                    if (backgroundColor != null) {
                        g.setColor(backgroundColor);
                        g.fillRect(x, y, width, height * 4 / 5);
                        g.fillArc(x, y + height / 2, width / 2, height / 2, -180, 180);
                        g.fillPolygon(xp, yp, 4);
                    }
                    g.setColor(foregroundColor);
                    g.drawLine(x, y, x, y + height * 3 / 4);
                    g.drawLine(x, y, x + width - 1, y);
                    g.drawLine(x + width - 1, y, x + width - 1, baseline);
                    g.drawLine(x + 2 * width / 3, baseline, x + width - 1, baseline);
                    g.drawArc(x, y + height / 2 - 1, width / 2, height / 2 - 1, -180, 120);
                    g.drawLine(xp[1], yp[1], xp[2], yp[2]);
                    break;
                }
            }
            if (regular_dimension != 0) {
                polygon_dimension = regular_dimension + 1;
                double angle = Math.toRadians(entityClass.getAngle() - 90.0);
                double shift = Math.PI * 2 / (double)regular_dimension;
                double dwidth = width;
                double dheight = height;
                for (int i = 0; i < regular_dimension; ++i) {
                    xp[i] = x + (int)(dwidth * (1.0 + Math.cos(angle)) * 0.5);
                    yp[i] = y + (int)(dheight * (1.0 + Math.sin(angle)) * 0.5);
                    angle -= shift;
                }
            }
            if (polygon_dimension != 0) {
                xp[polygon_dimension - 1] = xp[0];
                yp[polygon_dimension - 1] = yp[0];
                if (backgroundColor != null) {
                    g.setColor(backgroundColor);
                    g.fillPolygon(xp, yp, polygon_dimension);
                }
                g.setColor(foregroundColor);
                g.drawPolygon(xp, yp, polygon_dimension);
            }
            if (image != 0) {
                g.setColor(backgroundColor);
                Color inverse = ColorCache.getInverse(backgroundColor.getRGB());
                g.setColor(inverse);
                EntityComponent.paintImage(g, image, x, y, width, height, false);
            }
        }
    }

    public void paintMap(Graphics g, int x, int y, int width, int height, EntityInstance onPath, int depth) {
        if (width > 0 && height > 0) {
            Vector srcRelList;
            EntityInstance entityInstance = this.m_entityInstance;
            Color backgroundColor = entityInstance.hasChildren() && depth != 1 ? null : (entityInstance == onPath ? Color.red.darker() : entityInstance.getInheritedObjectColor());
            EntityComponent.paintShape(g, this, entityInstance.getEntityClass(), x, y, width, height, false, entityInstance.isOpen(), Color.black, backgroundColor);
            if (depth < 1 && (srcRelList = entityInstance.getSrcRelList()) != null) {
                int i = srcRelList.size();
                while (--i >= 0) {
                    EntityInstance child;
                    RelationInstance ri = (RelationInstance)srcRelList.elementAt(i);
                    if (!ri.isMarked(0x100000) || !(child = ri.getDst()).isShown()) continue;
                    int x1 = x + (int)((double)width * child.xRelLocal());
                    int y1 = y + (int)((double)height * child.yRelLocal());
                    int width1 = (int)((double)width * child.widthRelLocal());
                    int height1 = (int)((double)height * child.heightRelLocal());
                    child.paintMap(g, x1, y1, width1, height1, onPath, depth + 1);
                }
            }
        }
    }

    @Override
    public String getEntityLabel() {
        return this.m_entityInstance.getEntityLabel();
    }

    @Override
    public Icon getScaledIcon() {
        EntityInstance e;
        Option option = Options.getDiagramOptions();
        int elisionIcon = option.getElisionIcon();
        if (elisionIcon >= 0 && !(e = this.m_entityInstance).isMarked(128)) {
            EntityClass ec = e.getEntityClass();
            Diagram diagram = e.getDiagram();
            RelationClass rc = diagram.numToRelationClass(elisionIcon);
            return IconCache.getElisionIcon(e.getElisions(rc), rc.toString());
        }
        return this.m_scaledIcon;
    }

    @Override
    public void setScaledIcon(Icon icon) {
        this.m_scaledIcon = icon;
    }

    @Override
    public Icon getUnscaledIcon() {
        return this.m_entityInstance.getEntityClass().getUnscaledIcon();
    }

    @Override
    public int getIconWidth() {
        return this.getWidth();
    }

    @Override
    public int getIconHeight() {
        return this.getHeight();
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        g.translate(x, y);
        this.paintComponent(g);
    }
}

