/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.io.PrintWriter;
import javax.swing.Icon;
import lsedit.Attribute;
import lsedit.ClosedIcon;
import lsedit.Diagram;
import lsedit.EdgePoint;
import lsedit.EntityInstance;
import lsedit.IconCache;
import lsedit.LandscapeClassObject;
import lsedit.LeafIcon;
import lsedit.OpenIcon;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.ResultBox;
import lsedit.Ta;

public final class EntityClass
extends LandscapeClassObject {
    public static final String ENTITY_BASE_CLASS_ID = "$ENTITY";
    protected static final String CLASSANGLE_ID = "class_angle";
    protected static final String CLASSIMAGE_ID = "class_image";
    protected static final String CLASSICON_ID = "class_icon";
    public static final int ID_ATTR = 0;
    public static final int CLASSLABEL_ATTR = 1;
    public static final int CLASSDESC_ATTR = 2;
    public static final int CLASSSTYLE_ATTR = 3;
    public static final int CLASSANGLE_ATTR = 4;
    public static final int CLASSIMAGE_ATTR = 5;
    public static final int COLOR_ATTR = 6;
    public static final int LABEL_COLOR_ATTR = 7;
    public static final int OPEN_COLOR_ATTR = 8;
    public static final int CLASSICON_ATTR = 9;
    public static final int ATTRS = 10;
    public static final String[] attributeName = new String[]{"id", "class_label", "class_description", "class_style", "class_angle", "class_image", "color", "labelcolor", "opencolor", "class_icon"};
    public static final int[] attributeType = new int[]{3, 3, 12, 13, 2, 17, 8, 8, 8, 3};
    public static final int ENTITY_STYLE_NONE = -1;
    public static final int ENTITY_STYLE_3DBOX = 0;
    public static final int ENTITY_STYLE_2DBOX = 1;
    public static final int ENTITY_STYLE_FILE = 2;
    public static final int ENTITY_STYLE_DISK = 3;
    public static final int ENTITY_STYLE_FOLDER = 4;
    public static final int ENTITY_STYLE_SOURCEOBJ = 5;
    public static final int ENTITY_STYLE_CLASS = 6;
    public static final int ENTITY_STYLE_GROUP = 7;
    public static final int ENTITY_STYLE_LABELLED_GROUP = 8;
    public static final int ENTITY_STYLE_TRIANGLE = 9;
    public static final int ENTITY_STYLE_ROMBUS = 10;
    public static final int ENTITY_STYLE_TRAPEZOID = 11;
    public static final int ENTITY_STYLE_TRIANGLE2 = 12;
    public static final int ENTITY_STYLE_RECTANGLE = 13;
    public static final int ENTITY_STYLE_PENTAGON = 14;
    public static final int ENTITY_STYLE_HEXAGON = 15;
    public static final int ENTITY_STYLE_OCTAGON = 16;
    public static final int ENTITY_STYLE_DECAHEDRON = 17;
    public static final int ENTITY_STYLE_12SIDED = 18;
    public static final int ENTITY_STYLE_14SIDED = 19;
    public static final int ENTITY_STYLE_16SIDED = 20;
    public static final int ENTITY_STYLE_18SIDED = 21;
    public static final int ENTITY_STYLE_20SIDED = 22;
    public static final int ENTITY_STYLE_PAPER = 23;
    public static final int ENTITY_STYLE_SUNK_BOX = 24;
    public static final String[] styleName = new String[]{"3D Box", "2D Box", "File", "Disk", "Folder", "Source Object", "Class", "Group", "Labelled Group", "Triangle  (directed)", "Rombus    (directed)", "Trapezoid (directed)", "3-sided  Triangle", "4-sided  Diamond", "5-sided  Pentagon", "6-sided  Hexagon", "8-sided  Octagon", "10-sided Decahedron", "12 sided Polygon", "14 sided Polygon", "16 sided Polygon", "18 sided Polygon", "20 sided Dodecahedron", "Paper", "Sunken Box"};
    public static final int ENTITY_IMAGE_NONE = 0;
    public static final int ENTITY_IMAGE_ACTOR = 1;
    public static final int ENTITY_IMAGE_OVAL = 2;
    public static final int ENTITY_IMAGE_FRAME = 4;
    public static final int ENTITY_IMAGE_ROUNDED_FRAME = 8;
    public static final int ENTITY_IMAGE_X = 16;
    public static final int ENTITY_IMAGE_CLASS = 32;
    public static final int ENTITY_IMAGE_SPAN = 64;
    public static final int ENTITY_IMAGE_NAV_NEXT = 128;
    public static final int ENTITY_IMAGE_NAV_PREV = 256;
    public static final int ENTITY_IMAGE_LAST = 256;
    public static final String[] imageName = new String[]{"Actor", "Oval", "Frame", "Rounded Frame", "X", "Class", "Span", "Nav Next", "Nav Prev"};
    protected int m_image = 0;
    protected double m_angle = 0.0;
    protected boolean m_unscaledIconBad = false;
    protected Icon m_unscaledIcon = null;
    protected String m_unscaledIconFile = null;
    private EdgePoint[] m_edgePoints;
    OpenIcon m_openIcon = null;
    ClosedIcon m_closedIcon = null;
    LeafIcon m_leafIcon = null;

    @Override
    public int setShown(int value, boolean applyToSubclassesTo) {
        int ret = 0;
        if (this.m_shown != value) {
            Diagram diagram;
            if (value == 0 && (diagram = this.getDiagram()) != null) {
                diagram.clearEntityClassGroupFlags(this);
            }
            ret = 1;
        }
        if (super.setShown(value, applyToSubclassesTo) != 0) {
            ret = -1;
        }
        return ret;
    }

    public EntityClass(String id, int nid, Ta ta) {
        super(ta);
        this.setId(id);
        this.setNid(nid);
        this.setLabel(id);
    }

    public EntityClass getView() {
        EntityClass ec = new EntityClass(this.getId(), this.getNid(), this.getTa());
        ec.setShown(this.getShown(), false);
        ec.setActive(this.getActive(), false);
        return ec;
    }

    public void setView() {
        Ta ta = this.getTa();
        EntityClass ec = ta.getEntityClass(this.getId());
        if (ec != null) {
            ec.setShown(this.getShown(), false);
            ec.setActive(this.getActive(), false);
        }
    }

    public static String getEntityStyleName(int style) {
        if (style < 0 || style >= styleName.length) {
            return "";
        }
        return styleName[style];
    }

    @Override
    public String getStyleName(int style) {
        return EntityClass.getEntityStyleName(style);
    }

    public int getImage() {
        return this.m_image;
    }

    public void setImage(int image) {
        this.m_image = image;
    }

    public double getAngle() {
        return this.m_angle;
    }

    public int getDirection() {
        int val = (int)this.m_angle;
        return (val + 45) / 90 % 4;
    }

    public void setAngle(double angle) {
        this.m_angle = angle;
    }

    public void clearUnscaledIcon() {
        this.m_unscaledIcon = null;
        this.m_unscaledIconBad = false;
    }

    public void clearIcons() {
        if (this.m_openIcon != null) {
            this.m_openIcon.clear();
        }
        if (this.m_closedIcon != null) {
            this.m_closedIcon.clear();
        }
        if (this.m_leafIcon != null) {
            this.m_leafIcon.clear();
        }
        this.clearUnscaledIcon();
    }

    public Icon getUnscaledIcon() {
        Icon unscaledIcon = this.m_unscaledIcon;
        if (unscaledIcon == null && !this.m_unscaledIconBad && this.m_unscaledIconFile != null) {
            unscaledIcon = IconCache.lookup(this.m_unscaledIconFile);
            if (unscaledIcon == null) {
                unscaledIcon = IconCache.get(this.m_unscaledIconFile, this);
            }
            if (unscaledIcon == null) {
                this.m_unscaledIconBad = true;
            } else {
                this.m_unscaledIcon = unscaledIcon;
            }
        }
        return unscaledIcon;
    }

    public String getUnscaledIconFile() {
        return this.m_unscaledIconFile;
    }

    public void setUnscaledIconFile(String iconFile) {
        this.clearUnscaledIcon();
        this.m_unscaledIconFile = iconFile;
    }

    @Override
    public boolean processFirstOrder(String id, String value) {
        if (id.equals(CLASSIMAGE_ID)) {
            if (value != null) {
                this.setImage(Attribute.parseIntValue(value));
            }
            return true;
        }
        if (id.equals(CLASSANGLE_ID)) {
            if (value != null) {
                this.setAngle(Attribute.parseDoubleValue(value));
            }
            return true;
        }
        if (id.equals(CLASSICON_ID)) {
            if (value != null) {
                this.setUnscaledIconFile(value);
            }
            return true;
        }
        return super.processFirstOrder(id, value);
    }

    public void writeAttributes(PrintWriter ps) {
        String nodeId = this.getId();
        double angle = this.getAngle();
        int image = this.getImage();
        String iconFile = this.getUnscaledIconFile();
        nodeId = super.writeAttributes(ps, nodeId);
        if (angle != 0.0) {
            nodeId = EntityClass.writeAttribute(ps, nodeId, CLASSANGLE_ID, angle);
        }
        if (image != 0) {
            nodeId = EntityClass.writeAttribute(ps, nodeId, CLASSIMAGE_ID, image);
        }
        if (iconFile != null) {
            nodeId = EntityClass.writeAttribute(ps, nodeId, CLASSICON_ID, EntityClass.qt(iconFile));
        }
        if (nodeId == null) {
            ps.println("}");
            ps.println("");
        }
    }

    @Override
    public void reportClassAttributes(ResultBox resultBox) {
        super.reportClassAttributes(resultBox);
        resultBox.addText(CLASSIMAGE_ID);
        resultBox.addText(CLASSANGLE_ID);
        resultBox.addText(CLASSICON_ID);
    }

    public EntityInstance newEntity(String id) {
        EntityInstance e = new EntityInstance(this, id);
        return e;
    }

    protected EdgePoint[] needEdgePoints() {
        EdgePoint[] edgePoints = this.m_edgePoints;
        int needed = this.getTa().numRelationClasses() * 4;
        if (edgePoints == null) {
            edgePoints = new EdgePoint[needed];
            this.m_edgePoints = edgePoints;
        } else {
            int have = this.m_edgePoints.length;
            if (have < needed) {
                EdgePoint[] old = edgePoints;
                edgePoints = new EdgePoint[needed];
                this.m_edgePoints = edgePoints;
                for (int i = 0; i < have; ++i) {
                    edgePoints[i] = old[i];
                }
                old = null;
            }
        }
        return edgePoints;
    }

    protected void adjustEdgePoints() {
        EdgePoint[] edgePoints = this.m_edgePoints;
        if (edgePoints != null) {
            for (EdgePoint edgePoint : edgePoints) {
                if (edgePoint == null) continue;
                edgePoint.adjustEdgePoint(this);
            }
        }
    }

    public EdgePoint getPoint(int index) {
        return this.m_edgePoints[index];
    }

    public EdgePoint getPoint(RelationClass rc, int side) {
        int index = rc.getNid() * 4 + side;
        EdgePoint[] edgePoints = this.needEdgePoints();
        EdgePoint edgePoint = edgePoints[index];
        if (edgePoint == null) {
            edgePoints[index] = edgePoint = new EdgePoint();
            edgePoint.setFactors(this, rc, side);
        }
        return edgePoint;
    }

    public int getEdgePointIndex(int startindex, int endindex, EdgePoint edgePoint) {
        EdgePoint[] edgePoints = this.m_edgePoints;
        if (edgePoints != null) {
            for (int index = startindex; index < endindex; ++index) {
                if (edgePoints[index] != edgePoint) continue;
                return index;
            }
        }
        return -1;
    }

    public void changeIOfactor(RelationClass rc) {
        EdgePoint[] edgePoints = this.m_edgePoints;
        if (edgePoints != null) {
            int index = rc.getNid() * 4;
            int endindex = index + 4;
            if (endindex > edgePoints.length) {
                endindex = edgePoints.length;
            }
            while (index < endindex) {
                EdgePoint edgePoint = edgePoints[index];
                if (edgePoint != null) {
                    int side = index % 4;
                    edgePoint.setFactors(this, rc, side);
                }
                ++index;
            }
        }
    }

    public Icon getOpenIcon() {
        if (this.m_openIcon == null) {
            this.m_openIcon = new OpenIcon(this);
        }
        return this.m_openIcon;
    }

    public Icon getClosedIcon() {
        if (this.m_closedIcon == null) {
            this.m_closedIcon = new ClosedIcon(this);
        }
        return this.m_closedIcon;
    }

    public Icon getLeafIcon() {
        if (this.m_leafIcon == null) {
            this.m_leafIcon = new LeafIcon(this);
        }
        return this.m_leafIcon;
    }

    /*
     * Unable to fully structure code
     */
    public void getUsage(int[][] array, int direction) {
        ta = this.getTa();
        numRelationClasses = ta.numRelationClasses();
        numEntityClasses = ta.numEntityClasses();
        entityCache = ta.getEntityCache();
        for (i = 0; i < numRelationClasses; ++i) {
            row = array[i];
            for (j = 0; j < numEntityClasses; ++j) {
                row[j] = 0;
            }
        }
        switch (direction) {
            case 7: {
                direction = 0;
                omitSpan = true;
                break;
            }
            case 8: {
                direction = 1;
                omitSpan = true;
                break;
            }
            case 9: {
                direction = 2;
                omitSpan = true;
                break;
            }
            default: {
                omitSpan = false;
            }
        }
        e = entityCache.getFirst();
        while (e != null) {
            block29: {
                ec = e.getEntityClass();
                if (ec != this) break block29;
                switch (direction) {
                    case 0: 
                    case 1: 
                    case 3: 
                    case 4: 
                    case 6: {
                        v = e.getSrcRelList();
                        if (v == null) ** GOTO lbl57
                        i = v.size();
                        block21: while (--i >= 0) {
                            ri = (RelationInstance)v.elementAt(i);
                            e1 = ri.getDst();
                            if (e1 != e) ** GOTO lbl43
                            switch (direction) {
                                case 0: 
                                case 3: {
                                    ** GOTO lbl51
                                }
                            }
                            continue;
lbl43:
                            // 1 sources

                            if (direction == 3) continue;
                            if (ri == e1.getContainedByRelation()) {
                                if (omitSpan) {
                                    continue;
                                }
                            } else {
                                switch (direction) {
                                    case 4: 
                                    case 6: {
                                        continue block21;
                                    }
                                }
                            }
lbl51:
                            // 3 sources

                            rc = ri.getRelationClass();
                            row = array[rc.getOrderedId()];
                            ec1 = e1.getEntityClass();
                            v0 = ec1.getOrderedId();
                            row[v0] = row[v0] + 1;
                        }
lbl57:
                        // 2 sources

                        if (direction != 0 && direction != 6) break;
                    }
                    case 2: 
                    case 5: {
                        v = e.getDstRelList();
                        if (v == null) break;
                        i = v.size();
                        block22: while (--i >= 0) {
                            ri = (RelationInstance)v.elementAt(i);
                            e1 = ri.getSrc();
                            if (e1 == e) continue;
                            if (ri == e.getContainedByRelation()) {
                                if (omitSpan) {
                                    continue;
                                }
                            } else {
                                switch (direction) {
                                    case 5: 
                                    case 6: {
                                        continue block22;
                                    }
                                }
                            }
                            rc = ri.getRelationClass();
                            row = array[rc.getOrderedId()];
                            ec1 = e1.getEntityClass();
                            v1 = ec1.getOrderedId();
                            row[v1] = row[v1] + 1;
                        }
                        break;
                    }
                }
            }
            e = entityCache.getNext();
        }
    }

    @Override
    public int getPrimaryAttributeCount() {
        return 10;
    }

    @Override
    public String getLsAttributeNameAt(int index) {
        String name = index < 10 ? attributeName[index] : super.getLsAttributeNameAt(index);
        return name;
    }

    @Override
    public int getLsAttributeTypeAt(int index) {
        int ret = index < 10 ? attributeType[index] : super.getLsAttributeTypeAt(index);
        return ret;
    }

    @Override
    public Object getLsAttributeValueAt(int index) {
        Object value;
        switch (index) {
            case 0: {
                value = this.getId();
                break;
            }
            case 1: {
                value = this.getLabel();
                break;
            }
            case 2: {
                value = this.getDescription();
                break;
            }
            case 3: {
                value = new Integer(this.getStyle());
                break;
            }
            case 4: {
                value = new Double(this.getAngle());
                break;
            }
            case 5: {
                value = new Integer(this.getImage());
                break;
            }
            case 6: {
                value = this.getObjectColor();
                break;
            }
            case 7: {
                value = this.getLabelColor();
                break;
            }
            case 8: {
                value = this.getColorWhenOpen();
                break;
            }
            case 9: {
                value = this.getUnscaledIconFile();
                break;
            }
            default: {
                value = super.getLsAttributeValueAt(index);
            }
        }
        return value;
    }
}

