/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import lsedit.EntityInstance;

public class EntityCache {
    private Entry[] m_table = null;
    private int m_last_index = 0;
    private int m_next = 0;
    private Entry m_current = null;
    private int m_count = 0;

    public int size() {
        return this.m_count;
    }

    public void clear() {
        this.m_table = null;
        this.m_count = 0;
        this.m_last_index = 0;
        this.m_next = 0;
        this.m_current = null;
    }

    public EntityCache() {
        this.clear();
    }

    public void put(EntityInstance e) {
        int index;
        Entry[] table = this.m_table;
        if (table == null) {
            this.m_table = table = new Entry[262144];
        }
        this.m_last_index = index = e.getId().hashCode() & 0x3FFFF;
        Entry entry = table[index];
        while (entry != null) {
            EntityInstance e1 = entry.m_value;
            if (e1.getId().equals(e.getId()) && e == e1) {
                return;
            }
            entry = entry.m_next;
        }
        table[index] = new Entry(e, table[index]);
        ++this.m_count;
    }

    public void remove(EntityInstance e) {
        Entry[] table = this.m_table;
        if (table != null) {
            int index = e.getId().hashCode() & 0x3FFFF;
            Entry entry = table[index];
            Entry prev = null;
            while (entry != null) {
                if (e == entry.m_value) {
                    if (prev != null) {
                        prev.m_next = entry.m_next;
                    } else {
                        table[index] = entry.m_next;
                    }
                    entry.m_value = null;
                    --this.m_count;
                    return;
                }
                prev = entry;
                entry = entry.m_next;
            }
        }
        System.out.println("EntityCache: can't remove " + e);
    }

    public EntityInstance get(String id) {
        Entry[] table = this.m_table;
        if (table != null) {
            Entry entry = table[id.hashCode() & 0x3FFFF];
            while (entry != null) {
                EntityInstance e = entry.m_value;
                if (id.equals(e.getId())) {
                    return e;
                }
                entry = entry.m_next;
            }
        }
        return null;
    }

    public EntityInstance someEntity() {
        if (this.m_count != 0) {
            Entry[] table = this.m_table;
            Entry entry2 = table[this.m_last_index];
            if (entry2 != null) {
                return entry2.m_value;
            }
            for (Entry entry2 : table) {
                if (entry2 == null) continue;
                return entry2.m_value;
            }
        }
        return null;
    }

    protected EntityInstance getFirst(int start) {
        int lth = this.m_table == null ? 0 : this.m_table.length;
        for (int next = start; next < lth; ++next) {
            Entry current = this.m_table[next];
            if (current == null) continue;
            this.m_current = current.m_next;
            this.m_next = ++next;
            return current.m_value;
        }
        return null;
    }

    public EntityInstance getNext() {
        if (this.m_current != null) {
            EntityInstance e = this.m_current.m_value;
            this.m_current = this.m_current.m_next;
            return e;
        }
        return this.getFirst(this.m_next);
    }

    public EntityInstance getFirst() {
        return this.getFirst(0);
    }

    public void show() {
        Entry[] table = this.m_table;
        if (table == null) {
            System.out.println("Null Entity Cache");
        }
        if (this.m_count == 0) {
            System.out.println("Empty Entity Cache");
        }
        int length = table.length;
        for (int index = 0; index < length; ++index) {
            Entry entry = table[index];
            if (entry == null) continue;
            System.out.print(index + ": ");
            while (entry != null) {
                System.out.print(" " + entry.m_value);
                entry = entry.m_next;
            }
            System.out.println("");
        }
    }

    static class Entry {
        public EntityInstance m_value;
        public Entry m_next;

        protected Entry(EntityInstance e, Entry next) {
            this.m_value = e;
            this.m_next = next;
        }
    }
}

