/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.table.AbstractTableModel;
import lsedit.Diagram;
import lsedit.EntityClass;
import lsedit.EntityInstance;
import lsedit.LandscapeEditorCore;
import lsedit.RelationClass;
import lsedit.SelectedElisions;

class ElisionTableModel
extends AbstractTableModel {
    Diagram m_diagram;
    Vector m_entityClasses;
    Vector m_relationClasses;
    SelectedElisions[][] m_array;
    int m_rows;
    int m_columns;

    public ElisionTableModel(Diagram diagram, Object object) {
        int columns;
        Vector<Object> relationClasses;
        int rows;
        EntityClass ec;
        Vector<EntityClass> entityClasses;
        LandscapeEditorCore ls = diagram.getLs();
        JFrame frame = ls.getFrame();
        EntityInstance e = null;
        this.m_diagram = diagram;
        this.m_entityClasses = entityClasses = new Vector<EntityClass>();
        int i = 0;
        if (object instanceof EntityInstance) {
            e = (EntityInstance)object;
            ec = ((EntityInstance)object).getEntityClass();
            ec.setOrderedId(0);
            entityClasses.addElement(ec);
            rows = 1;
        } else if (object instanceof EntityClass) {
            ec = (EntityClass)object;
            ec.setOrderedId(0);
            entityClasses.addElement(ec);
            rows = 1;
        } else {
            Enumeration en = diagram.enumEntityClassesInOrder();
            while (en.hasMoreElements()) {
                ec = (EntityClass)en.nextElement();
                ec.setOrderedId(i);
                entityClasses.addElement(ec);
                ++i;
            }
            rows = entityClasses.size() + 1;
        }
        if (object instanceof RelationClass) {
            relationClasses = new Vector<Object>(1);
            relationClasses.addElement(object);
            columns = 2;
        } else {
            relationClasses = diagram.getRelationClasses();
            columns = relationClasses.size() + 2;
        }
        this.m_relationClasses = relationClasses;
        this.m_rows = rows;
        this.m_columns = columns--;
        SelectedElisions[][] array = new SelectedElisions[rows][];
        this.m_array = array;
        SelectedElisions[] row = null;
        int entityClassesSize = entityClasses.size();
        int relationClassesSize = relationClasses.size();
        for (i = 0; i < rows; ++i) {
            int all_col = i < entityClassesSize ? 0 : 512;
            row = new SelectedElisions[columns];
            array[i] = row;
            for (int j = 0; j < columns; ++j) {
                RelationClass rc;
                int all_row;
                if (j < relationClassesSize) {
                    all_row = 0;
                    rc = (RelationClass)this.m_relationClasses.elementAt(j);
                } else {
                    all_row = 256;
                    rc = null;
                }
                int elisions = e != null && all_row == 0 && all_col == 0 ? e.getElisions(rc) : all_row | all_col;
                row[j] = new SelectedElisions(elisions);
            }
        }
    }

    public Vector getEntityClasses() {
        return this.m_entityClasses;
    }

    public int getEntityClassesCount() {
        return this.m_entityClasses.size();
    }

    public Vector getRelationClasses() {
        return this.m_relationClasses;
    }

    public int getRelationClassesCount() {
        return this.m_relationClasses.size();
    }

    @Override
    public int getRowCount() {
        return this.m_rows;
    }

    @Override
    public int getColumnCount() {
        return this.m_columns;
    }

    public Class getColumnClass(int column) {
        return this.getValueAt(0, column).getClass();
    }

    @Override
    public String getColumnName(int col) {
        if (col == 0) {
            return "";
        }
        if (col > this.m_relationClasses.size()) {
            return "*ALL*";
        }
        Object object = this.m_relationClasses.elementAt(col - 1);
        return ((RelationClass)object).getLabel();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col != 0;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (col == 0) {
            Vector entityClasses = this.m_entityClasses;
            if (row < entityClasses.size()) {
                return entityClasses.elementAt(row);
            }
            return "*ALL*";
        }
        return this.m_array[row][col - 1];
    }

    public void updateElisions(int row, int column, int elisions, int mode) {
        SelectedElisions selected = this.m_array[row][column];
        selected.updateElisions(elisions, mode);
        this.fireTableCellUpdated(row, column);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        int elisions = ((SelectedElisions)value).getElisions();
        int scope = 0;
        if ((elisions & 0x200) != 0) {
            scope |= 1;
        }
        if ((elisions & 0x100) != 0) {
            scope |= 2;
        }
        if (scope != 0) {
            int entitiesSize = this.m_entityClasses.size();
            int relationsSize = this.m_relationClasses.size();
            int mode = elisions & 0x7000;
            elisions &= 0xFFFF8FFF;
            switch (scope) {
                case 1: {
                    --col;
                    for (int i = 0; i < entitiesSize; ++i) {
                        this.updateElisions(i, col, elisions, mode);
                    }
                    break;
                }
                case 2: {
                    for (int j = 0; j < relationsSize; ++j) {
                        this.updateElisions(row, j, elisions, mode);
                    }
                    break;
                }
                case 3: {
                    for (int i = 0; i < entitiesSize; ++i) {
                        for (int j = 0; j < relationsSize; ++j) {
                            this.updateElisions(i, j, elisions, mode);
                        }
                    }
                    break;
                }
            }
        }
    }

    public SelectedElisions[][] getArray() {
        return this.m_array;
    }
}

