/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.util.Enumeration;
import java.util.Vector;
import lsedit.Clipboard;
import lsedit.ClipboardEnumerator;
import lsedit.ClipboardListener;
import lsedit.Diagram;
import lsedit.EntityClass;
import lsedit.EntityClassPair;
import lsedit.EntityComponent;
import lsedit.EntityInstance;
import lsedit.LandscapeClassObject;
import lsedit.LandscapeObject;
import lsedit.LandscapeObject3D;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.Ta;
import lsedit.TaFeedback;
import lsedit.TaListener;

public class EditableTa
extends Ta {
    private Vector m_taListeners = new Vector();
    private int[] m_taListenersOffsets;
    private int m_numberTaListeners = 0;
    private int m_numberActiveTaListeners = 0;
    private ClipboardListener m_clipboardListener;
    private Clipboard m_clipboard = null;
    private Diagram m_diagram;
    private boolean m_counts_bad = false;
    private static final String[] g_taSignals = new String[]{"EC_NEW_SIGNAL", "EC_DELETE_SIGNAL", "EC_UNDELETE_SIGNAL", "RC_NEW_SIGNAL", "RC_DELETE_SIGNAL", "RC_UNDELETE_SIGNAL", "RC_IOFACTOR_SIGNAL", "CONTAINS_CHANGING_SIGNAL", "CONTAINS_CHANGED_SIGNAL", "DRAWROOT_CUTTING_SIGNAL", "ENTITY_NEW_SIGNAL", "ENTITY_CUTTING_SIGNAL", "ENTITY_CUT_SIGNAL", "ENTITY_PASTED_SIGNAL", "CONTAINER_CUTTING_SIGNAL", "CONTAINER_CUT_SIGNAL", "CONTAINER_PASTED_SIGNAL", "ENTITY_RELOCATING_SIGNAL", "ENTITY_RELOCATED_SIGNAL", "RELATION_NEW_SIGNAL", "RELATION_SRC_CUT_SIGNAL", "RELATION_SRC_PASTED_SIGNAL", "RELATION_DST_CUT_SIGNAL", "RELATION_DST_PASTED_SIGNAL", "RELATION_CUT_SIGNAL", "RELATION_PASTED_SIGNAL", "POSITION_SIGNAL", "SIZE_SIGNAL", "BOUNDS_SIGNAL", "PARENTCLASS_SIGNAL", "STYLE_SIGNAL", "LABEL_SIGNAL", "DESCRIPTION_SIGNAL", "COLOR_SIGNAL", "LABEL_COLOR_SIGNAL", "OPEN_COLOR_SIGNAL", "FONT_DELTA_SIGNAL", "INHERITS_SIGNAL", "IO_FACTOR_SIGNAL", "ARROW_COLOR_SIGNAL", "NEW_VIEW_SIGNAL", "EC_IMAGE_SIGNAL", "EC_ANGLE_SIGNAL", "EC_ICON_SIGNAL"};

    public EditableTa(TaFeedback taFeedback) {
        super(taFeedback);
        int[] offsets = new int[7];
        this.m_taListenersOffsets = offsets;
        for (int i = 6; i >= 0; --i) {
            offsets[i] = 0;
        }
    }

    public static String taSignal(int signal) {
        if (signal < 0 || signal >= g_taSignals.length) {
            return "Unknown TA signal";
        }
        return g_taSignals[signal];
    }

    public void addTaListener(TaListener listener, int category) {
        Vector listeners = this.m_taListeners;
        int[] offsets = this.m_taListenersOffsets;
        if (category < 0 || category >= 6) {
            System.out.println("EditableTa.addTaListener invalid category=" + category);
            return;
        }
        listeners.insertElementAt(listener, offsets[category + 1]);
        int i = category;
        while (++i <= 6) {
            int n = i;
            offsets[n] = offsets[n] + 1;
        }
        this.m_numberActiveTaListeners = ++this.m_numberTaListeners;
    }

    public void disableTaListeners() {
        this.m_numberActiveTaListeners = -1;
    }

    public void enableTaListeners() {
        this.m_numberActiveTaListeners = this.m_numberTaListeners;
    }

    protected void signalDiagramChanging(Diagram diagram) {
        Vector listeners = this.m_taListeners;
        int i = this.m_numberActiveTaListeners;
        while (--i >= 0) {
            ((TaListener)listeners.elementAt(i)).diagramChanging(diagram);
        }
    }

    protected void signalDiagramChanged(Diagram diagram, int signal) {
        Vector listeners = this.m_taListeners;
        int i = this.m_numberActiveTaListeners;
        while (--i >= 0) {
            ((TaListener)listeners.elementAt(i)).diagramChanged(diagram, signal);
        }
    }

    protected void beginUpdates() {
        Vector listeners = this.m_taListeners;
        int i = this.m_numberActiveTaListeners;
        while (--i >= 0) {
            ((TaListener)listeners.elementAt(i)).updateBegins();
        }
    }

    protected void endUpdates() {
        Vector listeners = this.m_taListeners;
        int i = this.m_numberActiveTaListeners;
        while (--i >= 0) {
            ((TaListener)listeners.elementAt(i)).updateEnds();
        }
    }

    public void signalEntityClassChanged(EntityClass ec, int signal) {
        Vector listeners = this.m_taListeners;
        int last = this.m_taListenersOffsets[1];
        int i = this.m_numberActiveTaListeners;
        while (--i >= last) {
            ((TaListener)listeners.elementAt(i)).entityClassChanged(ec, signal);
        }
    }

    public void signalRelationClassChanged(RelationClass rc, int signal) {
        Vector listeners = this.m_taListeners;
        int last = this.m_taListenersOffsets[1];
        int i = this.m_numberActiveTaListeners;
        while (--i >= last) {
            ((TaListener)listeners.elementAt(i)).relationClassChanged(rc, signal);
        }
    }

    protected void signalEntityParentChanged(EntityInstance e, EntityInstance parent, int signal) {
        Vector listeners = this.m_taListeners;
        int last = this.m_taListenersOffsets[2];
        int i = this.m_numberActiveTaListeners;
        while (--i >= last) {
            ((TaListener)listeners.elementAt(i)).entityParentChanged(e, parent, signal);
        }
    }

    protected void signalRelationParentChanged(RelationInstance ri, int signal) {
        Vector listeners = this.m_taListeners;
        int last = this.m_taListenersOffsets[3];
        int i = this.m_numberActiveTaListeners;
        while (--i >= last) {
            ((TaListener)listeners.elementAt(i)).relationParentChanged(ri, signal);
        }
    }

    protected void signalEntityChanged(EntityInstance e, int signal) {
        Vector listeners = this.m_taListeners;
        int last = this.m_taListenersOffsets[4];
        int i = this.m_numberActiveTaListeners;
        while (--i >= last) {
            ((TaListener)listeners.elementAt(i)).entityInstanceChanged(e, signal);
        }
    }

    protected void signalRelationChanged(RelationInstance ri, int signal) {
        Vector listeners = this.m_taListeners;
        int last = this.m_taListenersOffsets[5];
        int i = this.m_numberActiveTaListeners;
        while (--i >= last) {
            ((TaListener)listeners.elementAt(i)).relationInstanceChanged(ri, signal);
        }
    }

    protected void signalObjectChanged(LandscapeObject object, int signal) {
        if (object instanceof EntityInstance) {
            this.signalEntityChanged((EntityInstance)object, signal);
            return;
        }
        if (object instanceof RelationInstance) {
            this.signalRelationChanged((RelationInstance)object, signal);
            return;
        }
        if (object instanceof EntityClass) {
            this.signalEntityClassChanged((EntityClass)object, signal);
            return;
        }
        if (object instanceof RelationClass) {
            this.signalRelationClassChanged((RelationClass)object, signal);
        }
    }

    public void setDiagram(Diagram diagram) {
        this.m_diagram = diagram;
    }

    public void setInitialLocation(EntityInstance e, EntityInstance container) {
        EntityComponent component = container.getEntityComponent();
        e.setInitialLocation(container);
        this.signalEntityChanged(e, 28);
    }

    public void recomputeCounts() {
        if (this.m_counts_bad) {
            Enumeration en = this.enumEntityClasses();
            while (en.hasMoreElements()) {
                EntityClass ec = (EntityClass)en.nextElement();
                ec.noMembers();
            }
            en = this.enumRelationClasses();
            while (en.hasMoreElements()) {
                RelationClass rc = (RelationClass)en.nextElement();
                rc.noMembers();
            }
            if (this.m_rootInstance != null) {
                this.m_rootInstance.recomputeCounts();
            }
            this.m_counts_bad = false;
        }
    }

    public boolean isCountsBad() {
        return this.m_counts_bad;
    }

    public void setParentClass(LandscapeObject object, LandscapeClassObject value) {
        object.setParentClass(value);
        this.signalObjectChanged(object, 29);
    }

    public void setStyle(LandscapeObject object, int value) {
        object.setStyle(value);
        this.signalObjectChanged(object, 30);
    }

    public void setObjectColor(LandscapeObject object, Color value) {
        object.setObjectColor(value);
        this.signalObjectChanged(object, 33);
    }

    public void setAttributeName(LandscapeObject object, String oldName, String newName) {
        object.setAttributeName(oldName, newName);
    }

    public void addAttribute(LandscapeObject object, String id, String value) {
        object.addAttribute(id, value);
    }

    protected RelationInstance getNewRelation(RelationClass rc, EntityInstance from, EntityInstance to) {
        RelationInstance ri = this.addEdge(rc, from, to);
        this.signalRelationParentChanged(ri, 19);
        return ri;
    }

    private void cutRelationSrc(RelationInstance ri) {
        EntityInstance src = ri.getSrc();
        if (src.removeSrcRelation(ri)) {
            this.signalRelationParentChanged(ri, 20);
        }
    }

    private void cutRelationDst(RelationInstance ri) {
        EntityInstance dst = ri.getDst();
        if (dst.removeDstRelation(ri)) {
            this.signalRelationParentChanged(ri, 22);
        }
    }

    private void pasteRelationSrc(RelationInstance ri, EntityInstance src) {
        ri.setSrc(src);
        src.addSrcRelation(ri);
        this.signalRelationParentChanged(ri, 21);
    }

    private void pasteRelationDst(RelationInstance ri, EntityInstance dst) {
        ri.setDst(dst);
        dst.addDstRelation(ri);
        this.signalRelationParentChanged(ri, 23);
    }

    public void moveRelationSrc(RelationInstance ri, EntityInstance src) {
        this.cutRelationSrc(ri);
        this.pasteRelationSrc(ri, src);
    }

    public void moveRelationDst(RelationInstance ri, EntityInstance dst) {
        this.cutRelationDst(ri);
        this.pasteRelationDst(ri, dst);
    }

    public void cutRelation(RelationInstance ri) {
        ri.decrementClassMembers();
        this.cutRelationSrc(ri);
        this.cutRelationDst(ri);
        this.signalRelationParentChanged(ri, 24);
    }

    public void pasteRelation(RelationInstance ri) {
        ri.incrementClassMembers();
        this.pasteRelationSrc(ri, ri.getSrc());
        this.pasteRelationDst(ri, ri.getDst());
        this.signalRelationParentChanged(ri, 25);
    }

    protected void setLabel(LandscapeObject3D object, String value) {
        object.setLabel(value);
        this.signalObjectChanged(object, 31);
    }

    protected void setReversedLabel(RelationClass object, String value) {
        object.setReversedLabel(value);
        this.signalObjectChanged(object, 31);
    }

    protected void setDescription(LandscapeObject3D object, String value) {
        object.setDescription(value);
        this.signalObjectChanged(object, 32);
    }

    public boolean setLabelColor(LandscapeObject3D object, Color value) {
        boolean ret = object.setLabelColor(value);
        this.signalObjectChanged(object, 34);
        return ret;
    }

    public void setColorWhenOpen(LandscapeObject3D object, Color value) {
        object.setColorWhenOpen(value);
        this.signalObjectChanged(object, 35);
    }

    public EntityInstance getNewEntity(EntityClass ec, EntityInstance container) {
        String ename;
        int n = 0;
        while (this.entityExists(ename = "Entity#" + n)) {
            ++n;
        }
        if (ec == null && (ec = this.m_defaultEntityClass) == null) {
            ec = this.m_entityBaseClass;
        }
        EntityInstance e = this.newCachedEntity(ec, ename);
        RelationInstance ri = this.addEdge(this.getPrimaryContainsClass(), container, e);
        e.setContainedByRelation(ri);
        this.prepostorder();
        this.signalEntityParentChanged(e, container, 10);
        return e;
    }

    public void setFontDelta(EntityInstance e, int value) {
        e.setFontDelta(value);
        this.signalEntityChanged(e, 36);
    }

    public void setXRelLocal(EntityInstance e, double value) {
        e.setXRelLocal(value);
        this.signalEntityChanged(e, 26);
    }

    public void setYRelLocal(EntityInstance e, double value) {
        e.setYRelLocal(value);
        this.signalEntityChanged(e, 26);
    }

    public void setWidthRelLocal(EntityInstance e, double value) {
        e.setWidthRelLocal(value);
        this.signalEntityChanged(e, 27);
    }

    public void setHeightRelLocal(EntityInstance e, double value) {
        e.setHeightRelLocal(value);
        this.signalEntityChanged(e, 27);
    }

    public void setSizeRelLocal(EntityInstance e, double widthRelLocal, double heightRelLocal) {
        e.setWidthRelLocal(widthRelLocal);
        e.setHeightRelLocal(heightRelLocal);
        this.signalEntityChanged(e, 27);
    }

    public void setLocationRelLocal(EntityInstance e, double xRelLocal, double yRelLocal) {
        e.setXRelLocal(xRelLocal);
        e.setYRelLocal(yRelLocal);
        this.signalEntityChanged(e, 26);
    }

    public void setRelLocal(EntityInstance e, double newX, double newY, double newWidth, double newHeight) {
        boolean positionChanged = e.xRelLocal() != newX || e.yRelLocal() != newY;
        boolean areaChanged = e.widthRelLocal() != newWidth || e.heightRelLocal() != newHeight;
        e.setRelLocal(newX, newY, newWidth, newHeight);
        if (positionChanged && areaChanged) {
            this.signalEntityChanged(e, 28);
        } else {
            if (positionChanged) {
                this.signalEntityChanged(e, 26);
            }
            if (areaChanged) {
                this.signalEntityChanged(e, 27);
            }
        }
    }

    public void removeEntitiesFromCache() {
        int size;
        EntityInstance rootInstance = this.m_rootInstance;
        if (rootInstance != null) {
            rootInstance.removeTreeFromCache(this.m_entityCache);
        }
        if ((size = this.m_entityCache.size()) != 0) {
            System.out.println("Diagram.removeEntitiesFromCache failed count=" + size);
            this.m_entityCache.show();
        }
    }

    public void addEntitiesToCache() {
        if (this.m_rootInstance != null) {
            this.m_rootInstance.addTreeToCache(this.m_entityCache);
        }
    }

    public void markDeleted(EntityInstance me) {
        this.m_counts_bad = true;
        this.removeCache(me);
        me.markDeleted();
    }

    public void clearDeleted(EntityInstance me) {
        this.m_counts_bad = true;
        me.clearDeleted();
        this.putCache(me);
    }

    public void disconnectEdges(EntityInstance me, EntityInstance top) {
        EntityInstance other;
        RelationInstance ri;
        Enumeration en = me.srcRelationElements();
        this.markDeleted(me);
        if (en != null) {
            while (en.hasMoreElements()) {
                ri = (RelationInstance)en.nextElement();
                other = ri.getDst();
                if (top.hasDescendantOrSelf(other)) continue;
                other.removeDstRelation(ri);
            }
        }
        if ((en = me.dstRelationElements()) != null) {
            while (en.hasMoreElements()) {
                ri = (RelationInstance)en.nextElement();
                other = ri.getSrc();
                if (top.hasDescendantOrSelf(other)) continue;
                other.removeSrcRelation(ri);
            }
        }
        en = me.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en.nextElement();
            this.disconnectEdges(e, top);
        }
    }

    public void reconnectEdges(EntityInstance me) {
        EntityInstance other;
        RelationInstance ri;
        Enumeration en = me.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en.nextElement();
            this.reconnectEdges(e);
        }
        this.clearDeleted(me);
        en = me.srcRelationElements();
        if (en != null) {
            while (en.hasMoreElements()) {
                ri = (RelationInstance)en.nextElement();
                other = ri.getDst();
                other.addDstRelationIfAbsent(ri);
            }
        }
        if ((en = me.dstRelationElements()) != null) {
            while (en.hasMoreElements()) {
                ri = (RelationInstance)en.nextElement();
                other = ri.getSrc();
                other.addSrcRelationIfAbsent(ri);
            }
        }
    }

    private void disconnectEdgesJustMe(EntityInstance me, EntityInstance parent) {
        EntityInstance other;
        RelationInstance ri;
        int i;
        RelationClass containsClass = this.getPrimaryContainsClass();
        Vector dstRelList = me.getDstRelList();
        Vector srcRelList = me.getSrcRelList();
        if (dstRelList != null) {
            i = dstRelList.size();
            while (--i >= 0) {
                ri = (RelationInstance)dstRelList.elementAt(i);
                other = ri.getSrc();
                if (other == me) continue;
                other.removeSrcRelation(ri);
            }
        }
        if (srcRelList != null) {
            i = srcRelList.size();
            while (--i >= 0) {
                ri = (RelationInstance)srcRelList.elementAt(i);
                if (ri.isMarked(0x100000)) {
                    other = ri.getDst();
                    this.signalEntityParentChanged(other, me, 17);
                    me.removeContainment(other);
                    ri.setSrc(parent);
                    parent.addSrcRelation(ri);
                    parent.addContainment(other);
                    this.prepostorder();
                    this.signalEntityParentChanged(other, parent, 18);
                    ri = this.newRelation(containsClass, me, other);
                    other.setContainedByRelation(ri);
                    srcRelList.setElementAt(ri, i);
                    continue;
                }
                other = ri.getDst();
                if (other == me) continue;
                other.removeDstRelation(ri);
            }
        }
    }

    private EntityInstance reconnectEdgesJustMe(EntityInstance me) {
        EntityInstance parent;
        EntityInstance other;
        RelationInstance ri;
        int i;
        Vector srcRelList = me.getSrcRelList();
        Vector dstRelList = me.getDstRelList();
        if (srcRelList != null) {
            i = srcRelList.size();
            while (--i >= 0) {
                ri = (RelationInstance)srcRelList.elementAt(i);
                other = ri.getDst();
                if (other == me) continue;
                if (ri.isMarked(0x100000)) {
                    ri = other.getContainedByRelation();
                    parent = ri.getSrc();
                    this.signalEntityParentChanged(other, parent, 11);
                    parent.removeContainment(other);
                    parent.removeSrcRelation(ri);
                    ri.setSrc(me);
                    srcRelList.setElementAt(ri, i);
                    me.addContainment(other);
                    this.prepostorder();
                    this.signalEntityParentChanged(other, parent, 12);
                    continue;
                }
                other.addDstRelation(ri);
            }
        }
        parent = null;
        if (dstRelList != null) {
            i = dstRelList.size();
            while (--i >= 0) {
                ri = (RelationInstance)dstRelList.elementAt(i);
                other = ri.getSrc();
                if (other == me) continue;
                other.addSrcRelation(ri);
                if (!ri.isMarked(0x100000)) continue;
                parent = other;
            }
        }
        return parent;
    }

    protected void liftRelations(EntityInstance e, EntityInstance parent) {
        RelationClass rc;
        RelationInstance ri;
        int i;
        Vector srcRelList = e.getSrcRelList();
        Vector dstRelList = e.getDstRelList();
        if (parent == this.m_rootInstance) {
            parent = null;
        }
        if (dstRelList != null) {
            i = dstRelList.size();
            while (--i >= 0) {
                ri = (RelationInstance)dstRelList.elementAt(i);
                rc = ri.getRelationClass();
                if (!rc.isActive() || ri.isMarked(0x100000)) continue;
                if (parent == null || ri.getSrc() == parent) {
                    this.cutRelation(ri);
                    continue;
                }
                this.moveRelationDst(ri, parent);
            }
        }
        if (srcRelList != null) {
            i = srcRelList.size();
            while (--i >= 0) {
                ri = (RelationInstance)srcRelList.elementAt(i);
                rc = ri.getRelationClass();
                if (!rc.isActive() || ri.isMarked(0x100000)) continue;
                if (parent == null || ri.getDst() == parent) {
                    this.cutRelation(ri);
                    continue;
                }
                this.moveRelationSrc(ri, parent);
            }
        }
    }

    public boolean cutEntity(EntityInstance e) {
        if (e == this.m_rootInstance) {
            this.error("Can't cut the root node in the diagram");
            return false;
        }
        EntityInstance parent = e.getContainedBy();
        if (this.m_drawRoot != null && e.hasDescendantOrSelf(this.m_drawRoot)) {
            this.signalEntityParentChanged(e, parent, 9);
        }
        this.signalEntityParentChanged(e, parent, 11);
        this.disconnectEdges(e, e);
        parent.removeContainment(e);
        this.signalEntityParentChanged(e, parent, 12);
        return true;
    }

    public void pasteEntity(EntityInstance parent, EntityInstance e) {
        if (parent == null) {
            Object ri = null;
            parent = e.getContainedBy();
        } else {
            RelationInstance ri = e.getContainedByRelation();
            ri.setSrc(parent);
        }
        this.reconnectEdges(e);
        this.prepostorder();
        if (parent != null) {
            parent.addContainment(e);
        }
        this.signalEntityParentChanged(e, parent, 13);
    }

    public boolean moveEntityContainment(EntityInstance parent, EntityInstance e) {
        RelationInstance ri = e.getContainedByRelation();
        EntityInstance oldParent = ri.getSrc();
        if (oldParent == parent) {
            return false;
        }
        this.signalEntityParentChanged(e, oldParent, 17);
        oldParent.removeContainment(e);
        oldParent.removeSrcRelation(ri);
        ri.setSrc(parent);
        parent.addSrcRelation(ri);
        parent.addContainment(e);
        this.prepostorder();
        this.signalEntityParentChanged(e, parent, 18);
        return true;
    }

    public EntityInstance clusterEntity(EntityInstance container, EntityInstance e) {
        String ename;
        EntityClass ec = e.getEntityClass();
        if (ec != null) {
            ec = this.getEntityClass(ec.getId());
        }
        if (ec == null && (ec = this.m_defaultEntityClass) == null) {
            ec = this.m_entityBaseClass;
        }
        if (this.entityExists(ename = e.getId())) {
            int n = 0;
            while (this.entityExists(ename = "Entity#" + n)) {
                ++n;
            }
        }
        EntityInstance ret = this.newCachedEntity(ec, ename);
        RelationInstance ri = this.addEdge(this.getPrimaryContainsClass(), container, ret);
        ret.setContainedByRelation(ri);
        if (e.xRelLocal() >= 0.0 && e.yRelLocal() >= 0.0 && e.widthRelLocal() > 0.0 && e.heightRelLocal() > 0.0) {
            ret.setRelLocal(e);
        }
        this.signalEntityParentChanged(ret, container, 10);
        return ret;
    }

    public EntityInstance importEntity(EntityInstance container, EntityInstance e, EntityInstance match) {
        EntityClass ec = e.getEntityClass();
        if (ec != null) {
            ec = this.getEntityClass(ec.getId());
        }
        if (ec != null) {
            match.setParentClass(ec);
        }
        this.moveEntityContainment(container, match);
        if (e.xRelLocal() >= 0.0 && e.yRelLocal() >= 0.0 && e.widthRelLocal() > 0.0 && e.heightRelLocal() > 0.0) {
            match.setRelLocal(e);
        }
        return match;
    }

    public boolean deleteContainer(EntityInstance e) {
        if (e == this.m_rootInstance) {
            this.error("Can't cut the root node container in the graph");
            return false;
        }
        EntityInstance parent = e.getContainedBy();
        this.signalEntityParentChanged(e, parent, 14);
        if (this.m_drawRoot != null && e.hasDescendantOrSelf(this.m_drawRoot)) {
            this.signalEntityParentChanged(e, parent, 9);
        }
        this.disconnectEdgesJustMe(e, parent);
        this.markDeleted(e);
        this.signalEntityParentChanged(e, parent, 15);
        return true;
    }

    public void undeleteContainer(EntityInstance e) {
        EntityInstance parent = this.reconnectEdgesJustMe(e);
        this.clearDeleted(e);
        this.signalEntityParentChanged(e, parent, 16);
    }

    public void setInherits(LandscapeClassObject object, Vector value) {
        object.setInherits(value);
        this.signalObjectChanged(object, 37);
    }

    public void removeEntityClass(EntityClass ec) {
        Enumeration en = this.m_relationClasses.elements();
        while (en.hasMoreElements()) {
            RelationClass rc = (RelationClass)en.nextElement();
            Vector relationList = rc.getRelationList();
            if (relationList == null) continue;
            int i = relationList.size();
            while (i > 0) {
                EntityClassPair ep = (EntityClassPair)relationList.elementAt(--i);
                if (ep.m_entityClass1 != ec && ep.m_entityClass2 != ec) continue;
                relationList.removeElementAt(i);
            }
        }
        if (this.m_defaultEntityClass == ec) {
            this.setDefaultEntityClass(this.m_entityBaseClass);
        }
        this.m_entityClasses.remove(ec.getId());
        this.signalEntityClassChanged(ec, 1);
    }

    public EntityClass newEntityClass(String id, EntityClass baseClass) {
        EntityClass ec = this.addEntityClass(id);
        ec.addParentClass(baseClass);
        this.signalEntityClassChanged(ec, 0);
        return ec;
    }

    public void unRemoveEntityClass(EntityClass ec, Vector eps, EntityClass oldDefaultEntityClass) {
        this.m_entityClasses.put(ec.getId(), ec);
        if (eps != null) {
            int i = eps.size();
            while (i > 0) {
                EntityClassPair ep = (EntityClassPair)eps.elementAt(--i);
                ep.m_rc.addRelationConstraint(ep);
            }
        }
        if (this.m_defaultEntityClass != oldDefaultEntityClass) {
            this.setDefaultEntityClass(oldDefaultEntityClass);
        }
        this.signalEntityClassChanged(ec, 2);
    }

    public void setImage(EntityClass ec, int image) {
        ec.setImage(image);
        this.signalEntityClassChanged(ec, 41);
    }

    public void setUnscaledIconFile(EntityClass ec, String file) {
        ec.setUnscaledIconFile(file);
        this.signalEntityClassChanged(ec, 43);
    }

    public void setAngle(EntityClass ec, double angle) {
        int style = ec.getInheritedStyle();
        ec.setAngle(angle);
        if (style >= 9 && style <= 22) {
            this.signalEntityClassChanged(ec, 42);
        }
    }

    public RelationClass newRelationClass(String id, RelationClass baseClass) {
        RelationClass rc = this.addRelationClass(id);
        rc.addParentClass(baseClass);
        this.signalRelationClassChanged(rc, 3);
        return rc;
    }

    public void removeRelationClass(RelationClass rc) {
        if (this.m_defaultRelationClass == rc) {
            this.setDefaultRelationClass(this.m_relationBaseClass);
        }
        this.m_relationClasses.remove(rc.getId());
        this.signalRelationClassChanged(rc, 4);
    }

    public void unRemoveRelationClass(RelationClass rc, RelationClass defaultClass) {
        this.m_relationClasses.put(rc.getId(), rc);
        if (this.m_defaultRelationClass != defaultClass) {
            this.setDefaultRelationClass(defaultClass);
        }
        this.signalRelationClassChanged(rc, 5);
    }

    public void setArrowColor(RelationClass object, Color value) {
        object.setArrowColor(value);
    }

    public void setIOfactor(RelationClass rc, short value) {
        Diagram diagram = this.getDiagram();
        rc.setIOfactor(value);
        if (diagram != null) {
            this.changeIOfactor(rc);
        }
        this.signalRelationClassChanged(rc, 6);
    }

    public void setClipboardListener(ClipboardListener clipboardListener) {
        this.m_clipboardListener = clipboardListener;
    }

    public Clipboard getClipboard() {
        return this.m_clipboard;
    }

    protected void setClipboard(Clipboard value) {
        this.m_clipboard = value;
        if (this.m_clipboardListener != null) {
            this.m_clipboardListener.clipboardChanged();
        }
    }

    public boolean cutClipboard(Clipboard clipboard) {
        boolean ok;
        boolean bl = ok = !clipboard.contains(this.m_rootInstance);
        if (!ok) {
            this.error("Can't cut the root node in the diagram");
        } else {
            int size = clipboard.size();
            for (int i = 0; i < size; ++i) {
                EntityInstance e = (EntityInstance)clipboard.elementAt(i);
                this.cutEntity(e);
            }
            this.prepostorder();
            this.setClipboard(clipboard);
        }
        return ok;
    }

    public void pasteClipboard(Clipboard clipboard, EntityInstance container) {
        ClipboardEnumerator en = clipboard.clipboardElements();
        while (en.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en.nextElement();
            this.pasteEntity(container, e);
        }
        this.setClipboard(null);
    }

    public void unPasteClipboard(Clipboard saved_clipboard) {
        int i = 0;
        ClipboardEnumerator en = saved_clipboard.clipboardElements();
        while (en.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en.nextElement();
            this.cutEntity(e);
            EntityInstance container = en.oldContainer();
            RelationInstance ri = e.getContainedByRelation();
            if (ri.getSrc() != container) {
                ri.setSrc(container);
            }
            ++i;
        }
        this.setClipboard(saved_clipboard);
        this.prepostorder();
    }
}

