/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.JTableHeader;
import lsedit.ColorCache;
import lsedit.Diagram;
import lsedit.ElisionTable;
import lsedit.ElisionTableModel;
import lsedit.EntityClass;
import lsedit.EntityInstance;
import lsedit.FontCache;
import lsedit.LandscapeEditorCore;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.SelectedElisions;

public class EditElisions
extends JDialog
implements ActionListener {
    private LandscapeEditorCore m_ls;
    private ElisionTableModel m_elisionTableModel;
    private ElisionTable m_table;
    private JButton m_ok = null;
    private JButton m_cancel = null;
    private Object m_object;

    protected EditElisions(JFrame frame, LandscapeEditorCore ls, Object object) {
        super(frame, "Edit elision rules" + (object != null ? " for " + object.toString() : ""), true);
        ElisionTable table;
        ElisionTableModel tableModel;
        this.m_ls = ls;
        this.m_object = object;
        Font font = FontCache.getDialogFont();
        Font bold = font.deriveFont(1);
        this.setLocation(20, 20);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.setForeground(ColorCache.get(0, 0, 0));
        this.setBackground(ColorCache.get(192, 192, 192));
        this.setFont(font);
        this.m_elisionTableModel = tableModel = new ElisionTableModel(ls.getDiagram(), object);
        this.m_table = table = new ElisionTable(ls.getFrame(), tableModel);
        table.setFont(font);
        JTableHeader tableHeader = table.getTableHeader();
        tableHeader.setFont(bold);
        FontMetrics fm = this.getFontMetrics(font);
        int height = fm.getHeight() + 4;
        int height1 = 48;
        if (height < height1) {
            height = height1;
        }
        table.setRowHeight(height);
        table.setAutoResizeMode(0);
        JScrollPane scrollPane = new JScrollPane(table);
        table.setVisible(true);
        scrollPane.setVisible(true);
        contentPane.add((Component)scrollPane, "Center");
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout());
        this.m_ok = new JButton("Ok");
        this.m_ok.setFont(bold);
        this.m_ok.addActionListener(this);
        buttons.add(this.m_ok);
        this.m_cancel = new JButton("Cancel");
        this.m_cancel.setFont(bold);
        this.m_cancel.addActionListener(this);
        buttons.add(this.m_cancel);
        contentPane.add("South", buttons);
        table.removeEditor();
        table.doLayout();
        Dimension d1 = table.getPreferredSize();
        Dimension d = new Dimension(d1.width, height *= tableModel.getRowCount() + 1);
        table.setPreferredSize(d);
        scrollPane.setPreferredSize(d);
        this.pack();
        this.setVisible(true);
    }

    private static void changeElisions(EntityInstance e, SelectedElisions[] selectedElisions, Vector rcs) {
        int cols = rcs.size();
        int col = rcs.size();
        while (--col >= 0) {
            SelectedElisions selectedElision = selectedElisions[col];
            RelationClass rc = (RelationClass)rcs.elementAt(col);
            int nid = rc.getNid();
            int elisions = selectedElision.getElisions();
            if ((elisions & 0x40) == 0) continue;
            int mask = 1;
            for (int i = 0; i < 6; ++i) {
                if ((elisions & mask) != 0) {
                    e.setElision(i, nid);
                } else {
                    e.clearElision(i, nid);
                }
                mask <<= 1;
            }
        }
        e.elisionsChanged();
    }

    private static void descend(EntityInstance e, SelectedElisions[] row, EntityClass ec, Vector rcs) {
        Vector srcRelList = e.getSrcRelList();
        if (e.getParentClass() == ec) {
            EditElisions.changeElisions(e, row, rcs);
        }
        if (srcRelList != null) {
            int i = srcRelList.size();
            while (--i >= 0) {
                RelationInstance ri = (RelationInstance)srcRelList.elementAt(i);
                if (!ri.isMarked(0x100000)) continue;
                EntityInstance child = ri.getDst();
                EditElisions.descend(child, row, ec, rcs);
            }
        }
    }

    private void doEditElisions() {
        ElisionTableModel tableModel = this.m_elisionTableModel;
        SelectedElisions[][] array = tableModel.getArray();
        Diagram diagram = this.m_ls.getDiagram();
        Vector rcs = tableModel.getRelationClasses();
        if (this.m_object instanceof EntityInstance) {
            EditElisions.changeElisions((EntityInstance)this.m_object, array[0], rcs);
        } else {
            Vector entityClasses = tableModel.getEntityClasses();
            EntityInstance root = diagram.getRootInstance();
            int row = entityClasses.size();
            while (--row >= 0) {
                EditElisions.descend(root, array[row], (EntityClass)entityClasses.elementAt(row), rcs);
            }
        }
        diagram.revalidate();
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object source = ev.getSource();
        if (source == this.m_ok || source == this.m_cancel) {
            if (source == this.m_ok) {
                this.doEditElisions();
            }
            this.setVisible(false);
            return;
        }
    }
}

