/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import lsedit.ColorCache;
import lsedit.Diagram;
import lsedit.EntityClass;
import lsedit.EntityClassPair;
import lsedit.FontCache;
import lsedit.LandscapeEditorCore;
import lsedit.RelationClass;

public class EditConstraints
extends JDialog
implements ActionListener {
    JFrame m_frame;
    RelationClass m_rc;
    private JButton m_ok = null;
    private JButton m_restart = null;
    private JButton m_clear = null;
    private JButton m_help = null;
    private JButton m_cancel = null;
    EntityClass[] m_ecs;
    JCheckBox[][] m_array;
    int m_size;

    protected void clearArray() {
        int size = this.m_size;
        JCheckBox[][] array = this.m_array;
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                this.m_array[i][j].setSelected(false);
            }
        }
    }

    protected void initArray() {
        int size = this.m_size;
        JCheckBox[][] array = this.m_array;
        this.clearArray();
        Vector relationList = this.m_rc.getRelationList();
        Enumeration en = relationList.elements();
        while (en.hasMoreElements()) {
            EntityClassPair ep = (EntityClassPair)en.nextElement();
            this.m_array[ep.m_entityClass1.getOrderedId()][ep.m_entityClass2.getOrderedId()].setSelected(true);
        }
    }

    protected void processArray() {
        Vector relationList = this.m_rc.getRelationList();
        int i = relationList.size();
        while (i > 0) {
            EntityClassPair ep = (EntityClassPair)relationList.elementAt(--i);
            if (this.m_array[ep.m_entityClass1.getOrderedId()][ep.m_entityClass2.getOrderedId()].isSelected()) continue;
            relationList.removeElementAt(i);
        }
        int size = this.m_size;
        for (i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                if (!this.m_array[i][j].isSelected()) continue;
                this.m_rc.addRelationConstraint(this.m_ecs[i], this.m_ecs[j]);
            }
        }
    }

    protected EditConstraints(JFrame frame, Diagram diagram, RelationClass rc) {
        super(frame, "Edit Constraints on " + rc.getLabel(), true);
        int j;
        int size;
        this.m_frame = frame;
        Font font = FontCache.getDialogFont();
        Font bold = font.deriveFont(1);
        this.m_rc = rc;
        this.m_size = size = diagram.numEntityClasses();
        this.m_ecs = new EntityClass[size];
        int i = 0;
        Enumeration en = diagram.enumEntityClassesInOrder();
        while (en.hasMoreElements()) {
            EntityClass ec = (EntityClass)en.nextElement();
            ec.setOrderedId(i);
            this.m_ecs[i] = ec;
            ++i;
        }
        this.m_array = new JCheckBox[size][];
        for (i = 0; i < size; ++i) {
            this.m_array[i] = new JCheckBox[size];
            for (j = 0; j < size; ++j) {
                JCheckBox checkBox = new JCheckBox();
                checkBox.setFont(font);
                checkBox.setToolTipText(this.m_ecs[i].getLabel() + "->" + this.m_ecs[j].getLabel());
                this.m_array[i][j] = checkBox;
            }
        }
        this.initArray();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.setForeground(ColorCache.get(0, 0, 0));
        this.setBackground(ColorCache.get(192, 192, 192));
        this.setFont(font);
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, size + 1));
        JLabel label = new JLabel("");
        panel.add(label);
        for (i = 0; i < size; ++i) {
            label = new JLabel(this.m_ecs[i].getLabel());
            label.setFont(bold);
            panel.add(label);
        }
        for (i = 0; i < size; ++i) {
            label = new JLabel(this.m_ecs[i].getLabel() + " ");
            label.setFont(bold);
            panel.add(label);
            for (j = 0; j < size; ++j) {
                panel.add(this.m_array[i][j]);
            }
        }
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.setVisible(true);
        contentPane.add((Component)scrollPane, "Center");
        panel = new JPanel();
        panel.setLayout(new FlowLayout());
        this.m_ok = new JButton("Ok");
        this.m_ok.setFont(bold);
        this.m_ok.addActionListener(this);
        panel.add(this.m_ok);
        this.m_restart = new JButton("Restart");
        this.m_restart.setFont(bold);
        this.m_restart.addActionListener(this);
        panel.add(this.m_restart);
        this.m_clear = new JButton("Clear");
        this.m_clear.setFont(bold);
        this.m_clear.addActionListener(this);
        panel.add(this.m_clear);
        this.m_help = new JButton("Help");
        this.m_help.setFont(bold);
        this.m_help.addActionListener(this);
        panel.add(this.m_help);
        this.m_cancel = new JButton("Cancel");
        this.m_cancel.setFont(bold);
        this.m_cancel.addActionListener(this);
        panel.add(this.m_cancel);
        contentPane.add((Component)panel, "South");
        this.pack();
        this.setVisible(true);
    }

    public static void create(Diagram diagram, RelationClass rc) {
        LandscapeEditorCore ls = diagram.getLs();
        EditConstraints editConstraints = new EditConstraints(ls.getFrame(), diagram, rc);
        editConstraints.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object source = ev.getSource();
        if (source == this.m_restart) {
            this.initArray();
            return;
        }
        if (source == this.m_clear) {
            this.clearArray();
            return;
        }
        if (source == this.m_help) {
            JOptionPane.showMessageDialog(this.m_frame, "This matrix shows for all combination of source entities (shown vertically)\nand destination entities (shown horizontally) those that may (according to\nthe current schema) be connected by edges of the relation class:\n\n" + this.m_rc.getLabel() + "\n\n" + "Update these constraints by checking/unchecking the desired pairings of\n" + "source and destination entities\n", "Help", 1);
            return;
        }
        if (source == this.m_ok) {
            this.processArray();
        } else if (source != this.m_cancel) {
            return;
        }
        this.setVisible(false);
    }
}

