/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import lsedit.DrawInfo;
import lsedit.EdgePoint;
import lsedit.EntityInstance;
import lsedit.LandscapeObject;
import lsedit.MoveModeHandler;
import lsedit.Option;
import lsedit.Options;
import lsedit.RelationComponent;
import lsedit.RelationInstance;
import lsedit.RelationLabel;
import lsedit.Util;

class EdgeInfo
extends DrawInfo {
    private EntityInstance m_srcEntity;
    private EdgePoint m_src;
    private EntityInstance m_dstEntity;
    private EdgePoint m_dst;

    public String toString() {
        return "EdgeInfo: " + this.m_src + "->" + this.m_dst + " style=" + this.m_style + " embellished=" + this.m_embellished;
    }

    @Override
    public void getBounds(Rectangle r) {
        int x1 = this.getSrcX();
        int y1 = this.getSrcY();
        int x2 = this.getDstX();
        int y2 = this.getDstY();
        EdgeInfo.getLineBounds(x1, y1, x2, y2, r);
        if ((this.m_embellished & 1) != 0) {
            EdgeInfo.includeTailBounds(x1, y1, r);
        }
        if ((this.m_embellished & 2) != 0) {
            EdgeInfo.includeCentreBounds(x1, y1, x2, y2, r);
        }
        if ((this.m_embellished & 4) != 0) {
            this.includeArrowBounds(x1, y1, x2, y2, r);
        }
        if ((this.m_embellished & 8) != 0) {
            RelationLabel label = this.m_component.getRelationLabel();
            label.place(x1, y1, x2, y2);
        }
    }

    @Override
    public boolean contains(int x, int y) {
        EntityInstance srcEntity = this.m_srcEntity;
        EdgePoint src = this.m_src;
        EntityInstance dstEntity = this.m_dstEntity;
        EdgePoint dst = this.m_dst;
        return EdgeInfo.nearLine(srcEntity.getEdgePointX(src), srcEntity.getEdgePointY(src), dstEntity.getEdgePointX(dst), dstEntity.getEdgePointY(dst), x, y);
    }

    @Override
    public void paintComponent(Graphics g, int shiftX, int shiftY) {
        int embellished = this.m_embellished;
        EntityInstance srcEntity = this.m_srcEntity;
        EdgePoint src = this.m_src;
        EntityInstance dstEntity = this.m_dstEntity;
        EdgePoint dst = this.m_dst;
        int direction = this.m_component.getDirection();
        int srcX = (int)(srcEntity.getEdgePointX(src) - (double)shiftX);
        int srcY = (int)(srcEntity.getEdgePointY(src) - (double)shiftY);
        int dstX = (int)(dstEntity.getEdgePointX(dst) - (double)shiftX);
        int dstY = (int)(dstEntity.getEdgePointY(dst) - (double)shiftY);
        int arrowX = dstX;
        int arrowY = dstY;
        if ((embellished & 4) != 0 && direction != 3) {
            RelationInstance ri;
            Color newColor;
            Option option = Options.getDiagramOptions();
            int weight = this.arrowWeight();
            Color oldColor = g.getColor();
            if (option.isCenterArrowhead()) {
                arrowX = (srcX + dstX) / 2;
                arrowY = (srcY + dstY) / 2;
                Util.drawSegment(g, this.m_style, arrowX, arrowY, dstX, dstY);
            }
            if (option.isVariableArrowColor() && (newColor = (ri = this.m_component.getRelationInstance()).getInheritedArrowColor()) != null) {
                g.setColor(newColor);
            }
            double fraction = Util.drawArrowHead(g, srcX, srcY, arrowX, arrowY, weight);
            g.setColor(oldColor);
            arrowX -= (int)((double)(arrowX - srcX) * fraction);
            arrowY -= (int)((double)(arrowY - srcY) * fraction);
        }
        Util.drawSegment(g, this.m_style, srcX, srcY, arrowX, arrowY);
        if ((embellished & 1) != 0) {
            g.fillOval(srcX - 3, srcY - 3, 6, 6);
        }
        if ((embellished & 2) != 0) {
            Color tc = g.getColor();
            g.setColor(CENTRE_MARK_COLOR);
            g.fillRect((srcX + dstX - 4) / 2, (srcY + dstY - 4) / 2, 4, 4);
            g.setColor(tc);
        }
    }

    public EdgeInfo(RelationComponent component) {
        this.m_component = component;
    }

    public void setEdgeInfo(EntityInstance srcEntity, EdgePoint src, EntityInstance dstEntity, EdgePoint dst) {
        this.m_srcEntity = srcEntity;
        this.m_src = src;
        this.m_dstEntity = dstEntity;
        this.m_dst = dst;
    }

    public int getSrcX() {
        return (int)this.m_srcEntity.getEdgePointX(this.m_src);
    }

    public int getSrcY() {
        return (int)this.m_srcEntity.getEdgePointY(this.m_src);
    }

    public int getDstX() {
        return (int)this.m_dstEntity.getEdgePointX(this.m_dst);
    }

    public int getDstY() {
        return (int)this.m_dstEntity.getEdgePointY(this.m_dst);
    }

    @Override
    public boolean mouseOverEdgePoint(int x, int y, MoveModeHandler handler) {
        EntityInstance entity = this.m_srcEntity;
        EdgePoint edgePoint = this.m_src;
        if (EdgeInfo.nearPoint(entity.getEdgePointX(edgePoint), entity.getEdgePointY(edgePoint), x, y)) {
            RelationInstance ri = this.m_component.getRelationInstance();
            handler.overEdgePointCallBack(entity, ri, edgePoint);
            return true;
        }
        entity = this.m_dstEntity;
        edgePoint = this.m_dst;
        if (EdgeInfo.nearPoint(entity.getEdgePointX(edgePoint), entity.getEdgePointY(edgePoint), x, y)) {
            RelationInstance ri = this.m_component.getRelationInstance();
            handler.overEdgePointCallBack(entity, ri, edgePoint);
            return true;
        }
        return false;
    }

    @Override
    public boolean isFramedBy(Rectangle frame) {
        EntityInstance srcEntity = this.m_srcEntity;
        EdgePoint src = this.m_src;
        EntityInstance dstEntity = this.m_dstEntity;
        EdgePoint dst = this.m_dst;
        return frame.intersectsLine(srcEntity.getEdgePointX(src), srcEntity.getEdgePointY(src), dstEntity.getEdgePointX(dst), dstEntity.getEdgePointY(dst));
    }

    protected int arrowWeight() {
        Option option;
        RelationInstance ri = this.m_component.getRelationInstance();
        if (LandscapeObject.g_infoShown != ri && !(option = Options.getDiagramOptions()).isPermanentlyWeight()) {
            return 1;
        }
        return ri.getFrequency();
    }

    @Override
    public void switchEdgePoint(EdgePoint oldPoint, EdgePoint newPoint) {
        if (this.m_src == oldPoint) {
            this.m_src = newPoint;
        }
        if (this.m_dst == oldPoint) {
            this.m_dst = newPoint;
        }
    }
}

