/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import lsedit.Diagram;
import lsedit.DisplayEditElisions;
import lsedit.EntityClass;
import lsedit.EntityInstance;
import lsedit.FontCache;
import lsedit.HideElisionIcons;
import lsedit.LandscapeEditorCore;
import lsedit.Option;
import lsedit.Options;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.SetContainsRelation;
import lsedit.SetEntitiesFlag;
import lsedit.SetRelationsFlag;
import lsedit.ShownEntityChkBox;
import lsedit.ShownRelnChkBox;
import lsedit.TaListener;
import lsedit.TabBox;

public class ERBox
extends TabBox
implements ChangeListener,
TaListener,
MouseListener {
    protected static final int MARGIN = 5;
    protected static final int GAP = 5;
    protected static final int INDENT = 10;
    public static final String g_editInheritanceRules_text = "Edit inheritance rules";
    public static final String g_editClassAttributes_text = "Edit Class Attributes";
    public static final String g_showValidAttributes_text = "Show valid attributes";
    public static final String g_validateAttributes_text = "Validate attributes";
    public static final String g_createEntitiesOfThisClass_text = "Create entities of this class";
    public static final String g_showUsage_text = "Show Usage";
    public static final String g_editRelationConstraints_text = "Edit relation constraints";
    public static final String g_closureOfConstraints_text = "Closure of constraints";
    public static final String g_validateRelations_text = "Validate relations";
    public static final String g_showElisionIcons_text = "Show Elision Icons";
    public static final String g_hideElisionIcons_text = "Hide Elision Icons";
    public static final String g_createEdgesOfThisClass_text = "Create relations of this class";
    public static final String g_formsHierarchy_text = "Forms Hierarchy";
    public static final String g_empty_classes = "Empty Classes";
    public static final String g_member_counts = "Member Counts";
    public static final String g_editElisionRules_text = "Edit Elision Rules";
    public static final String g_hierarchy_text = "Inheritance Hierarchy";
    protected JLabel m_ulabel;
    protected JLabel m_elabel1 = null;
    protected JLabel m_elabel2;
    protected JLabel m_rlabel;
    protected JLabel m_rlabel2;
    protected JLabel m_footer1;
    protected JLabel m_footer2;
    protected JLabel m_clabel = new JLabel("Contains Hierarchy");
    protected boolean m_refill = false;
    protected boolean m_badcnts = false;
    protected int m_width;
    protected int m_height;

    @Override
    public Dimension getPreferredSize() {
        return this.getSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getSize();
    }

    protected void add(JComponent component, int indent) {
        Dimension d = component.getPreferredSize();
        int indent1 = 5 + indent;
        int width = indent1 + d.width;
        int height = d.height;
        if (width > this.m_width) {
            this.m_width = width;
        }
        component.setBounds(indent1, this.m_height, width, height);
        super.add(component);
        this.m_height += height;
    }

    protected void add(JComponent component) {
        this.add(component, 0);
    }

    public ERBox(LandscapeEditorCore ls, JTabbedPane tabbedPane, String title, String helpStr) {
        super(ls, tabbedPane, title, helpStr);
        tabbedPane.addChangeListener(this);
        this.addMouseListener(this);
    }

    public Font getTextFont() {
        return null;
    }

    public void setComponentsTextFont(Font font) {
        if (this.m_elabel1 != null) {
            this.m_elabel1.setFont(font);
        }
        this.m_elabel2.setFont(font);
        this.m_footer1.setFont(font);
        this.m_footer2.setFont(font);
    }

    public void setComponentsTitleFont(Font font) {
        this.m_ulabel.setFont(font);
        this.m_rlabel.setFont(font);
        this.m_clabel.setFont(font);
    }

    protected boolean helpEntityFlag() {
        return true;
    }

    protected boolean getFlag(EntityClass ec) {
        return false;
    }

    protected int setFlag(EntityClass ec, boolean value, boolean applyToSubclasses) {
        return 0;
    }

    protected boolean getFlag(RelationClass rc, int direction) {
        return false;
    }

    protected int setFlag(RelationClass rc, int direction, boolean value, boolean applyToSubclasses) {
        return 0;
    }

    protected String getFlagName() {
        return null;
    }

    protected boolean can_reverse() {
        return true;
    }

    protected void customFill() {
    }

    public void fill() {
        this.removeAll();
        this.m_width = 0;
        this.m_height = 0;
        if (this.isActive()) {
            Option option = Options.getDiagramOptions();
            LandscapeEditorCore ls = this.m_ls;
            Diagram diagram = ls.getDiagram();
            Font textFont = this.getTextFont();
            FontMetrics fontMetrics = this.getFontMetrics(textFont);
            int h = fontMetrics.getHeight();
            boolean isHideEmpty = option.isHideEmpty();
            boolean isMemberCounts = option.isMemberCounts();
            boolean isInheritance = option.isShowInheritance();
            boolean usesCounts = isHideEmpty || isMemberCounts;
            int n = 0;
            int cnt = -1;
            RelationClass[] containsClasses = diagram.getContainsClasses();
            this.m_height += 10;
            this.add(this.m_ulabel);
            if (diagram != null) {
                RelationClass rc;
                EntityClass ec;
                Enumeration en;
                if (usesCounts) {
                    diagram.recomputeCounts();
                }
                n = 0;
                if (isInheritance) {
                    en = diagram.enumEntityClassHierarchy(isHideEmpty);
                    while (en.hasMoreElements()) {
                        ec = (EntityClass)en.nextElement();
                        this.m_height += 10;
                        if (isMemberCounts) {
                            cnt = ec.countMembers();
                        }
                        this.add(new ShownEntityChkBox(this, ec, ++n, cnt, h, textFont), ec.getInheritanceDepth() * 10);
                    }
                } else {
                    en = diagram.enumEntityClassesInOrder();
                    while (en.hasMoreElements()) {
                        ec = (EntityClass)en.nextElement();
                        if (usesCounts) {
                            cnt = ec.countMembers();
                            if (isHideEmpty && cnt == 0) continue;
                            if (!isMemberCounts) {
                                cnt = -1;
                            }
                        }
                        this.m_height += 10;
                        this.add(new ShownEntityChkBox(this, ec, ++n, cnt, h, textFont));
                    }
                }
                this.m_height += 10;
                if (this.m_elabel1 != null) {
                    this.add(this.m_elabel1);
                }
                this.add(this.m_elabel2);
                this.m_height += 20;
                this.add(this.m_rlabel);
                this.m_height += 5;
                n = 0;
                cnt = -1;
                if (isInheritance) {
                    en = diagram.enumRelationClassHierarchy(isHideEmpty);
                    while (en.hasMoreElements()) {
                        rc = (RelationClass)en.nextElement();
                        if (isMemberCounts) {
                            cnt = rc.countMembers();
                        }
                        this.add(new ShownRelnChkBox(this, rc, 1, ++n, cnt, textFont), rc.getInheritanceDepth() * 10);
                    }
                } else {
                    en = diagram.enumRelationClassesInOrder();
                    while (en.hasMoreElements()) {
                        rc = (RelationClass)en.nextElement();
                        if (usesCounts) {
                            cnt = rc.countMembers();
                            if (isHideEmpty && cnt == 0) continue;
                            if (!isMemberCounts) {
                                cnt = -1;
                            }
                        }
                        this.add(new ShownRelnChkBox(this, rc, 1, ++n, cnt, textFont));
                    }
                }
                if (this.can_reverse()) {
                    this.add(this.m_rlabel2);
                    this.m_height += 5;
                    n = 0;
                    cnt = -1;
                    if (isInheritance) {
                        en = diagram.enumRelationClassHierarchy(isHideEmpty);
                        while (en.hasMoreElements()) {
                            rc = (RelationClass)en.nextElement();
                            if (isMemberCounts) {
                                cnt = rc.countMembers();
                            }
                            this.add(new ShownRelnChkBox(this, rc, 2, ++n, cnt, textFont), rc.getInheritanceDepth() * 10);
                        }
                    } else {
                        en = diagram.enumRelationClassesInOrder();
                        while (en.hasMoreElements()) {
                            rc = (RelationClass)en.nextElement();
                            if (usesCounts) {
                                cnt = rc.countMembers();
                                if (isHideEmpty && cnt == 0) continue;
                                if (!isMemberCounts) {
                                    cnt = -1;
                                }
                            }
                            this.add(new ShownRelnChkBox(this, rc, 2, ++n, cnt, textFont));
                        }
                    }
                }
                if (containsClasses != null) {
                    this.m_height += 10;
                    this.add(this.m_clabel);
                    for (n = 0; n < containsClasses.length; ++n) {
                        this.m_height += 5;
                        rc = containsClasses[n];
                        int dir = rc.getShown() != 2 ? 1 : 2;
                        this.add(new ShownRelnChkBox(this, rc, dir, -1, -1, textFont));
                    }
                }
            }
            this.m_height += 20;
            this.add(this.m_footer1);
            this.add(this.m_footer2);
            this.m_height += 10;
            this.customFill();
        }
        this.setBounds(0, 0, this.m_width, this.m_height);
        this.revalidate();
    }

    public void syncEntityClasses() {
        int size = this.getComponentCount();
        for (int i = 0; i < size; ++i) {
            Component o = this.getComponent(i);
            if (!(o instanceof ShownEntityChkBox)) continue;
            ((ShownEntityChkBox)o).sync();
        }
    }

    public void syncRelationClasses() {
        int size = this.getComponentCount();
        for (int i = 0; i < size; ++i) {
            Component o = this.getComponent(i);
            if (!(o instanceof ShownRelnChkBox)) continue;
            ((ShownRelnChkBox)o).sync();
        }
    }

    public void toggleFlags(int key) {
        int cnt = this.getComponentCount();
        boolean ns = true;
        if (key == 0) {
            Component c;
            int i;
            for (i = 0; i < cnt; ++i) {
                c = this.getComponent(i);
                if (!(c instanceof ShownRelnChkBox) || ((ShownRelnChkBox)c).getIndex() != 1) continue;
                ns = !((ShownRelnChkBox)c).isActive();
                break;
            }
            for (i = 0; i < cnt; ++i) {
                c = this.getComponent(i);
                if (!(c instanceof ShownRelnChkBox) || ns == ((ShownRelnChkBox)c).isActive()) continue;
                ((ShownRelnChkBox)c).doClick();
            }
        } else {
            for (int i = 0; i < cnt; ++i) {
                Component c = this.getComponent(i);
                if (!(c instanceof ShownRelnChkBox) || ((ShownRelnChkBox)c).getIndex() != key) continue;
                ((ShownRelnChkBox)c).doClick();
                break;
            }
        }
    }

    protected void customOptions(JPopupMenu popupMenu) {
    }

    protected void customRelationOptions(JPopupMenu popup, RelationClass rc) {
    }

    protected void doRightPopup(MouseEvent ev) {
        RelationClass rc;
        JMenuItem mi;
        EntityClass ec;
        Option option = Options.getDiagramOptions();
        LandscapeEditorCore ls = this.m_ls;
        Diagram diagram = ls.getDiagram();
        int x = ev.getX();
        int y = ev.getY();
        JPopupMenu popupMenu = new JPopupMenu("Options");
        String string = this.getFlagName();
        Enumeration en = diagram.enumEntityClasses();
        while (en.hasMoreElements()) {
            ec = (EntityClass)en.nextElement();
            if (!this.getFlag(ec)) continue;
            mi = new JMenuItem("No entities " + string);
            mi.addActionListener(new SetEntitiesFlag(this, false));
            popupMenu.add(mi);
            break;
        }
        en = diagram.enumEntityClasses();
        while (en.hasMoreElements()) {
            ec = (EntityClass)en.nextElement();
            if (this.getFlag(ec)) continue;
            mi = new JMenuItem("All entities " + string);
            mi.addActionListener(new SetEntitiesFlag(this, true));
            popupMenu.add(mi);
            break;
        }
        en = diagram.enumRelationClasses();
        while (en.hasMoreElements()) {
            rc = (RelationClass)en.nextElement();
            if (!this.getFlag(rc, 1)) continue;
            mi = new JMenuItem("No relations " + string);
            mi.addActionListener(new SetRelationsFlag(this, 1, false));
            popupMenu.add(mi);
            break;
        }
        en = diagram.enumRelationClasses();
        while (en.hasMoreElements()) {
            rc = (RelationClass)en.nextElement();
            if (this.getFlag(rc, 1)) continue;
            mi = new JMenuItem("All relations " + string);
            mi.addActionListener(new SetRelationsFlag(this, 1, true));
            popupMenu.add(mi);
            break;
        }
        if (this.can_reverse()) {
            en = diagram.enumRelationClasses();
            while (en.hasMoreElements()) {
                rc = (RelationClass)en.nextElement();
                if (!this.getFlag(rc, 2)) continue;
                mi = new JMenuItem("No reversed relations " + string);
                mi.addActionListener(new SetRelationsFlag(this, 2, false));
                popupMenu.add(mi);
                break;
            }
            en = diagram.enumRelationClasses();
            while (en.hasMoreElements()) {
                rc = (RelationClass)en.nextElement();
                if (this.getFlag(rc, 2)) continue;
                mi = new JMenuItem("All reversed relations " + string);
                mi.addActionListener(new SetRelationsFlag(this, 2, true));
                popupMenu.add(mi);
                break;
            }
        }
        string = option.isHideEmpty() ? "Show " : "Hide ";
        mi = new JMenuItem(string + g_empty_classes);
        mi.addActionListener(new ToggleEmptyClasses());
        popupMenu.add(mi);
        string = option.isMemberCounts() ? "Hide " : "Show ";
        mi = new JMenuItem(string + g_member_counts);
        mi.addActionListener(new ToggleMemberCounts());
        popupMenu.add(mi);
        mi = new JMenuItem(g_editElisionRules_text);
        mi.addActionListener(new DisplayEditElisions(ls, null));
        popupMenu.add(mi);
        if (option.getElisionIcon() >= 0) {
            mi = new JMenuItem(g_hideElisionIcons_text);
            mi.addActionListener(new HideElisionIcons(ls));
            popupMenu.add(mi);
        }
        string = option.isShowInheritance() ? "Hide " : "Show ";
        mi = new JMenuItem(string + g_hierarchy_text);
        mi.addActionListener(new ToggleHierarchy());
        popupMenu.add(mi);
        this.customOptions(popupMenu);
        mi = new JMenuItem(g_formsHierarchy_text);
        mi.addActionListener(new SetContainsRelation(ls));
        popupMenu.add(mi);
        FontCache.setMenuTreeFont(popupMenu);
        this.add(popupMenu);
        popupMenu.show(this, x, y);
        this.remove(popupMenu);
    }

    public void fontChanged() {
        this.fill();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fill();
    }

    @Override
    public void diagramChanging(Diagram diagram) {
    }

    @Override
    public void diagramChanged(Diagram diagram, int signal) {
        this.fill();
    }

    @Override
    public void updateBegins() {
    }

    @Override
    public void updateEnds() {
        if (this.m_badcnts) {
            Option option;
            this.m_badcnts = false;
            if (!(this.m_refill || (option = Options.getDiagramOptions()).isMemberCounts() || option.isHideEmpty())) {
                return;
            }
        } else if (!this.m_refill) {
            return;
        }
        this.m_refill = false;
        this.fill();
    }

    @Override
    public void entityClassChanged(EntityClass ec, int signal) {
        this.m_refill = true;
    }

    @Override
    public void relationClassChanged(RelationClass rc, int signal) {
        this.m_refill = true;
    }

    @Override
    public void entityParentChanged(EntityInstance e, EntityInstance parent, int signal) {
        this.m_badcnts = true;
    }

    @Override
    public void relationParentChanged(RelationInstance ri, int signal) {
        this.m_badcnts = true;
    }

    @Override
    public void mouseClicked(MouseEvent ev) {
        if (ev.isMetaDown()) {
            this.doRightPopup(ev);
        }
    }

    @Override
    public void mouseEntered(MouseEvent ev) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent ev) {
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
    }

    class ToggleHierarchy
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ev) {
            Option option;
            if ((ev.getModifiers() & 4) != 0 && ERBox.this.m_ls.processMetaKeyEvent(ERBox.g_hierarchy_text)) {
                return;
            }
            option.setShowInheritance(!(option = Options.getDiagramOptions()).isShowInheritance());
            ERBox.this.fill();
        }
    }

    class ToggleMemberCounts
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ev) {
            Option option;
            if ((ev.getModifiers() & 4) != 0 && ERBox.this.m_ls.processMetaKeyEvent(ERBox.g_member_counts)) {
                return;
            }
            option.setMemberCounts(!(option = Options.getDiagramOptions()).isMemberCounts());
            ERBox.this.fill();
        }
    }

    class ToggleEmptyClasses
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ev) {
            Option option = Options.getDiagramOptions();
            if ((ev.getModifiers() & 4) != 0 && ERBox.this.m_ls.processMetaKeyEvent(ERBox.g_empty_classes)) {
                return;
            }
            option.setHideEmpty(!option.isHideEmpty());
            ERBox.this.fill();
        }
    }
}

