/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import lsedit.EdgePoint;
import lsedit.MoveModeHandler;
import lsedit.Options;
import lsedit.RelationComponent;
import lsedit.RelationInstance;
import lsedit.Util;

class DrawInfo {
    protected static final Color CENTRE_MARK_COLOR = Color.yellow;
    protected static final int CENTRE_MARK_DIM = 4;
    protected static final double NEAR_POINT_THRESHOLD = 1.0;
    protected static final double NEAR_LINE_THRESHOLD2 = 1.0;
    protected RelationComponent m_component;
    protected int m_style = 0;
    protected int m_embellished;

    DrawInfo() {
    }

    public void getBounds(Rectangle r) {
        r.setBounds(0, 0, 0, 0);
    }

    public boolean contains(int x, int y) {
        return false;
    }

    public void paintComponent(Graphics g, int shiftX, int shiftY) {
    }

    protected static void getLineBounds(int srcX, int srcY, int dstX, int dstY, Rectangle r) {
        int y2;
        int y1;
        int x2;
        int x1;
        if (srcX <= dstX) {
            x1 = srcX;
            x2 = dstX;
        } else {
            x1 = dstX;
            x2 = srcX;
        }
        if (srcY <= dstY) {
            y1 = srcY;
            y2 = dstY;
        } else {
            y1 = dstY;
            y2 = srcY;
        }
        int linewidth = Options.getLineWidth();
        if (linewidth > 1) {
            int w = x2 - x1;
            int h = y2 - y1;
            int shift = linewidth / 2;
            if (h > 2 * w) {
                x1 -= shift;
                x2 += shift;
            }
            if (w >= 2 * h) {
                y1 -= shift;
                y2 += shift;
            }
        }
        r.setBounds(x1, y1, x2 - x1, y2 - y1);
    }

    protected static void includeTailBounds(int srcX, int srcY, Rectangle r) {
        int x1 = r.x;
        int y1 = r.y;
        int x2 = x1 + r.width;
        int y2 = y1 + r.height;
        int x = srcX - 3;
        int y = srcY - 3;
        if (x < x1) {
            x1 = x;
        }
        if (y < y1) {
            y1 = y;
        }
        y += 6;
        if ((x += 6) > x2) {
            x2 = x;
        }
        if (y > y2) {
            y2 = y;
        }
        r.setBounds(x1, y1, x2 - x1, y2 - y1);
    }

    protected static void includeCentreBounds(int srcX, int srcY, int dstX, int dstY, Rectangle r) {
        int x1 = r.x;
        int y1 = r.y;
        int x2 = x1 + r.width;
        int y2 = y1 + r.height;
        int x = (srcX + dstX - 4) / 2;
        int y = (srcY + dstY - 4) / 2;
        if (x < x1) {
            x1 = x;
        }
        if (y < y1) {
            y1 = y;
        }
        y += 4;
        if ((x += 4) > x2) {
            x2 = x;
        }
        if (y > y2) {
            y2 = y;
        }
        r.setBounds(x1, y1, x2 - x1, y2 - y1);
    }

    protected void includeArrowBounds(int srcX, int srcY, int dstX, int dstY, Rectangle r) {
        RelationInstance ri = this.m_component.getRelationInstance();
        int x1 = r.x;
        int y1 = r.y;
        int x2 = x1 + r.width;
        int y2 = y1 + r.height;
        int[] x3 = new int[3];
        int[] y3 = new int[3];
        if (Util.getArrow(srcX, srcY, dstX, dstY, x3, y3, ri.getFrequency()) != 0.0) {
            for (int i = 0; i < 3; ++i) {
                int x = x3[i];
                int y = y3[i];
                if (x < x1) {
                    x1 = x;
                }
                if (y < y1) {
                    y1 = y;
                }
                if (x > x2) {
                    x2 = x;
                }
                if (y <= y2) continue;
                y2 = y;
            }
        }
        r.setBounds(x1, y1, x2 - x1, y2 - y1);
    }

    protected static boolean nearPoint(double srcX, double srcY, int x, int y) {
        double diff = (double)x - srcX;
        if (diff < 0.0) {
            diff = -diff;
        }
        if (diff > 1.0) {
            return false;
        }
        diff = (double)y - srcY;
        if (diff < 0.0) {
            diff = -diff;
        }
        return !(diff > 1.0);
    }

    protected static boolean nearLine(double srcX, double srcY, double dstX, double dstY, int x, int y) {
        double py;
        double ly;
        double px;
        double lx;
        double dist2;
        if (srcX == dstX && srcY == dstY) {
            return DrawInfo.nearPoint(srcX, srcY, x, y);
        }
        double rx = x;
        double vx = dstX - srcX;
        double ry = y;
        double vy = dstY - srcY;
        double t = ((rx - srcX) * vx + (ry - srcY) * vy) / (vx * vx + vy * vy);
        return t >= 0.0 && t <= 1.0 && (dist2 = (lx = rx - (px = srcX + t * vx)) * lx + (ly = ry - (py = srcY + t * vy)) * ly) <= 1.0;
    }

    public void setStyle(int style) {
        this.m_style = style;
    }

    public void setEmbellished(int value) {
        this.m_embellished = value;
    }

    public boolean orEmbellished(int value) {
        if ((this.m_embellished & value) != value) {
            this.m_embellished |= value;
            return true;
        }
        return false;
    }

    public boolean nandEmbellished(int value) {
        if ((this.m_embellished & value) != 0) {
            this.m_embellished &= ~value;
            return true;
        }
        return false;
    }

    public boolean mouseOverEdgePoint(int x, int y, MoveModeHandler handler) {
        return false;
    }

    public boolean isFramedBy(Rectangle frame) {
        return false;
    }

    public void switchEdgePoint(EdgePoint oldPoint, EdgePoint newPoint) {
    }
}

