/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import lsedit.Attribute;
import lsedit.Cardinal;
import lsedit.ClientSet;
import lsedit.Clipboard;
import lsedit.ClusterMetrics;
import lsedit.ColorCache;
import lsedit.EditModeHandler;
import lsedit.EntityClass;
import lsedit.EntityComponent;
import lsedit.EntityInstance;
import lsedit.ExitFlag;
import lsedit.FontCache;
import lsedit.LandscapeClassObject;
import lsedit.LandscapeEditorCore;
import lsedit.LandscapeLayouter;
import lsedit.LandscapeModeHandler;
import lsedit.LandscapeObject;
import lsedit.Option;
import lsedit.Options;
import lsedit.Recluster;
import lsedit.RelationClass;
import lsedit.RelationComponent;
import lsedit.RelationInstance;
import lsedit.RelationLabel;
import lsedit.RelayoutSubtree;
import lsedit.ResultBox;
import lsedit.SortVector;
import lsedit.SupplierSet;
import lsedit.Ta;
import lsedit.TaListener;
import lsedit.TemporalTa;
import lsedit.TocBox;
import lsedit.Util;
import lsedit.Zoom;

public final class Diagram
extends TemporalTa
implements TaListener,
MouseMotionListener {
    public static final int BG = 191;
    public static final Color boxColor = Color.lightGray;
    public static final Color lighterBoxColor = new Color(0xE0E0E0);
    protected static final int GAP = 5;
    protected static final int MARGIN = 10;
    protected static final double SMALL_SCALE_UP = 1.2;
    protected static final double SMALL_SCALE_DOWN = 0.8;
    protected static final String SMALL_SCALE_STRING = "20%";
    protected LandscapeEditorCore m_ls;
    protected Option m_diagramOptions;
    protected int m_view_x = 0;
    protected int m_view_y = 0;
    protected ExitFlag m_exitFlag;
    protected Container m_cardinals = null;
    protected Container m_edges = null;
    protected Container m_edge_labels = null;
    protected SupplierSet m_supplierSet;
    protected ClientSet m_clientSet;
    protected int m_numVisibleRelationClasses = -1;
    protected boolean m_loaded = false;
    protected boolean m_visibleEdges = true;
    protected boolean m_drawEntities = true;
    protected boolean m_drawEdges = true;
    protected boolean m_viewActive = false;
    protected EntityInstance m_keyEntity;
    private Vector m_groupedEntities = new Vector();
    private Vector m_groupedRelations = new Vector();
    private Vector m_redBoxEntities = new Vector();
    private Vector m_highlightRelations = new Vector();
    protected EntityInstance m_chaseEntity = null;
    protected boolean m_modeHandlingActive = false;
    protected Clipboard m_clipboard = null;
    protected Vector m_oldChildren;
    protected ClusterMetrics m_clusterMetrics = null;
    private int m_flags = 0;
    private static final int REFILL_FLAG = 1;
    private static final int REPAINT_FLAG = 2;
    private static final int REFILL_EDGES_FLAG = 4;
    private static final int RESHADE_FLAG = 8;
    private static final int PAINT_FLAGS = 15;
    private static final int SHOWS_CLIENTS_FLAG = 16;
    private static final int SHOWS_SUPPLIERS_FLAG = 32;
    private static final int FILL_FLAGS = 48;
    private boolean m_updating = false;

    @Override
    protected Diagram getDiagram() {
        return this;
    }

    @Override
    protected boolean isSpecialPath(String path) {
        return this.m_ls.isSpecialPath(path);
    }

    @Override
    protected String parseSpecialPath(Ta ta, String path) {
        return this.m_ls.parseSpecialPath(ta, path);
    }

    protected void setVisibilityFlags() {
        this.m_numVisibleRelationClasses = 0;
        Enumeration en = this.enumRelationClasses();
        while (en.hasMoreElements()) {
            RelationClass rc = (RelationClass)en.nextElement();
            if (!rc.isShown()) continue;
            rc.setOrdinal(this.m_numVisibleRelationClasses++);
        }
        this.m_visibleEdges = this.m_numVisibleRelationClasses > 0;
    }

    public void invalidateVisibleRelationClasses() {
        this.m_numVisibleRelationClasses = -1;
    }

    public String parameterDetails() {
        return this.m_ls.parameterDetails();
    }

    @Override
    public boolean contains(int x, int y) {
        return this.m_loaded && super.contains(x, y);
    }

    @Override
    public Component add(Component c) {
        if (c instanceof RelationComponent) {
            RelationLabel label = ((RelationComponent)c).getRelationLabel();
            if (label != null) {
                this.m_edge_labels.add(label);
            }
            return this.m_edges.add(c);
        }
        if (c instanceof Cardinal) {
            return this.m_cardinals.add(c);
        }
        return super.add(c);
    }

    @Override
    public void remove(Component c) {
        if (c instanceof RelationComponent) {
            RelationLabel label = ((RelationComponent)c).getRelationLabel();
            if (label != null) {
                this.m_edge_labels.remove(label);
            }
            this.m_edges.remove(c);
            return;
        }
        if (c instanceof Cardinal) {
            this.m_cardinals.remove(c);
            return;
        }
        super.remove(c);
    }

    public Diagram(LandscapeEditorCore ls) {
        super(ls);
        this.m_cardinals = new Container();
        this.m_cardinals.setLayout(null);
        this.m_edges = new Container();
        this.m_edges.setLayout(null);
        this.m_edge_labels = new Container();
        this.m_edge_labels.setLayout(null);
        this.m_ls = ls;
        this.setDiagram(this);
        this.setLayout(null);
        this.setLocation(0, 0);
        this.m_exitFlag = new ExitFlag(ls);
        this.m_exitFlag.setLocation(3, 3);
        this.m_supplierSet = new SupplierSet(this);
        this.m_clientSet = new ClientSet(this);
        this.m_diagramOptions = new Option("Active");
        this.m_diagramOptions.setTo(Options.getLandscapeOptions());
        Options.setDiagramOptions(this.m_diagramOptions);
        this.addMouseMotionListener(this);
        this.addTaListener(this, 5);
    }

    public LandscapeEditorCore getLs() {
        return this.m_ls;
    }

    public Option getDiagramOptions() {
        return this.m_diagramOptions;
    }

    public void updateLiftEdges() {
        this.updateLiftEdges(this.m_drawRoot);
    }

    public void updateDeleteActiveEntities() {
        this.updateDeleteActiveEntities(this.m_drawRoot);
    }

    public void updateDeleteActiveContainers() {
        this.updateDeleteActiveContainers(this.m_drawRoot);
    }

    public void updateDeleteActiveEdges() {
        this.updateDeleteActiveEdges(this.m_drawRoot);
    }

    public void doDelete(Object object) {
        String msg;
        int mode = 0;
        Vector objects = this.targetEntityRelations(object);
        if (objects != null) {
            this.beginUndoRedo("Delete");
            Enumeration en = objects.elements();
            while (en.hasMoreElements()) {
                Object o = en.nextElement();
                if (o == null) continue;
                if (o instanceof RelationInstance) {
                    RelationInstance ri = (RelationInstance)o;
                    mode |= 1;
                    this.updateDeleteEdge(ri);
                    continue;
                }
                if (o instanceof EntityInstance) {
                    EntityInstance e = (EntityInstance)o;
                    if (e.getContainedBy() == null) continue;
                    this.updateCutEntity(e);
                    mode |= 2;
                    continue;
                }
                System.out.println("Can't delete object of type " + o.getClass());
            }
            this.endUndoRedo();
            if (mode != 0 && (mode & 2) != 0) {
                this.clearGroupFlags();
            }
        }
        switch (mode) {
            case 0: {
                msg = "Nothing selected to delete";
                break;
            }
            case 1: {
                msg = "Edge(s) deleted";
                break;
            }
            case 2: {
                msg = "Entity(s) deleted";
                break;
            }
            case 3: {
                this.clearGroupFlags();
                msg = "Entity(s) and Edge(s) deleted";
                break;
            }
            default: {
                msg = "???";
            }
        }
        this.m_ls.doFeedback(msg);
    }

    protected void duplicateEdges(EntityInstance e, RelationClass oldRc, RelationClass newRc) {
        Vector srcRelList = e.getSrcRelList();
        if (srcRelList != null) {
            int size = srcRelList.size();
            for (int i = 0; i < size; ++i) {
                RelationInstance ri = (RelationInstance)srcRelList.elementAt(i);
                if (ri.isMarked(0x100000)) {
                    EntityInstance dst = ri.getDst();
                    dst.savePositioning(newRc);
                    this.duplicateEdges(dst, oldRc, newRc);
                }
                if (oldRc != ri.getRelationClass()) continue;
                this.updateNewRelation(newRc, e, ri.getDst());
            }
        }
    }

    public void duplicateEdges(RelationClass oldRc, RelationClass newRc) {
        if (this.m_rootInstance != null) {
            Enumeration en = this.m_rootInstance.getChildren();
            while (en.hasMoreElements()) {
                EntityInstance e = (EntityInstance)en.nextElement();
                this.duplicateEdges(e, oldRc, newRc);
            }
        }
    }

    public void changeContainsClasses(RelationClass[] relationClasses) {
        this.signalRelationClassChanged(null, 7);
        this.clearEstablishForest(relationClasses);
        this.switchContainsClasses(relationClasses);
        this.signalRelationClassChanged(null, 8);
    }

    public void updateContainsClasses(RelationClass[] relationClasses) {
        String msg;
        this.signalRelationClassChanged(null, 7);
        if (relationClasses.length == 0) {
            msg = "Removing containment";
        } else {
            msg = "Switch to " + relationClasses[0].getLabel();
            if (relationClasses.length > 1) {
                msg = msg + " ... ";
            }
        }
        msg = msg + " heirarchy";
        this.beginUndoRedo(msg);
        this.clearEstablishForest(relationClasses);
        this.updateSwitchContainsClasses(relationClasses);
        this.signalRelationClassChanged(null, 8);
        this.endUndoRedo();
    }

    public void recomputeContainsClasses() {
        if (this.m_changed_spanning_edges) {
            this.m_changed_spanning_edges = false;
            this.changeContainsClasses(this.m_containsClasses);
        }
    }

    private void loadDiagramOption(String attribute, String value) {
        if (attribute.equals("diagram:drawroot")) {
            if (this.m_ls.m_startEntity == null) {
                this.m_ls.m_startEntity = value;
            }
            return;
        }
        if (attribute.equals("diagram:viewx")) {
            int ival = Util.parseInt(value);
            if (ival > 0) {
                this.m_view_x = ival;
            }
            return;
        }
        if (attribute.equals("diagram:viewy")) {
            int ival = Util.parseInt(value);
            if (ival > 0) {
                this.m_view_y = ival;
            }
            return;
        }
    }

    public String loadDiagram(String taPath) {
        LandscapeEditorCore ls = this.m_ls;
        ls.doFeedback("Loading: " + taPath);
        URL documentBase = ls.getDocumentBase();
        String ret = this.loadTA(taPath, documentBase);
        if (ret == null) {
            Attribute[] attributes;
            Option landscapeOptions = Options.getLandscapeOptions();
            Option diagramOptions = Options.getDiagramOptions();
            ls.addLseditHistory(taPath);
            diagramOptions.setTo(landscapeOptions);
            EntityInstance optionsInstance = this.m_rootInstance;
            this.m_view_x = 0;
            this.m_view_y = 0;
            if (optionsInstance != null && (attributes = optionsInstance.m_attributes) != null && attributes.length > 0) {
                switch (diagramOptions.getLoadMode()) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        if (JOptionPane.showConfirmDialog(this.m_ls.getFrame(), "Do you wish to load the options contained in " + taPath + "?\n" + "You are being asked this question because your landscape\n" + "load TA option is currently set to \"Prompt\"", "Load options contained in this TA file", 2) != 0) break;
                    }
                    default: {
                        for (int i = 0; i < attributes.length; ++i) {
                            String value;
                            Attribute attribute = attributes[i];
                            if (attribute == null || (value = attribute.externalString()) == null) continue;
                            value = value.trim();
                            String id = attribute.m_id;
                            if (id.startsWith("diagram:")) {
                                this.loadDiagramOption(id, value);
                                continue;
                            }
                            diagramOptions.loadOption(id, value);
                        }
                    }
                }
            }
            if (this.m_loaded_special) {
                ls.specialPathOptions(diagramOptions);
            }
            ls.changeTraceLifted(diagramOptions.isTraceLifted());
            ls.changeGroupQuery(diagramOptions.isGroupQuery());
            ls.changeQueryPersists(diagramOptions.isQueryPersists());
        }
        return ret;
    }

    public void cutGroup(Object object) {
        boolean addPriorCuts = this.m_ls.isAddToClipboard();
        TocBox tocBox = this.m_ls.getTocBox();
        Vector vector = object != null && object == tocBox ? tocBox.getTocGroupedEntities() : this.getGroupedEntities();
        if (vector == null) {
            this.m_ls.error("Group not selected");
            return;
        }
        if (vector.contains(this.m_rootInstance)) {
            this.m_ls.error("Can't cut the root node in the diagram");
        }
        this.beginUndoRedo("Cut group");
        this.clearAllEntityGroupFlags();
        Clipboard new_clipboard = new Clipboard(vector);
        String msg = "Group copied to clipboard";
        Clipboard old_clipboard = this.getClipboard();
        if (old_clipboard != null && old_clipboard.size() != 0) {
            if (addPriorCuts) {
                new_clipboard.setExtendsClipboard(old_clipboard);
                msg = msg + " - old cuts preserved";
            } else {
                msg = msg + " - old cuts discarded";
            }
        }
        this.updateCutClipboard(old_clipboard, new_clipboard);
        this.endUndoRedo();
        this.m_ls.doFeedback(msg);
    }

    public void pasteGroup(Object object) {
        Clipboard clipboard = this.getClipboard();
        if (clipboard == null) {
            this.m_ls.error("Clipboard empty");
            return;
        }
        TocBox tocBox = this.m_ls.getTocBox();
        EntityInstance pe = object != null && object == tocBox ? tocBox.targetEntity() : this.targetEntity(object);
        if (pe != null) {
            String label = pe.getEntityLabel();
            this.beginUndoRedo("Paste to " + label);
            this.updatePasteClipboard(clipboard, pe);
            this.endUndoRedo();
            this.m_ls.doFeedback("Pasted entities into " + label);
        }
    }

    public EntityInstance getDrawRootParent() {
        return this.m_drawRoot.getContainedBy();
    }

    public void setDrawRoot(EntityInstance e) {
        EntityInstance old = this.m_drawRoot;
        if (e != old) {
            if (old != null) {
                old.nandMark(16);
                old.setToolTipText();
            }
            this.m_drawRoot = e;
            if (e != null) {
                e.orMark(16);
                e.setToolTipText();
                e.setOpen();
                this.m_ls.addHistoryEntity(e);
            }
            this.m_ls.mapboxChanged(e);
        }
    }

    public void toggleDstElision(EntityInstance e) {
        e.toggleElision(0, this.enumRelationClasses());
    }

    public void toggleSrcElision(EntityInstance e) {
        e.toggleElision(1, this.enumRelationClasses());
    }

    public void toggleEnteringElision(EntityInstance e) {
        e.toggleElision(2, this.enumRelationClasses());
    }

    public void toggleExitingElision(EntityInstance e) {
        e.toggleElision(3, this.enumRelationClasses());
    }

    public void toggleInternalElision(EntityInstance e) {
        e.toggleElision(4, this.enumRelationClasses());
    }

    @Override
    public void setVisible(boolean value) {
        if (this.m_drawRoot != null) {
            this.m_drawRoot.setVisible(value);
        }
    }

    public void setViewActive() {
        this.m_viewActive = true;
    }

    public EntityInstance getKeyEntity() {
        return this.m_keyEntity;
    }

    public int getGroupedEntitiesCount() {
        return this.m_groupedEntities.size();
    }

    public EntityInstance getGroupedEntitiesContainer() {
        EntityInstance fe = (EntityInstance)this.m_groupedEntities.firstElement();
        return fe.getContainedBy();
    }

    public Vector getGroupedEntities() {
        Vector groupedEntities;
        if (this.m_rootInstance != null && !(groupedEntities = this.m_groupedEntities).isEmpty()) {
            return (Vector)groupedEntities.clone();
        }
        return null;
    }

    public boolean clearEntityGroupFlag(EntityInstance e) {
        if (e.getGroupFlag()) {
            Vector groupedEntities = this.m_groupedEntities;
            EntityInstance keyEntity = this.m_keyEntity;
            e.nandMark(196608);
            groupedEntities.removeElement(e);
            if (e == keyEntity) {
                if (groupedEntities.isEmpty()) {
                    this.m_keyEntity = null;
                } else {
                    this.m_keyEntity = keyEntity = (EntityInstance)groupedEntities.firstElement();
                    keyEntity.orMark(131072);
                    keyEntity.repaint();
                }
            }
            return true;
        }
        return false;
    }

    public void clearEntityClassGroupFlags(EntityClass ec) {
        Vector groupedEntities = this.m_groupedEntities;
        int i = groupedEntities.size();
        while (--i >= 0) {
            EntityInstance e = (EntityInstance)groupedEntities.elementAt(i);
            EntityClass ec1 = e.getEntityClass();
            if (ec1 != ec) continue;
            this.clearEntityGroupFlag(e);
        }
    }

    public void clearAllEntityGroupFlags() {
        Vector groupedEntities = this.m_groupedEntities;
        int i = groupedEntities.size();
        while (--i >= 0) {
            EntityInstance e = (EntityInstance)groupedEntities.elementAt(i);
            e.nandMark(196608);
            e.repaint();
        }
        groupedEntities.removeAllElements();
        this.m_keyEntity = null;
    }

    protected void setEntityGroupFlag(EntityInstance e) {
        if (!e.isMarked(65536) && e.isShown()) {
            e.orMark(65536);
            this.m_groupedEntities.addElement(e);
            if (this.m_keyEntity == null) {
                this.m_keyEntity = e;
                e.orMark(131072);
            }
            e.repaint();
        }
    }

    public void setKeyEntity(EntityInstance e) {
        if (e != this.m_keyEntity && e.isShown()) {
            if (!e.isMarked(65536)) {
                this.m_groupedEntities.addElement(e);
            }
            if (this.m_keyEntity != null) {
                this.m_keyEntity.nandMark(131072);
                this.m_keyEntity.repaint();
            }
            e.orMark(196608);
            this.m_keyEntity = e;
            e.repaint();
        }
    }

    public void clearKeyEntity() {
        Vector groupedEntities = this.m_groupedEntities;
        EntityInstance keyEntity = this.m_keyEntity;
        if (keyEntity != null) {
            int i = groupedEntities.size();
            while (--i >= 0) {
                EntityInstance other = (EntityInstance)groupedEntities.elementAt(i);
                if (other == keyEntity) continue;
                keyEntity.nandMark(131072);
                other.orMark(131072);
                this.m_keyEntity = other;
                other.repaint();
                return;
            }
        }
        this.clearEntityGroupFlag(keyEntity);
    }

    public void groupRedBoxes(boolean clear) {
        int i;
        LandscapeEditorCore ls = this.m_ls;
        Vector redboxes = this.getRedboxEntities();
        int n = i = redboxes == null ? 0 : redboxes.size();
        if (i == 0) {
            ls.error("No query result (highlighted red boxes) active.");
        } else {
            ls.doFeedback("Grouped " + i + " redboxes");
            if (clear) {
                this.clearGroupFlags();
            }
            while (0 <= --i) {
                EntityInstance e = (EntityInstance)redboxes.elementAt(i);
                if (!e.isMarked(1)) continue;
                this.setEntityGroupFlag(e);
            }
        }
    }

    public Vector getGroupedRelations() {
        Vector groupedRelations;
        if (this.m_rootInstance != null && !(groupedRelations = this.m_groupedRelations).isEmpty()) {
            return (Vector)groupedRelations.clone();
        }
        return null;
    }

    public void setRelationGroupFlag(RelationInstance ri) {
        if (!ri.getGroupFlag()) {
            this.m_groupedRelations.addElement(ri);
            ri.orMark(65536);
            ri.orEmbellished(2);
        }
    }

    public void clearRelationGroupFlag(RelationInstance ri) {
        if (ri.getGroupFlag()) {
            this.m_groupedRelations.removeElement(ri);
            ri.nandMark(65536);
            ri.nandEmbellished(2);
        }
    }

    public void clearRelationClassGroupFlags(RelationClass rc) {
        Vector groupedRelations = this.m_groupedRelations;
        int i = groupedRelations.size();
        while (--i >= 0) {
            RelationInstance ri = (RelationInstance)groupedRelations.elementAt(i);
            RelationClass rc1 = ri.getRelationClass();
            if (rc1 != rc) continue;
            this.clearRelationGroupFlag(ri);
        }
    }

    public void clearAllRelationGroupFlags() {
        Vector groupedRelations = this.m_groupedRelations;
        int i = groupedRelations.size();
        while (--i >= 0) {
            RelationInstance ri = (RelationInstance)groupedRelations.elementAt(i);
            ri.nandMark(65536);
            ri.nandEmbellished(2);
        }
        groupedRelations.removeAllElements();
    }

    public Vector getRedboxEntities() {
        Vector redboxEntities;
        if (this.m_rootInstance != null && !(redboxEntities = this.m_redBoxEntities).isEmpty()) {
            return (Vector)redboxEntities.clone();
        }
        return null;
    }

    public void setTracedFlag(EntityInstance e) {
        if (!e.isMarked(2048)) {
            this.m_redBoxEntities.addElement(e);
            e.orMark(2048);
            e.nandMark(8);
        }
    }

    public void setRedBoxFlag(EntityInstance e) {
        if (!e.isMarked(32768)) {
            this.setTracedFlag(e);
            e.orMark(32768);
            e.repaint();
        }
    }

    public boolean clearAllRedBoxFlags() {
        Vector redBoxEntities = this.m_redBoxEntities;
        int size = redBoxEntities.size();
        if (size > 0) {
            int i = size;
            while (--i >= 0) {
                EntityInstance e = (EntityInstance)redBoxEntities.elementAt(i);
                e.nandMark(34816);
                e.repaint();
            }
            redBoxEntities.removeAllElements();
            return true;
        }
        return false;
    }

    public void setHighlightFlag(RelationInstance ri) {
        if (!ri.isMarked(262144)) {
            this.m_highlightRelations.addElement(ri);
            ri.orMark(262144);
            ri.validate();
        }
    }

    public void setGroupAndHighlightFlag(RelationInstance ri) {
        this.setRelationGroupFlag(ri);
        this.setHighlightFlag(ri);
    }

    public void clearHighlightFlag(RelationInstance ri) {
        if (ri.isMarked(262144)) {
            this.m_highlightRelations.removeElement(ri);
            ri.nandMark(262144);
            ri.validate();
        }
    }

    public boolean clearAllHighlightFlags() {
        Vector highlightRelations = this.m_highlightRelations;
        int size = highlightRelations.size();
        if (size > 0) {
            int i = size;
            while (--i >= 0) {
                RelationInstance ri = (RelationInstance)highlightRelations.elementAt(i);
                ri.nandMark(262144);
                ri.validate();
            }
            highlightRelations.removeAllElements();
            return true;
        }
        return false;
    }

    public boolean getDrawEntities() {
        return this.m_drawEntities;
    }

    public boolean getDrawEdges() {
        return this.m_drawEdges;
    }

    public boolean clearDrawEntities() {
        if (this.m_drawEntities) {
            this.m_drawEntities = false;
            return true;
        }
        return false;
    }

    public boolean clearDrawEdges() {
        if (this.m_drawEdges) {
            this.m_drawEdges = false;
            return true;
        }
        return false;
    }

    public void clearQueryFlags(boolean force) {
        if (force || !Options.isQueryPersists()) {
            this.clearAllRedBoxFlags();
            this.clearAllHighlightFlags();
        }
    }

    public boolean clearHighlighting(boolean force) {
        boolean ret;
        boolean bl = ret = !this.getDrawEntities();
        if (ret) {
            this.m_drawEntities = true;
            this.m_drawEdges = true;
        }
        this.clearQueryFlags(force);
        return ret;
    }

    public void clearGroupFlags() {
        this.clearAllEntityGroupFlags();
        this.clearAllRelationGroupFlags();
    }

    public boolean clearFlags(boolean force) {
        this.m_viewActive = false;
        this.clearGroupFlags();
        return this.clearHighlighting(force);
    }

    public int numVisibleRelationClasses() {
        return this.m_numVisibleRelationClasses;
    }

    public String show_groupList(ResultBox resultBox) {
        Vector grp = this.getGroupedEntities();
        String msg = null;
        if (grp != null) {
            SortVector.byString(grp);
            resultBox.showResults("GROUP:", grp, "-- End of group --");
        } else {
            msg = "No entities selected";
        }
        return msg;
    }

    public String groupAll() {
        EntityInstance ke = this.getKeyEntity();
        int seen = 0;
        if (ke == null) {
            ke = this.getDrawRoot();
        }
        EntityInstance ge = ke;
        this.clearGroupFlags();
        if (!ge.isOpen()) {
            ge = ge.getContainedBy();
        }
        Enumeration en = ge.getChildrenShown();
        while (en.hasMoreElements()) {
            EntityInstance ce = (EntityInstance)en.nextElement();
            this.setEntityGroupFlag(ce);
            ++seen;
        }
        if (seen == 0) {
            return "No entities selected";
        }
        return seen + " entities selected";
    }

    public static int getHardGrid() {
        int gridPixels;
        Option option = Options.getDiagramOptions();
        if (option.isSnapToGrid() && (gridPixels = option.getGridSize()) > 1) {
            return gridPixels;
        }
        return 1;
    }

    public void invalidateAllEdges(EntityInstance root) {
        root.invalidateAllEdges();
        if (root.isOpen()) {
            Enumeration en = root.getChildren();
            while (en.hasMoreElements()) {
                this.invalidateAllEdges((EntityInstance)en.nextElement());
            }
        }
    }

    @Override
    public boolean isValidateRoot() {
        return true;
    }

    public void zoomChanged() {
        int h;
        int w;
        JComponent container = (JComponent)this.getParent();
        if (container == null) {
            w = 0;
            h = 0;
        } else {
            Option diagramOptions = Options.getDiagramOptions();
            Insets insets = container.getInsets();
            w = container.getWidth() - insets.right - insets.left;
            if (w <= 0) {
                w = 0;
            }
            if ((h = container.getHeight() - insets.bottom - insets.top) <= 0) {
                w = 0;
            }
            w = (int)((double)w * diagramOptions.getZoomX());
            h = (int)((double)h * diagramOptions.getZoomY());
        }
        if (this.getWidth() != w || this.getHeight() != h) {
            Dimension preferredSize = this.getPreferredSize();
            preferredSize.setSize(w, h);
            this.setPreferredSize(preferredSize);
            this.setSize(w, h);
            if (container != null) {
                container.revalidate();
            }
            this.revalidate();
        }
    }

    public void setZoom(double xfactor, double yfactor) {
        Option diagramOptions = Options.getDiagramOptions();
        diagramOptions.setZoomX(xfactor);
        diagramOptions.setZoomY(yfactor);
        this.zoomChanged();
    }

    public void initialZoom() {
        this.zoomChanged();
        this.centerDiagramOn(this.m_view_x, this.m_view_y);
    }

    public boolean updateZoom(double xfactor, double yfactor) {
        Option diagramOptions = Options.getDiagramOptions();
        double oldx = diagramOptions.getZoomX();
        double oldy = diagramOptions.getZoomY();
        if (xfactor <= 1.0 && yfactor <= 1.0 && oldx == 1.0 && oldy == 1.0) {
            return false;
        }
        double x = oldx * xfactor;
        double y = oldy * yfactor;
        if (x < 1.0) {
            x = 1.0;
        }
        if (y < 1.0) {
            y = 1.0;
        }
        if (x != oldx || y != oldy) {
            this.setZoom(x, y);
            if (this.undoEnabled()) {
                this.logEdit(new Zoom(this, oldx, oldy, x, y));
            }
        }
        return true;
    }

    public boolean set_to_viewport() {
        Option diagramOptions = Options.getDiagramOptions();
        double oldx = diagramOptions.getZoomX();
        double oldy = diagramOptions.getZoomY();
        if (oldx > 1.0 || oldy > 1.0) {
            this.setZoom(1.0, 1.0);
            if (this.undoEnabled()) {
                this.logEdit(new Zoom(this, oldx, oldy, 1.0, 1.0));
            }
            return true;
        }
        return false;
    }

    @Override
    public void validate() {
        int i;
        int mw = this.getWidth();
        int mh = this.getHeight();
        this.m_flags &= 0xFFFFFFCF;
        if (mw < 1 || mh < 1) {
            return;
        }
        this.removeAll();
        EntityInstance drawRoot = this.m_drawRoot;
        if (drawRoot == null) {
            return;
        }
        Option option = Options.getDiagramOptions();
        LandscapeEditorCore ls = this.m_ls;
        EntityInstance rootInstance = this.m_rootInstance;
        ls.setCursor(3);
        this.recomputeContainsClasses();
        if (this.m_numVisibleRelationClasses < 0) {
            this.setVisibilityFlags();
        }
        boolean liftEdges = option.isLiftEdges();
        boolean visibleEntities = option.isVisibleEntities();
        boolean visibleEdges = option.isVisibleEdges();
        boolean normalEntities = this.getDrawEntities();
        boolean hide = !normalEntities && (option.isChaseHide() || this.m_viewActive);
        this.m_cardinals.removeAll();
        if (option.isShowDstCardinals() || option.isShowSrcCardinals()) {
            this.m_cardinals.setBounds(0, 0, mw, mh);
            this.add(this.m_cardinals);
        }
        this.m_edges.removeAll();
        this.m_edges.setBounds(0, 0, mw, mh);
        this.add(this.m_edges);
        this.m_edge_labels.removeAll();
        this.m_edge_labels.setBounds(0, 0, mw, mh);
        this.add(this.m_edge_labels);
        mw -= 30;
        mh -= 20;
        int yshift = 0;
        Vector clients = null;
        Vector suppliers = null;
        if (drawRoot != rootInstance) {
            this.add(this.m_exitFlag);
            this.m_exitFlag.activate();
        }
        rootInstance.clearLiftedEdges(0, liftEdges, hide);
        this.m_drawRoot.setOpen();
        drawRoot.orMark(16);
        ClientSet clientSet = this.m_clientSet;
        SupplierSet supplierSet = this.m_supplierSet;
        clientSet.removeAll();
        supplierSet.removeAll();
        if (drawRoot == rootInstance) {
            clientSet = null;
            supplierSet = null;
        } else {
            boolean showClients = option.isShowClients();
            boolean showSuppliers = option.isShowSuppliers();
            boolean isTopClients = option.isTopClients();
            boolean useCompaction = option.isUseCompaction();
            if (showClients || showSuppliers) {
                int ypos;
                int temp;
                if (!showClients) {
                    clientSet = null;
                }
                if (!showSuppliers) {
                    supplierSet = null;
                }
                rootInstance.findClientsSuppliers(clientSet, supplierSet, drawRoot, null, visibleEntities, visibleEdges, liftEdges);
                if (clientSet != null && clientSet.setFound() == 0) {
                    clientSet = null;
                }
                if (supplierSet != null && supplierSet.setFound() == 0) {
                    supplierSet = null;
                }
                if (useCompaction) {
                    if (supplierSet != null) {
                        supplierSet.compact(mw, clientSet, drawRoot);
                    }
                    if (clientSet != null && clientSet.compact(mw, supplierSet, drawRoot)) {
                        supplierSet.compact(mw, clientSet, drawRoot);
                    }
                }
                if (clientSet != null) {
                    temp = 70;
                    mh -= temp;
                    if (isTopClients) {
                        ypos = 10;
                        yshift = temp;
                    } else {
                        ypos = this.getHeight() - 50 - 10;
                    }
                    clientSet.setBounds(15, ypos, mw, 50);
                }
                if (supplierSet != null) {
                    temp = 70;
                    mh -= temp;
                    if (!isTopClients) {
                        ypos = 10;
                        yshift = temp;
                    } else {
                        ypos = this.getHeight() - 50 - 10;
                    }
                    supplierSet.setBounds(15, ypos, mw, 50);
                }
            }
        }
        drawRoot.setEntitySize(mw, mh, this);
        drawRoot.computeDrawEntity(null, 1, true, liftEdges);
        if (clientSet != null && (clients = clientSet.getFullSet()) != null) {
            i = clients.size();
            while (--i >= 0) {
                ((EntityInstance)clients.elementAt(i)).computeDrawEntity(null, 2, visibleEntities, liftEdges);
            }
        }
        if (supplierSet != null && (suppliers = supplierSet.getFullSet()) != null) {
            int size = suppliers.size();
            i = suppliers.size();
            while (--i >= 0) {
                ((EntityInstance)suppliers.elementAt(i)).computeDrawEntity(null, 4, visibleEntities, liftEdges);
            }
        }
        drawRoot.liftAllDiagramEdges(drawRoot, liftEdges);
        EntityInstance e = ls.getForwardEntity();
        if (e != null) {
            this.queryEntity(70, e, ls.getResultBox(), ls.getForward());
            ls.clearForwardEntity();
            this.validate();
            return;
        }
        int x = 15;
        int y = 10 + yshift;
        drawRoot.setEntityLocation(x, y);
        drawRoot.setDiagramLocation(x, y);
        drawRoot.computeShading();
        if (supplierSet != null && supplierSet.getFullSetSize() != 0) {
            supplierSet.order();
            this.add(supplierSet);
            this.m_flags |= 0x20;
            supplierSet.setVisible(true);
        }
        if (clientSet != null && clientSet.getFullSetSize() != 0) {
            clientSet.order();
            this.add(clientSet);
            this.m_flags |= 0x10;
            clientSet.setVisible(true);
        }
        boolean normalEdges = this.getDrawEdges();
        if (!normalEntities || this.m_visibleEdges) {
            drawRoot.drawAllEdges(this, normalEdges);
        }
        this.refillEdges();
        if (option.isShowDstCardinals()) {
            drawRoot.resizeDstCardinals(this.m_numRelationClasses);
            drawRoot.resetDstCardinals();
            drawRoot.calcDstEdgeCardinals();
            drawRoot.showDstCardinals();
        }
        if (option.isShowSrcCardinals()) {
            drawRoot.resizeSrcCardinals(this.m_numRelationClasses);
            drawRoot.resetSrcCardinals();
            drawRoot.calcSrcEdgeCardinals();
            drawRoot.showSrcCardinals();
        }
        Container container = this.m_cardinals;
        int cnt = container.getComponentCount();
        for (i = 0; i < cnt; ++i) {
            Cardinal cardinal = (Cardinal)container.getComponent(i);
            cardinal.known();
        }
        ls.setCursor(0);
        this.repaint();
        this.m_loaded = true;
    }

    public void navigateTo(EntityInstance e, boolean mustbeContainer) {
        EntityInstance old;
        EntityInstance parent;
        LandscapeEditorCore ls = this.getLs();
        EntityInstance child = null;
        EntityInstance e1 = e;
        this.clearFlags(true);
        if (mustbeContainer && e.getFirstChild() == null && (parent = e.getContainedBy()) != null) {
            child = e;
            e1 = parent;
        }
        if (child == null && (old = this.getDrawRoot()) != null) {
            EntityInstance parent2;
            while ((parent2 = old.getContainedBy()) != null) {
                if (parent2 == e1) {
                    child = old;
                    break;
                }
                old = parent2;
            }
        }
        if (child != null) {
            this.setRedBoxFlag(child);
            this.setEntityGroupFlag(child);
        }
        this.setDrawRoot(e1);
        ls.setLeftBox();
        if (e != e1) {
            this.centerDiagramOn(e);
        }
        this.revalidate();
        ls.doFeedback("Now showing: " + (e == null ? " nothing" : e.getEntityLabel()));
    }

    public void navigateToRoot() {
        this.navigateTo(this.m_rootInstance, false);
    }

    public boolean allowElision() {
        return this.getDrawEntities();
    }

    public boolean isModeHandlingActive() {
        return this.m_modeHandlingActive;
    }

    public void setModeHandlingActive(boolean value) {
        this.m_modeHandlingActive = value;
    }

    public RelationInstance targetRelation(Object object) {
        if (object != null) {
            if (object instanceof Vector) {
                Vector v = (Vector)object;
                switch (v.size()) {
                    case 0: {
                        this.m_ls.doFeedback("Target relation set is empty");
                        return null;
                    }
                    case 1: {
                        object = v.firstElement();
                        break;
                    }
                    default: {
                        this.m_ls.doFeedback("Target relation set has multiple objects in it");
                        return null;
                    }
                }
            }
            if (object instanceof RelationInstance) {
                return (RelationInstance)object;
            }
            return null;
        }
        Vector v = this.getGroupedRelations();
        if (v == null) {
            this.m_ls.doFeedback("Select the edge you wish to work on");
        } else {
            if (v.size() == 1) {
                return (RelationInstance)v.firstElement();
            }
            this.m_ls.doFeedback("Can't operate on " + v.size() + " grouped edges");
        }
        return null;
    }

    public EntityInstance targetEntity(Object object) {
        if (object != null) {
            if (object instanceof Vector) {
                Vector v = (Vector)object;
                switch (v.size()) {
                    case 0: {
                        this.m_ls.doFeedback("Target entity set is empty");
                        return null;
                    }
                    case 1: {
                        object = v.firstElement();
                        break;
                    }
                    default: {
                        this.m_ls.doFeedback("Target entity set has multiple objects in it");
                        return null;
                    }
                }
            }
            if (object instanceof EntityInstance) {
                return (EntityInstance)object;
            }
            return null;
        }
        EntityInstance ke = this.getKeyEntity();
        if (ke != null) {
            return ke;
        }
        return this.getDrawRoot();
    }

    public Vector targetEntityRelations(Object object) {
        if (object != null) {
            if (object instanceof Vector) {
                Vector v = (Vector)object;
                if (v.size() > 0) {
                    return v;
                }
                this.m_ls.doFeedback("Target set is empty");
                return null;
            }
            Vector<Object> v = new Vector<Object>();
            v.addElement(object);
            return v;
        }
        Vector v = this.getGroupedRelations();
        Vector v1 = this.getGroupedEntities();
        if (v == null) {
            v = v1;
        } else if (v1 != null) {
            v.addAll(v1);
        }
        if (v == null) {
            this.m_ls.doFeedback("Select the entity/relations you wish to work on");
        }
        return v;
    }

    public LandscapeObject targetEntityRelation(Object object) {
        Vector v = this.targetEntityRelations(object);
        LandscapeObject landscapeObject = null;
        if (v == null) {
            this.m_ls.doFeedback("No object specified");
        } else {
            if (v.size() != 1) {
                this.m_ls.doFeedback("Select a single entity or relation that you wish to work with");
            } else {
                landscapeObject = (LandscapeObject)v.elementAt(0);
            }
            v = null;
        }
        return landscapeObject;
    }

    public Vector targetRelations(Object object) {
        if (object != null) {
            if (object instanceof Vector) {
                Vector v = (Vector)object;
                if (v.size() > 0) {
                    return v;
                }
                this.m_ls.doFeedback("Target relation set is empty");
                return null;
            }
            Vector<Object> v = new Vector<Object>();
            v.addElement(object);
            return v;
        }
        Vector v = this.getGroupedRelations();
        if (v == null) {
            this.m_ls.doFeedback("Select the edges you wish to work on");
        }
        return v;
    }

    public Vector targetEntities(Object object) {
        if (object != null) {
            if (object instanceof Vector) {
                Vector v = (Vector)object;
                if (v.size() > 0) {
                    return v;
                }
                this.m_ls.doFeedback("Target entity set is empty");
                return null;
            }
            Vector<Object> v = new Vector<Object>();
            v.addElement(object);
            return v;
        }
        return this.getGroupedEntities();
    }

    public Vector getClusterGroup() {
        Vector<EntityInstance> grp = this.getGroupedEntities();
        if (grp == null) {
            Enumeration children = this.m_drawRoot.getChildrenShown();
            while (children.hasMoreElements()) {
                EntityInstance child = (EntityInstance)children.nextElement();
                if (grp == null) {
                    grp = new Vector<EntityInstance>();
                }
                grp.addElement(child);
            }
        }
        return grp;
    }

    public Vector getReclusterGroup() {
        Vector grp = this.getGroupedEntities();
        if (grp != null) {
            return grp;
        }
        grp = this.getGroupedRelations();
        if (grp != null) {
            return grp;
        }
        Enumeration children = this.m_drawRoot.getChildrenShown();
        while (children.hasMoreElements()) {
            if (grp == null) {
                grp = new Vector();
            }
            grp.addElement(children.nextElement());
        }
        return grp;
    }

    public Vector getTargetGroup(Object object) {
        Vector v = object != null ? this.targetEntities(object) : this.getClusterGroup();
        return v;
    }

    @Override
    public Clipboard getClipboard() {
        return this.m_clipboard;
    }

    @Override
    protected void setClipboard(Clipboard value) {
        this.m_clipboard = value;
        this.m_ls.clipboardChanged();
    }

    protected void relayoutSubtree(EntityInstance container, boolean compute) {
        Enumeration en = container.getChildrenShown();
        while (en.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en.nextElement();
            e.setRelLocal(-1.0, -1.0, e.widthRelLocal(), e.heightRelLocal());
            this.relayoutSubtree(e, compute);
        }
    }

    protected void doRelayoutAll(EntityInstance e, boolean compute) {
        if (this.undoEnabled()) {
            this.logEdit(new RelayoutSubtree(this, e, compute));
        }
        this.relayoutSubtree(e, compute);
    }

    protected void doRelayoutAll(boolean layout) {
        this.doRelayoutAll(this.m_drawRoot, layout);
    }

    public String relayoutAll() {
        RelayoutDialog relayoutDialog = new RelayoutDialog();
        String ret = relayoutDialog.msg();
        relayoutDialog.dispose();
        return ret;
    }

    public String closeAll() {
        this.m_drawRoot.closeDescendants();
        this.revalidate();
        return "Entities closed";
    }

    public String openAll() {
        this.m_drawRoot.openDescendants();
        return "Entities opened";
    }

    protected void centerDiagramOn(int x, int y) {
        Option diagramOptions = Options.getDiagramOptions();
        double zoom_x = diagramOptions.getZoomX();
        double zoom_y = diagramOptions.getZoomY();
        if (zoom_x > 1.0 || zoom_y > 1.0) {
            int max;
            JScrollPane scrollPane = this.m_ls.m_scrollDiagram;
            JViewport viewport = scrollPane.getViewport();
            Dimension d = this.getPreferredSize();
            int width1 = d.width;
            int height1 = d.height;
            int width2 = (int)((double)width1 / zoom_x);
            int height2 = (int)((double)height1 / zoom_y);
            if (x < 0) {
                x = 0;
            } else {
                max = width1 - width2;
                if (x > max) {
                    x = max;
                }
            }
            if (y < 0) {
                y = 0;
            } else {
                max = height1 - height2;
                if (y > max) {
                    y = max;
                }
            }
            scrollPane.validate();
            viewport.setViewPosition(new Point(x, y));
        }
    }

    protected void centerDiagramOn(EntityInstance e) {
        Option diagramOptions = Options.getDiagramOptions();
        double zoom_x = diagramOptions.getZoomX();
        double zoom_y = diagramOptions.getZoomY();
        if (zoom_x > 1.0 || zoom_y > 1.0) {
            Dimension d = this.getPreferredSize();
            int width1 = d.width;
            int height1 = d.height;
            int width2 = (int)((double)width1 / zoom_x);
            int height2 = (int)((double)height1 / zoom_y);
            int x_center = (int)((e.xRelLocal() + e.widthRelLocal() / 2.0) * (double)width1);
            int y_center = (int)((e.yRelLocal() + e.heightRelLocal() / 2.0) * (double)height1);
            int x = x_center - width2 / 2;
            int y = y_center - height2 / 2;
            this.centerDiagramOn(x, y);
        }
    }

    protected void scale(EntityInstance e, double wf, double hf, boolean doContainer, boolean doPos) {
        if (doContainer) {
            double x1 = e.xRelLocal();
            double y1 = e.yRelLocal();
            double w1 = e.widthRelLocal() * wf;
            double h1 = e.heightRelLocal() * hf;
            if (doPos) {
                x1 *= wf;
                y1 *= hf;
            }
            this.updateRelLocal(e, x1, y1, w1, h1);
        } else {
            Enumeration en = e.getChildren();
            while (en.hasMoreElements()) {
                EntityInstance e1 = (EntityInstance)en.nextElement();
                this.scale(e1, wf, hf, true, true);
            }
        }
    }

    public void scale(EntityInstance e, double sf, boolean doContainer, boolean doPos) {
        this.scale(e, sf, sf, doContainer, doPos);
    }

    public void scale(EntityInstance e, double sf, boolean doContainer) {
        this.scale(e, sf, sf, doContainer, false);
    }

    public void scale(EntityInstance e, double sf) {
        this.scale(e, sf, sf, true, false);
    }

    public void scaleX(EntityInstance e, double sf, boolean doContainer, boolean doPos) {
        this.scale(e, sf, 1.0, doContainer, doPos);
    }

    public void scaleX(EntityInstance e, double sf, boolean doContainer) {
        this.scale(e, sf, 1.0, doContainer, false);
    }

    public void scaleX(EntityInstance e, double sf) {
        this.scale(e, sf, 1.0, true, false);
    }

    public void scaleY(EntityInstance e, double sf, boolean doContainer, boolean doPos) {
        this.scale(e, 1.0, sf, doContainer, doPos);
    }

    public void scaleY(EntityInstance e, double sf, boolean doContainer) {
        this.scale(e, 1.0, sf, doContainer, false);
    }

    public void scaleY(EntityInstance e, double sf) {
        this.scale(e, 1.0, sf, true, false);
    }

    public String scaleEntity(int scale, boolean incFlag) {
        Vector grp = this.getClusterGroup();
        String msg = null;
        EntityInstance e = null;
        if (grp != null) {
            block0 : switch (grp.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    e = (EntityInstance)grp.firstElement();
                    if (e.isDrawRoot()) break;
                }
                default: {
                    switch (scale) {
                        case 77: 
                        case 109: {
                            if (e != null) break block0;
                            e = (EntityInstance)grp.firstElement();
                            break block0;
                        }
                        default: {
                            Enumeration en = grp.elements();
                            while (en.hasMoreElements()) {
                                EntityInstance ge = (EntityInstance)en.nextElement();
                                switch (scale) {
                                    case 120: {
                                        this.scaleX(ge, 0.8, incFlag);
                                        break;
                                    }
                                    case 88: {
                                        this.scaleX(ge, 1.2, incFlag);
                                        break;
                                    }
                                    case 121: {
                                        this.scaleY(ge, 0.8, incFlag);
                                        break;
                                    }
                                    case 89: {
                                        this.scaleY(ge, 1.2, incFlag);
                                        break;
                                    }
                                    case 122: {
                                        this.scale(ge, 0.8, incFlag);
                                        break;
                                    }
                                    case 90: {
                                        this.scale(ge, 1.2, incFlag);
                                    }
                                }
                            }
                            return msg;
                        }
                    }
                }
            }
        }
        switch (scale) {
            case 77: {
                if (e != null) {
                    if (this.updateZoom(1.2, 1.2)) {
                        msg = "Magnified " + e.getEntityLabel();
                    }
                    this.centerDiagramOn(e);
                    break;
                }
            }
            case 90: {
                if (!this.updateZoom(1.2, 1.2)) break;
                msg = "Zoomed in";
                break;
            }
            case 109: {
                if (e != null) {
                    if (this.updateZoom(0.8, 0.8)) {
                        msg = "Reduced " + e.getEntityLabel();
                    }
                    this.centerDiagramOn(e);
                    break;
                }
            }
            case 122: {
                if (!this.updateZoom(0.8, 0.8)) break;
                msg = "Zoomed out";
                break;
            }
            case 88: {
                if (!this.updateZoom(1.2, 1.0)) break;
                msg = "Zoomed in X direction";
                break;
            }
            case 120: {
                if (!this.updateZoom(0.8, 1.0)) break;
                msg = "Zoomed out X direction";
                break;
            }
            case 89: {
                if (!this.updateZoom(1.0, 1.2)) break;
                msg = "Zoomed in Y direction";
                break;
            }
            case 121: {
                if (!this.updateZoom(1.0, 0.8)) break;
                msg = "Zoomed out Y direction";
            }
        }
        Option diagramOptions = Options.getDiagramOptions();
        double zoom_x = diagramOptions.getZoomX();
        double zoom_y = diagramOptions.getZoomY();
        msg = msg + " (20%) to " + zoom_x + "x" + zoom_y;
        return msg;
    }

    public String handleElision(int key, Object object) {
        String em = "";
        Vector grp = this.targetEntities(object);
        boolean open = false;
        EntityInstance ke = null;
        if (grp == null || grp.size() == 0) {
            return "Nothing selected";
        }
        switch (key) {
            case 99: {
                em = "Containment";
                ke = grp.size() == 1 ? (EntityInstance)grp.elementAt(0) : this.getKeyEntity();
                if (ke == null) {
                    return "Unable to identify key entity to open/close";
                }
                open = ke.isStateOpen();
                break;
            }
            case 117: {
                em = "Target ";
                break;
            }
            case 115: {
                em = "Source ";
                break;
            }
            case 85: {
                em = "Entering";
                break;
            }
            case 83: {
                em = "Exiting";
                break;
            }
            case 73: {
                em = "Internal edges";
                break;
            }
            default: {
                return null;
            }
        }
        Enumeration en = grp.elements();
        while (en.hasMoreElements()) {
            EntityInstance ge = (EntityInstance)en.nextElement();
            switch (key) {
                case 99: {
                    boolean geopen = ge.isStateOpen();
                    if (ge != ke && open != geopen) break;
                    if (geopen) {
                        ge.setStateClosed();
                        break;
                    }
                    ge.setStateOpen();
                    break;
                }
                case 117: {
                    this.toggleDstElision(ge);
                    break;
                }
                case 115: {
                    this.toggleSrcElision(ge);
                    break;
                }
                case 85: {
                    this.toggleEnteringElision(ge);
                    break;
                }
                case 83: {
                    this.toggleExitingElision(ge);
                    break;
                }
                case 73: {
                    this.toggleInternalElision(ge);
                }
            }
        }
        this.revalidate();
        return em + " elision toggled for group";
    }

    public boolean openEdgeExpansion(EntityInstance me, EntityInstance from, EntityInstance to, String indent, ResultBox resultBox) {
        Vector srcRelList = me.getSrcRelList();
        boolean ret = false;
        if (srcRelList != null) {
            String indent1 = indent;
            Enumeration en = srcRelList.elements();
            while (en.hasMoreElements()) {
                RelationInstance ri = (RelationInstance)en.nextElement();
                EntityInstance dst = ri.getDst();
                if (me == from && dst == to || !to.hasDescendantOrSelf(dst)) continue;
                ret = true;
                resultBox.addRelation(indent, ri);
                if (indent1 == indent) {
                    indent1 = indent + "+- ";
                }
                this.setHighlightFlag(ri);
                if (dst == to) continue;
                do {
                    dst = dst.getContainedBy();
                    dst.setStateOpen();
                } while (dst != to);
            }
            boolean opened = false;
            en = me.getChildren();
            while (en.hasMoreElements()) {
                EntityInstance e = (EntityInstance)en.nextElement();
                boolean ret1 = this.openEdgeExpansion(e, from, to, indent1, resultBox);
                if (!ret1 || opened) continue;
                opened = true;
                ret = true;
                me.setStateOpen();
            }
        }
        return ret;
    }

    public boolean openSrcEdgeExpansion(EntityInstance me, EntityInstance from, EntityInstance to, String indent, ResultBox resultBox) {
        Vector srcRelList = me.getSrcRelList();
        boolean ret = false;
        if (srcRelList != null) {
            String indent1 = indent;
            Enumeration en = srcRelList.elements();
            while (en.hasMoreElements()) {
                RelationInstance ri = (RelationInstance)en.nextElement();
                EntityInstance dst = ri.getDst();
                if (me == from && dst == to || !to.hasDescendantOrSelf(dst)) continue;
                ret = true;
                resultBox.addRelation(indent, ri);
                if (indent1 == indent) {
                    indent1 = indent + "+- ";
                }
                this.setHighlightFlag(ri);
            }
            boolean opened = false;
            en = me.getChildren();
            while (en.hasMoreElements()) {
                EntityInstance e = (EntityInstance)en.nextElement();
                boolean ret1 = this.openSrcEdgeExpansion(e, from, to, indent1, resultBox);
                if (!ret1 || opened) continue;
                opened = true;
                ret = true;
                me.setStateOpen();
            }
        }
        return ret;
    }

    public boolean openDstEdgeExpansion(EntityInstance me, EntityInstance from, EntityInstance to, String indent, ResultBox resultBox) {
        Enumeration en;
        Vector dstRelList = me.getDstRelList();
        boolean ret = false;
        String indent1 = indent;
        if (dstRelList != null) {
            en = dstRelList.elements();
            while (en.hasMoreElements()) {
                RelationInstance ri = (RelationInstance)en.nextElement();
                EntityInstance src = ri.getSrc();
                if (src == from && me == to || !from.hasDescendantOrSelf(src)) continue;
                ret = true;
                resultBox.addRelation(indent, ri);
                if (indent1 == indent) {
                    indent1 = indent + "+- ";
                }
                this.setHighlightFlag(ri);
            }
        }
        boolean opened = false;
        en = me.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en.nextElement();
            boolean ret1 = this.openDstEdgeExpansion(e, from, to, indent1, resultBox);
            if (!ret1 || opened) continue;
            opened = true;
            ret = true;
            me.setStateOpen();
        }
        return ret;
    }

    protected boolean handleEdgeExpansion(int key, Object object, ResultBox resultBox) {
        String msg1;
        Vector edges = this.targetRelations(object);
        if (edges == null) {
            return false;
        }
        String msg = null;
        switch (key) {
            case 105: {
                msg1 = "Opened sources and destinations of edges.";
                break;
            }
            case 79: {
                msg1 = "Opened sources of edges.";
                break;
            }
            case 111: {
                msg1 = "Opened destination of edges.";
                break;
            }
            case 73: {
                msg1 = "Closed source and destination of edges";
                break;
            }
            case 67: {
                msg1 = "Closed source of edges";
                break;
            }
            default: {
                msg1 = "Closed source and destination of edges";
            }
        }
        resultBox.setResultTitle("SELECTED RELATIONS:");
        EntityInstance drawRoot = this.getDrawRoot();
        Enumeration en = edges.elements();
        block18: while (en.hasMoreElements()) {
            RelationInstance ri = (RelationInstance)en.nextElement();
            this.setGroupAndHighlightFlag(ri);
            EntityInstance src = ri.getDrawSrc();
            EntityInstance dst = ri.getDrawDst();
            switch (key) {
                case 105: {
                    if (!this.openEdgeExpansion(src, src, dst, "", resultBox)) continue block18;
                    msg = msg1;
                    continue block18;
                }
                case 79: {
                    if (!this.openSrcEdgeExpansion(src, src, dst, "", resultBox)) continue block18;
                    msg = msg1;
                    continue block18;
                }
                case 111: {
                    if (!this.openDstEdgeExpansion(dst, src, dst, "", resultBox)) continue block18;
                    msg = msg1;
                    continue block18;
                }
                case 73: {
                    dst = ri.getDst();
                    src = ri.getSrc();
                    while ((src = src.getContainedBy()) != null && drawRoot.hasDescendant(src) && src != dst && !src.hasDescendant(dst)) {
                        if (!src.setStateClosed()) continue;
                        msg = msg1;
                    }
                    while ((dst = dst.getContainedBy()) != null && drawRoot.hasDescendant(dst) && src != dst && !dst.hasDescendant(src)) {
                        if (!dst.setStateClosed()) continue;
                        msg = msg1;
                    }
                    break;
                }
                case 67: {
                    dst = ri.getDst();
                    src = ri.getSrc();
                    while ((src = src.getContainedBy()) != null && drawRoot.hasDescendant(src) && src != dst && !src.hasDescendant(dst)) {
                        if (!src.setStateClosed()) continue;
                        msg = msg1;
                    }
                    break;
                }
                case 99: {
                    dst = ri.getDst();
                    src = ri.getSrc();
                    while ((dst = dst.getContainedBy()) != null && drawRoot.hasDescendant(dst) && src != dst && !dst.hasDescendant(src)) {
                        if (!dst.setStateClosed()) continue;
                        msg = msg1;
                    }
                    break;
                }
            }
            resultBox.addRelation(ri);
        }
        resultBox.done("-- End --");
        if (this.clearDrawEntities() || this.clearDrawEdges()) {
            this.revalidate();
        }
        if (msg != null) {
            this.m_ls.doFeedback(msg);
            return true;
        }
        switch (key) {
            case 79: 
            case 105: 
            case 111: {
                msg = "No further expansion is possible";
                break;
            }
            default: {
                msg = "No further contraction is possible";
            }
        }
        this.m_ls.error(msg);
        return false;
    }

    protected void setHighlightFlag(EntityInstance src, EntityInstance dst, RelationClass rc) {
        Vector srcLiftedList = src.getSrcLiftedList();
        if (srcLiftedList != null) {
            int i = srcLiftedList.size();
            while (--i >= 0) {
                RelationInstance ri = (RelationInstance)srcLiftedList.elementAt(i);
                if (ri.getDrawDst() != dst || ri.getRelationClass() != rc) continue;
                this.setHighlightFlag(ri);
                break;
            }
        }
    }

    public void addToTracedList(boolean forward, EntityInstance e, EntityInstance te, RelationClass rc, boolean markFlag, boolean groupingFlag, Vector list, int steps, boolean traceLifted) {
        EntityInstance dst;
        RelationInstance ri;
        int i;
        this.setTracedFlag(e);
        if (steps == 0) {
            return;
        }
        Vector relList = e.getDstRelList();
        int size = 0;
        for (int direction = 2; direction != 0; --direction) {
            i = 0;
            if (relList == null) {
                size = 0;
            } else {
                size = relList.size();
                if (rc != null) {
                    int direction2 = rc.getActive();
                    switch (direction2) {
                        case 1: 
                        case 2: {
                            if (forward ^ direction2 != direction) break;
                        }
                        case 0: {
                            i = size;
                        }
                    }
                }
            }
            while (i < size) {
                block32: {
                    EntityInstance temp;
                    RelationClass rc1;
                    block33: {
                        block31: {
                            ri = (RelationInstance)relList.elementAt(i);
                            rc1 = ri.getRelationClass();
                            if (rc != null) break block31;
                            int direction1 = rc1.getActive();
                            switch (direction1) {
                                case 1: 
                                case 2: {
                                    if (forward ^ direction1 != direction) break;
                                }
                                case 0: {
                                    break block32;
                                }
                            }
                            break block33;
                        }
                        if (rc1 != rc) break block32;
                    }
                    EntityInstance drawSrc = ri.getDrawSrc();
                    EntityInstance drawDst = ri.getDrawDst();
                    if (direction == 1) {
                        dst = ri.getDst();
                    } else {
                        temp = drawSrc;
                        drawSrc = drawDst;
                        drawDst = temp;
                        dst = ri.getSrc();
                    }
                    if (!dst.isMarked(0x100000)) {
                        if (drawSrc != null && drawDst != null && (drawSrc.isMarked(1) || drawDst.isMarked(1)) && markFlag) {
                            this.setRedBoxFlag(drawDst);
                            if (groupingFlag && drawDst.isMarked(1)) {
                                this.setEntityGroupFlag(drawDst);
                            }
                            if (direction != 1) {
                                temp = drawSrc;
                                drawSrc = drawDst;
                                drawDst = temp;
                            }
                            this.setHighlightFlag(drawSrc, drawDst, rc1);
                        }
                        dst.orMark(0x100000);
                        if (rc == null) {
                            if (markFlag) {
                                list.addElement(ri);
                            } else {
                                list.addElement(dst);
                            }
                            this.addToTracedList(forward, dst, dst, rc, markFlag, groupingFlag, list, steps - 1, traceLifted);
                        } else if (e == te) {
                            list.addElement(dst);
                        } else {
                            list.addElement(ri);
                        }
                    }
                }
                ++i;
            }
            relList = e.getSrcRelList();
        }
        if (!te.isOpen() && traceLifted) {
            for (i = 0; i < size; ++i) {
                ri = (RelationInstance)relList.elementAt(i);
                if (!ri.isMarked(0x100000)) continue;
                dst = ri.getDst();
                this.addToTracedList(forward, dst, te, rc, markFlag, groupingFlag, list, steps, traceLifted);
            }
        }
    }

    protected void clearFoundList(Vector list) {
        int i = list.size();
        while (--i >= 0) {
            EntityInstance e;
            Object object = list.elementAt(i);
            if (object instanceof EntityInstance) {
                e = (EntityInstance)object;
                e.nandMark(0x100000);
                continue;
            }
            if (!(object instanceof RelationInstance)) continue;
            RelationInstance ri = (RelationInstance)object;
            e = ri.getSrc();
            e.nandMark(0x100000);
            e = ri.getDst();
            e.nandMark(0x100000);
        }
    }

    protected int addTracedRelations(boolean forward, EntityInstance e, RelationClass rc, ResultBox resultBox, boolean groupingFlag, int steps, boolean traceLifted) {
        Vector list = new Vector();
        this.addToTracedList(forward, e, e, rc, true, groupingFlag, list, steps, traceLifted);
        int size = list.size();
        if (size > 0) {
            this.clearFoundList(list);
            resultBox.addRelations(e, rc, list, forward, rc == null);
        }
        return size;
    }

    protected int addTracedRelationClasses(boolean forward, EntityInstance e, ResultBox resultBox, boolean groupingFlag, int steps, boolean traceLifted) {
        int num = 0;
        Enumeration en = this.enumRelationClasses();
        while (en.hasMoreElements()) {
            RelationClass rc = (RelationClass)en.nextElement();
            if (!rc.isActive()) continue;
            num += this.addTracedRelations(forward, e, rc, resultBox, groupingFlag, steps, traceLifted);
        }
        return num;
    }

    protected int showContents(EntityInstance e, ResultBox resultBox) {
        Vector list = new Vector();
        int n = 0;
        Enumeration en = e.getChildren();
        while (en.hasMoreElements()) {
            list.add(en.nextElement());
            ++n;
        }
        if (n > 0) {
            SortVector.byString(list);
        }
        resultBox.addContents(e, list);
        return n;
    }

    protected int showContentsWithClosure(EntityInstance e, ResultBox resultBox) {
        int n = this.showContents(e, resultBox);
        Enumeration en = e.getChildren();
        while (en.hasMoreElements()) {
            n += this.showContentsWithClosure((EntityInstance)en.nextElement(), resultBox);
        }
        return n;
    }

    protected int doQueryEntity(EntityInstance e, int query, ResultBox resultBox, boolean groupingFlag, int steps) {
        Option option = Options.getDiagramOptions();
        boolean traceLifted = option.isTraceLifted();
        switch (query) {
            case 102: {
                return this.addTracedRelationClasses(true, e, resultBox, groupingFlag, steps, traceLifted);
            }
            case 98: {
                return this.addTracedRelationClasses(false, e, resultBox, groupingFlag, steps, traceLifted);
            }
            case 70: {
                return this.addTracedRelations(true, e, null, resultBox, groupingFlag, steps, traceLifted);
            }
            case 66: {
                return this.addTracedRelations(false, e, null, resultBox, groupingFlag, steps, traceLifted);
            }
            case 118: {
                return this.showContents(e, resultBox);
            }
            case 86: {
                return this.showContentsWithClosure(e, resultBox);
            }
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean rootCause1(EntityInstance e, EntityInstance te, Vector list, boolean groupingFlag) {
        Vector relList = e.getDstRelList();
        int size = 0;
        boolean ret = false;
        if (e.isMarked(0x100000)) {
            return e.isMarked(0x8000000);
        }
        e.orMark(0x100000);
        list.addElement(e);
        int direction = 2;
        while (true) {
            EntityInstance dst;
            RelationInstance ri;
            int i;
            if (direction != 0) {
                size = relList == null ? 0 : relList.size();
            } else {
                if (!te.isOpen()) {
                    for (i = 0; i < size; ++i) {
                        ri = (RelationInstance)relList.elementAt(i);
                        if (!ri.isMarked(0x100000)) continue;
                        dst = ri.getDst();
                        ret |= this.rootCause1(dst, te, list, false);
                    }
                }
                return ret;
            }
            block6: for (i = 0; i < size; ++i) {
                EntityInstance temp;
                ri = (RelationInstance)relList.elementAt(i);
                RelationClass rc1 = ri.getRelationClass();
                int direction1 = rc1.getActive();
                switch (direction1) {
                    case 1: 
                    case 2: {
                        if (direction1 == direction) break;
                    }
                    case 0: {
                        continue block6;
                    }
                }
                EntityInstance drawSrc = ri.getDrawSrc();
                EntityInstance drawDst = ri.getDrawDst();
                if (direction == 1) {
                    dst = ri.getDst();
                } else {
                    temp = drawSrc;
                    drawSrc = drawDst;
                    drawDst = temp;
                    dst = ri.getSrc();
                }
                boolean ret1 = dst.isMarked(0x8000000);
                if (!(ret1 |= this.rootCause1(dst, dst, list, groupingFlag))) continue;
                ret = true;
                e.orMark(0x8000000);
                if (drawSrc == null || drawDst == null || !drawSrc.isMarked(1) && !drawDst.isMarked(1)) continue;
                if (groupingFlag && e.isMarked(1)) {
                    this.setEntityGroupFlag(e);
                }
                if (direction != 1) {
                    temp = drawSrc;
                    drawSrc = drawDst;
                    drawDst = temp;
                }
                this.setHighlightFlag(drawSrc, drawDst, rc1);
            }
            relList = e.getSrcRelList();
            --direction;
        }
    }

    private int rootCause(Vector grp, ResultBox resultBox, boolean groupingFlag) {
        EntityInstance e;
        int i;
        int size = grp.size();
        Vector<EntityInstance> list = null;
        int last = 0;
        Vector<EntityInstance> list1 = new Vector<EntityInstance>();
        for (i = 0; i < size; ++i) {
            e = (EntityInstance)grp.elementAt(i);
            resultBox.addResultEntity(e, 0);
            list1.addElement(e);
            this.addToTracedList(true, e, e, null, false, false, list1, -1, true);
            this.clearFoundList(list1);
            if (i == 0) {
                list = list1;
                last = list.size() - 1;
                list1 = new Vector();
            } else {
                EntityInstance e1;
                int j = list1.size();
                while (0 <= --j) {
                    e1 = (EntityInstance)list1.elementAt(j);
                    e1.orMark(0x8000000);
                }
                for (j = last; 0 <= j; --j) {
                    e1 = (EntityInstance)list.elementAt(j);
                    if (e1.isMarked(0x8000000)) continue;
                    if (j != last) {
                        list.setElementAt((EntityInstance)list.elementAt(last), j);
                    }
                    list.removeElementAt(last);
                    --last;
                }
                j = list1.size();
                while (0 <= --j) {
                    e1 = (EntityInstance)list1.elementAt(j);
                    e1.nandMark(0x8000000);
                }
                list1.removeAllElements();
            }
            if (last >= 0) continue;
            return 0;
        }
        SortVector.byPreorder(list, true);
        resultBox.addResultTitle("Collectively depend on");
        for (i = 0; i <= last; ++i) {
            e = (EntityInstance)list.elementAt(i);
            e.orMark(0x8000000);
            this.setRedBoxFlag(e);
            if (groupingFlag && e.isMarked(1)) {
                this.setEntityGroupFlag(e);
            }
            resultBox.addResultEntity(e, 0);
        }
        list1.removeAllElements();
        i = size;
        while (i > 0) {
            e = (EntityInstance)grp.elementAt(--i);
            this.rootCause1(e, e, list1, groupingFlag);
        }
        i = list1.size();
        while (--i >= 0) {
            e = (EntityInstance)list1.elementAt(i);
            e.nandMark(0x8100000);
        }
        return last + 1;
    }

    public void queryEntity(int query, Object object, ResultBox resultBox, int forSteps) {
        EntityInstance ge;
        Enumeration en;
        String title;
        boolean groupingFlag = Options.isGroupQuery();
        boolean contentQuery = false;
        Vector<EntityInstance> grp = this.targetEntities(object);
        int steps = 1;
        this.clearQueryFlags(false);
        switch (query) {
            case 118: {
                title = "CONTENTS";
                contentQuery = true;
                break;
            }
            case 98: 
            case 102: {
                title = query == 102 ? "FORWARD QUERY" : "BACKWARD QUERY";
                int mode = 0;
                if (grp != null) {
                    en = grp.elements();
                    while (en.hasMoreElements()) {
                        ge = (EntityInstance)en.nextElement();
                        if (ge.isMarked(6)) {
                            mode |= 2;
                            continue;
                        }
                        mode |= 1;
                    }
                }
                switch (mode) {
                    case 2: {
                        title = title + " IN DIAGRAM";
                        break;
                    }
                    case 3: {
                        title = title + " IN DIAGRAM WHEN CLIENT/SUPPLIER";
                    }
                }
                break;
            }
            case 86: {
                contentQuery = true;
            }
            case 66: 
            case 70: 
            case 82: {
                switch (query) {
                    case 70: {
                        title = "FORWARD QUERY ";
                        break;
                    }
                    case 66: {
                        title = "BACK QUERY ";
                        break;
                    }
                    case 86: {
                        title = "CONTENTS";
                        break;
                    }
                    default: {
                        title = "FORWARD ROOT CAUSE ";
                    }
                }
                steps = forSteps;
                if (steps >= 0) break;
                steps = this.m_diagramOptions.getChaseEdges();
                break;
            }
            default: {
                title = null;
            }
        }
        title = steps < 0 ? title + "(closure)" : title + "(+" + steps + ")";
        resultBox.setResultTitle(title);
        if (grp == null || grp.isEmpty()) {
            grp = new Vector<EntityInstance>();
            grp.addElement(this.getDrawRoot());
        }
        int num = 0;
        if (query == 82) {
            num = this.rootCause(grp, resultBox, groupingFlag);
        } else {
            en = grp.elements();
            while (en.hasMoreElements()) {
                ge = (EntityInstance)en.nextElement();
                num += this.doQueryEntity(ge, query, resultBox, groupingFlag, steps);
            }
        }
        String footer = num == 0 ? "NO ENTITIES" : "-- End of Query --";
        resultBox.done(footer);
        resultBox.activate();
        if (!contentQuery) {
            this.clearDrawEntities();
            this.clearDrawEdges();
            this.revalidate();
        }
    }

    public boolean newEntityClass() {
        String message = "Enter new entry class name";
        String id;
        while ((id = JOptionPane.showInputDialog(message)) != null) {
            EntityClass ec = this.getEntityClass(id);
            if (ec == null) {
                this.beginUndoRedo("New entity class");
                this.updateNewEntityClass(id, this.m_entityBaseClass);
                this.endUndoRedo();
                return true;
            }
            message = id + " in use. Enter new name";
        }
        return false;
    }

    public RelationClass newRelationClass() {
        String message = "Enter new relation class name";
        String id;
        while ((id = JOptionPane.showInputDialog(message)) != null) {
            if ((id = id.trim()) == null) {
                return null;
            }
            RelationClass rc = this.getRelationClass(id);
            if (rc == null) {
                rc = this.updateNewRelationClass(id, this.m_relationBaseClass);
                return rc;
            }
            message = id + " in use. Enter new name";
        }
        return null;
    }

    public void alsoValidateSubclasses(Vector v, String title) {
        String message;
        int size = v.size();
        switch (size) {
            case 1: {
                return;
            }
            case 2: {
                LandscapeClassObject o = (LandscapeClassObject)v.elementAt(1);
                message = "Also validate subclass " + o.getLabel();
                break;
            }
            default: {
                LandscapeClassObject o = (LandscapeClassObject)v.elementAt(1);
                message = "Also validate subclasses " + o.getLabel();
                int i = 2;
                while (i < size) {
                    o = (LandscapeClassObject)v.elementAt(i);
                    message = ++i == size ? message + " and " : message + ", ";
                    message = message + o.getLabel();
                }
                break block0;
            }
        }
        LandscapeClassObject first = (LandscapeClassObject)v.elementAt(0);
        switch (JOptionPane.showConfirmDialog(null, message, "Validating " + first.getLabel() + title, 1)) {
            case 0: {
                break;
            }
            case 1: {
                v.removeAllElements();
                v.add(first);
                break;
            }
            default: {
                v.removeAllElements();
            }
        }
    }

    public void showValidAttributes(LandscapeClassObject o, ResultBox resultBox) {
        resultBox.addResultTitle("Valid attributes of " + o.getLabel());
        Vector v = o.getValidAttributes();
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            Attribute attribute = (Attribute)v.elementAt(i);
            resultBox.addResultAttribute(attribute);
        }
        resultBox.addResultTitle("Lsedit class attributes");
        o.reportClassAttributes(resultBox);
        resultBox.addResultTitle("Lsedit first order attributes");
        if (o instanceof EntityClass) {
            EntityInstance.reportFirstOrderAttributes(resultBox);
        } else {
            RelationInstance.reportFirstOrderAttributes(resultBox);
        }
        resultBox.done("End of report");
        resultBox.activate();
    }

    public void validateEntityAttributes(EntityClass ec, ResultBox resultBox, boolean query) {
        String message;
        int errors;
        Vector v = this.getClassAndSubclasses(ec);
        if (query) {
            this.alsoValidateSubclasses(v, " attributes");
            if (v.size() == 0) {
                return;
            }
        }
        Vector[] a = new Vector[v.size()];
        resultBox.addResultTitle("Validating attributes of " + ec.getLabel() + (v.size() <= 1 ? "" : " and subclasses") + (this.m_drawRoot == this.m_rootInstance ? "" : " under " + this.m_drawRoot.getEntityLabel()));
        resultBox.activate();
        if (this.m_drawRoot != this.m_rootInstance) {
            errors = this.m_drawRoot.validateEntityAttributes(v, a, resultBox);
        } else {
            errors = 0;
            Enumeration en = this.m_rootInstance.getChildren();
            while (en.hasMoreElements()) {
                EntityInstance child = (EntityInstance)en.nextElement();
                errors += child.validateEntityAttributes(v, a, resultBox);
            }
        }
        switch (errors) {
            case 0: {
                message = "No errors";
                break;
            }
            case 1: {
                message = "1 erroneous entity encountered during validation";
                break;
            }
            default: {
                message = errors + " erroneous entities encountered during validation";
            }
        }
        resultBox.done(message);
    }

    public void validateRelationAttributes(RelationClass rc, ResultBox resultBox, boolean query) {
        String message;
        Vector v = this.getClassAndSubclasses(rc);
        if (query) {
            this.alsoValidateSubclasses(v, " attributes");
            if (v.size() == 0) {
                return;
            }
        }
        Vector[] a = new Vector[v.size()];
        resultBox.addResultTitle("Validating attributes of " + rc.getLabel() + (v.size() <= 1 ? "" : " and subclasses") + (this.m_drawRoot == this.m_rootInstance ? "" : " under " + this.m_drawRoot.getEntityLabel()));
        resultBox.activate();
        int errors = this.m_drawRoot.validateRelationAttributes(v, a, resultBox);
        switch (errors) {
            case 0: {
                message = "No errors";
                break;
            }
            case 1: {
                message = "1 erroneous relation encountered during validation";
                break;
            }
            default: {
                message = errors + " erroneous relations encountered during validation";
            }
        }
        resultBox.done(message);
    }

    public void validateRelations(RelationClass rc, ResultBox resultBox, boolean query) {
        String message;
        Vector v = rc.getClassAndSubclasses(this.m_relationClasses);
        if (query) {
            this.alsoValidateSubclasses(v, " constraints");
            if (v.size() == 0) {
                return;
            }
        }
        boolean[][][] a = new boolean[v.size()][][];
        resultBox.addResultTitle("Validating " + rc.getLabel() + " relations" + (v.size() <= 1 ? "" : " and subclasses") + (this.m_drawRoot == this.m_rootInstance ? "" : " under " + this.m_drawRoot.getEntityLabel()));
        resultBox.activate();
        this.m_drawRoot.clearValidatedMark();
        int errors = this.m_drawRoot.validateRelations(v, a, resultBox, this.m_rootInstance);
        switch (errors) {
            case 0: {
                message = "No errors";
                break;
            }
            case 1: {
                message = "1 erroneous relation encountered during validation";
                break;
            }
            default: {
                message = errors + " erroneous relations encountered during validation";
            }
        }
        resultBox.done(message);
    }

    public void validateAll(ResultBox resultBox) {
        this.validateEntityAttributes(this.m_entityBaseClass, resultBox, false);
        this.validateRelationAttributes(this.m_relationBaseClass, resultBox, false);
        this.validateRelations(this.m_relationBaseClass, resultBox, false);
    }

    public void redistribute() {
        this.m_ls.setCursor(3);
        this.beginUndoRedo("Redistribute nodes");
        this.m_ls.doFeedback(Recluster.layout(this));
        this.endUndoRedo();
        this.m_ls.setCursor(0);
    }

    public void group_unconnected() {
        String message;
        int seen = 0;
        Vector v = this.getClusterGroup();
        if (v == null) {
            Util.beep();
            message = "No group selected";
        } else {
            boolean cleared = this.clearFlags(false);
            for (int i = 0; i < v.size(); ++i) {
                EntityInstance e = (EntityInstance)v.elementAt(i);
                if (!e.hasNoEdges()) continue;
                this.setEntityGroupFlag(e);
                ++seen;
            }
            message = seen == 0 ? "No suitable entities detected" : seen + " entities selected";
            if (cleared) {
                this.revalidate();
            }
        }
        this.m_ls.doFeedback(message);
    }

    public void clusterMetrics() {
        if (this.m_clusterMetrics == null) {
            this.m_clusterMetrics = new ClusterMetrics(this.m_ls);
        }
        this.m_clusterMetrics.init(this.m_drawRoot);
        this.m_drawRoot.clusterMetrics(this.m_clusterMetrics, 1);
        this.m_clusterMetrics.showit();
    }

    public void checkRefcnts(ResultBox resultBox) {
        resultBox.activate();
        resultBox.setResultTitle("Checking refcnt's");
        if (this.m_rootInstance != null) {
            this.m_rootInstance.checkRefcnts(resultBox);
        }
        resultBox.done("End of report");
    }

    public int clearElisions(Object object) {
        Vector grp = this.getTargetGroup(object);
        int ret = 0;
        if (grp != null) {
            Enumeration en = grp.elements();
            while (en.hasMoreElements()) {
                EntityInstance e = (EntityInstance)en.nextElement();
                ret += e.clearElisions();
            }
        }
        return ret;
    }

    public int toggleDescendants(Object object) {
        Vector grp = this.getTargetGroup(object);
        int ret = 0;
        if (grp != null) {
            Enumeration en = grp.elements();
            while (en.hasMoreElements()) {
                EntityInstance e = (EntityInstance)en.nextElement();
                if (e.isMarked(524288)) {
                    ret += e.openDescendants();
                    continue;
                }
                ret += e.closeDescendants();
            }
        }
        return ret;
    }

    public void resetIOpoints() {
        int ret;
        if (this.m_rootInstance != null && (ret = JOptionPane.showConfirmDialog(this.m_ls.getFrame(), "Set IO points associated with active entities and relations to default?", "Cancel operation?", 2)) == 0) {
            this.m_rootInstance.resetIOpoints();
        }
    }

    public void resizeEntity(EntityInstance e, Rectangle lyt) {
        double yRelLocal;
        double heightRelLocal;
        double xRelLocal;
        double widthRelLocal;
        EntityComponent entityComponent = e.getEntityComponent();
        EntityComponent parentComponent = (EntityComponent)entityComponent.getParent();
        int parentWidth = parentComponent.getWidth();
        int parentHeight = parentComponent.getHeight();
        if (parentWidth <= 0) {
            widthRelLocal = 0.1;
            xRelLocal = 0.1;
        } else {
            widthRelLocal = parentWidth;
            xRelLocal = (double)(lyt.x - parentComponent.getDiagramX()) / widthRelLocal;
            widthRelLocal = (double)lyt.width / widthRelLocal;
        }
        if (parentHeight <= 0) {
            heightRelLocal = 0.1;
            yRelLocal = 0.1;
        } else {
            heightRelLocal = parentHeight;
            yRelLocal = (double)(lyt.y - parentComponent.getDiagramY()) / heightRelLocal;
            heightRelLocal = (double)lyt.height / heightRelLocal;
        }
        this.beginUndoRedo("Resize " + e);
        this.updateRelLocal(e, xRelLocal, yRelLocal, widthRelLocal, heightRelLocal);
        this.endUndoRedo();
    }

    public void containsClassesChanging() {
        Vector oldChildren = null;
        if (this.getContainsClasses() != null && Options.getDiagramOptions().isFocusAncestor()) {
            oldChildren = this.getGroupedEntities();
            if (oldChildren == null) {
                oldChildren = new Vector();
            }
            if (oldChildren.size() == 0) {
                Enumeration en = this.m_drawRoot.getChildren();
                while (en.hasMoreElements()) {
                    oldChildren.add(en.nextElement());
                }
                if (oldChildren.size() == 0) {
                    oldChildren = null;
                }
            }
        }
        this.m_oldChildren = oldChildren;
    }

    public void containsClassesChanged() {
        Vector oldChildren = this.m_oldChildren;
        this.clearFlags(true);
        if (oldChildren != null) {
            EntityInstance drawRoot;
            EntityInstance newDrawRoot;
            for (newDrawRoot = drawRoot = this.getDrawRoot(); newDrawRoot != null && !newDrawRoot.hasDescendantsOrSelf(oldChildren); newDrawRoot = newDrawRoot.getContainedBy()) {
            }
            if (newDrawRoot != drawRoot && newDrawRoot != null) {
                this.navigateTo(newDrawRoot, false);
            }
            this.m_oldChildren = null;
        }
    }

    public void entityPressed(MouseEvent ev, EntityInstance e, int x, int y) {
        LandscapeEditorCore ls = this.m_ls;
        EditModeHandler modeHandler = ls.getModeHandler();
        ls.showDescription(e, true);
        ((LandscapeModeHandler)modeHandler).entityPressed(ev, e, x, y);
    }

    public void entityDragged(MouseEvent ev, EntityInstance e, int x, int y) {
        EditModeHandler modeHandler = this.m_ls.getModeHandler();
        ((LandscapeModeHandler)modeHandler).entityDragged(ev, e, x, y);
    }

    public void entityReleased(MouseEvent ev, EntityInstance e, int x, int y) {
        LandscapeEditorCore ls = this.m_ls;
        EditModeHandler modeHandler = ls.getModeHandler();
        ((LandscapeModeHandler)modeHandler).entityReleased(ev, e, x, y);
        if (y > 0) {
            ls.m_toolButton[0].requestFocus();
            ls.requestFocus();
        }
    }

    public void relationPressed(MouseEvent ev, RelationInstance ri, int x, int y) {
        LandscapeEditorCore ls = this.m_ls;
        EditModeHandler modeHandler = ls.getModeHandler();
        ls.showDescription(ri, true);
        ((LandscapeModeHandler)modeHandler).relationPressed(ev, ri, x, y);
    }

    public void relationDragged(MouseEvent ev, RelationInstance ri, int x, int y) {
        EditModeHandler modeHandler = this.m_ls.getModeHandler();
        ((LandscapeModeHandler)modeHandler).relationDragged(ev, ri, x, y);
    }

    public void relationReleased(MouseEvent ev, RelationInstance ri, int x, int y) {
        LandscapeEditorCore ls = this.m_ls;
        EditModeHandler modeHandler = ls.getModeHandler();
        ((LandscapeModeHandler)modeHandler).relationReleased(ev, ri, x, y);
        if (y > 0) {
            ls.m_toolButton[0].requestFocus();
            ls.requestFocus();
        }
    }

    public void movedOverThing(MouseEvent ev, Object thing, int x, int y) {
        EditModeHandler modeHandler = this.m_ls.getModeHandler();
        ((LandscapeModeHandler)modeHandler).movedOverThing(ev, thing, x, y);
    }

    public void doUpdateInherits(LandscapeClassObject object, Vector value) {
        this.beginUndoRedo("Update inherits");
        this.updateInherits(object, value);
        this.endUndoRedo();
    }

    public void doUpdateRemoveEntityClass(EntityClass ec) {
        this.beginUndoRedo("Delete " + ec.getLabel() + " entity class");
        this.updateRemoveEntityClass(ec);
        this.clearGroupFlags();
        this.endUndoRedo();
    }

    public void doUpdateRemoveRelationClass(RelationClass rc) {
        this.beginUndoRedo("Delete " + rc.getLabel() + " relation class");
        this.updateRemoveRelationClass(rc);
        this.endUndoRedo();
    }

    private void refillEdges() {
        Container edges = this.m_edges;
        int i = edges.getComponentCount();
        while (--i >= 0) {
            RelationComponent component = (RelationComponent)edges.getComponent(i);
            RelationInstance ri = component.getRelationInstance();
            if (ri.isMarked(524288)) continue;
            ri.orMark(524288);
            component.fill();
        }
    }

    @Override
    public void diagramChanging(Diagram diagram) {
    }

    @Override
    public void diagramChanged(Diagram diagram, int signal) {
    }

    @Override
    public void updateBegins() {
        if (this.m_updating) {
            System.out.println("Diagram nested updateBegins");
            Thread.dumpStack();
        }
        this.m_updating = true;
    }

    @Override
    public void updateEnds() {
        int paintFlags = this.m_flags & 0xF;
        if (!this.m_updating) {
            System.out.println("Diagram not-nested updateEnds");
            Thread.dumpStack();
        }
        this.m_updating = false;
        if (paintFlags != 0) {
            this.m_flags &= 0xFFFFFFF0;
            if ((paintFlags & 1) != 0) {
                this.revalidate();
                return;
            }
            if ((paintFlags & 4) != 0) {
                this.refillEdges();
            }
            if ((paintFlags & 8) != 0) {
                this.m_drawRoot.computeShading();
            }
            if ((paintFlags & 2) != 0) {
                this.repaint();
            }
        }
    }

    public void iconsChange(EntityClass ec) {
        EntityInstance root = this.getRootInstance();
        if (root != null) {
            root.entityIconChanges(ec);
        }
    }

    public void iconPathChanged() {
        Enumeration en = this.enumEntityClasses();
        EntityInstance root = this.getRootInstance();
        while (en.hasMoreElements()) {
            EntityClass ec = (EntityClass)en.nextElement();
            ec.clearIcons();
        }
        if (root != null) {
            root.entityIconChanges(null);
        }
    }

    @Override
    public void entityClassChanged(EntityClass ec, int signal) {
        switch (signal) {
            case 30: 
            case 42: {
                EntityInstance root = this.getRootInstance();
                ec.adjustEdgePoints();
                if (root != null) {
                    root.shapeChanges(ec);
                }
                this.m_flags |= 2;
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 41: {
                EntityInstance root = this.getRootInstance();
                if (root != null) {
                    root.entityAppearanceChanges(ec);
                }
                this.m_flags |= 2;
                break;
            }
            case 43: {
                this.iconsChange(ec);
                this.m_flags |= 2;
            }
        }
    }

    @Override
    public void relationClassChanged(RelationClass rc, int signal) {
        switch (signal) {
            case 30: 
            case 33: {
                EntityInstance root = this.getRootInstance();
                if (root != null) {
                    root.edgeAppearanceChanges(rc);
                }
                this.m_flags |= 2;
                break;
            }
            case 6: {
                this.m_flags |= 1;
                break;
            }
            case 7: {
                this.containsClassesChanging();
                this.m_flags |= 1;
                break;
            }
            case 8: {
                this.containsClassesChanged();
                this.m_flags |= 1;
            }
        }
    }

    @Override
    public void entityParentChanged(EntityInstance e, EntityInstance parent, int signal) {
        switch (signal) {
            case 9: {
                this.navigateTo(parent, true);
                break;
            }
            case 14: {
                this.clearEntityGroupFlag(e);
                break;
            }
            case 11: {
                Vector groupedEntities = this.m_groupedEntities;
                int i = groupedEntities.size();
                while (--i >= 0) {
                    EntityInstance grouped = (EntityInstance)groupedEntities.elementAt(i);
                    if (!e.hasDescendantOrSelf(grouped)) continue;
                    this.clearEntityGroupFlag(grouped);
                }
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 16: 
            case 18: {
                this.m_flags |= 1;
            }
        }
    }

    @Override
    public void relationParentChanged(RelationInstance ri, int signal) {
        this.m_flags |= 1;
    }

    @Override
    public void entityInstanceChanged(EntityInstance e, int signal) {
        switch (signal) {
            case 26: 
            case 27: 
            case 28: {
                e.setEntityBounds();
                this.m_flags |= 0xE;
            }
        }
        e.repaint();
    }

    @Override
    public void relationInstanceChanged(RelationInstance ri, int signal) {
        RelationComponent component = ri.getRelationComponent();
        switch (signal) {
            case 30: {
                if (component == null) break;
                component.styleChanged(ri.getInheritedStyle());
            }
        }
        if (component != null) {
            component.repaint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent ev) {
    }

    @Override
    public void mouseMoved(MouseEvent ev) {
        this.movedOverThing(ev, this, ev.getX(), ev.getY());
    }

    public class RelayoutDialog
    extends JDialog
    implements ActionListener {
        LandscapeLayouter[] m_layouters;
        protected JRadioButton[] m_radioButtons;
        protected JButton[] m_buttons;
        protected JButton m_clearLayoutAll;
        protected JButton m_relayoutAll;
        protected JButton m_setDefault;
        protected JButton m_close;
        protected String m_msg;

        public RelayoutDialog() {
            super(Diagram.this.m_ls.getFrame(), "Reconfigure layouters/clusterers", true);
            this.m_msg = null;
            this.m_layouters = Diagram.this.m_ls.getLayouters();
            int layouts = this.m_layouters.length;
            this.m_buttons = new JButton[layouts];
            Font font = FontCache.getDialogFont();
            Font bold = font.deriveFont(1);
            int x = Diagram.this.getX() + 20;
            int y = Diagram.this.getY() + 20;
            this.setLocation(x, y);
            this.setForeground(ColorCache.get(0, 0, 0));
            this.setBackground(ColorCache.get(192, 192, 192));
            this.setFont(font);
            Container contentPane = this.getContentPane();
            JTabbedPane tabbedPane = new JTabbedPane();
            tabbedPane.addTab("Layouters", null, new LayoutTab(), null);
            tabbedPane.addTab("Clusterers", null, new ClusterTab(), null);
            tabbedPane.addTab("Layout all", null, new RelayoutAllTab(), null);
            contentPane.add("North", tabbedPane);
            JPanel panel = new JPanel();
            panel.setLayout(new FlowLayout());
            this.m_close = new JButton("Close");
            this.m_close.setFont(bold);
            this.m_close.addActionListener(this);
            panel.add(this.m_close);
            contentPane.add((Component)panel, "South");
            this.pack();
            this.setVisible(true);
        }

        public String msg() {
            return this.m_msg;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            Object source = ev.getSource();
            if (source == this.m_close) {
                this.setVisible(false);
                return;
            }
        }

        class RelayoutAllTab
        extends JPanel
        implements ActionListener {
            protected void changeSelected(int i) {
                JRadioButton radioButton = RelayoutDialog.this.m_radioButtons[i];
                LandscapeLayouter layouter = RelayoutDialog.this.m_layouters[i];
                radioButton.setSelected(true);
                String name = layouter.getName();
                RelayoutDialog.this.m_clearLayoutAll.setText("Clear layout for subtree " + Diagram.this.m_drawRoot + " using " + name);
                RelayoutDialog.this.m_relayoutAll.setText("Relayout subtree " + Diagram.this.m_drawRoot + " using " + name);
                RelayoutDialog.this.m_setDefault.setText("Set default layouter to " + layouter.getName());
            }

            public RelayoutAllTab() {
                this.setLayout(new BorderLayout());
                RelayoutDialog.this.m_clearLayoutAll = new JButton();
                RelayoutDialog.this.m_clearLayoutAll.addActionListener(this);
                RelayoutDialog.this.m_relayoutAll = new JButton();
                RelayoutDialog.this.m_relayoutAll.addActionListener(this);
                RelayoutDialog.this.m_setDefault = new JButton();
                RelayoutDialog.this.m_setDefault.addActionListener(this);
                int layouts = RelayoutDialog.this.m_layouters.length;
                RelayoutDialog.this.m_radioButtons = new JRadioButton[layouts];
                LandscapeLayouter layouter = Diagram.this.m_ls.getLayouter();
                Font font = FontCache.getDialogFont();
                Font bold = font.deriveFont(1);
                JPanel grid = new JPanel();
                grid.setLayout(new GridLayout(9, 1, 0, 10));
                ButtonGroup buttonGroup = new ButtonGroup();
                for (int i = 0; i < layouts; ++i) {
                    JRadioButton radioButton;
                    if (!RelayoutDialog.this.m_layouters[i].isLayouter()) continue;
                    RelayoutDialog.this.m_radioButtons[i] = radioButton = new JRadioButton(RelayoutDialog.this.m_layouters[i].getMenuLabel());
                    radioButton.setFont(bold);
                    radioButton.addActionListener(this);
                    if (RelayoutDialog.this.m_layouters[i] == layouter) {
                        this.changeSelected(i);
                    }
                    buttonGroup.add(radioButton);
                    grid.add(radioButton);
                }
                grid.add(RelayoutDialog.this.m_clearLayoutAll);
                grid.add(RelayoutDialog.this.m_relayoutAll);
                grid.add(RelayoutDialog.this.m_setDefault);
                this.add((Component)grid, "Center");
            }

            @Override
            public void actionPerformed(ActionEvent ev) {
                Object source = ev.getSource();
                int cnt = RelayoutDialog.this.m_radioButtons.length;
                if (source == RelayoutDialog.this.m_clearLayoutAll || source == RelayoutDialog.this.m_relayoutAll || source == RelayoutDialog.this.m_setDefault) {
                    for (int i = 0; i < cnt; ++i) {
                        JRadioButton radioButton = RelayoutDialog.this.m_radioButtons[i];
                        if (radioButton == null || !radioButton.isSelected()) continue;
                        if (source == RelayoutDialog.this.m_setDefault) {
                            Diagram.this.m_ls.defaultToLayouter(i);
                            break;
                        }
                        Diagram.this.doRelayoutAll(source == RelayoutDialog.this.m_relayoutAll);
                        RelayoutDialog.this.m_msg = "Prior graph layout deleted";
                        break;
                    }
                    return;
                }
                for (int i = 0; i < cnt; ++i) {
                    JRadioButton radioButton = RelayoutDialog.this.m_radioButtons[i];
                    if (source != radioButton) continue;
                    if (radioButton.isEnabled()) {
                        this.changeSelected(i);
                    }
                    return;
                }
            }
        }

        class ClusterTab
        extends JPanel
        implements ActionListener {
            public ClusterTab() {
                this.setLayout(new BorderLayout());
                int layouts = RelayoutDialog.this.m_layouters.length;
                Font font = FontCache.getDialogFont();
                Font bold = font.deriveFont(1);
                JPanel grid1 = new JPanel();
                grid1.setLayout(new GridLayout(6, 1, 0, 10));
                for (int i = 0; i < layouts; ++i) {
                    LandscapeLayouter layouter = RelayoutDialog.this.m_layouters[i];
                    if (layouter.isLayouter() || !layouter.isConfigurable()) continue;
                    JButton button = new JButton("configure " + RelayoutDialog.this.m_layouters[i].getName());
                    button.setFont(bold);
                    button.addActionListener(this);
                    RelayoutDialog.this.m_buttons[i] = button;
                    grid1.add(button);
                }
                this.add((Component)grid1, "Center");
            }

            @Override
            public void actionPerformed(ActionEvent ev) {
                Object source = ev.getSource();
                int cnt = RelayoutDialog.this.m_buttons.length;
                for (int i = 0; i < cnt; ++i) {
                    if (source != RelayoutDialog.this.m_buttons[i]) continue;
                    RelayoutDialog.this.m_layouters[i].configure(Diagram.this.m_ls);
                    return;
                }
            }
        }

        class LayoutTab
        extends JPanel
        implements ActionListener {
            public LayoutTab() {
                this.setLayout(new BorderLayout());
                int layouts = RelayoutDialog.this.m_layouters.length;
                Font font = FontCache.getDialogFont();
                Font bold = font.deriveFont(1);
                JPanel grid1 = new JPanel();
                grid1.setLayout(new GridLayout(6, 1, 0, 10));
                for (int i = 0; i < layouts; ++i) {
                    LandscapeLayouter layouter = RelayoutDialog.this.m_layouters[i];
                    if (!layouter.isLayouter() || !layouter.isConfigurable()) continue;
                    JButton button = new JButton("configure " + layouter.getName() + " layouter");
                    button.setFont(bold);
                    button.addActionListener(this);
                    RelayoutDialog.this.m_buttons[i] = button;
                    grid1.add(button);
                }
                this.add((Component)grid1, "Center");
            }

            @Override
            public void actionPerformed(ActionEvent ev) {
                Object source = ev.getSource();
                int cnt = RelayoutDialog.this.m_buttons.length;
                for (int i = 0; i < cnt; ++i) {
                    if (source != RelayoutDialog.this.m_buttons[i]) continue;
                    RelayoutDialog.this.m_layouters[i].configure(Diagram.this.m_ls);
                    return;
                }
            }
        }
    }
}

