/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import lsedit.ColorCache;
import lsedit.FontCache;

public class ColorChooser
extends JDialog
implements ActionListener {
    private static JColorChooser m_tcc = null;
    private JSlider m_slider;
    private JButton m_okButton;
    private JButton m_canButton;
    private JButton m_nullButton;
    private JButton m_clearButton;
    private Color m_color;
    int alpha;

    public ColorChooser(JFrame frame, String title, Color oldColor, boolean include_alpha, boolean allow_null) {
        super(frame, title, true);
        Font font = FontCache.getDialogFont();
        Font bold = font.deriveFont(1);
        this.m_slider = null;
        this.m_color = oldColor;
        Container contentPane = this.getContentPane();
        if (m_tcc == null) {
            m_tcc = new JColorChooser();
        }
        m_tcc.setFont(font);
        m_tcc.setColor(oldColor == null ? Color.gray : oldColor);
        contentPane.add("North", m_tcc);
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(1, 15, 15));
        if (include_alpha) {
            JPanel p1 = new JPanel();
            this.m_slider = new JSlider(0, 255, 255);
            this.m_slider.setFont(font);
            this.m_slider.setMajorTickSpacing(50);
            this.m_slider.setPaintLabels(true);
            this.m_slider.setPaintTicks(true);
            this.alpha = oldColor == null ? 255 : oldColor.getAlpha();
            this.m_slider.setValue(this.alpha);
            p1.add("Top", this.m_slider);
            JLabel label = new JLabel("Alpha", 0);
            label.setFont(bold);
            p1.add("Bottom", label);
            contentPane.add("Center", p1);
        }
        this.m_okButton = new JButton("OK");
        this.m_okButton.setFont(bold);
        this.m_okButton.addActionListener(this);
        p.add(this.m_okButton);
        if (!allow_null) {
            this.m_nullButton = null;
        } else {
            this.m_nullButton = new JButton("Null");
            this.m_nullButton.setFont(bold);
            this.m_nullButton.addActionListener(this);
            p.add(this.m_nullButton);
        }
        this.m_clearButton = new JButton("Clear Cache");
        this.m_clearButton.setFont(bold);
        this.m_clearButton.addActionListener(this);
        p.add(this.m_clearButton);
        this.m_canButton = new JButton("Cancel");
        this.m_canButton.setFont(bold);
        this.m_canButton.addActionListener(this);
        p.add(this.m_canButton);
        contentPane.add("South", p);
        this.setLocation(20, 20);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source != this.m_canButton) {
            if (source == this.m_okButton) {
                int alpha;
                this.m_color = m_tcc.getColor();
                if (this.m_slider != null && (alpha = this.m_slider.getValue()) != 255) {
                    this.m_color = ColorCache.get(this.m_color.getRed(), this.m_color.getGreen(), this.m_color.getBlue(), alpha);
                }
            } else if (source != null && source == this.m_nullButton) {
                this.m_color = null;
            } else {
                if (source == this.m_clearButton) {
                    int cnt = ColorCache.size();
                    ColorCache.clear();
                    JOptionPane.showMessageDialog(this, cnt + " colors have been removed from the cache");
                    return;
                }
                return;
            }
        }
        this.setVisible(false);
    }

    public Color getColor() {
        return this.m_color;
    }
}

