/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import lsedit.ColorCache;
import lsedit.EntityInstance;
import lsedit.FontCache;
import lsedit.LandscapeEditorCore;
import lsedit.MetricsEntry;
import lsedit.RelationInstance;

public class ClusterMetrics
extends JDialog
implements ActionListener {
    protected static final String[] m_titles = new String[]{"Rooted at", "Internal edges", "External edges", "Minimum children", "Maximum children", "Average children", "Leaf nodes", "Total entities", "Maximum depth"};
    protected Font m_font;
    protected Font m_bold;
    protected JPanel m_left;
    protected JPanel m_center;
    protected JPanel m_right;
    protected JButton m_save;
    protected JButton m_ok;
    protected MetricsEntry m_last;
    protected MetricsEntry m_current;

    public ClusterMetrics(LandscapeEditorCore ls) {
        super(ls.getFrame(), "Cluster Metrics", true);
        Font bold;
        Font font;
        this.m_font = font = FontCache.getDialogFont();
        this.m_bold = bold = font.deriveFont(1);
        JFrame frame = ls.getFrame();
        this.setLocation(frame.getX() + 200, frame.getY() + 300);
        this.setForeground(ColorCache.get(0, 0, 0));
        this.setBackground(ColorCache.get(192, 192, 192));
        this.setFont(font);
        Container contentPane = this.getContentPane();
        this.m_left = new JPanel();
        this.m_left.setLayout(new GridLayout(m_titles.length, 1));
        for (int i = 0; i < m_titles.length; ++i) {
            JLabel label = new JLabel(m_titles[i] + ": ", 4);
            label.setFont(this.m_font);
            this.m_left.add(label);
        }
        this.m_center = new JPanel();
        this.m_center.setLayout(new GridLayout(m_titles.length, 1));
        this.m_right = new JPanel();
        this.m_right.setLayout(new GridLayout(m_titles.length, 1));
        contentPane.add((Component)this.m_left, "West");
        contentPane.add((Component)this.m_center, "Center");
        contentPane.add((Component)this.m_right, "East");
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        this.m_save = new JButton("Save");
        this.m_save.setFont(bold);
        panel.add(this.m_save);
        this.m_save.addActionListener(this);
        this.m_ok = new JButton("Ok");
        this.m_ok.setFont(bold);
        panel.add(this.m_ok);
        this.m_ok.addActionListener(this);
        contentPane.add((Component)panel, "South");
        this.m_last = null;
        this.m_current = null;
    }

    public void init(EntityInstance drawRoot) {
        this.m_current = new MetricsEntry(drawRoot);
    }

    public void seenRelation(RelationInstance ri) {
        if (!ri.isMarked(0x100000)) {
            EntityInstance src = ri.getSrc();
            EntityInstance dst = ri.getDst();
            if (src.getContainedBy() == dst.getContainedBy()) {
                ++this.m_current.m_internal_edges;
            } else {
                ++this.m_current.m_external_edges;
            }
        }
    }

    public void seenEntity(EntityInstance e, int depth) {
        int children = e.numChildren();
        if (depth > this.m_current.m_max_depth) {
            this.m_current.m_max_depth = depth;
        }
        if (children == 0) {
            ++this.m_current.m_leaf_nodes;
        } else {
            ++this.m_current.m_boxes_seen;
            this.m_current.m_total_children += children;
            if (this.m_current.m_min_children == 0) {
                this.m_current.m_min_children = children;
            } else if (this.m_current.m_min_children > children) {
                this.m_current.m_min_children = children;
            }
            if (this.m_current.m_max_children < children) {
                this.m_current.m_max_children = children;
            }
        }
    }

    public void showit() {
        JLabel label;
        String s;
        int i;
        this.m_right.removeAll();
        for (i = 0; i < m_titles.length; ++i) {
            s = this.m_current.text(i);
            label = new JLabel(s);
            label.setFont(this.m_bold);
            this.m_right.add(label);
        }
        if (this.m_current.same(this.m_last)) {
            this.m_center.setVisible(false);
        } else {
            this.m_center.removeAll();
            for (i = 0; i < m_titles.length; ++i) {
                s = this.m_last.text(i);
                label = new JLabel(s);
                label.setFont(this.m_font);
                Color color = this.m_current.sameEntry(this.m_last, i) ? Color.BLACK : Color.RED;
                label.setForeground(color);
                this.m_center.add(label);
            }
            this.m_center.setVisible(true);
        }
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object source = ev.getSource();
        if (source == this.m_save) {
            this.m_last = this.m_current;
        } else if (source == this.m_ok) {
            this.setVisible(false);
        }
    }
}

