/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import lsedit.ClusterNode;
import lsedit.ColorCache;
import lsedit.Diagram;
import lsedit.Distance;
import lsedit.EntityInstance;
import lsedit.FontCache;
import lsedit.LandscapeEditorCore;
import lsedit.LandscapeLayouter;
import lsedit.RelationInstance;
import lsedit.SortVector;
import lsedit.SpringLayout2;
import lsedit.SpringNode;
import lsedit.ToolBarEventHandler;
import lsedit.Util;

public class ClusterLayout
extends LandscapeLayouter
implements ToolBarEventHandler {
    protected static final int STIFFNESS = 0;
    protected static final int REPULSION = 1;
    protected static final int ATTRACTION = 2;
    protected static final int GAP = 3;
    protected static final int BORDER = 4;
    protected static final int ITERATIONS = 5;
    protected static final int TIMEOUT = 6;
    protected static final int FORM_CLUSTERS = 7;
    protected static final int SEPARATION_FACTOR = 8;
    protected static final String[] m_textfield_tags = new String[]{"clusterlayout:stiffness[", "clusterlayout:repulsion[", "clusterlayout:attraction[", "clusterlayout:gap[", "clusterlayout:border[", "clusterlayout:iterations[", "clusterlayout:timeout[", "clusterlayout:clusters[", "clusterlayout:separation["};
    protected static final String[] m_textfield_titles = new String[]{"Edge stiffness", "Collision repulsion", "General Gravity", "Ideal gap", "Border", "Iterations", "Timeout", "Number of clusters", "Separation factor"};
    protected static final String[] m_textfield_resets = new String[]{"0.05", "0.025", "0.005", "0.01", "0.01", "1000", "300", "0", "2.5"};
    protected static String[] m_textfield_defaults = new String[]{"0.05", "0.025", "0.005", "0.01", "0.01", "1000", "300", "0", "2.5"};
    protected static String[] m_textfield_currents = new String[]{"0.05", "0.025", "0.005", "0.01", "0.01", "1000", "300", "0", "2.5"};
    protected double m_stiffness = 0.05;
    protected double m_repulsion = 0.025;
    protected double m_attraction = 0.005;
    protected double m_gap = 0.01;
    protected double m_border = 0.01;
    protected int m_iterations = 1000;
    protected int m_timeout = 300;
    protected int m_form_clusters = 0;
    protected double m_separation_factor = 2.5;
    protected static final int LEAVES = 0;
    protected static final int MUSTBE_RELATED = 1;
    protected static final int COMBINE_CLUSTERS = 2;
    protected static final int CLUSTER_SOURCES = 3;
    protected static final int CLUSTER_SINKS = 4;
    protected static final int FEEDBACK = 5;
    protected static final String[] m_checkbox_tags = new String[]{"clusterlayout:leaves[", "clusterlayout:related[", "clusterlayout:combine[", "clusterlayout:sources[", "clusterlayout:sinks[", "clusterlayout:feedback["};
    protected static final String[] m_checkbox_titles = new String[]{"Cluster leaves", "Must be related", "Combine clusters", "Cluster sources", "Cluster sinks", "Provide feedback"};
    protected static final boolean[] m_checkbox_resets = new boolean[]{true, true, true, true, true, true};
    protected static boolean[] m_checkbox_defaults = new boolean[]{true, true, true, true, true, true};
    protected static boolean[] m_checkbox_currents = new boolean[]{true, true, true, true, true, true};
    protected static final int BUTTON_OK = 0;
    protected static final int BUTTON_CANCEL = 1;
    protected static final int BUTTON_HELP = 2;
    protected static final int BUTTON_UNDO = 3;
    protected static final int BUTTON_DEFAULT = 4;
    protected static final int BUTTON_SET = 5;
    protected static final int BUTTON_RESET = 6;
    protected static final String[] m_button_titles = new String[]{"Ok", "Cancel", "Help", null, "Default", "Set", "Reset"};
    protected static final String[] m_button_tips = new String[]{null, null, null, "Enable/disable undo", "Use remembered default", "Set default to current", "Set default to initial"};

    protected static boolean parameterBoolean(int i) {
        return m_checkbox_currents[i];
    }

    @Override
    public String getTag() {
        return "clusterlayout:";
    }

    protected void setParameter(int i, String string) {
        string = string.trim();
        try {
            switch (i) {
                case 5: 
                case 6: 
                case 7: {
                    int ival = Integer.parseInt(string);
                    switch (i) {
                        case 5: {
                            this.m_iterations = ival;
                            break;
                        }
                        case 6: {
                            this.m_timeout = ival;
                            break;
                        }
                        case 7: {
                            this.m_form_clusters = ival;
                        }
                    }
                    break;
                }
                default: {
                    double dval = Double.parseDouble(string);
                    switch (i) {
                        case 0: {
                            this.m_stiffness = dval;
                            break;
                        }
                        case 1: {
                            this.m_repulsion = dval;
                            break;
                        }
                        case 2: {
                            this.m_attraction = dval;
                            break;
                        }
                        case 3: {
                            this.m_gap = dval;
                            break;
                        }
                        case 4: {
                            this.m_border = dval;
                            break;
                        }
                        case 8: {
                            this.m_separation_factor = dval;
                        }
                    }
                }
            }
            ClusterLayout.m_textfield_currents[i] = string;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void reset() {
        int i;
        String[] textfield_resets = m_textfield_resets;
        String[] textfield_defaults = m_textfield_defaults;
        String[] textfield_currents = m_textfield_currents;
        boolean[] checkbox_resets = m_checkbox_resets;
        boolean[] checkbox_defaults = m_checkbox_defaults;
        boolean[] checkbox_currents = m_checkbox_currents;
        for (i = 0; i < textfield_resets.length; ++i) {
            String string;
            textfield_defaults[i] = string = textfield_resets[i];
            textfield_currents[i] = string;
        }
        for (i = 0; i < checkbox_resets.length; ++i) {
            boolean bool;
            checkbox_defaults[i] = bool = checkbox_resets[i];
            checkbox_currents[i] = bool;
        }
    }

    @Override
    public void loadLayoutOption(int mode, String attribute, String value) {
        int i;
        String[] textfield_tags = m_textfield_tags;
        for (i = 0; i < textfield_tags.length; ++i) {
            if (!attribute.equals(textfield_tags[i])) continue;
            switch (mode) {
                case 0: {
                    ClusterLayout.m_textfield_defaults[i] = value;
                }
                case 1: {
                    this.setParameter(i, value);
                }
            }
            return;
        }
        String[] checkbox_tags = m_checkbox_tags;
        for (i = 0; i < checkbox_tags.length; ++i) {
            if (!attribute.equals(checkbox_tags[i])) continue;
            boolean bool = value.charAt(0) == 't';
            switch (mode) {
                case 0: {
                    ClusterLayout.m_checkbox_defaults[i] = bool;
                }
                case 1: {
                    ClusterLayout.m_checkbox_currents[i] = bool;
                }
            }
            return;
        }
    }

    @Override
    public void saveLayoutOptions(int mode, PrintWriter ps) {
        int i;
        boolean[] emit_booleans;
        String[] emit_strings;
        boolean[] prior_booleans;
        String[] prior_strings;
        switch (mode) {
            case 0: {
                prior_strings = m_textfield_resets;
                prior_booleans = m_checkbox_resets;
                emit_strings = m_textfield_defaults;
                emit_booleans = m_checkbox_defaults;
                break;
            }
            case 1: {
                prior_strings = m_textfield_defaults;
                prior_booleans = m_checkbox_defaults;
                emit_strings = m_textfield_currents;
                emit_booleans = m_checkbox_currents;
                break;
            }
            default: {
                return;
            }
        }
        for (i = 0; i < m_textfield_tags.length; ++i) {
            String string = emit_strings[i];
            if (string.equals(prior_strings[i])) continue;
            ps.println(m_textfield_tags[i] + "=" + string);
        }
        for (i = 0; i < m_checkbox_tags.length; ++i) {
            boolean bool = emit_booleans[i];
            if (bool == prior_booleans[i]) continue;
            ps.println(m_checkbox_tags[i] + "=" + (bool ? "true" : "false"));
        }
    }

    protected void log(String message) {
        if (ClusterLayout.parameterBoolean(5)) {
            System.out.println(Util.toLocaleString() + ": " + message);
        }
    }

    public ClusterLayout(LandscapeEditorCore ls, LandscapeLayouter fallback) {
        super(ls, fallback);
    }

    @Override
    public String getName() {
        return "Cluster";
    }

    @Override
    public String getMenuLabel() {
        return "Cluster";
    }

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    public boolean isLayouter() {
        return false;
    }

    @Override
    public boolean configure(LandscapeEditorCore ls) {
        ClusterConfigure configure = new ClusterConfigure();
        boolean ok = configure.ok();
        configure.dispose();
        return ok;
    }

    @Override
    public boolean doLayout1(Vector masterBoxes, EntityInstance container) {
        SpringNode tail;
        double y;
        double x;
        SpringNode target;
        int j;
        EntityInstance e1;
        RelationInstance ri;
        SpringNode clusterNode;
        EntityInstance e;
        Enumeration en;
        Vector selectedBoxes;
        boolean leaves = ClusterLayout.parameterBoolean(0);
        boolean mustbe_related = ClusterLayout.parameterBoolean(1);
        if (!leaves) {
            selectedBoxes = masterBoxes;
        } else {
            selectedBoxes = new Vector();
            en = masterBoxes.elements();
            while (en.hasMoreElements()) {
                e = (EntityInstance)en.nextElement();
                e.gatherLeaves(selectedBoxes);
            }
        }
        int size = selectedBoxes.size();
        if (size < 2) {
            return true;
        }
        this.log("Clustering " + size + " items");
        SpringNode[] clusterNodes = new ClusterNode[size];
        boolean[][] related = new boolean[size][];
        int i = 0;
        while (i < size) {
            clusterNodes[i] = clusterNode = new ClusterNode();
            related[i] = new boolean[size - i];
            clusterNode.m_e = e = (EntityInstance)selectedBoxes.elementAt(i);
            clusterNode.m_clients = 0;
            clusterNode.m_suppliers = 0;
            clusterNode.m_cluster = i++;
            clusterNode.m_next = null;
            e.orMark(0x4000000);
        }
        if (leaves) {
            for (i = 0; i < size; ++i) {
                clusterNode = clusterNodes[i];
                e = clusterNode.m_e;
                en = e.srcRelationElements();
                if (en != null) {
                    block8: while (en.hasMoreElements()) {
                        ri = (RelationInstance)en.nextElement();
                        if (!ri.isRelationShown() || !(e1 = ri.getDst()).isMarked(0x4000000)) continue;
                        for (j = i + 1; j < size; ++j) {
                            if (e1 != clusterNodes[j].m_e) continue;
                            related[i][j - i] = true;
                            continue block8;
                        }
                    }
                }
                if ((en = e.dstRelationElements()) == null) continue;
                block10: while (en.hasMoreElements()) {
                    ri = (RelationInstance)en.nextElement();
                    if (!ri.isRelationShown() || !(e1 = ri.getSrc()).isMarked(0x4000000)) continue;
                    for (j = i + 1; j < size; ++j) {
                        if (e1 != clusterNodes[j].m_e) continue;
                        related[i][j - i] = true;
                        continue block10;
                    }
                }
            }
        } else {
            for (i = 0; i < size; ++i) {
                clusterNode = clusterNodes[i];
                e = clusterNode.m_e;
                en = e.srcLiftedRelationElements();
                if (en != null) {
                    block13: while (en.hasMoreElements()) {
                        ri = (RelationInstance)en.nextElement();
                        if (!ri.isRelationShown() || !(e1 = ri.getDrawDst()).isMarked(0x4000000)) continue;
                        for (j = i + 1; j < size; ++j) {
                            if (e1 != clusterNodes[j].m_e) continue;
                            related[i][j - i] = true;
                            continue block13;
                        }
                    }
                }
                if ((en = e.dstLiftedRelationElements()) == null) continue;
                block15: while (en.hasMoreElements()) {
                    ri = (RelationInstance)en.nextElement();
                    if (!ri.isRelationShown() || !(e1 = ri.getDrawSrc()).isMarked(0x4000000)) continue;
                    for (j = i + 1; j < size; ++j) {
                        if (e1 != clusterNodes[j].m_e) continue;
                        related[i][j - i] = true;
                        continue block15;
                    }
                }
            }
        }
        this.log("Laying out these " + size + " items");
        double stiffness = this.m_stiffness;
        double repulsion = this.m_repulsion;
        double attraction = this.m_attraction;
        double gap = this.m_gap;
        double border = this.m_border;
        double separation_factor = this.m_separation_factor;
        int iterations = this.m_iterations;
        int timeout = this.m_timeout;
        int form_clusters = this.m_form_clusters;
        SpringLayout2.place(clusterNodes, related, iterations, gap, border, stiffness, repulsion, attraction, 0.0, 0.0, timeout);
        this.log("Build graph for " + size + " items");
        SpringNode sources = null;
        SpringNode sinks = null;
        SpringNode utilities = null;
        SpringNode catchall = null;
        int clusters = size;
        Diagram diagram = this.m_ls.getDiagram();
        int size1 = size - 1;
        boolean cluster_sources = ClusterLayout.parameterBoolean(3);
        boolean cluster_sinks = ClusterLayout.parameterBoolean(4);
        block17: for (i = 0; i < size; ++i) {
            clusterNode = clusterNodes[i];
            e = clusterNode.m_e;
            int flag = 0;
            if (leaves) {
                en = e.srcRelationElements();
                if (en != null) {
                    while (en.hasMoreElements()) {
                        ri = (RelationInstance)en.nextElement();
                        if (!ri.isRelationShown() || !(e1 = ri.getDst()).isMarked(0x4000000)) continue;
                        flag |= 1;
                        break;
                    }
                }
                if ((en = e.dstRelationElements()) != null) {
                    while (en.hasMoreElements()) {
                        ri = (RelationInstance)en.nextElement();
                        if (!ri.isRelationShown() || !(e1 = ri.getSrc()).isMarked(0x4000000)) continue;
                        flag |= 2;
                        break;
                    }
                }
            } else {
                en = e.srcLiftedRelationElements();
                if (en != null) {
                    while (en.hasMoreElements()) {
                        ri = (RelationInstance)en.nextElement();
                        if (!ri.isRelationShown() || !(e1 = ri.getDrawDst()).isMarked(0x4000000)) continue;
                        flag |= 1;
                        break;
                    }
                }
                if ((en = e.dstLiftedRelationElements()) != null) {
                    while (en.hasMoreElements()) {
                        ri = (RelationInstance)en.nextElement();
                        if (!ri.isRelationShown() || !(e1 = ri.getDrawSrc()).isMarked(0x4000000)) continue;
                        flag |= 2;
                        break;
                    }
                }
            }
            switch (flag) {
                case 0: {
                    if (utilities == null) {
                        utilities = clusterNode;
                        continue block17;
                    }
                    target = utilities;
                    break;
                }
                case 1: {
                    if (!cluster_sources) continue block17;
                    if (sources == null) {
                        sources = clusterNode;
                        continue block17;
                    }
                    target = sources;
                    break;
                }
                case 2: {
                    if (!cluster_sinks) continue block17;
                    if (sinks == null) {
                        sinks = clusterNode;
                        continue block17;
                    }
                    target = sinks;
                    break;
                }
                default: {
                    continue block17;
                }
            }
            clusterNode.m_cluster = target.m_cluster;
            clusterNode.m_next = target.m_next;
            target.m_next = clusterNode;
            --clusters;
        }
        if (form_clusters == 1) {
            this.log("Placing everything in a single cluster");
            target = null;
            size1 = 0;
            for (i = 0; i < size; ++i) {
                clusterNode = clusterNodes[i];
                if (!(utilities != null && clusterNode.m_cluster == utilities.m_cluster || sources != null && clusterNode.m_cluster == sources.m_cluster || sinks != null && clusterNode.m_cluster == sinks.m_cluster)) {
                    if (target != null) {
                        clusterNode.m_cluster = target.m_cluster;
                        clusterNode.m_next = target.m_next;
                        target.m_next = clusterNode;
                        --clusters;
                        continue;
                    }
                    target = clusterNode;
                }
                size1 = i;
            }
        } else {
            this.log("After initial restructuring " + clusters + " clusters remain");
            if (form_clusters < clusters) {
                double length;
                SpringNode clusterNode1;
                Vector<Distance> distances = new Vector<Distance>();
                for (i = 0; i < size; ++i) {
                    clusterNode = clusterNodes[i];
                    if (utilities != null && clusterNode.m_cluster == utilities.m_cluster) continue;
                    x = clusterNode.m_x;
                    y = clusterNode.m_y;
                    for (j = i + 1; j < size; ++j) {
                        if (mustbe_related && !related[i][j - i]) continue;
                        clusterNode1 = clusterNodes[j];
                        if (utilities != null && ((ClusterNode)clusterNode1).m_cluster == utilities.m_cluster) continue;
                        double xdiff = ((ClusterNode)clusterNode1).m_x - x;
                        double ydiff = ((ClusterNode)clusterNode1).m_y - y;
                        length = Math.sqrt(xdiff * xdiff + ydiff * ydiff);
                        distances.add(new Distance(length, i, j));
                    }
                }
                boolean combine = ClusterLayout.parameterBoolean(2);
                int pairs = distances.size();
                this.log("Sorting " + pairs + " of distances");
                SortVector.byDistance(distances);
                double ideal_length = -1.0;
                for (i = 0; i < pairs; ++i) {
                    Distance distance = (Distance)distances.elementAt(i);
                    length = distance.m_length;
                    if (form_clusters == 0 && combine && ideal_length >= 0.0 && length > ideal_length * separation_factor) {
                        this.log("Distance #" + i + " of " + length + " exceeds prior distance " + ideal_length + "*" + separation_factor);
                        break;
                    }
                    ideal_length = length;
                    clusterNode = clusterNodes[distance.m_i];
                    clusterNode1 = clusterNodes[distance.m_j];
                    if (clusterNode.m_cluster == ((ClusterNode)clusterNode1).m_cluster) continue;
                    j = clusterNode.m_cluster;
                    clusterNode = clusterNodes[j];
                    clusterNode1 = clusterNodes[((ClusterNode)clusterNode1).m_cluster];
                    if (clusterNode == sources || clusterNode == sinks || clusterNode1 == sources || clusterNode1 == sinks || !combine && clusterNode.m_next != null && ((ClusterNode)clusterNode1).m_next != null) continue;
                    tail = clusterNode1;
                    while (tail.m_next != null) {
                        tail.m_cluster = j;
                        tail = tail.m_next;
                    }
                    tail.m_cluster = j;
                    tail.m_next = clusterNode.m_next;
                    clusterNode.m_next = clusterNode1;
                    if (--clusters <= form_clusters) {
                        this.log("Reduced to " + clusters + " clusters");
                        break;
                    }
                    if (clusters < 3) break;
                }
                if (clusters > form_clusters) {
                    this.log("Grouping remaining clusters containing one item");
                    size1 = -1;
                    for (i = 0; i < size; ++i) {
                        clusterNode = clusterNodes[i];
                        if (clusterNode.m_cluster != i) continue;
                        if (clusterNode.m_next == null) {
                            if (catchall != null) {
                                clusterNode.m_cluster = catchall.m_cluster;
                                clusterNode.m_next = catchall.m_next;
                                catchall.m_next = clusterNode;
                                --clusters;
                                continue;
                            }
                            catchall = clusterNode;
                        }
                        size1 = i;
                    }
                }
            }
            this.log("Reorganised " + size + " items into " + clusters + " selected clusters");
        }
        clusters = 0;
        e1 = null;
        for (i = 0; i <= size1; ++i) {
            clusterNode = clusterNodes[i];
            if (clusterNode.m_cluster != i) continue;
            e1 = diagram.updateNewEntity(null, container);
            String text = "Cluster" + ++clusters;
            if (clusterNode == utilities) {
                text = text + " (Unconnected)";
            } else if (clusterNode == catchall) {
                text = text + " (Stray)";
            } else if (clusterNode == sources) {
                text = text + " (Sources)";
            } else if (clusterNode == sinks) {
                text = text + " (Sinks)";
            }
            e1.setLabel(text);
            int cnt = 1;
            e = clusterNode.m_e;
            x = clusterNode.m_x;
            y = clusterNode.m_y;
            double width = e.widthRelLocal() / 2.0;
            double height = e.heightRelLocal() / 2.0;
            double xmin = x - width;
            double xmax = x + width;
            double ymin = y - height;
            double ymax = y + height;
            tail = clusterNode.m_next;
            while (tail != null) {
                double y1;
                e = tail.m_e;
                x = tail.m_x;
                y = tail.m_y;
                width = e.widthRelLocal() / 2.0;
                height = e.heightRelLocal() / 2.0;
                double x1 = x - width;
                if (x1 < xmin) {
                    xmin = x1;
                }
                if ((x1 = x + width) > xmax) {
                    xmax = x1;
                }
                if ((y1 = y - height) < ymin) {
                    ymin = y1;
                }
                if ((y1 = y + height) > ymax) {
                    ymax = y1;
                }
                ++cnt;
                tail = tail.m_next;
            }
            e1.setDescription("Cluster of " + cnt + " items");
            double mx = (1.0 - 2.0 * border) / (xmax - xmin);
            double cx = border - mx * xmin;
            double my = (1.0 - 2.0 * border) / (ymax - ymin);
            double cy = border - my * ymin;
            tail = clusterNode;
            while (tail != null) {
                e = tail.m_e;
                x = tail.m_x * mx + cx;
                y = tail.m_y * my + cy;
                width = e.widthRelLocal();
                height = e.heightRelLocal();
                diagram.updateRelLocal(e, x - width / 2.0, y - height / 2.0, width, height);
                EntityInstance parent = e.getContainedBy();
                diagram.updateMoveEntityContainment(e1, e);
                if (leaves) {
                    while (true) {
                        e = parent;
                        parent = e.getContainedBy();
                        if (e.getFirstChild() != null) break;
                        diagram.updateCutEntity(e);
                    }
                }
                tail = tail.m_next;
            }
        }
        for (i = 0; i < size; ++i) {
            clusterNode = clusterNodes[i];
            e = clusterNode.m_e;
            e.nandMark(0x4000000);
        }
        boolean cleared = diagram.clearFlags(false);
        if (clusters == 1 && e1 != null) {
            diagram.navigateTo(e1, true);
        } else if (cleared) {
            diagram.revalidate();
        }
        this.log("Finished forming " + clusters + " clusters");
        return true;
    }

    @Override
    public String doLayout(Diagram dg) {
        LandscapeEditorCore ls = this.m_ls;
        Vector selectedBoxes = dg.getClusterGroup();
        if (selectedBoxes == null) {
            Util.beep();
            return "No group selected";
        }
        String msg = this.allInDiagram(selectedBoxes);
        if (msg != null) {
            return msg;
        }
        EntityInstance parent = this.parentOfSet(selectedBoxes);
        if (parent == null) {
            return "Cluster layout requires that all things laid out share same parent";
        }
        ls.doLayout1(this, selectedBoxes, parent, false);
        return "Graph redrawn using Cluster Layout";
    }

    @Override
    public void processKeyEvent(int key, int modifiers, Object object) {
        if (!this.configure(this.m_ls)) {
            return;
        }
        Diagram dg = this.m_ls.getDiagram();
        if (dg != null) {
            String rmsg = this.doLayout(dg);
            this.m_ls.doFeedback(rmsg);
        }
    }

    class ClusterConfigure
    extends JDialog
    implements ActionListener {
        protected JTextField[] m_textfields;
        protected JCheckBox[] m_checkboxes;
        protected JButton[] m_buttons;
        protected JLabel m_message;
        protected boolean m_ret;

        public ClusterConfigure() {
            JLabel label;
            int i;
            super(ClusterLayout.this.getLs().getFrame(), "Cluster Configuration", true);
            this.m_ret = false;
            Font font = FontCache.getDialogFont();
            Font bold = font.deriveFont(1);
            this.setForeground(ColorCache.get(0, 0, 0));
            this.setBackground(ColorCache.get(192, 192, 192));
            this.setFont(font);
            JPanel topPanel = new JPanel();
            JPanel labelPanel1 = new JPanel();
            JPanel valuePanel1 = new JPanel();
            JPanel labelPanel2 = new JPanel();
            JPanel valuePanel2 = new JPanel();
            topPanel.setLayout(new BorderLayout());
            GridLayout gridLayout = new GridLayout(9, 1, 0, 10);
            labelPanel1.setLayout(gridLayout);
            gridLayout = new GridLayout(9, 1, 0, 10);
            valuePanel1.setLayout(gridLayout);
            gridLayout = new GridLayout(9, 1, 0, 10);
            labelPanel2.setLayout(gridLayout);
            gridLayout = new GridLayout(9, 1, 0, 10);
            valuePanel2.setLayout(gridLayout);
            JPanel labelPanel = labelPanel1;
            JPanel valuePanel = valuePanel1;
            this.m_textfields = new JTextField[m_textfield_tags.length];
            for (i = 0; i < m_textfield_tags.length; ++i) {
                JTextField textfield;
                if (i == 7) {
                    labelPanel = labelPanel2;
                    valuePanel = valuePanel2;
                }
                this.m_textfields[i] = textfield = new JTextField(m_textfield_currents[i], 20);
                label = new JLabel(m_textfield_titles[i], 4);
                label.setFont(bold);
                labelPanel.add(label);
                textfield.setFont(font);
                textfield.addActionListener(this);
                valuePanel.add(textfield);
            }
            this.m_checkboxes = new JCheckBox[m_checkbox_tags.length];
            for (i = 0; i < m_checkbox_tags.length; ++i) {
                JCheckBox checkbox;
                this.m_checkboxes[i] = checkbox = new JCheckBox("", m_checkbox_currents[i]);
                label = new JLabel(m_checkbox_titles[i], 4);
                label.setFont(bold);
                labelPanel.add(label);
                checkbox.setFont(font);
                valuePanel.add(checkbox);
            }
            JPanel leftPanel = new JPanel();
            leftPanel.setLayout(new BorderLayout());
            leftPanel.add("West", labelPanel1);
            leftPanel.add("East", valuePanel1);
            JPanel rightPanel = new JPanel();
            rightPanel.setLayout(new BorderLayout());
            rightPanel.add("West", labelPanel2);
            rightPanel.add("East", valuePanel2);
            topPanel.add("West", leftPanel);
            topPanel.add("East", rightPanel);
            Container contentPane = this.getContentPane();
            contentPane.add("North", topPanel);
            String string = ClusterLayout.this.m_ls.getDiagram().undoEnabled() ? "You might wish to disable undo/redo operations" : "You might wish to enable undo/redo operations";
            this.m_message = new JLabel(string, 0);
            this.m_message.setFont(font);
            this.m_message.setForeground(Color.RED);
            this.m_message.setSize(400, 50);
            this.m_message.setPreferredSize(new Dimension(400, 50));
            contentPane.add("Center", this.m_message);
            JPanel bottomPanel = new JPanel();
            bottomPanel.setLayout(new FlowLayout(1, 15, 15));
            this.m_buttons = new JButton[m_button_titles.length];
            for (i = 0; i < m_button_titles.length; ++i) {
                JButton button;
                string = m_button_titles[i];
                if (string == null) {
                    string = ClusterLayout.this.undoLabel();
                }
                this.m_buttons[i] = button = new JButton(string);
                button.setFont(bold);
                String tip = m_button_tips[i];
                if (tip != null) {
                    button.setToolTipText(tip);
                }
                button.addActionListener(this);
                bottomPanel.add(button);
            }
            contentPane.add("South", bottomPanel);
            this.pack();
            this.setVisible(true);
        }

        public boolean ok() {
            return this.m_ret;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            int i;
            Object source = ev.getSource();
            int state = -1;
            for (i = 0; i < m_button_titles.length; ++i) {
                if (source != this.m_buttons[i]) continue;
                state = i;
                break;
            }
            switch (state) {
                case 6: {
                    for (i = 0; i < m_textfield_tags.length; ++i) {
                        ClusterLayout.m_textfield_defaults[i] = m_textfield_resets[i];
                    }
                    for (i = 0; i < m_checkbox_tags.length; ++i) {
                        ClusterLayout.m_checkbox_defaults[i] = m_checkbox_resets[i];
                    }
                }
                case 4: {
                    for (i = 0; i < m_textfield_tags.length; ++i) {
                        this.m_textfields[i].setText(m_textfield_defaults[i]);
                    }
                    for (i = 0; i < m_checkbox_tags.length; ++i) {
                        this.m_checkboxes[i].setSelected(m_checkbox_defaults[i]);
                    }
                    return;
                }
                case 5: {
                    for (i = 0; i < m_textfield_tags.length; ++i) {
                        ClusterLayout.m_textfield_defaults[i] = this.m_textfields[i].getText();
                    }
                    for (i = 0; i < m_checkbox_tags.length; ++i) {
                        ClusterLayout.m_checkbox_defaults[i] = this.m_checkboxes[i].isSelected();
                    }
                    return;
                }
                case 3: {
                    LandscapeEditorCore ls = ClusterLayout.this.m_ls;
                    ls.invertUndo();
                    this.m_buttons[state].setText(ClusterLayout.this.undoLabel());
                    this.m_message.setText("");
                    return;
                }
                case 2: {
                    JOptionPane.showMessageDialog(ClusterLayout.this.m_ls.getFrame(), "<Stiffness> of edges connecting related nodes\n  A larger value increases the force between related nodes\n<Repulsive force> between overlapping nodes\n  A larger value thrusts overlapping nodes further apart\n  0     => disable collision detection\n<Attraction> between nodes\n  General attractive force reducing size of graph which\n  permits larger nodes\n<Ideal gap> as fraction for space between entities\n<Border> as fraction to leave for border of diagram\n<Iterations> of spring layout algorithm\n<Timeout> in seconds to spend in layout algorithm\n\n<Number of clusters> to form. Use 0 to have the layouter use the\n separation factor to decide when to terminate clustering.\n Set to 1 to view the graph used to cluster\n<Separation factor> causes clustering to stop when the\n minimum distance between nodes left to be clustered, is\n more than the prior minimum distance * factor.  Only\n relevant when no set number of clusters are required and\n clusters may themselves be combined.\n<Cluster leaves> of the tree discarding all existing containers\n<Mustbe related> restricts items in cluster to connected items\n Otherwise clustering is purely based on the spacial layout\n<Combine clusters> permits clusters containing multiple nodes to be\n themselves further clustered.\n<Custer sources> having no incoming edges in a special cluster.\n<Cluster sinks> having no output edges in a special cluster.", "Help", 0);
                    return;
                }
            }
            block31: for (i = 0; i < m_textfield_tags.length; ++i) {
                JTextField textfield = this.m_textfields[i];
                if (source != textfield && state != 0) continue;
                String string = textfield.getText();
                string = string.trim();
                String name = m_textfield_titles[i];
                switch (i) {
                    case 5: 
                    case 6: {
                        try {
                            int ivalue = Integer.parseInt(string);
                            if (ivalue > 0) continue block31;
                            this.m_message.setText(name + " must be positive");
                            return;
                        }
                        catch (Throwable exception) {
                            this.m_message.setText(name + " not an integer value");
                            return;
                        }
                    }
                    case 7: {
                        try {
                            int ivalue = Integer.parseInt(string);
                            if (ivalue >= 0) continue block31;
                            this.m_message.setText(name + " may not be negative");
                            return;
                        }
                        catch (Throwable exception) {
                            this.m_message.setText(name + " not an integer value");
                            return;
                        }
                    }
                    default: {
                        try {
                            double dval = Double.parseDouble(string);
                            switch (i) {
                                case 3: 
                                case 4: {
                                    if (!(dval < 0.0) && !(dval >= 1.0)) break;
                                    this.m_message.setText(name + " must be in the range 0 to 1.0");
                                    return;
                                }
                            }
                            continue block31;
                        }
                        catch (Throwable exception) {
                            this.m_message.setText(name + " not a double precision value");
                            return;
                        }
                    }
                }
            }
            switch (state) {
                case 0: {
                    for (i = 0; i < m_textfield_tags.length; ++i) {
                        ClusterLayout.this.setParameter(i, this.m_textfields[i].getText());
                    }
                    for (i = 0; i < m_checkbox_tags.length; ++i) {
                        ClusterLayout.m_checkbox_currents[i] = this.m_checkboxes[i].isSelected();
                    }
                    this.m_ret = true;
                }
                case 1: {
                    break;
                }
                default: {
                    return;
                }
            }
            this.setVisible(false);
        }
    }
}

