/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import lsedit.Clipboard;
import lsedit.ClipboardEnumerator;
import lsedit.ClipboardListener;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.FontCache;
import lsedit.LandscapeEditorCore;
import lsedit.MyMenuItem;
import lsedit.Options;
import lsedit.TabBox;
import lsedit.ToolBarEventHandler;

public class ClipboardBox
extends TabBox
implements ChangeListener,
ToolBarEventHandler,
ClipboardListener,
MouseListener {
    protected static final int MARGIN = 5;
    protected static final int INDENT = 10;
    protected JCheckBox m_addChk;
    protected ExpandedChkBox m_expandChk;
    protected static Dimension m_preferredSize = new Dimension(0, 0);
    public static final String m_helpStr = "This box shows the contents of the clipboard within the current diagram.";
    protected static Font m_textFont = null;
    protected static FontMetrics m_fm = null;
    protected static int m_fontheight;
    protected static int m_baseline;
    protected static int m_height;
    protected static int m_top;

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void paintComponent(Graphics g) {
        Clipboard clipboard;
        m_height = m_top;
        Diagram diagram = this.m_ls.getDiagram();
        if (diagram != null && (clipboard = diagram.getClipboard()) != null && !clipboard.isEmpty()) {
            if (g != null) {
                g.setFont(m_textFont);
                g.setColor(Color.BLACK);
            }
            ClipboardEnumerator en = clipboard.clipboardElements();
            while (en.hasMoreElements()) {
                EntityInstance e = (EntityInstance)en.nextElement();
                this.paintTree(g, e, 0);
                m_height += m_fontheight;
            }
        }
    }

    public void setTop() {
        FontMetrics fm = m_fm;
        if (fm == null) {
            m_fm = fm = this.getFontMetrics(m_textFont);
        }
        m_fontheight = fm.getHeight();
        m_baseline = m_fontheight - fm.getDescent();
        int y = 5;
        Dimension d = this.m_addChk.getPreferredSize();
        this.m_addChk.setBounds(5, y, d.width, d.height);
        d = this.m_expandChk.getPreferredSize();
        this.m_expandChk.setBounds(5, y += d.height, d.width, d.height);
        m_top = (y += d.height) + m_fontheight + m_baseline;
    }

    public static void setTextFont(Font font) {
        if (m_textFont != font) {
            m_textFont = font;
            m_fm = null;
        }
    }

    public void setComponentsFont(Font font) {
        this.m_addChk.setFont(font);
        this.m_expandChk.setFont(font);
        this.setTop();
    }

    public void textFontChanged(Font font) {
        ClipboardBox.setTextFont(font);
        this.setComponentsFont(font);
        this.clipboardChanged();
    }

    public ClipboardBox(LandscapeEditorCore ls, JTabbedPane tabbedPane) {
        super(ls, tabbedPane, "Clipboard", m_helpStr);
        if (m_textFont == null) {
            ClipboardBox.setTextFont(Options.getTargetFont(21));
        }
        this.m_addChk = new JCheckBox("Add to clipboard");
        this.m_addChk.setForeground(Color.black);
        this.m_expandChk = new ExpandedChkBox("Expand trees");
        this.m_expandChk.setForeground(Color.black);
        this.setComponentsFont(m_textFont);
        this.add(this.m_addChk);
        this.add(this.m_expandChk);
        tabbedPane.addChangeListener(this);
        this.addMouseListener(this);
        this.setNewPreferredSize();
    }

    private void paintTree(Graphics g, EntityInstance e, int indent) {
        String label = e.getEntityLabel();
        if (g == null) {
            int w;
            FontMetrics fm = m_fm;
            if (fm == null) {
                m_fm = fm = this.getFontMetrics(m_textFont);
            }
            if ((w = fm.stringWidth(label) + 10 + indent) > ClipboardBox.m_preferredSize.width) {
                ClipboardBox.m_preferredSize.width = w;
            }
        } else {
            g.drawString(label, 5 + indent, m_height);
        }
        m_height += m_fontheight;
        if (this.m_expandChk.isSelected()) {
            Enumeration children = e.getChildren();
            while (children.hasMoreElements()) {
                EntityInstance child = (EntityInstance)children.nextElement();
                EntityInstance parent1 = child.getContainedBy();
                if (parent1 != e) continue;
                this.paintTree(g, child, indent + 10);
            }
        }
    }

    protected void setNewPreferredSize() {
        int oldwidth = ClipboardBox.m_preferredSize.width;
        int oldheight = ClipboardBox.m_preferredSize.height;
        Dimension d = this.m_addChk.getPreferredSize();
        ClipboardBox.m_preferredSize.width = 5 + d.width;
        this.paintComponent(null);
        ClipboardBox.m_preferredSize.height = m_height + m_fontheight;
        if (ClipboardBox.m_preferredSize.width != oldwidth || ClipboardBox.m_preferredSize.height != oldheight) {
            this.setPreferredSize(m_preferredSize);
            this.setSize(m_preferredSize);
            this.m_scrollPane.revalidate();
        }
    }

    public boolean isAddToClipboard() {
        return this.m_addChk.isSelected();
    }

    public void clear() {
        Diagram diagram = this.m_ls.getDiagram();
        if (diagram != null) {
            diagram.setClipboard(null);
        }
        this.m_ls.doFeedback("Clipboard cleared");
    }

    @Override
    public void clipboardChanged() {
        this.setNewPreferredSize();
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent ev) {
    }

    @Override
    public void mouseEntered(MouseEvent ev) {
    }

    @Override
    public void mouseExited(MouseEvent ev) {
    }

    @Override
    public void mousePressed(MouseEvent ev) {
        Clipboard clipboard;
        Diagram diagram = this.m_ls.getDiagram();
        if (diagram != null && (clipboard = diagram.getClipboard()) != null && !clipboard.isEmpty() && ev.isMetaDown()) {
            JPopupMenu m = new JPopupMenu("Clipboard options");
            new MyMenuItem(m, "Dispose clipboard", this, -1, 127, "Discard this clipboard");
            FontCache.setMenuTreeFont(m);
            m.show(this, ev.getX(), ev.getY());
            return;
        }
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.isActive()) {
            this.repaint();
        }
    }

    @Override
    public LandscapeEditorCore getLs() {
        return this.m_ls;
    }

    @Override
    public boolean processMetaKeyEvent(String name) {
        return this.m_ls.processMetaKeyEvent(name);
    }

    @Override
    public void processKeyEvent(int key, int modifiers, Object object) {
        switch (key) {
            case 127: {
                int ret = JOptionPane.showConfirmDialog(this.m_ls.getFrame(), "Confirm deletion?", "Delete Clipboard", 2);
                if (ret != 0) break;
                this.clear();
                break;
            }
        }
    }

    @Override
    public void showInfo(String msg) {
    }

    protected class ExpandedChkBox
    extends JCheckBox
    implements ItemListener {
        ExpandedChkBox(String label) {
            super(label);
            this.setSelected(false);
            this.addItemListener(this);
        }

        @Override
        public void itemStateChanged(ItemEvent ev) {
            ClipboardBox.this.clipboardChanged();
        }
    }
}

