/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import lsedit.Diagram;
import lsedit.EntityComponent;
import lsedit.EntityInstance;
import lsedit.LandscapeEditorCore;
import lsedit.Options;
import lsedit.SortVector;

public abstract class ClientSupplierSet
extends JPanel {
    public static final int CLIENT_SUPPLIER_HEIGHT = 50;
    public static final int GAP = 5;
    protected LandscapeEditorCore m_ls;
    protected Diagram m_diagram;
    protected JLabel m_label = null;
    protected static Font m_clientFont = null;
    protected EntityInstance m_drawRoot;
    protected Vector m_set;
    protected int m_fullSize;
    protected int m_displayedSize;

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.setSizes(width, height);
    }

    protected int calcWidth(Graphics g) {
        int tw = 0;
        Enumeration en = this.m_set.elements();
        while (en.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en.nextElement();
            Dimension dim = e.getFitDim(g, 0, true);
            tw += dim.width;
        }
        return tw;
    }

    protected void setSizes(int w, int h) {
        Vector set = this.m_set;
        int components = set.size();
        if (components == 0) {
            JLabel label = this.m_label;
            if (label == null) {
                this.m_label = label = new JLabel();
                label.setFont(ClientSupplierSet.getClientSupplierFont());
            }
            label.setText("All " + this.m_fullSize + " clients are also suppliers");
            label.setHorizontalAlignment(0);
            label.setBounds(0, 0, w, h);
        } else {
            Graphics g = this.m_ls.getGraphics();
            int gaps = (components + 1) * 5;
            int width = w - gaps;
            int tw = this.calcWidth(g);
            double width1 = width;
            double scale = width1 / (double)tw;
            this.m_label = null;
            if (scale > 2.0) {
                scale = 2.0;
            }
            int i = components;
            while (--i >= 0) {
                EntityInstance e = (EntityInstance)set.elementAt(i);
                EntityComponent entityComponent = e.neededComponent();
                Dimension dim = e.getFitDim(g, 0, true);
                width1 = scale * (double)dim.width;
                int width2 = (int)width1;
                if (width2 <= 0) {
                    width2 = 1;
                }
                e.setEntitySize(width2, h, this);
            }
        }
    }

    protected void sort() {
        if (this.m_set.size() > 1) {
            SortVector.byAvgX(this.m_set, true);
        }
    }

    protected void addSet() {
        Vector set;
        int components;
        if (this.m_label != null) {
            this.add(this.m_label);
        }
        if ((components = (set = this.m_set).size()) != 0) {
            Graphics g = this.m_ls.getGraphics();
            int diagramX = this.getX();
            int diagramY = this.getY();
            int gaps = (components + 1) * 5;
            int w = this.getWidth();
            int h = this.getHeight();
            int width = w - gaps;
            int tw = this.calcWidth(g);
            double width1 = width;
            double scale = width1 / (double)tw;
            double xpos = 5.0;
            if (scale > 2.0) {
                scale = 2.0;
                xpos += (double)(width - tw * 2) / 2.0;
            }
            for (int i = 0; i < components; ++i) {
                EntityInstance e = (EntityInstance)set.elementAt(i);
                Dimension dim = e.getFitDim(g, 0, true);
                width1 = scale * (double)dim.width;
                int x = (int)xpos;
                e.setEntityLocation(x, 0);
                e.setDiagramLocation(diagramX + x, diagramY);
                xpos += width1 + 5.0;
            }
        }
    }

    public static void setTextFont(Font font) {
        m_clientFont = font;
    }

    public static Font getClientSupplierFont() {
        if (m_clientFont == null) {
            m_clientFont = Options.getTargetFont(4);
        }
        return m_clientFont;
    }

    public ClientSupplierSet(Diagram diagram) {
        this.setLayout(null);
        this.m_diagram = diagram;
        this.m_ls = diagram.getLs();
        this.m_set = new Vector();
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.m_set.removeAllElements();
        this.m_fullSize = 0;
        this.m_displayedSize = 0;
    }

    public void addMember(EntityInstance e) {
        this.m_set.add(e);
    }

    public void seenMember() {
        ++this.m_fullSize;
    }

    public Vector getFullSet() {
        return this.m_set;
    }

    public int getFullSetSize() {
        return this.m_fullSize;
    }

    public void order() {
        this.m_displayedSize = this.m_set.size();
        this.sort();
        this.addSet();
    }
}

