/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import lsedit.ColorCache;
import lsedit.Diagram;
import lsedit.EntityClass;
import lsedit.FontCache;
import lsedit.LandscapeClassObject;
import lsedit.LandscapeEditorCore;
import lsedit.RelationClass;
import lsedit.UsageColumnModel;
import lsedit.UsageLabel;
import lsedit.UsageTable;
import lsedit.UsageTableModel;

public class ClassUsage
extends JDialog
implements ActionListener,
ItemListener {
    public static final String[] g_ec_directions = new String[]{"All", "From", "To", "Loop", "Child", "Parent", "Span", "All Except Span", "From Except Span", "To Except Span"};
    public static final String[] g_ec_arrows = new String[]{"<-all->", "-from->", "<-to-", "-loop-", "=child=>", "<=parent=", "<=span=>", "<-nospan->", "-nospan->", "<-nospan-"};
    public static final int EC_DIRECTION_ALL = 0;
    public static final int EC_DIRECTION_FROM = 1;
    public static final int EC_DIRECTION_TO = 2;
    public static final int EC_DIRECTION_LOOP = 3;
    public static final int EC_DIRECTION_CHILD = 4;
    public static final int EC_DIRECTION_PARENT = 5;
    public static final int EC_DIRECTION_SPAN = 6;
    public static final int EC_DIRECTION_ALL_EXCEPT_SPAN = 7;
    public static final int EC_DIRECTION_FROM_EXCEPT_SPAN = 8;
    public static final int EC_DIRECTION_TO_EXCEPT_SPAN = 9;
    public static final String[] g_rc_directions = new String[]{"All", "Loop", "Span", "All Except Span", "Max", "Max From", "Max To", "Max To/From"};
    public static final String[] g_rc_arrows = new String[]{"<-all->", "-loop-", "<=span=>", "<-nospan->", "<-max->", "-max from->", "<-max to-", "<-max to/from->"};
    public static final int RC_DIRECTION_ALL = 0;
    public static final int RC_DIRECTION_LOOP = 1;
    public static final int RC_DIRECTION_SPAN = 2;
    public static final int RC_DIRECTION_ALL_EXCEPT_SPAN = 3;
    public static final int RC_DIRECTION_MAX = 4;
    public static final int RC_DIRECTION_MAX_FROM = 5;
    public static final int RC_DIRECTION_MAX_TO = 6;
    public static final int RC_DIRECTION_MAX_FROM_TO = 7;
    private Font m_font;
    private Font m_bold;
    private int m_numEntityClasses;
    private int m_numRelationClasses;
    private LandscapeClassObject m_classObject;
    private EntityClass[] m_ecs;
    private RelationClass[] m_rcs;
    private LandscapeClassObject[] m_cs;
    private UsageLabel[][] m_labels;
    private int[][] m_array = null;
    private JButton m_ok = null;
    private JComboBox m_comboBox = null;
    private JComboBox m_directionBox = null;
    private int m_direction;
    private JPanel m_panel;
    private UsageTableModel m_model;
    private UsageColumnModel m_column_model;
    private UsageTable m_table = null;
    private Dimension m_preferredSize;

    protected void fill(LandscapeClassObject classObject) {
        int cnt;
        int j;
        int sum;
        UsageLabel[] row;
        UsageLabel label;
        int rows;
        int i;
        String[] terms;
        boolean isEntityClass = classObject instanceof EntityClass;
        String[] stringArray = terms = isEntityClass ? g_ec_directions : g_rc_directions;
        if (classObject != this.m_classObject && (this.m_classObject == null || isEntityClass ^ this.m_classObject instanceof EntityClass)) {
            this.m_directionBox.removeAllItems();
            for (i = 0; i < terms.length; ++i) {
                this.m_directionBox.addItem(terms[i]);
            }
            this.m_directionBox.setSelectedIndex(0);
        }
        this.m_classObject = classObject;
        this.m_direction = this.m_directionBox.getSelectedIndex();
        if (this.m_direction < 0) {
            this.m_direction = 0;
        }
        boolean isMax = false;
        if (isEntityClass) {
            this.setTitle("Usage for Entity Class " + classObject.getLabel() + " " + terms[this.m_direction]);
            ((EntityClass)classObject).getUsage(this.m_array, this.m_direction);
            rows = this.m_rcs.length;
            for (i = 0; i < rows; ++i) {
                label = this.m_labels[i + 1][0];
                label.setForeground(Color.RED);
                label.setText(this.m_rcs[i].getLabel());
            }
        } else {
            this.setTitle("Usage for Relation Class " + classObject.getLabel() + " " + terms[this.m_direction]);
            switch (this.m_direction) {
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    isMax = true;
                }
            }
            ((RelationClass)classObject).getUsage(this.m_array, this.m_direction);
            rows = this.m_ecs.length;
            for (i = 0; i < rows; ++i) {
                label = this.m_labels[i + 1][0];
                label.setForeground(Color.BLACK);
                label.setText(this.m_ecs[i].getLabel());
            }
        }
        int total = 0;
        for (i = 0; i < rows; ++i) {
            row = this.m_labels[i + 1];
            sum = 0;
            for (j = 0; j < this.m_ecs.length; ++j) {
                String arrow;
                String text;
                label = row[j + 1];
                cnt = this.m_array[i][j];
                if (cnt == 0) {
                    text = "-";
                } else {
                    if (isMax) {
                        if (sum < cnt) {
                            sum = cnt;
                        }
                    } else {
                        sum += cnt;
                    }
                    text = "" + cnt;
                }
                label.setText(text);
                if (isEntityClass) {
                    if (i == j) {
                        label.setOpaque(false);
                    }
                    arrow = g_ec_arrows[this.m_direction];
                    text = classObject.getLabel() + arrow + this.m_rcs[i].getLabel() + arrow + this.m_ecs[j].getLabel();
                } else {
                    if (i == j) {
                        label.setOpaque(true);
                    }
                    arrow = g_rc_arrows[this.m_direction];
                    text = this.m_ecs[i].getLabel() + arrow + classObject.getLabel() + arrow + this.m_ecs[j].getLabel();
                }
                label.setToolTipText(text);
            }
            label = row[j + 1];
            label.setText("" + sum);
            if (isMax) {
                if (total >= sum) continue;
                total = sum;
                continue;
            }
            total += sum;
        }
        int total1 = 0;
        row = this.m_labels[rows + 1];
        for (j = 0; j < this.m_ecs.length; ++j) {
            sum = 0;
            for (i = 0; i < rows; ++i) {
                cnt = this.m_array[i][j];
                if (isMax) {
                    if (sum >= cnt) continue;
                    sum = cnt;
                    continue;
                }
                sum += cnt;
            }
            label = row[j + 1];
            label.setText("" + sum);
            if (isMax) {
                if (total1 >= sum) continue;
                total1 = sum;
                continue;
            }
            total1 += sum;
        }
        if (isMax) {
            label = this.m_labels[0][this.m_ecs.length + 1];
            label.setText("*MAX*");
            label = this.m_labels[rows + 1][0];
            label.setText("*MAX*");
        } else {
            label = this.m_labels[0][this.m_ecs.length + 1];
            label.setText("*TOTAL*");
            label = this.m_labels[rows + 1][0];
            label.setText("*TOTAL*");
        }
        label = this.m_labels[rows + 1][this.m_ecs.length + 1];
        if (total == total1) {
            label.setText("" + total);
        } else {
            label.setText("" + total1 + "/" + total);
        }
        if (this.m_table == null) {
            FontMetrics fm = this.getFontMetrics(this.m_bold);
            this.m_table = new UsageTable(this.m_model);
            this.m_table.setFont(this.m_font);
            int rowHeight = fm.getHeight() + 4;
            this.m_table.setRowHeight(rowHeight);
            this.m_column_model = new UsageColumnModel(fm, this.m_labels[0], this.m_cs);
            this.m_table.setColumnModel(this.m_column_model);
            int preferredWidth = this.m_column_model.getTotalColumnWidth();
            int preferredHeight = (rows + 2) * ++rowHeight;
            this.m_preferredSize = new Dimension(preferredWidth, preferredHeight);
            this.m_table.setPreferredSize(this.m_preferredSize);
        }
        this.m_model.setRowCount(rows + 2);
        this.m_model.fireTableDataChanged();
        this.m_table.doLayout();
    }

    protected ClassUsage(JFrame frame, Diagram diagram, LandscapeClassObject classObject) {
        super(frame, "Usage for " + classObject.getLabel(), true);
        Color diagonal = new Color(222, 222, 197);
        String[] directionNames = new String[3];
        this.m_font = FontCache.getDialogFont();
        this.m_bold = this.m_font.deriveFont(1);
        this.m_numEntityClasses = diagram.numEntityClasses();
        this.m_numRelationClasses = diagram.numRelationClasses();
        this.m_ecs = new EntityClass[this.m_numEntityClasses];
        this.m_rcs = new RelationClass[this.m_numRelationClasses];
        this.m_cs = new LandscapeClassObject[this.m_numEntityClasses + this.m_numRelationClasses];
        int i = 0;
        int selected = 0;
        Enumeration en = diagram.enumEntityClassesInOrder();
        while (en.hasMoreElements()) {
            EntityClass ec = (EntityClass)en.nextElement();
            if (ec == classObject) {
                selected = i;
            }
            ec.setOrderedId(i);
            this.m_cs[i] = ec;
            this.m_ecs[i] = ec;
            ++i;
        }
        int j = 0;
        en = diagram.enumRelationClassesInOrder();
        while (en.hasMoreElements()) {
            RelationClass rc = (RelationClass)en.nextElement();
            if (rc == classObject) {
                selected = i;
            }
            rc.setOrderedId(j);
            this.m_cs[i] = rc;
            this.m_rcs[j] = rc;
            ++j;
            ++i;
        }
        int size = this.m_numEntityClasses;
        if (size < this.m_numRelationClasses) {
            size = this.m_numRelationClasses;
        }
        this.m_array = new int[size + 1][];
        this.m_labels = new UsageLabel[size + 2][];
        for (i = 0; i <= size + 1; ++i) {
            if (i <= size) {
                this.m_array[i] = new int[this.m_numEntityClasses + 1];
            }
            UsageLabel[] row = new UsageLabel[this.m_numEntityClasses + 2];
            this.m_labels[i] = row;
            for (j = 0; j <= this.m_numEntityClasses + 1; ++j) {
                UsageLabel label;
                if (i == 0) {
                    if (j == 0) {
                        label = new UsageLabel("");
                    } else {
                        label = j <= this.m_numEntityClasses ? new UsageLabel(this.m_ecs[j - 1].getLabel()) : new UsageLabel("*All*");
                        label.setFont(this.m_bold);
                        label.setForeground(Color.BLACK);
                    }
                } else {
                    label = new UsageLabel("");
                    if (j > 0) {
                        if (i == j) {
                            label.setBackground(diagonal);
                        }
                        label.setForeground(Color.BLUE);
                        label.setFont(this.m_font);
                    }
                }
                label.setHorizontalAlignment(0);
                row[j] = label;
            }
        }
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.setForeground(ColorCache.get(0, 0, 0));
        this.setBackground(ColorCache.get(192, 192, 192));
        this.setFont(this.m_font);
        this.m_model = new UsageTableModel(0, this.m_numEntityClasses + 2, this.m_labels);
        this.m_directionBox = new JComboBox();
        this.m_directionBox.addItemListener(this);
        this.m_classObject = null;
        this.fill(classObject);
        JScrollPane scrollPane = new JScrollPane(this.m_table);
        scrollPane.setPreferredSize(this.m_preferredSize);
        scrollPane.setVisible(true);
        contentPane.add((Component)scrollPane, "Center");
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        this.m_comboBox = new JComboBox<LandscapeClassObject>(this.m_cs);
        this.m_comboBox.setSelectedIndex(selected);
        this.m_comboBox.addItemListener(this);
        panel.add(this.m_comboBox);
        panel.add(this.m_directionBox);
        this.m_ok = new JButton("Close");
        this.m_ok.setFont(this.m_bold);
        this.m_ok.addActionListener(this);
        panel.add(this.m_ok);
        contentPane.add((Component)panel, "South");
        this.pack();
        this.setVisible(true);
    }

    public static void create(Diagram diagram, LandscapeClassObject classObject) {
        LandscapeEditorCore ls = diagram.getLs();
        ClassUsage classUsage = new ClassUsage(ls.getFrame(), diagram, classObject);
        classUsage.dispose();
    }

    @Override
    public void itemStateChanged(ItemEvent ev) {
        Object source = ev.getSource();
        if (source == this.m_comboBox) {
            LandscapeClassObject classObject = (LandscapeClassObject)this.m_comboBox.getSelectedItem();
            if (classObject != this.m_classObject) {
                this.fill(classObject);
            }
            return;
        }
        if (source == this.m_directionBox) {
            int direction = this.m_directionBox.getSelectedIndex();
            if (direction != this.m_direction) {
                this.fill(this.m_classObject);
            }
            return;
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object source = ev.getSource();
        if (source != this.m_ok) {
            return;
        }
        this.setVisible(false);
    }
}

