/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import lsedit.Arrow;
import lsedit.ColorCache;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.FontCache;
import lsedit.LandscapeEditorCore;
import lsedit.LandscapeLayouter;
import lsedit.ListVector;
import lsedit.MyListCellRenderer;
import lsedit.MyListModel;
import lsedit.Option;
import lsedit.Options;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.SortVector;
import lsedit.ToolBarEventHandler;
import lsedit.Util;

public class BunchClusterLayout
extends LandscapeLayouter
implements ToolBarEventHandler {
    public static final String[] g_clustering_approach = new String[]{"Agglomerative", "One level"};
    public static final String[] g_output_mode = new String[]{"Median", "Top", "Detailed"};
    public static final String[] g_cluster_algorithm = new String[]{"Hill climbing", "Genetic", "Exhaustive"};
    public static final String[] g_debug = new String[]{"Silent", "Minimal", "Verbose", "Diagnostic"};
    public static final String[] g_techniques = new String[]{"bunch.SASimpleTechnique"};
    public static final String[] g_selection_method = new String[]{"Tournament", "Roulette wheel"};
    public static final String[] g_calculator_classes = new String[]{"bunch.TurboMQIncrW", "bunch.TurboMQIncr", "bunch.TurboMQW", "bunch.TurboMQ", "bunch.ITurboMQ", "bunch.basicMQ"};
    protected static final int EXPORT = 0;
    protected static final int COMMAND = 1;
    protected static final int IMPORTDIR = 2;
    protected static final int IMPORTFILE = 3;
    protected static final int LIBRARYS = 4;
    protected static final int CLIENTS = 5;
    protected static final int SUPPLIERS = 6;
    protected static final int OMNIPRESENT = 7;
    protected static final int HC_POPULATION_SIZE = 8;
    protected static final int HC_SEARCH_SPACE = 9;
    protected static final int HC_RANDOMIZE = 10;
    protected static final int HC_INITIAL_TEMP = 11;
    protected static final int HC_ALPHA = 12;
    protected static final int GA_GENERATIONS = 13;
    protected static final int GA_POPULATION_SIZE = 14;
    protected static final int GA_CROSSOVER_PROB = 15;
    protected static final int GA_MUTATION_PROB = 16;
    protected static final int MAXRUNTIME = 17;
    protected static final int USERFILE = 18;
    protected static final int CLIENTS_MULTIPLIER = 19;
    protected static final int SUPPLIERS_MULTIPLIER = 20;
    protected static final int BOTH_MULTIPLIER = 21;
    protected static final String[] m_textfield_tags = new String[]{"bunch:export", "bunch:command", "bunch:importdir", "bunch:import", "bunch:librarys", "bunch:clients", "bunch:suppliers", "bunch:omnipresent", "bunch:hcpopulation", "bunch:hcsearchspace", "bunch:hcrandomize", "bunch:hcinitial", "bunch:hcalpha", "bunch:gagenerations", "bunch:gapopulation", "bunch:gacrossover", "bunch:gamutation", "bunch:maxruntime", "bunch:userfile", "bunch:clientsmult", "bunch:suppliermult", "bunch:bothmult"};
    protected static final String[] m_textfield_titles = new String[]{"Initial graph file:", "Bunch command line interface:", "Bunch output directory:", "Import file:", "Library list:", "Omnipresent clients:", "Omnipresent suppliers:", "Omnipresent nodes:", null, null, null, null, null, "Number of Generations:", "Population Size", "Crossover Probability:", "Mutation Probability", null, "Input cluster file:", null, null, null};
    protected static final String[] m_textfield_resets = new String[]{"junk.ta", "java.exe -classpath \".;bunch.jar\" clue.Clue", "", "junk.ta.bunch", "", "", "", "", "1", "0", "100", "1.0", "0.85", "500", "50", "0.6", "0.015", "1000", "", "0.3", "0.3", "0.3"};
    protected static String[] m_textfield_defaults = new String[]{"junk.ta", "java.exe -classpath \".;bunch.jar\" clue.Clue", "", "junk.ta.bunch", "", "", "", "", "1", "0", "100", "1.0", "0.85", "500", "50", "0.6", "0.015", "1000", "", "0.3", "0.3", "0.3"};
    protected static String[] m_textfield_currents = new String[]{"junk.ta", "java.exe -classpath \".;bunch.jar\" clue.Clue", "", "junk.ta.bunch", "", "", "", "", "1", "0", "100", "1.0", "0.85", "500", "50", "0.6", "0.015", "1000", "", "0.3", "0.3", "0.3"};
    protected JComboBox m_clustering_approach = new JComboBox<String>(g_clustering_approach);
    protected JComboBox m_output_mode = new JComboBox<String>(g_output_mode);
    protected JComboBox m_cluster_algorithm = new JComboBox<String>(g_cluster_algorithm);
    protected JComboBox m_selection_method = new JComboBox<String>(g_selection_method);
    protected JComboBox m_calculator_classes = new JComboBox<String>(g_calculator_classes);
    protected JComboBox m_debug = new JComboBox<String>(g_debug);
    protected static final int DELETEEXPORT = 0;
    protected static final int DELETEIMPORT = 1;
    protected static final int LEAVES = 2;
    protected static final int FEEDBACK = 3;
    protected static final int VANILLA = 4;
    protected static final int ANNEALING = 5;
    protected static final int TIMEOUT = 6;
    protected static final int LOCK_USER = 7;
    protected static final String[] m_checkbox_tags = new String[]{"bunch:deleteExport", "bunch:deleteImport", "bunch:leaves", "bunch:feedback", "bunch:vanilla", "bunch:annealing", "bunch:timeout", "bunch:lockuser"};
    protected static final String[] m_checkbox_titles = new String[]{"Delete export file", "Delete import file", "Cluster leaves", "Feedback", "Vanilla", "Enable Simulated Annealing", "Limit runtime to", "Lock clusters"};
    protected static final boolean[] m_checkbox_resets = new boolean[]{false, false, true, true, false, false, false, false};
    protected static boolean[] m_checkbox_defaults = new boolean[]{false, false, true, true, false, false, false, false};
    protected static boolean[] m_checkbox_currents = new boolean[]{false, false, true, true, false, false, false, false};
    protected static final int BUTTON_OK = 0;
    protected static final int BUTTON_CANCEL = 1;
    protected static final int BUTTON_HELP = 2;
    protected static final int BUTTON_UNDO = 3;
    protected static final int BUTTON_DEFAULT = 4;
    protected static final int BUTTON_SET = 5;
    protected static final int BUTTON_RESET = 6;
    protected static final String[] m_button_titles = new String[]{"Ok", "Cancel", "Help", null, "Default", "Set", "Reset"};
    protected static final String[] m_button_tips = new String[]{null, null, null, "Enable/disable undo", "Use remembered default", "Set default to current", "Set default to initial"};
    protected static final int[] g_omnipresents = new int[]{256, 512, 1024, 1536};
    protected static final String[] g_omnipresent_names = new String[]{"LIBRARY_LIST", "OMNIPRESENT_CLIENTS", "OMNIPRESENT_SUPPLIERS", "OMNIPRESENT_BOTH"};
    protected Diagram m_dg;
    protected String m_ret;

    protected static String parameterString(int i) {
        return m_textfield_currents[i];
    }

    protected static boolean parameterBoolean(int i) {
        return m_checkbox_currents[i];
    }

    @Override
    public String getTag() {
        return "bunch:";
    }

    @Override
    public void reset() {
        int i;
        String[] textfield_resets = m_textfield_resets;
        String[] textfield_defaults = m_textfield_defaults;
        String[] textfield_currents = m_textfield_currents;
        boolean[] checkbox_resets = m_checkbox_resets;
        boolean[] checkbox_defaults = m_checkbox_defaults;
        boolean[] checkbox_currents = m_checkbox_currents;
        for (i = 0; i < textfield_resets.length; ++i) {
            String string;
            textfield_defaults[i] = string = textfield_resets[i];
            textfield_currents[i] = string;
        }
        for (i = 0; i < checkbox_resets.length; ++i) {
            boolean bool;
            checkbox_defaults[i] = bool = checkbox_resets[i];
            checkbox_currents[i] = bool;
        }
    }

    @Override
    public void loadLayoutOption(int mode, String attribute, String value) {
        int i;
        String[] textfield_tags = m_textfield_tags;
        for (i = 0; i < textfield_tags.length; ++i) {
            if (!attribute.startsWith(textfield_tags[i])) continue;
            switch (mode) {
                case 0: {
                    BunchClusterLayout.m_textfield_defaults[i] = value;
                }
                case 1: {
                    BunchClusterLayout.m_textfield_currents[i] = value;
                }
            }
            return;
        }
        String[] checkbox_tags = m_checkbox_tags;
        for (i = 0; i < checkbox_tags.length; ++i) {
            if (!attribute.equals(checkbox_tags[i])) continue;
            boolean bool = value.charAt(0) == 't';
            switch (mode) {
                case 0: {
                    BunchClusterLayout.m_checkbox_defaults[i] = bool;
                }
                case 1: {
                    BunchClusterLayout.m_checkbox_currents[i] = bool;
                }
            }
            return;
        }
    }

    @Override
    public void saveLayoutOptions(int mode, PrintWriter ps) {
        int i;
        boolean[] emit_booleans;
        String[] emit_strings;
        boolean[] prior_booleans;
        String[] prior_strings;
        switch (mode) {
            case 0: {
                prior_strings = m_textfield_resets;
                prior_booleans = m_checkbox_resets;
                emit_strings = m_textfield_defaults;
                emit_booleans = m_checkbox_defaults;
                break;
            }
            case 1: {
                prior_strings = m_textfield_defaults;
                prior_booleans = m_checkbox_defaults;
                emit_strings = m_textfield_currents;
                emit_booleans = m_checkbox_currents;
                break;
            }
            default: {
                return;
            }
        }
        for (i = 0; i < m_textfield_tags.length; ++i) {
            String string = emit_strings[i];
            if (string.equals(prior_strings[i])) continue;
            ps.println(m_textfield_tags[i] + "=" + string);
        }
        for (i = 0; i < m_checkbox_tags.length; ++i) {
            boolean bool = emit_booleans[i];
            if (bool == prior_booleans[i]) continue;
            ps.println(m_checkbox_tags[i] + "=" + (bool ? "true" : "false"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void log(String message) {
        if (BunchClusterLayout.parameterBoolean(3)) {
            BunchClusterLayout bunchClusterLayout = this;
            synchronized (bunchClusterLayout) {
                System.err.println(Util.toLocaleString() + ": " + message);
            }
        }
    }

    protected void message(String string) {
        this.log(string);
        JOptionPane.showMessageDialog(this.m_ls.getFrame(), string, "Error", 0);
    }

    public BunchClusterLayout(LandscapeEditorCore ls, LandscapeLayouter fallback) {
        super(ls, fallback);
        this.m_debug.setSelectedIndex(1);
    }

    @Override
    public String getName() {
        return "Bunch Cluster";
    }

    @Override
    public String getMenuLabel() {
        return "Bunch Cluster";
    }

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    public boolean isLayouter() {
        return false;
    }

    public boolean configure(LandscapeEditorCore ls, String message, Vector selected) {
        BunchClusterConfigure configure = new BunchClusterConfigure(this, message, selected);
        boolean ok = configure.ok();
        configure.dispose();
        return ok;
    }

    @Override
    public boolean configure(LandscapeEditorCore ls) {
        return this.configure(ls, null, null);
    }

    protected boolean write(Vector selectedBoxes, String exportname) {
        Diagram dg = this.m_ls.getDiagram();
        PrintWriter ps = null;
        try {
            this.log("Exporting " + exportname);
            File exportfile = new File(exportname);
            FileOutputStream os = new FileOutputStream(exportfile);
            ps = new PrintWriter(os);
        }
        catch (Exception error) {
            this.message("Exception creating export stream " + exportname + ": " + error.getMessage());
            return false;
        }
        boolean leaves = BunchClusterLayout.parameterBoolean(2);
        try {
            EntityInstance e;
            Enumeration en = selectedBoxes.elements();
            while (en.hasMoreElements()) {
                e = (EntityInstance)en.nextElement();
                e.orMark(0x4000000);
            }
            en = selectedBoxes.elements();
            while (en.hasMoreElements()) {
                EntityInstance e1;
                int weight;
                RelationClass rc;
                RelationInstance ri;
                Enumeration en1;
                e = (EntityInstance)en.nextElement();
                if (leaves) {
                    en1 = e.srcRelationElements();
                    if (en1 == null) continue;
                    while (en1.hasMoreElements()) {
                        ri = (RelationInstance)en1.nextElement();
                        rc = ri.getRelationClass();
                        weight = rc.getWeight();
                        if (weight == 0 || !(e1 = ri.getDst()).isMarked(0x4000000)) continue;
                        if (weight > 0) {
                            if (weight == 1) {
                                ps.println(e.getId() + " " + e1.getId());
                                continue;
                            }
                            ps.println(e.getId() + " " + e1.getId() + " " + weight);
                            continue;
                        }
                        if ((weight = -weight) == 1) {
                            ps.println(e1.getId() + " " + e.getId());
                            continue;
                        }
                        ps.println(e1.getId() + " " + e.getId() + " " + weight);
                    }
                    continue;
                }
                en1 = e.srcLiftedRelationElements();
                if (en1 == null) continue;
                while (en1.hasMoreElements()) {
                    ri = (RelationInstance)en1.nextElement();
                    rc = ri.getRelationClass();
                    weight = rc.getWeight();
                    if (weight == 0 || !(e1 = ri.getDrawDst()).isMarked(0x4000000)) continue;
                    if (weight > 0) {
                        if (weight == 1) {
                            ps.println(e.getId() + " " + e1.getId());
                            continue;
                        }
                        ps.println(e.getId() + " " + e1.getId() + " " + weight);
                        continue;
                    }
                    if ((weight = -weight) == 1) {
                        ps.println(e1.getId() + " " + e.getId());
                        continue;
                    }
                    ps.println(e1.getId() + " " + e.getId() + " " + weight);
                }
            }
            ps.close();
            if (ps.checkError()) {
                this.message("An unknown error occurred writing output");
                return false;
            }
            this.log("Export written");
        }
        catch (Exception error) {
            this.message("Exception writing output: " + error.getMessage());
            return false;
        }
        return true;
    }

    boolean waitFor(Process process) {
        try {
            int ret = process.waitFor();
            this.log("Process returned exit value of " + ret);
        }
        catch (Exception error) {
            this.message("WaitFor failed: " + error.getMessage());
            return false;
        }
        return true;
    }

    protected boolean read(String importname, EntityInstance container, boolean collapse) {
        EntityInstance e;
        BufferedReader in;
        Diagram diagram = this.m_ls.getDiagram();
        boolean ok = false;
        Hashtable<String, EntityInstance> clusters = new Hashtable<String, EntityInstance>();
        this.log("Importing '" + importname + "'");
        try {
            FileReader fileReader = new FileReader(importname);
            in = new BufferedReader(fileReader);
        }
        catch (Exception error) {
            this.message("Exception opening " + importname + ": " + error.getMessage());
            return false;
        }
        int line = 0;
        String str = "";
        try {
            block6: while ((str = in.readLine()) != null) {
                ++line;
                String keyword = str.substring(0, 3);
                if (!keyword.equals("SS(")) {
                    this.message("Expected to see 'contain ' but saw '" + keyword + "' in " + importname + " at line " + line);
                    break;
                }
                int index = str.indexOf(41, 3);
                if (index < 1) {
                    this.message("First token missing in " + importname + " at line " + line);
                    break;
                }
                String firstToken = str.substring(3, index);
                if (firstToken.equals("ROOT") && str.equals("SS(ROOT) = ")) {
                    this.message("Bunch found nothing worth clustering");
                    continue;
                }
                EntityInstance cluster = (EntityInstance)clusters.get(firstToken);
                if (cluster == null) {
                    cluster = diagram.updateNewEntity(null, container);
                    cluster.setLabel(firstToken);
                    clusters.put(firstToken, cluster);
                }
                index = str.indexOf(61, index);
                while (index > 0) {
                    String secondToken;
                    int endindex = str.indexOf(44, index += 2);
                    if ((secondToken = endindex < 0 ? str.substring(index) : str.substring(index, endindex)).length() < 1) {
                        this.message("Second token missing in " + importname + " at line " + line);
                        continue block6;
                    }
                    e = (EntityInstance)clusters.get(secondToken);
                    if (e == null) {
                        e = diagram.getCache(secondToken);
                    }
                    if (e == null) {
                        e = diagram.updateNewEntity(null, cluster);
                        e.setLabel(secondToken);
                        clusters.put(secondToken, e);
                    } else {
                        EntityInstance parent = e.getContainedBy();
                        diagram.updateMoveEntityContainment(cluster, e);
                        if (collapse) {
                            while (true) {
                                e = parent;
                                parent = e.getContainedBy();
                                if (e.getFirstChild() != null) break;
                                diagram.updateCutEntity(e);
                            }
                        }
                    }
                    index = endindex;
                }
            }
        }
        catch (Exception error) {
            this.message("Exception reading " + importname + ": " + error.getMessage());
        }
        if (str == null) {
            Enumeration en = clusters.elements();
            while (en.hasMoreElements()) {
                e = (EntityInstance)en.nextElement();
                diagram.doRelayoutAll(e, false);
            }
            ok = true;
        }
        clusters.clear();
        try {
            in.close();
        }
        catch (Exception error) {
            this.message("Exception closing " + importname + ": " + error.getMessage());
            return false;
        }
        return ok;
    }

    protected void emitParameter(PrintWriter ps, String name, String value) {
        if (value != null && (value = value.trim()).length() > 0) {
            ps.println(name + "=" + value);
        }
    }

    protected void emitParameter(PrintWriter ps, String name, int arg) {
        String value = BunchClusterLayout.parameterString(arg);
        if (value != null && (value = value.trim()).length() > 0) {
            ps.println(name + "=" + value);
        }
    }

    @Override
    public boolean doLayout1(Vector masterBoxes, EntityInstance parent) {
        String exportname;
        block52: {
            String importname;
            String command;
            int size;
            EntityInstance e;
            Vector selectedBoxes;
            boolean calledConfigure;
            boolean leaves;
            block51: {
                String string;
                leaves = BunchClusterLayout.parameterBoolean(2);
                calledConfigure = false;
                if (!leaves) {
                    selectedBoxes = masterBoxes;
                } else {
                    selectedBoxes = new Vector();
                    Enumeration en = masterBoxes.elements();
                    while (en.hasMoreElements()) {
                        e = (EntityInstance)en.nextElement();
                        e.gatherLeaves(selectedBoxes);
                    }
                }
                size = selectedBoxes.size();
                if (size < 2) {
                    this.m_ret = "Too few entities to reasonably cluster";
                    return true;
                }
                do {
                    exportname = BunchClusterLayout.parameterString(0);
                    command = BunchClusterLayout.parameterString(1);
                    importname = BunchClusterLayout.parameterString(3);
                    string = null;
                    if (exportname.length() == 0) {
                        string = "Please specify an export file to write to";
                    }
                    if (string == null) break block51;
                    calledConfigure = true;
                } while (this.configure(this.m_ls, string, selectedBoxes));
                return true;
            }
            if (!calledConfigure && !this.configure(this.m_ls, null, selectedBoxes)) {
                return true;
            }
            this.log("Using Bunch to cluster " + size + " items");
            if (!this.write(selectedBoxes, exportname)) {
                return false;
            }
            if (command.length() == 0) {
                this.m_ret = "Bunch output written to file";
                return true;
            }
            int debug = this.m_debug.getSelectedIndex();
            boolean vanilla = BunchClusterLayout.parameterBoolean(4);
            RunBunch runBunch = new RunBunch();
            new Thread(runBunch).start();
            Process process = runBunch.getProcess();
            if (process == null) {
                return false;
            }
            if (!vanilla) {
                boolean flag;
                String value;
                OutputStream os = process.getOutputStream();
                PrintWriter ps = new PrintWriter(os);
                this.log("Writing API instructions to bunch");
                if (debug > 0) {
                    ps.println("DEBUG=" + g_debug[debug]);
                }
                this.emitParameter(ps, "MDG_INPUT_FILE_NAME", 0);
                if (importname != null && importname.length() > 0) {
                    if (importname.endsWith(".bunch")) {
                        value = importname.substring(0, importname.length() - 6);
                    } else {
                        value = importname;
                        importname = importname + ".bunch";
                    }
                    this.emitParameter(ps, "OUTPUT_FILE", value);
                } else {
                    this.emitParameter(ps, "OUTPUT_DIRECTORY", 2);
                }
                ps.println("OUTPUT_FORMAT=Text");
                ps.println("OUTPUT_TREE=True");
                int i = this.m_output_mode.getSelectedIndex();
                if (i >= 0) {
                    ps.println("MDG_OUTPUT_MODE=" + g_output_mode[i]);
                }
                if ((i = this.m_clustering_approach.getSelectedIndex()) >= 0) {
                    ps.println("CLUSTERING_APPROACH=" + g_clustering_approach[i]);
                }
                if ((i = this.m_cluster_algorithm.getSelectedIndex()) >= 0) {
                    ps.println("CLUSTERING_ALG=" + g_cluster_algorithm[i]);
                    switch (i) {
                        case 0: {
                            this.emitParameter(ps, "ALG_HC_POPULATION_SZ", 8);
                            this.emitParameter(ps, "ALG_HC_HC_PCT", 9);
                            this.emitParameter(ps, "ALG_HC_RND_PCT", 10);
                            if (!BunchClusterLayout.parameterBoolean(5)) break;
                            ps.println("ALG_HC_SA_CLASS=" + g_techniques[0]);
                            value = BunchClusterLayout.parameterString(11);
                            String value1 = BunchClusterLayout.parameterString(12);
                            if (value == null) {
                                value = "";
                            }
                            if (value1 == null) {
                                value1 = "";
                            }
                            value = value.trim();
                            value1 = value1.trim();
                            if (value.length() <= 0 && value1.length() <= 0) break;
                            ps.print("ALG_HC_SA_CONFIG=");
                            flag = false;
                            if (value.length() > 0) {
                                ps.print("InitialTemp=" + value);
                                flag = true;
                            }
                            if (value1.length() <= 0) break;
                            if (flag) {
                                ps.print(",");
                            }
                            ps.print("Alpha=" + value1);
                            break;
                        }
                        case 1: {
                            i = this.m_selection_method.getSelectedIndex();
                            if (i >= 0) {
                                ps.println("ALG_GA_SELECTION_METHOD=" + g_selection_method[i]);
                            }
                            this.emitParameter(ps, "ALG_GA_NUM_GENERATIONS", 13);
                            this.emitParameter(ps, "ALG_GA_POPULATION_SZ", 14);
                            this.emitParameter(ps, "ALG_GA_CROSSOVER_PROB", 15);
                            this.emitParameter(ps, "ALG_GA_MUTATION_PROB", 16);
                        }
                    }
                }
                if ((i = this.m_calculator_classes.getSelectedIndex()) >= 0) {
                    ps.println("MQ_CALCULATOR_CLASS=" + g_calculator_classes[i]);
                }
                this.emitParameter(ps, "USER_DIRECTED_CLUSTER_SIL", 18);
                if (BunchClusterLayout.parameterBoolean(7)) {
                    this.emitParameter(ps, "LOCK_USER_SET_CLUSTERS", "True");
                }
                if (BunchClusterLayout.parameterBoolean(6)) {
                    this.emitParameter(ps, "TIMEOUT_TIME", 17);
                }
                for (i = 0; i < g_omnipresents.length; ++i) {
                    flag = false;
                    int match = g_omnipresents[i];
                    for (int j = 0; j < selectedBoxes.size(); ++j) {
                        e = (EntityInstance)selectedBoxes.elementAt(j);
                        if (e.getOmnipresent() != match) continue;
                        if (!flag) {
                            ps.print(g_omnipresent_names[i] + "=");
                            flag = true;
                        } else {
                            ps.print(",");
                        }
                        ps.print(e.getId());
                    }
                    if (!flag) continue;
                    ps.println("");
                }
                ps.close();
                InputStream is = process.getInputStream();
                int c = 32;
                try {
                    c = is.read();
                }
                catch (Exception error) {
                    // empty catch block
                }
                if (c != 79) {
                    this.message("Bunch execution failed");
                    return false;
                }
            }
            if (!this.waitFor(process)) {
                return false;
            }
            if (importname != null && importname.length() > 0) {
                if (!this.read(importname, parent, leaves)) {
                    return false;
                }
                this.log("Import loaded");
                this.m_ret = "Graph redrawn using Bunch";
                if (BunchClusterLayout.parameterBoolean(1)) {
                    try {
                        File importfile = new File(importname);
                        if (!importfile.delete()) {
                            this.message("Unable to delete '" + importfile + "'");
                            break block52;
                        }
                        this.log("Deleted " + importfile);
                    }
                    catch (Exception error) {
                        this.message("Exception deleting '" + importname + "' " + error.getMessage());
                    }
                }
            } else {
                this.m_ret = "No import file name specified";
            }
        }
        if (exportname.length() != 0 && BunchClusterLayout.parameterBoolean(0)) {
            try {
                File exportfile = new File(exportname);
                if (!exportfile.delete()) {
                    this.message("Unable to delete '" + exportfile + "'");
                } else {
                    this.log("Deleted " + exportfile);
                }
            }
            catch (Exception error) {
                this.message("Exception deleting '" + exportname + "' " + error.getMessage());
            }
        }
        return true;
    }

    @Override
    public String doLayout(Diagram dg) {
        LandscapeEditorCore ls = this.m_ls;
        this.m_dg = dg;
        Vector masterBoxes = dg.getClusterGroup();
        if (masterBoxes == null) {
            Util.beep();
            return "No group selected";
        }
        EntityInstance parent = this.parentOfSet(masterBoxes);
        if (parent == null) {
            return "Cluster layout requires that all things laid out share same parent";
        }
        this.m_ret = "Bunch Cluster layout aborted";
        ls.doLayout1(this, masterBoxes, parent, false);
        return this.m_ret;
    }

    @Override
    public void processKeyEvent(int key, int modifiers, Object object) {
        Diagram dg = this.m_ls.getDiagram();
        if (dg != null) {
            String rmsg = this.doLayout(dg);
            this.m_ls.doFeedback(rmsg);
        }
    }

    class RunBunch
    implements Runnable {
        Process m_process = null;
        boolean m_waiting = true;

        RunBunch() {
        }

        public synchronized Process getProcess() {
            while (this.m_waiting) {
                try {
                    this.wait(1L);
                }
                catch (Exception error) {
                    BunchClusterLayout.this.message("wait error: " + error.getMessage());
                }
            }
            return this.m_process;
        }

        public Process startCommand(String command) {
            Process process = null;
            BunchClusterLayout.this.log("Executing [" + command + "]");
            try {
                Runtime runtime = Runtime.getRuntime();
                if (runtime == null) {
                    BunchClusterLayout.this.message("No runtime available");
                } else {
                    process = runtime.exec(command);
                }
            }
            catch (Exception error) {
                BunchClusterLayout.this.log("Exception executing [" + command + "] " + error.getMessage());
                process = null;
            }
            if (process != null) {
                ErrOutput errOutput = new ErrOutput(process.getErrorStream());
                new Thread(errOutput).start();
                if (BunchClusterLayout.parameterBoolean(4)) {
                    ErrOutput stdOutput = new ErrOutput(process.getInputStream());
                    new Thread(stdOutput).start();
                }
            }
            this.m_process = process;
            this.m_waiting = false;
            return process;
        }

        @Override
        public void run() {
            String command = BunchClusterLayout.parameterString(1);
            this.startCommand(command);
        }
    }

    class ErrOutput
    implements Runnable {
        InputStream m_inputStream = null;

        ErrOutput(InputStream inputStream) {
            this.m_inputStream = inputStream;
        }

        @Override
        public void run() {
            try {
                String s;
                InputStreamReader isReader = new InputStreamReader(this.m_inputStream);
                BufferedReader reader = new BufferedReader(isReader);
                while ((s = reader.readLine()) != null) {
                    BunchClusterLayout.this.log(s);
                }
                reader.close();
            }
            catch (Exception error) {
                BunchClusterLayout.this.log("ErrOutput error: " + error.getMessage());
            }
        }
    }

    class EchoOutput
    implements Runnable {
        InputStream m_inputStream = null;
        String m_source;

        EchoOutput(String source, InputStream inputStream) {
            this.m_inputStream = inputStream;
            this.m_source = source;
        }

        @Override
        public void run() {
            String source = this.m_source;
            try {
                String s;
                InputStreamReader isReader = new InputStreamReader(this.m_inputStream);
                BufferedReader reader = new BufferedReader(isReader);
                while ((s = reader.readLine()) != null) {
                    BunchClusterLayout.this.log(source + ": " + s);
                }
                reader.close();
            }
            catch (Exception error) {
                BunchClusterLayout.this.log(source + " input error: " + error.getMessage());
            }
        }
    }

    class BunchClusterConfigure
    extends JDialog
    implements ActionListener {
        private JTabbedPane m_topPanel;
        private BasicTab m_basicTab;
        private OptionsTab m_optionsTab;
        private LibrariesTab m_librariesTab;
        private ClientsTab m_clientsTab;
        private SuppliersTab m_suppliersTab;
        private BothTab m_bothTab;
        private UserTab m_userTab;
        private WeightsTab m_weightsTab;
        protected Vector m_selected;
        protected ListVector m_sorted;
        protected JTextField[] m_textfields;
        protected JCheckBox[] m_checkboxes;
        protected JButton[] m_buttons;
        protected JLabel m_message;
        protected boolean m_isok;

        protected void setTabStates() {
            boolean state = !this.m_checkboxes[4].isSelected();
            this.m_topPanel.remove(this.m_optionsTab);
            if (this.m_librariesTab != null) {
                this.m_topPanel.remove(this.m_librariesTab);
            }
            if (this.m_clientsTab != null) {
                this.m_topPanel.remove(this.m_clientsTab);
            }
            if (this.m_suppliersTab != null) {
                this.m_topPanel.remove(this.m_suppliersTab);
            }
            if (this.m_bothTab != null) {
                this.m_topPanel.remove(this.m_bothTab);
            }
            if (this.m_userTab != null) {
                this.m_topPanel.remove(this.m_userTab);
            }
            if (state) {
                this.m_topPanel.addTab("Options", null, this.m_optionsTab, null);
                if (this.m_selected != null) {
                    if (this.m_librariesTab == null) {
                        this.m_librariesTab = new LibrariesTab();
                    }
                    if (this.m_clientsTab == null) {
                        this.m_clientsTab = new ClientsTab();
                    }
                    if (this.m_suppliersTab == null) {
                        this.m_suppliersTab = new SuppliersTab();
                    }
                    if (this.m_bothTab == null) {
                        this.m_bothTab = new BothTab();
                    }
                    if (this.m_userTab == null) {
                        this.m_userTab = new UserTab();
                    }
                    this.m_topPanel.addTab("Libraries", null, this.m_librariesTab, null);
                    this.m_topPanel.addTab("Clients", null, this.m_clientsTab, null);
                    this.m_topPanel.addTab("Suppliers", null, this.m_suppliersTab, null);
                    this.m_topPanel.addTab("Both", null, this.m_bothTab, null);
                    this.m_topPanel.addTab("User directed clustering", null, this.m_userTab, null);
                }
            }
        }

        public BunchClusterConfigure(BunchClusterLayout layout, String message, Vector selected) {
            int i;
            super(layout.getLs().getFrame(), layout.getName() + " Configuration", true);
            this.m_isok = false;
            this.m_selected = selected;
            if (selected != null) {
                this.m_sorted = new ListVector(selected.size());
                this.m_sorted.addAll(selected);
                SortVector.byString(this.m_sorted);
            } else {
                this.m_sorted = null;
            }
            Font font = FontCache.getDialogFont();
            Font bold = font.deriveFont(1);
            Container contentPane = this.getContentPane();
            contentPane.setLayout(new BorderLayout());
            this.setForeground(ColorCache.get(0, 0, 0));
            this.setBackground(ColorCache.get(192, 192, 192));
            this.setFont(font);
            this.m_textfields = new JTextField[m_textfield_tags.length];
            for (i = 0; i < m_textfield_tags.length; ++i) {
                JTextField textfield;
                this.m_textfields[i] = textfield = new JTextField(m_textfield_currents[i], 60);
                textfield.setFont(font);
            }
            this.m_checkboxes = new JCheckBox[m_checkbox_tags.length];
            for (i = 0; i < m_checkbox_tags.length; ++i) {
                JCheckBox checkbox;
                this.m_checkboxes[i] = checkbox = new JCheckBox(m_checkbox_titles[i], m_checkbox_currents[i]);
                checkbox.setFont(font);
            }
            this.m_topPanel = new JTabbedPane();
            this.m_optionsTab = new OptionsTab();
            this.m_basicTab = new BasicTab();
            this.m_weightsTab = new WeightsTab();
            this.m_topPanel.addTab("Basic", null, this.m_basicTab, null);
            this.m_topPanel.addTab("Weights", null, this.m_weightsTab, null);
            this.setTabStates();
            if (message == null) {
                message = BunchClusterLayout.this.m_ls.getDiagram().undoEnabled() ? "You might wish to disable undo/redo operations" : "You might wish to enable undo/redo operations";
            }
            this.m_message = new JLabel(message, 0);
            this.m_message.setFont(font);
            this.m_message.setForeground(Color.RED);
            this.m_message.setSize(400, 50);
            this.m_message.setPreferredSize(new Dimension(400, 50));
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new FlowLayout(1, 15, 15));
            this.m_buttons = new JButton[m_button_titles.length];
            for (i = 0; i < m_button_titles.length; ++i) {
                JButton button;
                String string = m_button_titles[i];
                if (string == null) {
                    string = BunchClusterLayout.this.undoLabel();
                }
                this.m_buttons[i] = button = new JButton(string);
                button.setFont(bold);
                String tip = m_button_tips[i];
                if (tip != null) {
                    button.setToolTipText(tip);
                }
                button.addActionListener(this);
                buttonPanel.add(button);
            }
            contentPane.add("North", this.m_topPanel);
            contentPane.add("South", buttonPanel);
            contentPane.add("Center", this.m_message);
            this.pack();
            this.setVisible(true);
        }

        public boolean ok() {
            return this.m_isok;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            int i;
            Object source = ev.getSource();
            int state = -1;
            for (i = 0; i < m_button_titles.length; ++i) {
                if (source != this.m_buttons[i]) continue;
                state = i;
                break;
            }
            switch (state) {
                case 6: {
                    for (i = 0; i < m_textfield_tags.length; ++i) {
                        BunchClusterLayout.m_textfield_defaults[i] = m_textfield_resets[i];
                    }
                    for (i = 0; i < m_checkbox_tags.length; ++i) {
                        BunchClusterLayout.m_checkbox_defaults[i] = m_checkbox_resets[i];
                    }
                }
                case 4: {
                    for (i = 0; i < m_textfield_tags.length; ++i) {
                        this.m_textfields[i].setText(m_textfield_defaults[i]);
                    }
                    for (i = 0; i < m_checkbox_tags.length; ++i) {
                        this.m_checkboxes[i].setSelected(m_checkbox_defaults[i]);
                    }
                    BunchClusterLayout.this.m_clustering_approach.setSelectedIndex(0);
                    BunchClusterLayout.this.m_output_mode.setSelectedIndex(0);
                    BunchClusterLayout.this.m_cluster_algorithm.setSelectedIndex(0);
                    BunchClusterLayout.this.m_selection_method.setSelectedIndex(0);
                    BunchClusterLayout.this.m_debug.setSelectedIndex(1);
                    return;
                }
                case 5: {
                    for (i = 0; i < m_textfield_tags.length; ++i) {
                        BunchClusterLayout.m_textfield_defaults[i] = this.m_textfields[i].getText();
                    }
                    for (i = 0; i < m_checkbox_tags.length; ++i) {
                        BunchClusterLayout.m_checkbox_defaults[i] = this.m_checkboxes[i].isSelected();
                    }
                    return;
                }
                case 3: {
                    LandscapeEditorCore ls = BunchClusterLayout.this.m_ls;
                    ls.invertUndo();
                    this.m_buttons[state].setText(BunchClusterLayout.this.undoLabel());
                    this.m_message.setText("");
                    return;
                }
                case 2: {
                    JOptionPane.showMessageDialog(BunchClusterLayout.this.m_ls.getFrame(), "The Bunch clustering algorithm attempts to cluster nodes by using the external bunch command line interface\nThis command line interface to bunch is named clue. For help and documentation on bunch please visit:\nhttp://serg.mcs.drexel.edu/bunch", "Help", 0);
                    return;
                }
                case 0: {
                    if (!this.m_weightsTab.isOk()) {
                        this.m_message.setText("Weights must be integers");
                        return;
                    }
                    this.m_weightsTab.setWeights();
                    for (i = 0; i < m_textfield_tags.length; ++i) {
                        BunchClusterLayout.m_textfield_currents[i] = this.m_textfields[i].getText();
                    }
                    for (i = 0; i < m_checkbox_tags.length; ++i) {
                        BunchClusterLayout.m_checkbox_currents[i] = this.m_checkboxes[i].isSelected();
                    }
                    this.m_isok = true;
                }
                case 1: {
                    break;
                }
                default: {
                    return;
                }
            }
            this.setVisible(false);
        }

        class UserTab
        extends Box
        implements ActionListener {
            private JTextField m_userfile;
            private JCheckBox m_lock;
            private JButton m_fileButton;
            private JButton m_clearButton;

            public UserTab() {
                super(1);
                this.m_fileButton = new JButton("Select...");
                this.m_clearButton = new JButton("Clear");
                Font font = FontCache.getDialogFont();
                Font bold = font.deriveFont(1);
                JPanel row = new JPanel();
                row.add(new JLabel());
                this.add(row);
                row = new JPanel();
                row.setLayout(new FlowLayout());
                JLabel label = new JLabel(m_textfield_titles[18], 4);
                label.setFont(bold);
                row.add(label);
                this.m_userfile = BunchClusterConfigure.this.m_textfields[18];
                this.m_userfile.setColumns(50);
                row.add(this.m_userfile);
                this.m_fileButton.addActionListener(this);
                row.add(this.m_fileButton);
                this.add(row);
                row = new JPanel();
                row.setLayout(new FlowLayout());
                this.m_lock = BunchClusterConfigure.this.m_checkboxes[7];
                row.add(this.m_lock);
                this.m_clearButton.addActionListener(this);
                row.add(this.m_clearButton);
                this.add(row);
            }

            @Override
            public void actionPerformed(ActionEvent ev) {
                Object source = ev.getSource();
                if (source == this.m_fileButton) {
                    String name = BunchClusterLayout.this.m_ls.filePrompt("File to read preconfigured clustering from", this.m_userfile.getText(), 0, null);
                    if (name != null) {
                        this.m_userfile.setText(name);
                    }
                    return;
                }
                if (source == this.m_clearButton) {
                    this.m_userfile.setText("");
                    this.m_lock.setSelected(false);
                    return;
                }
            }
        }

        class BothTab
        extends OmnipresentTab
        implements ActionListener {
            JTextField m_multiple;

            @Override
            protected int match() {
                return 1536;
            }

            @Override
            protected String topLabel() {
                return "Clients and Suppliers:";
            }

            @Override
            protected String generalLabel() {
                return "items";
            }

            @Override
            protected String findText() {
                return "Find nodes having excessive edges";
            }

            @Override
            protected JTextField multiple() {
                this.m_multiple = BunchClusterConfigure.this.m_textfields[21];
                return this.m_multiple;
            }

            @Override
            protected String multipleLabel() {
                return "edges";
            }

            @Override
            protected boolean find() {
                EntityInstance e1;
                RelationClass rc;
                RelationInstance ri;
                Enumeration en;
                EntityInstance e;
                int i;
                double multiple;
                ListVector sorted = BunchClusterConfigure.this.m_sorted;
                int size = sorted.size();
                boolean change = false;
                boolean leaves = BunchClusterLayout.parameterBoolean(2);
                String string = this.m_multiple.getText();
                try {
                    multiple = Double.parseDouble(string);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(BunchClusterLayout.this.m_ls.getFrame(), "Multiple value '" + string + "' is not a double", "Can't find items", 2);
                    return false;
                }
                if (size == 0) {
                    return false;
                }
                int cnt = 0;
                for (i = 0; i < size; ++i) {
                    e = (EntityInstance)sorted.elementAt(i);
                    if (leaves) {
                        en = e.srcRelationElements();
                        if (en != null) {
                            while (en.hasMoreElements()) {
                                ri = (RelationInstance)en.nextElement();
                                rc = ri.getRelationClass();
                                if (rc.getWeight() == 0 || !(e1 = ri.getDst()).isMarked(0x4000000)) continue;
                                ++cnt;
                            }
                        }
                        if ((en = e.dstRelationElements()) == null) continue;
                        while (en.hasMoreElements()) {
                            ri = (RelationInstance)en.nextElement();
                            rc = ri.getRelationClass();
                            if (rc.getWeight() == 0 || !(e1 = ri.getSrc()).isMarked(0x4000000)) continue;
                            ++cnt;
                        }
                        continue;
                    }
                    en = e.srcLiftedRelationElements();
                    if (en != null) {
                        while (en.hasMoreElements()) {
                            ri = (RelationInstance)en.nextElement();
                            rc = ri.getRelationClass();
                            if (rc.getWeight() == 0 || !(e1 = ri.getDrawDst()).isMarked(0x4000000)) continue;
                            ++cnt;
                        }
                    }
                    if ((en = e.dstLiftedRelationElements()) == null) continue;
                    while (en.hasMoreElements()) {
                        ri = (RelationInstance)en.nextElement();
                        rc = ri.getRelationClass();
                        if (rc.getWeight() == 0 || !(e1 = ri.getDrawSrc()).isMarked(0x4000000)) continue;
                        ++cnt;
                    }
                }
                if (cnt == 0) {
                    return false;
                }
                double average = multiple * (double)cnt / (double)size;
                for (i = 0; i < size; ++i) {
                    e = (EntityInstance)sorted.elementAt(i);
                    cnt = 0;
                    if (leaves) {
                        en = e.srcRelationElements();
                        if (en != null) {
                            while (en.hasMoreElements()) {
                                ri = (RelationInstance)en.nextElement();
                                rc = ri.getRelationClass();
                                if (rc.getWeight() == 0 || !(e1 = ri.getDst()).isMarked(0x4000000)) continue;
                                ++cnt;
                            }
                        }
                        if ((en = e.dstRelationElements()) != null) {
                            while (en.hasMoreElements()) {
                                ri = (RelationInstance)en.nextElement();
                                rc = ri.getRelationClass();
                                if (rc.getWeight() == 0 || !(e1 = ri.getSrc()).isMarked(0x4000000)) continue;
                                ++cnt;
                            }
                        }
                    } else {
                        en = e.srcLiftedRelationElements();
                        if (en != null) {
                            while (en.hasMoreElements()) {
                                ri = (RelationInstance)en.nextElement();
                                rc = ri.getRelationClass();
                                if (rc.getWeight() == 0 || !(e1 = ri.getDrawDst()).isMarked(0x4000000)) continue;
                                ++cnt;
                            }
                        }
                        if ((en = e.dstLiftedRelationElements()) != null) {
                            while (en.hasMoreElements()) {
                                ri = (RelationInstance)en.nextElement();
                                rc = ri.getRelationClass();
                                if (rc.getWeight() == 0 || !(e1 = ri.getDrawSrc()).isMarked(0x4000000)) continue;
                                ++cnt;
                            }
                        }
                    }
                    if (cnt <= 0 || !((double)cnt >= average)) continue;
                    e.orMark(1536);
                    change = true;
                }
                return change;
            }

            @Override
            public void actionPerformed(ActionEvent ev) {
                super.actionPerformed(ev);
            }
        }

        class SuppliersTab
        extends OmnipresentTab
        implements ActionListener {
            JTextField m_multiple;

            @Override
            protected int match() {
                return 1024;
            }

            @Override
            protected String topLabel() {
                return "Suppliers:";
            }

            @Override
            protected String generalLabel() {
                return "suppliers";
            }

            @Override
            protected String findText() {
                return "Find nodes having excessive inputs";
            }

            @Override
            protected JTextField multiple() {
                this.m_multiple = BunchClusterConfigure.this.m_textfields[20];
                return this.m_multiple;
            }

            @Override
            protected String multipleLabel() {
                return "inputs";
            }

            @Override
            protected boolean find() {
                EntityInstance e1;
                RelationClass rc;
                RelationInstance ri;
                Enumeration en;
                EntityInstance e;
                int i;
                double multiple;
                ListVector sorted = BunchClusterConfigure.this.m_sorted;
                int size = sorted.size();
                boolean pos = this.positiveWeights();
                boolean neg = this.negativeWeights();
                boolean change = false;
                boolean leaves = BunchClusterLayout.parameterBoolean(2);
                String string = this.m_multiple.getText();
                try {
                    multiple = Double.parseDouble(string);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(BunchClusterLayout.this.m_ls.getFrame(), "Multiple value '" + string + "' is not a double", "Can't find items", 2);
                    return false;
                }
                if (size == 0) {
                    return false;
                }
                int cnt = 0;
                for (i = 0; i < size; ++i) {
                    e = (EntityInstance)sorted.elementAt(i);
                    if (pos) {
                        if (leaves) {
                            en = e.dstRelationElements();
                            if (en != null) {
                                while (en.hasMoreElements()) {
                                    ri = (RelationInstance)en.nextElement();
                                    rc = ri.getRelationClass();
                                    if (rc.getWeight() <= 0 || !(e1 = ri.getSrc()).isMarked(0x4000000)) continue;
                                    ++cnt;
                                }
                            }
                        } else {
                            en = e.dstLiftedRelationElements();
                            if (en != null) {
                                while (en.hasMoreElements()) {
                                    ri = (RelationInstance)en.nextElement();
                                    rc = ri.getRelationClass();
                                    if (rc.getWeight() <= 0 || !(e1 = ri.getDrawSrc()).isMarked(0x4000000)) continue;
                                    ++cnt;
                                }
                            }
                        }
                    }
                    if (!neg) continue;
                    if (leaves) {
                        en = e.srcRelationElements();
                        if (en == null) continue;
                        while (en.hasMoreElements()) {
                            ri = (RelationInstance)en.nextElement();
                            rc = ri.getRelationClass();
                            if (rc.getWeight() >= 0 || !(e1 = ri.getDst()).isMarked(0x4000000)) continue;
                            ++cnt;
                        }
                        continue;
                    }
                    en = e.srcLiftedRelationElements();
                    if (en == null) continue;
                    while (en.hasMoreElements()) {
                        ri = (RelationInstance)en.nextElement();
                        rc = ri.getRelationClass();
                        if (rc.getWeight() >= 0 || !(e1 = ri.getDrawDst()).isMarked(0x4000000)) continue;
                        ++cnt;
                    }
                }
                if (cnt == 0) {
                    return false;
                }
                double average = multiple * (double)cnt / (double)size;
                for (i = 0; i < size; ++i) {
                    e = (EntityInstance)sorted.elementAt(i);
                    cnt = 0;
                    if (pos) {
                        if (leaves) {
                            en = e.dstRelationElements();
                            if (en != null) {
                                while (en.hasMoreElements()) {
                                    ri = (RelationInstance)en.nextElement();
                                    rc = ri.getRelationClass();
                                    if (rc.getWeight() <= 0 || !(e1 = ri.getSrc()).isMarked(0x4000000)) continue;
                                    ++cnt;
                                }
                            }
                        } else {
                            en = e.dstLiftedRelationElements();
                            if (en != null) {
                                while (en.hasMoreElements()) {
                                    ri = (RelationInstance)en.nextElement();
                                    rc = ri.getRelationClass();
                                    if (rc.getWeight() <= 0 || !(e1 = ri.getDrawSrc()).isMarked(0x4000000)) continue;
                                    ++cnt;
                                }
                            }
                        }
                    }
                    if (neg) {
                        if (leaves) {
                            en = e.srcRelationElements();
                            if (en != null) {
                                while (en.hasMoreElements()) {
                                    ri = (RelationInstance)en.nextElement();
                                    rc = ri.getRelationClass();
                                    if (rc.getWeight() >= 0 || !(e1 = ri.getDst()).isMarked(0x4000000)) continue;
                                    ++cnt;
                                }
                            }
                        } else {
                            en = e.srcLiftedRelationElements();
                            if (en != null) {
                                while (en.hasMoreElements()) {
                                    ri = (RelationInstance)en.nextElement();
                                    rc = ri.getRelationClass();
                                    if (rc.getWeight() >= 0 || !(e1 = ri.getDrawDst()).isMarked(0x4000000)) continue;
                                    ++cnt;
                                }
                            }
                        }
                    }
                    if (cnt <= 0 || !((double)cnt >= average)) continue;
                    e.orMark(1024);
                    change = true;
                }
                return change;
            }

            @Override
            public void actionPerformed(ActionEvent ev) {
                super.actionPerformed(ev);
            }
        }

        class ClientsTab
        extends OmnipresentTab
        implements ActionListener {
            JTextField m_multiple;

            @Override
            protected int match() {
                return 512;
            }

            @Override
            protected String topLabel() {
                return "Clients:";
            }

            @Override
            protected String generalLabel() {
                return "clients";
            }

            @Override
            protected String findText() {
                return "Find nodes having excessive outputs";
            }

            @Override
            protected JTextField multiple() {
                this.m_multiple = BunchClusterConfigure.this.m_textfields[19];
                return this.m_multiple;
            }

            @Override
            protected String multipleLabel() {
                return "outputs";
            }

            @Override
            protected boolean find() {
                EntityInstance e1;
                RelationClass rc;
                RelationInstance ri;
                Enumeration en;
                EntityInstance e;
                int i;
                double multiple;
                ListVector sorted = BunchClusterConfigure.this.m_sorted;
                int size = sorted.size();
                boolean pos = this.positiveWeights();
                boolean neg = this.negativeWeights();
                boolean change = false;
                boolean leaves = BunchClusterLayout.parameterBoolean(2);
                String string = this.m_multiple.getText();
                try {
                    multiple = Double.parseDouble(string);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(BunchClusterLayout.this.m_ls.getFrame(), "Multiple value '" + string + "' is not a double", "Can't find items", 2);
                    return false;
                }
                if (size == 0) {
                    return false;
                }
                int cnt = 0;
                for (i = 0; i < size; ++i) {
                    e = (EntityInstance)sorted.elementAt(i);
                    if (pos) {
                        if (leaves) {
                            en = e.srcRelationElements();
                            if (en != null) {
                                while (en.hasMoreElements()) {
                                    ri = (RelationInstance)en.nextElement();
                                    rc = ri.getRelationClass();
                                    if (rc.getWeight() <= 0 || !(e1 = ri.getDst()).isMarked(0x4000000)) continue;
                                    ++cnt;
                                }
                            }
                        } else {
                            en = e.srcLiftedRelationElements();
                            if (en != null) {
                                while (en.hasMoreElements()) {
                                    ri = (RelationInstance)en.nextElement();
                                    rc = ri.getRelationClass();
                                    if (rc.getWeight() <= 0 || !(e1 = ri.getDrawDst()).isMarked(0x4000000)) continue;
                                    ++cnt;
                                }
                            }
                        }
                    }
                    if (!neg) continue;
                    if (leaves) {
                        en = e.dstRelationElements();
                        if (en == null) continue;
                        while (en.hasMoreElements()) {
                            ri = (RelationInstance)en.nextElement();
                            rc = ri.getRelationClass();
                            if (rc.getWeight() >= 0 || !(e1 = ri.getSrc()).isMarked(0x4000000)) continue;
                            ++cnt;
                        }
                        continue;
                    }
                    en = e.dstLiftedRelationElements();
                    if (en == null) continue;
                    while (en.hasMoreElements()) {
                        ri = (RelationInstance)en.nextElement();
                        rc = ri.getRelationClass();
                        if (rc.getWeight() >= 0 || !(e1 = ri.getDrawSrc()).isMarked(0x4000000)) continue;
                        ++cnt;
                    }
                }
                if (cnt == 0) {
                    return false;
                }
                double average = multiple * (double)cnt / (double)size;
                for (i = 0; i < size; ++i) {
                    e = (EntityInstance)sorted.elementAt(i);
                    cnt = 0;
                    if (pos) {
                        if (leaves) {
                            en = e.srcRelationElements();
                            if (en != null) {
                                while (en.hasMoreElements()) {
                                    ri = (RelationInstance)en.nextElement();
                                    rc = ri.getRelationClass();
                                    if (rc.getWeight() <= 0 || !(e1 = ri.getDst()).isMarked(0x4000000)) continue;
                                    ++cnt;
                                }
                            }
                        } else {
                            en = e.srcLiftedRelationElements();
                            if (en != null) {
                                while (en.hasMoreElements()) {
                                    ri = (RelationInstance)en.nextElement();
                                    rc = ri.getRelationClass();
                                    if (rc.getWeight() <= 0 || !(e1 = ri.getDrawDst()).isMarked(0x4000000)) continue;
                                    ++cnt;
                                }
                            }
                        }
                    }
                    if (neg) {
                        if (leaves) {
                            en = e.dstRelationElements();
                            if (en != null) {
                                while (en.hasMoreElements()) {
                                    ri = (RelationInstance)en.nextElement();
                                    rc = ri.getRelationClass();
                                    if (rc.getWeight() >= 0 || !(e1 = ri.getSrc()).isMarked(0x4000000)) continue;
                                    ++cnt;
                                }
                            }
                        } else {
                            en = e.dstLiftedRelationElements();
                            if (en != null) {
                                while (en.hasMoreElements()) {
                                    ri = (RelationInstance)en.nextElement();
                                    rc = ri.getRelationClass();
                                    if (rc.getWeight() >= 0 || !(e1 = ri.getDrawSrc()).isMarked(0x4000000)) continue;
                                    ++cnt;
                                }
                            }
                        }
                    }
                    if (cnt <= 0 || !((double)cnt >= average)) continue;
                    e.orMark(512);
                    change = true;
                }
                return change;
            }

            @Override
            public void actionPerformed(ActionEvent ev) {
                super.actionPerformed(ev);
            }
        }

        class LibrariesTab
        extends OmnipresentTab
        implements ActionListener {
            @Override
            protected int match() {
                return 256;
            }

            @Override
            protected String topLabel() {
                return "Libraries:";
            }

            @Override
            protected String generalLabel() {
                return "libraries";
            }

            @Override
            protected String findText() {
                return "Find nodes having only inputs";
            }

            @Override
            protected JTextField multiple() {
                return null;
            }

            @Override
            protected String multipleLabel() {
                return null;
            }

            @Override
            protected boolean find() {
                ListVector sorted = BunchClusterConfigure.this.m_sorted;
                int size = sorted.size();
                boolean pos = this.positiveWeights();
                boolean neg = this.negativeWeights();
                boolean change = false;
                boolean leaves = BunchClusterLayout.parameterBoolean(2);
                for (int i = 0; i < size; ++i) {
                    EntityInstance e1;
                    RelationClass rc;
                    RelationInstance ri;
                    Enumeration en;
                    EntityInstance e = (EntityInstance)sorted.elementAt(i);
                    boolean flag = true;
                    if (leaves) {
                        if (pos) {
                            en = e.srcRelationElements();
                            if (en != null) {
                                while (en.hasMoreElements()) {
                                    ri = (RelationInstance)en.nextElement();
                                    rc = ri.getRelationClass();
                                    if (rc.getWeight() <= 0 || !(e1 = ri.getDst()).isMarked(0x4000000)) continue;
                                    flag = false;
                                    break;
                                }
                            }
                            if (!flag) continue;
                        }
                        if (neg) {
                            en = e.dstRelationElements();
                            if (en != null) {
                                while (en.hasMoreElements()) {
                                    ri = (RelationInstance)en.nextElement();
                                    rc = ri.getRelationClass();
                                    if (rc.getWeight() >= 0 || !(e1 = ri.getSrc()).isMarked(0x4000000)) continue;
                                    flag = false;
                                    break;
                                }
                            }
                            if (!flag) {
                                continue;
                            }
                        }
                    } else {
                        if (pos) {
                            en = e.srcLiftedRelationElements();
                            if (en != null) {
                                while (en.hasMoreElements()) {
                                    ri = (RelationInstance)en.nextElement();
                                    rc = ri.getRelationClass();
                                    if (rc.getWeight() <= 0 || !(e1 = ri.getDrawDst()).isMarked(0x4000000)) continue;
                                    flag = false;
                                    break;
                                }
                            }
                            if (!flag) continue;
                        }
                        if (neg) {
                            en = e.dstLiftedRelationElements();
                            if (en != null) {
                                while (en.hasMoreElements()) {
                                    ri = (RelationInstance)en.nextElement();
                                    rc = ri.getRelationClass();
                                    if (rc.getWeight() >= 0 || !(e1 = ri.getDrawSrc()).isMarked(0x4000000)) continue;
                                    flag = false;
                                    break;
                                }
                            }
                            if (!flag) continue;
                        }
                    }
                    e.orMark(256);
                    change = true;
                }
                return change;
            }

            @Override
            public void actionPerformed(ActionEvent ev) {
                super.actionPerformed(ev);
            }
        }

        abstract class OmnipresentTab
        extends JPanel
        implements ActionListener {
            MyListModel m_rest_model;
            JList m_rest;
            MyListModel m_omnipresent_model;
            JList m_omnipresent;
            JButton m_add;
            JButton m_remove;
            JButton m_find;
            JButton m_clear;

            protected abstract int match();

            protected abstract String topLabel();

            protected abstract String generalLabel();

            protected abstract String findText();

            protected abstract boolean find();

            protected abstract JTextField multiple();

            protected abstract String multipleLabel();

            public OmnipresentTab() {
                JList<String> omnipresent;
                JList<String> rest;
                Font font = FontCache.getDialogFont();
                Font bold = font.deriveFont(1);
                this.m_rest_model = new MyListModel(BunchClusterConfigure.this.m_sorted, 0);
                this.m_omnipresent_model = new MyListModel(BunchClusterConfigure.this.m_sorted, this.match());
                this.m_rest = rest = new JList<String>(this.m_rest_model);
                this.m_omnipresent = omnipresent = new JList<String>(this.m_omnipresent_model);
                rest.setPrototypeCellValue("12345678901234567890");
                rest.setVisibleRowCount(16);
                rest.setCellRenderer(new MyListCellRenderer());
                omnipresent.setPrototypeCellValue("12345678901234567890");
                omnipresent.setVisibleRowCount(16);
                omnipresent.setCellRenderer(new MyListCellRenderer());
                Box buttons = new Box(1);
                this.m_add = new JButton("=>");
                this.m_add.addActionListener(this);
                this.m_remove = new JButton("<=");
                this.m_remove.addActionListener(this);
                buttons.add(this.m_remove);
                buttons.add(this.m_add);
                GridBagLayout gridBagLayout = new GridBagLayout();
                GridBagConstraints c = new GridBagConstraints();
                this.setFont(bold);
                this.setLayout(gridBagLayout);
                JLabel label = new JLabel("Nodes:");
                label.setFont(bold);
                c.fill = 0;
                c.gridx = 0;
                c.gridy = 0;
                c.gridwidth = 1;
                c.gridheight = 1;
                c.weightx = 1.0;
                c.weighty = 0.0;
                c.anchor = 17;
                gridBagLayout.setConstraints(label, c);
                this.add(label);
                label = new JLabel(this.topLabel());
                label.setFont(bold);
                c.fill = 0;
                c.gridx = 2;
                c.gridy = 0;
                c.gridwidth = 0;
                c.gridheight = 1;
                c.weightx = 1.0;
                c.weighty = 0.0;
                c.anchor = 17;
                gridBagLayout.setConstraints(label, c);
                this.add(label);
                c.fill = 1;
                c.gridx = 0;
                c.gridy = 1;
                c.gridwidth = 1;
                c.gridheight = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.anchor = 10;
                JScrollPane scrollPane = new JScrollPane(rest);
                gridBagLayout.setConstraints(scrollPane, c);
                this.add(scrollPane);
                c.fill = 0;
                c.gridx = 1;
                c.gridy = 1;
                c.gridwidth = 1;
                c.gridheight = 1;
                c.weightx = 0.0;
                c.weighty = 0.0;
                gridBagLayout.setConstraints(buttons, c);
                this.add(buttons);
                c.fill = 1;
                c.gridx = 2;
                c.gridy = 1;
                c.gridwidth = 0;
                c.gridheight = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                omnipresent.setPreferredSize(rest.getPreferredSize());
                scrollPane = new JScrollPane(omnipresent);
                gridBagLayout.setConstraints(scrollPane, c);
                this.add(scrollPane);
                JPanel row = new JPanel();
                row.setLayout(new FlowLayout());
                this.m_clear = new JButton("Clear");
                this.m_clear.setToolTipText("Clear existing " + this.generalLabel());
                this.m_clear.addActionListener(this);
                this.m_find = new JButton("Find");
                this.m_find.setToolTipText(this.findText());
                this.m_find.addActionListener(this);
                row.add(this.m_clear);
                row.add(this.m_find);
                JTextField mult = this.multiple();
                if (mult != null) {
                    mult.setColumns(6);
                    row.add(mult);
                    label = new JLabel(" times average " + this.multipleLabel());
                    label.setFont(bold);
                    row.add(label);
                }
                c.fill = 0;
                c.gridx = 0;
                c.gridy = 2;
                c.gridwidth = 0;
                c.gridheight = 1;
                c.weightx = 0.0;
                c.weighty = 0.0;
                gridBagLayout.setConstraints(row, c);
                this.add(row);
            }

            protected boolean positiveWeights() {
                Diagram diagram = BunchClusterLayout.this.m_ls.getDiagram();
                if (diagram != null) {
                    Enumeration en = diagram.enumRelationClassesInOrder();
                    while (en.hasMoreElements()) {
                        RelationClass rc = (RelationClass)en.nextElement();
                        if (rc.getWeight() <= 0) continue;
                        return true;
                    }
                }
                return false;
            }

            protected boolean negativeWeights() {
                Diagram diagram = BunchClusterLayout.this.m_ls.getDiagram();
                if (diagram != null) {
                    Enumeration en = diagram.enumRelationClassesInOrder();
                    while (en.hasMoreElements()) {
                        RelationClass rc = (RelationClass)en.nextElement();
                        if (rc.getWeight() >= 0) continue;
                        return true;
                    }
                }
                return false;
            }

            @Override
            public void actionPerformed(ActionEvent ev) {
                boolean change = false;
                int match1 = this.match();
                Object source = ev.getSource();
                if (source == this.m_add) {
                    int size;
                    Object[] values = this.m_rest.getSelectedValues();
                    if (values != null && (size = values.length) > 0) {
                        for (int i = 0; i < size; ++i) {
                            EntityInstance e = (EntityInstance)values[i];
                            e.orMark(match1);
                        }
                        change = true;
                    }
                } else if (source == this.m_remove) {
                    int size;
                    Object[] values = this.m_omnipresent.getSelectedValues();
                    if (values != null && (size = values.length) > 0) {
                        for (int i = 0; i < size; ++i) {
                            EntityInstance e = (EntityInstance)values[i];
                            e.nandMark(match1);
                        }
                        change = true;
                    }
                } else if (source == this.m_find || source == this.m_clear) {
                    EntityInstance e;
                    int i;
                    ListVector sorted = BunchClusterConfigure.this.m_sorted;
                    int size = BunchClusterConfigure.this.m_sorted.size();
                    if (this.m_omnipresent_model.getSize() != 0) {
                        int rc = JOptionPane.showConfirmDialog(BunchClusterLayout.this.m_ls.getFrame(), "This will clear the " + this.generalLabel() + "\n" + "you have already selected\n" + "and start again.\n" + "Are you sure?", "Cancel automatic calculation?", 2);
                        if (rc != 0) {
                            return;
                        }
                        for (i = 0; i < size; ++i) {
                            e = (EntityInstance)sorted.elementAt(i);
                            if (e.getOmnipresent() != match1) continue;
                            e.nandMark(match1);
                            change = true;
                        }
                    }
                    if (source == this.m_find) {
                        for (i = 0; i < size; ++i) {
                            e = (EntityInstance)sorted.elementAt(i);
                            e.orMark(0x4000000);
                        }
                        change |= this.find();
                        for (i = 0; i < size; ++i) {
                            e = (EntityInstance)sorted.elementAt(i);
                            e.nandMark(0x4000000);
                        }
                    }
                }
                if (change) {
                    BunchClusterConfigure.this.m_sorted.stateChanged();
                }
            }
        }

        class OptionsTab
        extends Box
        implements ActionListener {
            JCheckBox m_timeout;
            JTextField m_maxruntime;

            protected JPanel newRow() {
                JPanel row = new JPanel();
                row.setLayout(new FlowLayout());
                return row;
            }

            protected void setMaxRuntimeState() {
                this.m_maxruntime.setEnabled(this.m_timeout.isSelected());
            }

            public OptionsTab() {
                JTextField maxruntime;
                super(1);
                Font font = FontCache.getDialogFont();
                Font bold = font.deriveFont(1);
                JLabel label = new JLabel("Use the following options to control Bunch's clustering engine: ");
                label.setFont(bold);
                JPanel row = this.newRow();
                row.add(label);
                this.add(row);
                JLabel label1 = new JLabel("Clustering Approach:");
                label1.setFont(bold);
                row = this.newRow();
                row.add(label1);
                JComboBox combo1 = BunchClusterLayout.this.m_clustering_approach;
                row.add(combo1);
                this.add(row);
                JLabel label2 = new JLabel("Clustering Algorithm:");
                label2.setFont(bold);
                row = this.newRow();
                row.add(label2);
                JComboBox combo2 = BunchClusterLayout.this.m_calculator_classes;
                row.add(combo2);
                this.add(row);
                JLabel label3 = new JLabel("Output options:");
                label3.setFont(bold);
                row = this.newRow();
                row.add(label3);
                JComboBox combo3 = BunchClusterLayout.this.m_output_mode;
                row.add(BunchClusterLayout.this.m_output_mode);
                this.add(row);
                Dimension labelsize = label2.getPreferredSize();
                label1.setPreferredSize(labelsize);
                label3.setPreferredSize(labelsize);
                Dimension combosize = combo2.getPreferredSize();
                combo1.setPreferredSize(combosize);
                combo3.setPreferredSize(combosize);
                row = this.newRow();
                this.m_timeout = BunchClusterConfigure.this.m_checkboxes[6];
                this.m_timeout.addActionListener(this);
                row.add(this.m_timeout);
                this.m_maxruntime = maxruntime = BunchClusterConfigure.this.m_textfields[17];
                maxruntime.setColumns(6);
                this.setMaxRuntimeState();
                row.add(maxruntime);
                label = new JLabel("(ms)");
                label.setFont(bold);
                row.add(label);
                this.add(row);
                BunchClusterConfigure.this.pack();
                this.setVisible(true);
            }

            @Override
            public void actionPerformed(ActionEvent ev) {
                Object source = ev.getSource();
                if (source == this.m_timeout) {
                    this.setMaxRuntimeState();
                    return;
                }
            }
        }

        class WeightsTab
        extends JPanel {
            public static final int WIDTH = 45;
            public static final int HEIGHT = 20;
            private Box m_weights;

            public WeightsTab() {
                Box weights;
                Diagram diagram = BunchClusterLayout.this.m_ls.getDiagram();
                this.setLayout(new BorderLayout());
                this.m_weights = weights = new Box(1);
                if (diagram != null) {
                    Enumeration en = diagram.enumRelationClassesInOrder();
                    while (en.hasMoreElements()) {
                        RelationClass rc = (RelationClass)en.nextElement();
                        weights.add(new WeightedReln(rc));
                    }
                }
                Dimension dim = BunchClusterConfigure.this.m_basicTab.getPreferredSize();
                JScrollPane scrollPane = new JScrollPane(weights);
                scrollPane.setPreferredSize(dim);
                this.add("Center", scrollPane);
            }

            public boolean isOk() {
                Box weights = this.m_weights;
                int size = weights.getComponentCount();
                for (int i = 0; i < size; ++i) {
                    WeightedReln weightedReln = (WeightedReln)weights.getComponent(i);
                    if (weightedReln.isOk()) continue;
                    return false;
                }
                return true;
            }

            public void setWeights() {
                Box weights = this.m_weights;
                int size = weights.getComponentCount();
                for (int i = 0; i < size; ++i) {
                    WeightedReln weightedReln = (WeightedReln)weights.getComponent(i);
                    weightedReln.setWeight();
                }
            }

            class WeightedReln
            extends JPanel
            implements DocumentListener {
                protected JTextField m_textfield;
                protected Arrow m_arrow;
                protected JLabel m_inverted;
                protected RelationClass m_rc;

                protected void setInverted() {
                    boolean invert;
                    boolean bl = invert = this.m_textfield.getText().indexOf(45) >= 0;
                    if (this.m_textfield.getText().indexOf(45) >= 0) {
                        this.m_inverted.setText(" (Inverted)");
                    } else {
                        this.m_inverted.setText("");
                    }
                    this.m_arrow.setInvert(invert);
                }

                public WeightedReln(RelationClass rc) {
                    Arrow arrow;
                    JTextField textfield;
                    Option option = Options.getDiagramOptions();
                    Font font = FontCache.getDialogFont();
                    Font bold = font.deriveFont(1);
                    FlowLayout flowLayout = new FlowLayout(0);
                    this.setLayout(flowLayout);
                    this.m_rc = rc;
                    int weight = rc.getWeight();
                    this.m_textfield = textfield = new JTextField("" + weight);
                    textfield.setFont(font);
                    textfield.setColumns(5);
                    textfield.getDocument().addDocumentListener(this);
                    this.add(textfield);
                    Color color = rc.getInheritedObjectColor();
                    this.m_arrow = arrow = new Arrow(1, 2);
                    arrow.setForeground(color);
                    if (option.isVariableArrowColor()) {
                        color = rc.getInheritedArrowColor();
                        arrow.setHeadColor(color);
                    }
                    arrow.setStyle(rc.getInheritedStyle());
                    arrow.setToolTipText(rc.getDescription());
                    this.add(arrow);
                    color = rc.getInheritedLabelColor();
                    String labelText = rc.getLabel();
                    JLabel label = new JLabel(labelText);
                    label.setForeground(color);
                    label.setFont(font);
                    this.add(label);
                    this.m_inverted = new JLabel("");
                    this.m_inverted.setForeground(Color.RED);
                    this.m_inverted.setFont(bold);
                    this.setInverted();
                    this.add(this.m_inverted);
                }

                public boolean isOk() {
                    try {
                        int val = Integer.parseInt(this.m_textfield.getText());
                    }
                    catch (Exception e) {
                        return false;
                    }
                    return true;
                }

                public void setWeight() {
                    int val;
                    try {
                        val = Integer.parseInt(this.m_textfield.getText());
                    }
                    catch (Exception e) {
                        val = 0;
                    }
                    this.m_rc.setWeight(val);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.setInverted();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.setInverted();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.setInverted();
                }
            }
        }

        class BasicTab
        extends JPanel
        implements ActionListener,
        DocumentListener {
            private JButton m_exportButton = new JButton("Select...");
            private JButton m_optionButton = new JButton("Options");
            private JButton m_dirButton = new JButton("Select...");
            private JButton m_importButton = new JButton("Select...");

            protected void setOptionState() {
                boolean enabled = false;
                switch (BunchClusterLayout.this.m_cluster_algorithm.getSelectedIndex()) {
                    case 0: 
                    case 1: {
                        enabled = true;
                    }
                }
                this.m_optionButton.setEnabled(enabled);
            }

            protected void setImportFile() {
                if (!BunchClusterConfigure.this.m_checkboxes[4].isSelected()) {
                    BunchClusterConfigure.this.m_textfields[3].setText(Util.formFileName(BunchClusterConfigure.this.m_textfields[2].getText(), BunchClusterConfigure.this.m_textfields[0].getText() + ".bunch"));
                }
            }

            protected void setVanillaState() {
                boolean state = !BunchClusterConfigure.this.m_checkboxes[4].isSelected();
                BunchClusterLayout.this.m_cluster_algorithm.setEnabled(state);
                this.m_optionButton.setEnabled(state);
                BunchClusterConfigure.this.m_textfields[2].setEnabled(state);
                this.m_dirButton.setEnabled(state);
                if (state) {
                    this.setOptionState();
                    this.setImportFile();
                }
                BunchClusterConfigure.this.setTabStates();
            }

            public BasicTab() {
                this.setLayout(new BorderLayout());
                Font font = FontCache.getDialogFont();
                Font bold = font.deriveFont(1);
                JPanel labelPanel = new JPanel();
                GridLayout gridLayout = new GridLayout(6, 1, 0, 10);
                labelPanel.setLayout(gridLayout);
                JPanel valuePanel = new JPanel();
                gridLayout = new GridLayout(6, 1, 0, 10);
                valuePanel.setLayout(gridLayout);
                JPanel buttonPanel = new JPanel();
                gridLayout = new GridLayout(6, 1, 0, 10);
                buttonPanel.setLayout(gridLayout);
                JLabel label = new JLabel(m_textfield_titles[1], 4);
                label.setFont(bold);
                labelPanel.add(label);
                valuePanel.add(BunchClusterConfigure.this.m_textfields[1]);
                JCheckBox vanilla = BunchClusterConfigure.this.m_checkboxes[4];
                vanilla.addActionListener(this);
                buttonPanel.add(vanilla);
                label = new JLabel(m_textfield_titles[0], 4);
                label.setFont(bold);
                labelPanel.add(label);
                valuePanel.add(BunchClusterConfigure.this.m_textfields[0]);
                BunchClusterConfigure.this.m_textfields[0].getDocument().addDocumentListener(this);
                this.m_exportButton.setFont(bold);
                this.m_exportButton.addActionListener(this);
                buttonPanel.add(this.m_exportButton);
                label = new JLabel("Clustering method:", 4);
                label.setFont(bold);
                labelPanel.add(label);
                BunchClusterLayout.this.m_cluster_algorithm.addActionListener(this);
                valuePanel.add(BunchClusterLayout.this.m_cluster_algorithm);
                this.m_optionButton.setFont(bold);
                this.m_optionButton.addActionListener(this);
                this.setOptionState();
                buttonPanel.add(this.m_optionButton);
                label = new JLabel(m_textfield_titles[2], 4);
                label.setFont(bold);
                labelPanel.add(label);
                valuePanel.add(BunchClusterConfigure.this.m_textfields[2]);
                BunchClusterConfigure.this.m_textfields[2].getDocument().addDocumentListener(this);
                this.m_dirButton.setFont(bold);
                this.m_dirButton.addActionListener(this);
                buttonPanel.add(this.m_dirButton);
                label = new JLabel(m_textfield_titles[3], 4);
                label.setFont(bold);
                labelPanel.add(label);
                valuePanel.add(BunchClusterConfigure.this.m_textfields[3]);
                this.m_importButton.setFont(bold);
                this.m_importButton.addActionListener(this);
                buttonPanel.add(this.m_importButton);
                label = new JLabel("Output diagnostics:", 4);
                label.setFont(bold);
                labelPanel.add(label);
                valuePanel.add(BunchClusterLayout.this.m_debug);
                buttonPanel.add(new JLabel(""));
                JPanel checkboxPanel = new JPanel();
                checkboxPanel.setLayout(new FlowLayout(1, 15, 15));
                for (int i = 0; i <= 3; ++i) {
                    if (i == 2 && BunchClusterConfigure.this.m_selected != null) continue;
                    checkboxPanel.add(BunchClusterConfigure.this.m_checkboxes[i]);
                }
                this.add("West", labelPanel);
                this.add("Center", valuePanel);
                this.add("East", buttonPanel);
                this.add("South", checkboxPanel);
                this.setVanillaState();
            }

            @Override
            public void actionPerformed(ActionEvent ev) {
                Object source = ev.getSource();
                if (source == this.m_exportButton) {
                    String name = BunchClusterLayout.this.m_ls.filePrompt("File to write to", BunchClusterConfigure.this.m_textfields[0].getText(), 2, null);
                    if (name != null) {
                        BunchClusterConfigure.this.m_textfields[0].setText(name);
                    }
                    return;
                }
                if (source == BunchClusterLayout.this.m_cluster_algorithm) {
                    this.setOptionState();
                    return;
                }
                if (source == this.m_optionButton) {
                    switch (BunchClusterLayout.this.m_cluster_algorithm.getSelectedIndex()) {
                        case 0: {
                            new HillClimbingConfiguration();
                            break;
                        }
                        case 1: {
                            new GeneticConfiguration();
                        }
                    }
                    return;
                }
                if (source == this.m_dirButton) {
                    String name = BunchClusterLayout.this.m_ls.filePrompt("Directory to read from", BunchClusterConfigure.this.m_textfields[2].getText(), 1, null);
                    if (name != null) {
                        BunchClusterConfigure.this.m_textfields[2].setText(name);
                    }
                    return;
                }
                if (source == this.m_importButton) {
                    String name = BunchClusterLayout.this.m_ls.filePrompt("File to read back from", BunchClusterConfigure.this.m_textfields[3].getText(), 2, null);
                    if (name != null) {
                        BunchClusterConfigure.this.m_textfields[3].setText(name);
                    }
                    return;
                }
                if (source == BunchClusterConfigure.this.m_checkboxes[4]) {
                    this.setVanillaState();
                    return;
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.setImportFile();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.setImportFile();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.setImportFile();
            }

            class GeneticConfiguration
            extends JDialog
            implements ActionListener {
                JTextField[] m_local_textfields;
                JLabel m_message;
                JButton m_ok;
                JButton m_cancel;

                public GeneticConfiguration() {
                    super(BunchClusterLayout.this.getLs().getFrame(), "Genetic Algorithm Configuration", true);
                    Font font = FontCache.getDialogFont();
                    Font bold = font.deriveFont(1);
                    this.setLayout(new BorderLayout());
                    JPanel main = new JPanel();
                    main.setLayout(new BorderLayout());
                    JPanel labelPanel = new JPanel();
                    GridLayout gridLayout = new GridLayout(5, 1, 0, 10);
                    labelPanel.setLayout(gridLayout);
                    JPanel valuePanel = new JPanel();
                    gridLayout = new GridLayout(5, 1, 0, 10);
                    valuePanel.setLayout(gridLayout);
                    JLabel label = new JLabel("GA Selection Method:", 2);
                    label.setFont(bold);
                    labelPanel.add(label);
                    valuePanel.add(BunchClusterLayout.this.m_selection_method);
                    this.m_local_textfields = new JTextField[17];
                    for (int i = 13; i <= 16; ++i) {
                        JTextField textfield;
                        this.m_local_textfields[i] = textfield = new JTextField(BunchClusterConfigure.this.m_textfields[i].getText(), 12);
                        label = new JLabel(m_textfield_titles[i], 2);
                        label.setFont(bold);
                        labelPanel.add(label);
                        textfield.setFont(font);
                        valuePanel.add(textfield);
                    }
                    main.add("West", labelPanel);
                    main.add("East", valuePanel);
                    this.add("North", main);
                    this.m_message = new JLabel("", 0);
                    this.m_message.setFont(font);
                    this.m_message.setForeground(Color.RED);
                    this.m_message.setSize(300, 50);
                    this.m_message.setPreferredSize(new Dimension(300, 50));
                    this.add("Center", this.m_message);
                    this.m_ok = new JButton("OK");
                    this.m_ok.addActionListener(this);
                    this.m_cancel = new JButton("Cancel");
                    this.m_cancel.addActionListener(this);
                    JPanel buttons = new JPanel();
                    buttons.setLayout(new FlowLayout());
                    buttons.add(this.m_ok);
                    buttons.add(this.m_cancel);
                    this.add("South", buttons);
                    this.pack();
                    this.setVisible(true);
                }

                @Override
                public void actionPerformed(ActionEvent ev) {
                    Object source = ev.getSource();
                    if (source == this.m_ok) {
                        int i;
                        String message = null;
                        for (i = 13; i <= 16; ++i) {
                            String value = this.m_local_textfields[i].getText();
                            switch (i) {
                                case 13: {
                                    int val;
                                    try {
                                        val = Integer.parseInt(value);
                                    }
                                    catch (Exception e) {
                                        message = "Generations not an integer";
                                    }
                                    break;
                                }
                                case 14: {
                                    int val;
                                    try {
                                        val = Integer.parseInt(value);
                                    }
                                    catch (Exception e) {
                                        message = "Population size not an integer";
                                    }
                                    break;
                                }
                                case 15: {
                                    double dval;
                                    try {
                                        dval = Double.parseDouble(value);
                                        if (!(dval < 0.0) && !(dval > 1.0)) break;
                                        message = "Crossover not a probability";
                                    }
                                    catch (Exception e) {
                                        message = "Crossover probability not a double";
                                    }
                                    break;
                                }
                                case 16: {
                                    double dval;
                                    try {
                                        dval = Double.parseDouble(value);
                                        if (!(dval < 0.0) && !(dval > 1.0)) break;
                                        message = "Mutation not a probability";
                                        break;
                                    }
                                    catch (Exception e) {
                                        message = "Mutation probability not a double";
                                    }
                                }
                            }
                            if (message == null) continue;
                            this.m_message.setText(message);
                            return;
                        }
                        for (i = 13; i <= 16; ++i) {
                            BunchClusterConfigure.this.m_textfields[i].setText(this.m_local_textfields[i].getText());
                        }
                    } else if (source != this.m_cancel) {
                        return;
                    }
                    this.setVisible(false);
                }
            }

            class HillClimbingConfiguration
            extends JDialog
            implements ActionListener,
            ChangeListener {
                JTextField m_population_size;
                JSlider m_slider;
                JLabel m_slider_value;
                JTextField m_randomize;
                JComboBox m_techniques;
                JCheckBox m_annealing;
                JTextField m_initialTemp;
                JTextField m_alpha;
                JLabel m_message;
                JButton m_ok;
                JButton m_cancel;

                private void allowAnnealing() {
                    boolean enabled = this.m_annealing.isSelected();
                    this.m_techniques.setEnabled(enabled);
                    this.m_initialTemp.setEnabled(enabled);
                    this.m_alpha.setEnabled(enabled);
                }

                public HillClimbingConfiguration() {
                    int val;
                    super(BunchClusterLayout.this.getLs().getFrame(), "HillClimbing Configuration", true);
                    Box top = new Box(1);
                    Font font = FontCache.getDialogFont();
                    Border border = BorderFactory.createLineBorder(Color.BLACK);
                    border = BorderFactory.createTitledBorder(border, "Clustering options", 4, 2, font, Color.BLUE);
                    top.setBorder(border);
                    JPanel row = new JPanel();
                    row.setLayout(new FlowLayout());
                    JLabel label = new JLabel("Population size: ");
                    label.setFont(font);
                    row.add(label);
                    this.m_population_size = new JTextField(BunchClusterConfigure.this.m_textfields[8].getText());
                    this.m_population_size.setColumns(6);
                    row.add(this.m_population_size);
                    top.add(row);
                    row = new JPanel();
                    row.setLayout(new FlowLayout());
                    label = new JLabel("Minimum % of Search Space to Consider:");
                    row.add(label);
                    top.add(row);
                    row = new JPanel();
                    row.setLayout(new FlowLayout());
                    try {
                        val = Integer.parseInt(BunchClusterConfigure.this.m_textfields[9].getText());
                    }
                    catch (Exception exception) {
                        val = 0;
                    }
                    this.m_slider = new JSlider(0, 100, val);
                    Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
                    labels.put(new Integer(0), new JLabel("NAHC"));
                    labels.put(new Integer(100), new JLabel("SAHC"));
                    this.m_slider.setLabelTable(labels);
                    this.m_slider.setPaintLabels(true);
                    this.m_slider.addChangeListener(this);
                    row.add(this.m_slider);
                    this.m_slider_value = new JLabel("" + val + "%");
                    this.m_slider_value.setForeground(Color.BLUE);
                    row.add(this.m_slider_value);
                    top.add(row);
                    row = new JPanel();
                    row.setLayout(new FlowLayout());
                    label = new JLabel("Randomize %: ");
                    row.add(label);
                    this.m_randomize = new JTextField(BunchClusterConfigure.this.m_textfields[10].getText());
                    this.m_randomize.setColumns(6);
                    row.add(this.m_randomize);
                    top.add(row);
                    Box bottom = new Box(1);
                    border = BorderFactory.createLineBorder(Color.BLACK);
                    border = BorderFactory.createTitledBorder(border, "Simulated Annealing", 4, 2, font, Color.BLUE);
                    bottom.setBorder(border);
                    row = new JPanel();
                    row.setLayout(new FlowLayout());
                    this.m_annealing = new JCheckBox(m_checkbox_titles[5], BunchClusterConfigure.this.m_checkboxes[5].isSelected());
                    this.m_annealing.addActionListener(this);
                    row.add(this.m_annealing);
                    bottom.add(row);
                    row = new JPanel();
                    row.setLayout(new FlowLayout());
                    label = new JLabel("Technique: ");
                    row.add(label);
                    this.m_techniques = new JComboBox<String>(g_techniques);
                    row.add(this.m_techniques);
                    bottom.add(row);
                    row = new JPanel();
                    row.setLayout(new FlowLayout());
                    label = new JLabel("P(accept)=exp(deltaMQ/T); T(k+1)=alpha*T(k)");
                    label.setForeground(Color.RED);
                    row.add(label);
                    bottom.add(row);
                    row = new JPanel();
                    row.setLayout(new FlowLayout());
                    label = new JLabel("Initial Temp. T(0): ");
                    row.add(label);
                    this.m_initialTemp = new JTextField(BunchClusterConfigure.this.m_textfields[11].getText());
                    row.add(this.m_initialTemp);
                    label = new JLabel("Alpha: ");
                    row.add(label);
                    this.m_alpha = new JTextField(BunchClusterConfigure.this.m_textfields[12].getText());
                    row.add(this.m_alpha);
                    bottom.add(row);
                    this.allowAnnealing();
                    JPanel main = new JPanel();
                    main.setLayout(new BorderLayout());
                    main.add("North", top);
                    main.add("South", bottom);
                    this.setLayout(new BorderLayout());
                    this.add("North", main);
                    this.m_message = new JLabel("", 0);
                    this.m_message.setFont(font);
                    this.m_message.setForeground(Color.RED);
                    this.m_message.setSize(300, 50);
                    this.m_message.setPreferredSize(new Dimension(300, 50));
                    this.add("Center", this.m_message);
                    this.m_ok = new JButton("OK");
                    this.m_ok.addActionListener(this);
                    this.m_cancel = new JButton("Cancel");
                    this.m_cancel.addActionListener(this);
                    JPanel buttons = new JPanel();
                    buttons.setLayout(new FlowLayout());
                    buttons.add(this.m_ok);
                    buttons.add(this.m_cancel);
                    this.add("South", buttons);
                    this.pack();
                    this.setVisible(true);
                }

                @Override
                public void actionPerformed(ActionEvent ev) {
                    Object source = ev.getSource();
                    if (source == this.m_annealing) {
                        this.allowAnnealing();
                        return;
                    }
                    if (source == this.m_ok) {
                        String value;
                        int i;
                        String message = null;
                        for (i = 8; i <= 12; ++i) {
                            switch (i) {
                                case 8: {
                                    value = this.m_population_size.getText();
                                    try {
                                        int val = Integer.parseInt(value);
                                    }
                                    catch (Exception e) {
                                        message = "Population size not an integer";
                                    }
                                    break;
                                }
                                case 10: {
                                    double dval;
                                    value = this.m_randomize.getText();
                                    try {
                                        dval = Double.parseDouble(value);
                                    }
                                    catch (Exception e) {
                                        message = "Randomize not a double";
                                    }
                                    break;
                                }
                                case 11: {
                                    double dval;
                                    value = this.m_initialTemp.getText();
                                    try {
                                        dval = Double.parseDouble(value);
                                    }
                                    catch (Exception e) {
                                        message = "Initial temp not a double";
                                    }
                                    break;
                                }
                                case 12: {
                                    double dval;
                                    value = this.m_alpha.getText();
                                    try {
                                        dval = Double.parseDouble(value);
                                        break;
                                    }
                                    catch (Exception e) {
                                        message = "Alpha not a double";
                                    }
                                }
                            }
                            if (message == null) continue;
                            this.m_message.setText(message);
                            return;
                        }
                        for (i = 8; i <= 12; ++i) {
                            switch (i) {
                                case 8: {
                                    value = this.m_population_size.getText();
                                    break;
                                }
                                case 9: {
                                    value = "" + this.m_slider.getValue();
                                    break;
                                }
                                case 10: {
                                    value = this.m_randomize.getText();
                                    break;
                                }
                                case 11: {
                                    value = this.m_initialTemp.getText();
                                    break;
                                }
                                case 12: {
                                    value = this.m_alpha.getText();
                                    break;
                                }
                                default: {
                                    value = "";
                                }
                            }
                            BunchClusterConfigure.this.m_textfields[i].setText(value);
                        }
                        BunchClusterConfigure.this.m_checkboxes[5].setSelected(this.m_annealing.isSelected());
                    } else if (source != this.m_cancel) {
                        return;
                    }
                    this.setVisible(false);
                }

                @Override
                public void stateChanged(ChangeEvent ev) {
                    Object source = ev.getSource();
                    if (source == this.m_slider) {
                        int value = this.m_slider.getValue();
                        this.m_slider_value.setText("" + value);
                        this.m_randomize.setText("" + (100 - value));
                        return;
                    }
                }
            }
        }
    }
}

