/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.util.BitSet;
import lsedit.ColorCache;
import lsedit.EdgePoint;
import lsedit.EntityInstance;
import lsedit.EntityPosition;
import lsedit.LandscapeEditorCore;
import lsedit.LandscapeObject;
import lsedit.LsLink;
import lsedit.MsgOut;
import lsedit.RelationClass;
import lsedit.StringCache;
import lsedit.Ta;
import lsedit.Util;

public class AttributeValue {
    private static final int CT_QUOTE = 1;
    protected static char[] m_input;
    protected static int m_start;
    protected static String m_sval;
    private static String[] colorNames;
    private static Color[] colorNameValues;

    protected static void load(String avi) {
        int length = avi.length();
        if (m_input == null || m_input.length < length + 1) {
            m_input = new char[length + 1];
        }
        int pos = 0;
        block12: for (int i = 0; i < length; ++i) {
            int c = avi.charAt(i);
            switch (c) {
                case 34: 
                case 39: {
                    AttributeValue.m_input[pos++] = '\u0001';
                    continue block12;
                }
                case 92: {
                    if (++i < length) {
                        c = avi.charAt(i);
                        switch (c) {
                            case 110: {
                                c = 10;
                                break;
                            }
                            case 116: {
                                c = 9;
                                break;
                            }
                            case 102: {
                                c = 12;
                                break;
                            }
                            case 114: {
                                c = 13;
                                break;
                            }
                            case 101: {
                                c = 27;
                                break;
                            }
                            case 100: {
                                c = 127;
                            }
                        }
                    }
                }
                default: {
                    AttributeValue.m_input[pos++] = c;
                }
            }
        }
        m_start = 0;
        AttributeValue.m_input[pos] = '\u0000';
    }

    protected static final int nextToken() {
        char c;
        int pos = m_start;
        block9: while (true) {
            c = m_input[pos];
            switch (c) {
                case ' ': {
                    ++pos;
                    continue block9;
                }
                case '\u0000': {
                    m_start = pos;
                    return 0;
                }
                case '(': 
                case ')': {
                    m_start = ++pos;
                    return c;
                }
                case '\u0001': {
                    m_start = ++pos;
                    while ((c = m_input[pos]) != '\u0001' && c != '\u0000') {
                        ++pos;
                    }
                    m_sval = StringCache.get(m_input, m_start, pos - m_start);
                    m_start = ++pos;
                    return 1;
                }
            }
            break;
        }
        m_start = pos;
        while (true) {
            block12: {
                c = m_input[pos];
                switch (c) {
                    case '\u0000': 
                    case ' ': 
                    case '(': 
                    case ')': {
                        break;
                    }
                    default: {
                        break block12;
                    }
                }
                m_sval = StringCache.get(m_input, m_start, pos - m_start);
                m_start = pos;
                return 1;
            }
            ++pos;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int countValues(String avi) {
        int values = 0;
        int depth = 0;
        AttributeValue.load(avi);
        block6: while (true) {
            switch (AttributeValue.nextToken()) {
                case 1: {
                    ++values;
                    continue block6;
                }
                case 40: {
                    if (++depth <= 1) continue block6;
                    return -1;
                }
                case 41: {
                    if (--depth < 0) return -1;
                    continue block6;
                }
                case 0: {
                    if (depth == 0) return values;
                    return -1;
                }
            }
            break;
        }
        return values;
    }

    public static String parseString(String avi) {
        AttributeValue.load(avi);
        if (AttributeValue.nextToken() == 1) {
            return m_sval;
        }
        return null;
    }

    private static int parseColorValue(String value, LandscapeObject forObject, String forMember, int forComponent) {
        int i;
        char sign = value.charAt(0);
        if (value.indexOf(46) >= 0) {
            if (sign == '*') {
                value = value.substring(1);
            }
            double d = Double.parseDouble(value);
            i = (int)(d * 255.0 + 0.5);
            if (sign == '*' && forObject != null) {
                Color baseColor = forObject.getSuperColor(forMember);
                switch (forComponent) {
                    case 1: {
                        i = baseColor.getRed();
                        break;
                    }
                    case 2: {
                        i = baseColor.getGreen();
                        break;
                    }
                    case 3: {
                        i = baseColor.getBlue();
                        break;
                    }
                    case 4: {
                        i = baseColor.getAlpha();
                    }
                }
                i = (int)(d * (double)i);
            }
        } else {
            if (sign == '+') {
                value = value.substring(1);
            }
            i = Integer.parseInt(value);
            switch (sign) {
                case '+': 
                case '-': {
                    Color baseColor;
                    if (forObject != null && (baseColor = forObject.getSuperColor(forMember)) != null) {
                        switch (forComponent) {
                            case 1: {
                                i += baseColor.getRed();
                                break;
                            }
                            case 2: {
                                i += baseColor.getGreen();
                                break;
                            }
                            case 3: {
                                i += baseColor.getBlue();
                                break;
                            }
                            case 4: {
                                i += baseColor.getAlpha();
                            }
                        }
                    }
                    if (i < 0) {
                        i = 0;
                        break;
                    }
                    if (i <= 255) break;
                    i = 255;
                }
            }
        }
        return i %= 256;
    }

    public static Color parseColor(String avi, LandscapeObject forObject, String forMember) {
        int r = 0;
        int g = 0;
        int b = 0;
        int a = 255;
        int values = 0;
        boolean depth = false;
        AttributeValue.load(avi);
        block16: while (true) {
            switch (AttributeValue.nextToken()) {
                case 1: {
                    if (!depth && values == 0) {
                        String sval = m_sval;
                        int lth = sval.length();
                        int i = colorNames.length;
                        while (0 <= --i) {
                            int extra;
                            String name = colorNames[i];
                            int lth1 = name.length();
                            if (lth1 > lth || !name.equalsIgnoreCase(sval.substring(extra = lth - lth1))) continue;
                            Color color = colorNameValues[i];
                            if (4 <= extra) {
                                if (sval.substring(0, 4).equalsIgnoreCase("dark")) {
                                    color = color.darker();
                                } else if (5 <= extra && sval.substring(0, 5).equalsIgnoreCase("light")) {
                                    color = color.brighter();
                                }
                            }
                            r = color.getRed();
                            g = color.getGreen();
                            b = color.getBlue();
                            values = 4;
                            break;
                        }
                        if (i >= 0) continue block16;
                    }
                    int val = AttributeValue.parseColorValue(m_sval, forObject, forMember, ++values);
                    switch (values) {
                        case 1: {
                            r = val;
                            continue block16;
                        }
                        case 2: {
                            g = val;
                            continue block16;
                        }
                        case 3: {
                            b = val;
                            continue block16;
                        }
                        case 4: {
                            a = val;
                            continue block16;
                        }
                    }
                    MsgOut.println("parseColor: too many values");
                    break block16;
                }
                case 0: 
                case 41: {
                    break block16;
                }
                case 40: {
                    if (!depth) {
                        depth = true;
                        continue block16;
                    }
                }
                default: {
                    MsgOut.println("parseColor: illegal list structure");
                    break block16;
                }
            }
            break;
        }
        switch (values) {
            case 0: {
                MsgOut.println("parseColor: missing rgb values");
                break;
            }
            case 1: {
                MsgOut.println("parseColor: missing green and blue values");
                break;
            }
            case 2: {
                MsgOut.println("parseColor: missing blue value");
            }
        }
        return ColorCache.get(r, g, b, a);
    }

    public static void parsePoints(String avi, EntityInstance e, int side, EdgePoint[] ept) {
        int ttype;
        Ta ta = e.getTa();
        int state = 0;
        RelationClass rc = null;
        int index = 0;
        short wf = -32767;
        AttributeValue.load(avi);
        block14: while ((ttype = AttributeValue.nextToken()) != 0) {
            block0 : switch (state) {
                case 0: {
                    if (ttype != 40) {
                        MsgOut.println("parsePoints: not a list");
                        break;
                    }
                    state = 1;
                    continue block14;
                }
                case 1: {
                    if (ttype != 40) {
                        MsgOut.println("parsePoints: not a list of lists");
                        break;
                    }
                    state = 2;
                    continue block14;
                }
                case 2: {
                    rc = ta.getRelationClass(m_sval);
                    if (rc == null) {
                        state = 5;
                        continue block14;
                    }
                    index = rc.getNid() * 4 + side;
                    state = 3;
                    continue block14;
                }
                case 3: {
                    wf = Util.parseRelativeValue(m_sval);
                    state = 4;
                    continue block14;
                }
                case 4: {
                    short hf = Util.parseRelativeValue(m_sval);
                    EdgePoint edgePoint = ept[index];
                    if (edgePoint == null) {
                        ept[index] = edgePoint = new EdgePoint();
                    }
                    edgePoint.setFactors(e.getEntityClass(), wf, hf);
                    state = 5;
                    continue block14;
                }
                case 5: {
                    if (ttype != 41) continue block14;
                    state = 6;
                    continue block14;
                }
                case 6: {
                    switch (ttype) {
                        case 40: {
                            state = 2;
                            continue block14;
                        }
                        case 41: {
                            break block0;
                        }
                    }
                    MsgOut.println("parsePoints: illegal list structure");
                    break;
                }
                case 7: {
                    if (ttype == 0) break;
                    MsgOut.println("parsePoints: expected EOF");
                }
            }
            break;
        }
    }

    public static void parseElisions(String avi, Ta ta, int type, BitSet bitset) {
        boolean depth = false;
        AttributeValue.load(avi);
        block5: while (true) {
            switch (AttributeValue.nextToken()) {
                case 1: {
                    String sval = m_sval;
                    RelationClass rc = ta.getRelationClass(sval);
                    if (rc == null) {
                        MsgOut.println("parseElisions: '" + sval + "'is not a known relation class");
                        continue block5;
                    }
                    bitset.set(rc.getNid() * 6 + type);
                    continue block5;
                }
                case 0: 
                case 41: {
                    break block5;
                }
                case 40: {
                    if (!depth) {
                        depth = true;
                        continue block5;
                    }
                }
                default: {
                    MsgOut.println("parseElisions: illegal list structure");
                    break block5;
                }
            }
            break;
        }
    }

    public static void parseXEntityPositions(String avi, EntityPosition[] positions) {
        boolean depth = false;
        int i = 0;
        AttributeValue.load(avi);
        block5: while (true) {
            switch (AttributeValue.nextToken()) {
                case 1: {
                    EntityPosition position = positions[i];
                    if (position == null) {
                        positions[i] = position = new EntityPosition();
                    }
                    position.m_xRelLocal = Util.parseRelativeValue(m_sval);
                    ++i;
                    continue block5;
                }
                case 0: 
                case 41: {
                    break block5;
                }
                case 40: {
                    if (!depth) {
                        depth = true;
                        continue block5;
                    }
                }
                default: {
                    MsgOut.println("parseEntityPositions: illegal X list structure");
                    break block5;
                }
            }
            break;
        }
    }

    public static void parseYEntityPositions(String avi, EntityPosition[] positions) {
        boolean depth = false;
        int i = 0;
        AttributeValue.load(avi);
        block5: while (true) {
            switch (AttributeValue.nextToken()) {
                case 1: {
                    EntityPosition position = positions[i];
                    if (position == null) {
                        positions[i] = position = new EntityPosition();
                    }
                    position.m_yRelLocal = Util.parseRelativeValue(m_sval);
                    ++i;
                    continue block5;
                }
                case 0: 
                case 41: {
                    break block5;
                }
                case 40: {
                    if (!depth) {
                        depth = true;
                        continue block5;
                    }
                }
                default: {
                    MsgOut.println("parseEntityPositions: illegal Y list structure");
                    break block5;
                }
            }
            break;
        }
    }

    public static void parseWidthEntityPositions(String avi, EntityPosition[] positions) {
        boolean depth = false;
        int i = 0;
        AttributeValue.load(avi);
        block5: while (true) {
            switch (AttributeValue.nextToken()) {
                case 1: {
                    EntityPosition position = positions[i];
                    if (position == null) {
                        positions[i] = position = new EntityPosition();
                    }
                    position.m_widthRelLocal = Util.parseRelativeValue(m_sval);
                    ++i;
                    continue block5;
                }
                case 0: 
                case 41: {
                    break block5;
                }
                case 40: {
                    if (!depth) {
                        depth = true;
                        continue block5;
                    }
                }
                default: {
                    MsgOut.println("parseEntityPositions: illegal width list structure");
                    break block5;
                }
            }
            break;
        }
    }

    public static void parseHeightEntityPositions(String avi, EntityPosition[] positions) {
        boolean depth = false;
        int i = 0;
        AttributeValue.load(avi);
        block5: while (true) {
            switch (AttributeValue.nextToken()) {
                case 1: {
                    EntityPosition position = positions[i];
                    if (position == null) {
                        positions[i] = position = new EntityPosition();
                    }
                    position.m_heightRelLocal = Util.parseRelativeValue(m_sval);
                    ++i;
                    continue block5;
                }
                case 0: 
                case 41: {
                    break block5;
                }
                case 40: {
                    if (!depth) {
                        depth = true;
                        continue block5;
                    }
                }
                default: {
                    MsgOut.println("parseEntityPositions: illegal list structure");
                    break block5;
                }
            }
            break;
        }
    }

    public static void followLink(String avi, LandscapeEditorCore ls, EntityInstance e, boolean mustbeContainer) {
        String file = null;
        int target = 1;
        int values = 0;
        boolean depth = false;
        AttributeValue.load(avi);
        block13: while (true) {
            switch (AttributeValue.nextToken()) {
                case 1: {
                    switch (++values) {
                        case 1: {
                            file = Util.expand(m_sval, e.getId(), ls);
                            break;
                        }
                        case 2: {
                            String tgtStr = Util.expand(m_sval, ls);
                            target = LsLink.convertTarget(tgtStr);
                        }
                    }
                    continue block13;
                }
                case 0: 
                case 41: {
                    break block13;
                }
                case 40: {
                    if (!depth) {
                        depth = true;
                        continue block13;
                    }
                }
                default: {
                    MsgOut.println("followLink: illegal list structure");
                    target = -1;
                    break block13;
                }
            }
            break;
        }
        switch (target) {
            case 5: {
                ls.navigateTo(e, mustbeContainer);
            }
            case -1: {
                break;
            }
            default: {
                ls.followURL(file, target);
            }
        }
    }

    static {
        colorNames = new String[]{"black", "blue", "cyan", "gray", "green", "magenta", "orange", "pink", "red", "white", "yellow"};
        colorNameValues = new Color[]{Color.black, Color.blue, Color.cyan, Color.gray, Color.green, Color.magenta, Color.orange, Color.pink, Color.red, Color.white, Color.yellow};
    }
}

