/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import lsedit.AttributeBoxPanel;
import lsedit.Diagram;
import lsedit.EntityClass;
import lsedit.LandscapeClassObject;
import lsedit.LandscapeEditorCore;
import lsedit.LandscapeObject;
import lsedit.LandscapeObject3D;
import lsedit.Options;
import lsedit.ShowAttributeColor;
import lsedit.ShowImage;
import lsedit.ShowLabel;
import lsedit.Util;

public final class AttributeBox
extends JSplitPane
implements ChangeListener {
    protected static final int GAP = 20;
    protected static final Color m_titleColor = Color.red.darker();
    public static Font m_textFont = null;
    protected static final String m_indent = "    ";
    protected static final String m_helpStr = "Hold shift down to freeze";
    protected static final int horizontal_margin = 10;
    protected static final int vertical_indent = 10;
    protected LandscapeEditorCore m_ls;
    protected JTabbedPane m_tabbedPane;
    protected JScrollPane m_scrollPane;
    protected GridLayout m_layout;
    protected JPanel m_left;
    protected JPanel m_right;
    protected LandscapeObject m_object = null;
    protected int m_leftWidth = 0;
    protected int m_rightWidth = 0;
    protected int m_height = 0;

    @Override
    public Dimension getPreferredSize() {
        return this.getSize();
    }

    public AttributeBox(LandscapeEditorCore ls, JTabbedPane tabbedPane) {
        super(1);
        Insets insets = tabbedPane.getInsets();
        int divider = this.getDividerSize();
        int width = tabbedPane.getWidth() - insets.left - insets.right;
        int height = tabbedPane.getHeight() - insets.top - insets.bottom;
        int left = (width - divider) / 2;
        int right = width - divider - left;
        if (m_textFont == null) {
            m_textFont = Options.getTargetFont(22);
        }
        this.m_ls = ls;
        this.m_tabbedPane = tabbedPane;
        this.m_left = new AttributeBoxPanel(this);
        this.m_right = new AttributeBoxPanel(this);
        this.m_left.setBackground(Diagram.boxColor);
        this.m_right.setBackground(Diagram.boxColor);
        this.m_left.setPreferredSize(new Dimension(left, height));
        this.m_left.setSize(left, height);
        this.m_right.setPreferredSize(new Dimension(right, left));
        this.m_right.setSize(right, height);
        this.setLeftComponent(this.m_left);
        this.setRightComponent(this.m_right);
        this.setSize(width, height);
        this.setDividerLocation(left);
        this.setOneTouchExpandable(true);
        this.m_scrollPane = new JScrollPane();
        this.m_scrollPane.setBounds(0, 0, width, height);
        this.setPreferredSize(new Dimension(width, height));
        this.setToolTipText(m_helpStr);
        this.m_scrollPane.setViewportView(this);
        tabbedPane.addTab("Attrs", null, this.m_scrollPane, m_helpStr);
        tabbedPane.addChangeListener(this);
    }

    public static void setTextFont(Font font) {
        m_textFont = font;
    }

    public void textFontChanged(Font font) {
        AttributeBox.setTextFont(font);
        this.fill();
    }

    public void activate() {
        this.m_tabbedPane.setSelectedComponent(this.m_scrollPane);
    }

    public boolean isActive() {
        if (this.isVisible()) {
            Component active = this.m_tabbedPane.getSelectedComponent();
            return this.m_scrollPane == active;
        }
        return false;
    }

    public void addBoth(JComponent left, JComponent right) {
        Dimension dim = left.getPreferredSize();
        int leftWidth = dim.width;
        int leftHeight = dim.height;
        dim = right.getPreferredSize();
        int rightWidth = dim.width;
        int rightHeight = dim.height;
        if (leftWidth > this.m_leftWidth) {
            this.m_leftWidth = leftWidth;
        }
        if (rightWidth > this.m_rightWidth) {
            this.m_rightWidth = rightWidth;
        }
        int height = leftHeight < rightHeight ? rightHeight : leftHeight;
        left.setBounds(0, this.m_height, leftWidth, height);
        right.setBounds(0, this.m_height, rightWidth, height);
        this.m_left.add(left);
        this.m_right.add(right);
        this.m_height += height;
    }

    public void fill(LandscapeObject object) {
        LandscapeClassObject parent;
        ShowLabel right;
        ShowLabel left;
        ShowLabel label;
        String name;
        int type;
        int i;
        int attributes = 0;
        attributes = object.getLsAttributeCount();
        int primary = object.getPrimaryAttributeCount();
        for (i = 0; i < attributes && (type = object.getLsAttributeTypeAt(i)) != 0; ++i) {
            name = object.getLsAttributeNameAt(i);
            label = new ShowLabel(name);
            Color foreground = i < primary ? Color.blue : Color.red;
            label.setForeground(foreground);
            label.setFont(m_textFont);
            left = label;
            Object value = object.getLsAttributeValueAt(i);
            if (value == null) {
                label = new ShowLabel("null");
                label.setForeground(Color.red);
                right = label;
            } else {
                switch (type) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 11: 
                    case 12: 
                    case 15: 
                    case 16: {
                        right = new ShowLabel(value.toString());
                        break;
                    }
                    case 7: 
                    case 8: {
                        right = new ShowAttributeColor((Color)value);
                        right.setOpaque(true);
                        break;
                    }
                    case 17: {
                        right = new ShowImage((Integer)value);
                        break;
                    }
                    case 13: {
                        int style = (Integer)value;
                        String description = style < 0 || style >= EntityClass.styleName.length ? "" + style : EntityClass.styleName[style];
                        right = new ShowLabel(description);
                        break;
                    }
                    case 14: {
                        int style = (Integer)value;
                        String description = style < 0 || style >= Util.lineStyleName.length ? "" + style : Util.lineStyleName[style];
                        right = new ShowLabel(description);
                        break;
                    }
                    default: {
                        right = new ShowLabel("");
                    }
                }
            }
            this.addBoth(left, right);
        }
        this.m_height += 10;
        label = new ShowLabel("Attributes");
        label.setForeground(Color.GREEN);
        left = label;
        right = new ShowLabel("" + attributes);
        this.addBoth(left, right);
        name = object instanceof LandscapeObject3D ? ((LandscapeObject3D)object).getId() : "Relation";
        i = 0;
        while ((parent = object.derivedFrom(i)) != null) {
            this.m_height += 20;
            left = new ShowLabel("Superclass of");
            right = new ShowLabel(name);
            this.addBoth(left, right);
            this.fill(parent);
            ++i;
        }
    }

    public void fill() {
        JPanel left = this.m_left;
        JPanel right = this.m_right;
        left.removeAll();
        right.removeAll();
        if (this.isActive()) {
            Component component;
            LandscapeObject object = this.m_object;
            this.m_leftWidth = 0;
            this.m_rightWidth = 0;
            this.m_height = 0;
            if (object == null) {
                ShowLabel leftlabel = new ShowLabel("No object");
                ShowLabel rightlabel = new ShowLabel("");
                this.m_height = 10;
                this.addBoth(leftlabel, rightlabel);
            } else {
                this.fill(object);
            }
            int leftWidth = this.m_leftWidth;
            int rightWidth = this.m_rightWidth;
            int height = this.m_height;
            int i = left.getComponentCount();
            while (--i >= 0) {
                component = left.getComponent(i);
                component.setSize(leftWidth, component.getHeight());
            }
            i = right.getComponentCount();
            while (--i >= 0) {
                component = right.getComponent(i);
                component.setSize(rightWidth, component.getHeight());
            }
            int width = leftWidth + rightWidth + 10;
            this.setBounds(0, 0, width, height);
            this.setPreferredSize(new Dimension(width, height));
            left.setBounds(0, 0, leftWidth, height);
            left.setPreferredSize(new Dimension(leftWidth, height));
            right.setBounds(0, 0, rightWidth, height);
            right.setPreferredSize(new Dimension(rightWidth, height));
            this.setDividerLocation(leftWidth + 5);
            this.m_scrollPane.revalidate();
            this.revalidate();
        }
    }

    public void show(LandscapeObject object) {
        if (this.m_object != object) {
            this.m_object = object;
            this.fill();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fill();
    }
}

