/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import lsedit.DrawInfo;
import lsedit.EntityInstance;
import lsedit.RelationClass;
import lsedit.RelationComponent;
import lsedit.RelationInstance;
import lsedit.Util;

class ArcInfo
extends DrawInfo {
    protected static final int RECURSIVE_LOOP_DOTTED_ANGLE = 8;
    protected static final int RECURSIVE_LOOP_DOTTED_SPACE = 10;
    int m_x;
    int m_y;
    int m_x_radius;
    int m_y_radius;
    int m_angle;
    boolean m_isElided;

    @Override
    public void getBounds(Rectangle r) {
        r.setBounds(this.m_x - this.m_x_radius, this.m_y - this.m_y_radius, this.m_x_radius * 2, this.m_y_radius * 2);
    }

    @Override
    public boolean contains(int x, int y) {
        int y1 = y - this.m_y;
        int x1 = x - this.m_x;
        switch (this.m_angle) {
            case 0: {
                if (y1 < 0 || x1 < 0) break;
                return false;
            }
            case 1: {
                if (y1 > 0 || x1 < 0) break;
                return false;
            }
            case 2: {
                if (x1 > 0 || y1 > 0) break;
                return false;
            }
            default: {
                if (x1 > 0 || y1 < 0) break;
                return false;
            }
        }
        double d1 = (double)x1 / (double)this.m_x_radius;
        double d2 = (double)y1 / (double)this.m_y_radius;
        return (d1 = d1 * d1 + d2 * d2) > 0.95 && d1 < 1.05;
    }

    @Override
    public void paintComponent(Graphics g, int shiftX, int shiftY) {
        int x1;
        int embellished = this.m_embellished;
        int sweep = this.m_isElided ? 45 : 270;
        if (this.m_style != 2) {
            g.drawArc(0, 0, this.m_x_radius * 2, this.m_y_radius * 2, this.m_angle * 90, sweep);
        } else {
            for (int i = this.m_angle * 90; i < this.m_angle * 90 + sweep; i += 18) {
                g.drawArc(0, 0, this.m_x_radius * 2, this.m_y_radius * 2, i, 8);
            }
        }
        if (this.m_component.getDirection() != 3) {
            int y2;
            int x2;
            int y1;
            switch (this.m_angle) {
                case 0: {
                    x1 = 2 * this.m_x_radius - 1;
                    y1 = 0;
                    x2 = x1;
                    y2 = this.m_y_radius - 1;
                    break;
                }
                case 1: {
                    x1 = 2 * this.m_x_radius - 1;
                    y1 = 2 * this.m_y_radius - 1;
                    x2 = x1;
                    y2 = this.m_y_radius - 1;
                    break;
                }
                case 2: {
                    x1 = 0;
                    y1 = 2 * this.m_y_radius - 1;
                    x2 = 0;
                    y2 = this.m_y_radius - 1;
                    break;
                }
                default: {
                    x1 = 0;
                    y1 = 0;
                    x2 = 0;
                    y2 = this.m_y_radius - 1;
                }
            }
            Util.drawArrowHead(g, x1, y1, x2, y2, 1);
        }
        if ((embellished & 2) != 0) {
            Color tc = g.getColor();
            g.setColor(CENTRE_MARK_COLOR);
            x1 = this.m_angle < 2 ? 0 : 2 * this.m_x_radius - 4;
            g.fillRect(x1, this.m_y_radius - 2, 4, 4);
        }
    }

    public ArcInfo(RelationComponent component) {
        this.m_component = component;
    }

    public void setElided(boolean elided) {
        this.m_isElided = elided;
    }

    public void computePosition() {
        int y1;
        int x1;
        RelationInstance ri = this.m_component.getRelationInstance();
        RelationClass rc = ri.getRelationClass();
        int nid = rc.getNid();
        EntityInstance drawSrc = ri.getDrawSrc();
        int w = drawSrc.getWidth();
        int h = drawSrc.getHeight();
        switch (nid / 8) {
            case 0: {
                x1 = w;
                y1 = 0;
                this.m_angle = 3;
                break;
            }
            case 1: {
                x1 = w;
                y1 = h;
                this.m_angle = 2;
                break;
            }
            case 2: {
                x1 = 0;
                y1 = h;
                this.m_angle = 1;
                break;
            }
            default: {
                x1 = 0;
                y1 = 0;
                this.m_angle = 0;
            }
        }
        nid = nid % 8 + 1;
        this.m_x = x1 + drawSrc.getDiagramX();
        this.m_y = y1 + drawSrc.getDiagramY();
        this.m_x_radius = nid * w / 36;
        this.m_y_radius = nid * h / 36;
    }
}

