/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import lsedit.Diagram;
import lsedit.FontCache;
import lsedit.HelpViews;
import lsedit.LandscapeEditorCore;
import lsedit.RemoveAllViews;
import lsedit.View;
import lsedit.ViewBox;

class Add
extends JButton
implements ActionListener,
MouseListener {
    LandscapeEditorCore m_ls;

    public Add(LandscapeEditorCore ls) {
        super("[Add]");
        this.m_ls = ls;
        this.addActionListener(this);
        this.addMouseListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        LandscapeEditorCore ls = this.m_ls;
        Diagram diagram = ls.getDiagram();
        if (diagram != null) {
            ViewBox viewBox = ls.getViewBox();
            View view = new View();
            view.setDiagram(diagram);
            view.rename();
            view.getSnapshot(diagram);
            diagram.addView(view);
            viewBox.fill();
        }
    }

    protected void doRightPopup(MouseEvent ev) {
        LandscapeEditorCore ls = this.m_ls;
        int x = ev.getX();
        int y = ev.getY();
        JPopupMenu popupMenu = new JPopupMenu("Options");
        JMenuItem mi = new JMenuItem("Remove All");
        mi.addActionListener(new RemoveAllViews(ls));
        popupMenu.add(mi);
        mi = new JMenuItem("Help");
        mi.addActionListener(new HelpViews(ls));
        popupMenu.add(mi);
        FontCache.setMenuTreeFont(popupMenu);
        this.add(popupMenu);
        popupMenu.show(this, x, y);
        this.remove(popupMenu);
    }

    @Override
    public void mouseClicked(MouseEvent ev) {
    }

    @Override
    public void mouseEntered(MouseEvent ev) {
    }

    @Override
    public void mouseExited(MouseEvent ev) {
    }

    @Override
    public void mousePressed(MouseEvent ev) {
        if (ev.isMetaDown()) {
            this.doRightPopup(ev);
        }
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
    }
}

