/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import lsedit.ColorCache;
import lsedit.Diagram;
import lsedit.EntityClass;
import lsedit.EntityInstance;
import lsedit.FontCache;
import lsedit.LandscapeClassObject;
import lsedit.LandscapeEditorCore;
import lsedit.LandscapeLayouter;
import lsedit.LandscapeObject;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.SortVector;
import lsedit.ToolBarEventHandler;
import lsedit.Util;

public class AAClusterLayout
extends LandscapeLayouter
implements ToolBarEventHandler {
    public static final int TYPE_COLUMN = 0;
    public static final int SOURCE_COLUMN = 1;
    public static final int RELATION_COLUMN = 2;
    public static final int TARGET_COLUMN = 3;
    public static final int ATTRIBUTE_COLUMN = 4;
    public static final int USE_COLUMN = 5;
    public static final int RULE_COMPONENTS = 6;
    public static final String[] g_columnnames = new String[]{"Type", "Source", "Relation", "Target", "Attribute", "Construct"};
    public static final int TYPE_DELETE = 0;
    public static final int TYPE_ANY = 1;
    public static final int TYPE_CLIENT = 2;
    public static final int TYPE_SUPPLIER = 3;
    public static final int TYPE_CLASS = 4;
    public static final int TYPE_CLIENT_CLASS = 5;
    public static final int TYPE_SUPPLIER_CLASS = 6;
    public static final String[] g_typenames = new String[]{"Delete", "Any", "Client", "Supplier", "Class", "Client class", "Supplier class"};
    public static final String g_all_entities = "ALL ENTITIES";
    public static final String g_all_relations = "ALL RELATIONS";
    public static final String g_null = "";
    public static final String g_all = "ALL";
    public static final String[] g_usenames = new String[]{"%a=%v", "%a", "%v", "%c:%a=%v", "%c:%a", "%c"};
    public static final String[] g_metrics = new String[]{"Jaccard", "Simple Matching", "Sorensen-Dice"};
    public static final String[] g_algorithms = new String[]{"Single Linkage", "Complete Linkage", "Weighted Average", "Unweighted Average"};
    public static final String[] g_debugs = new String[]{"Run Silently", "Minimal output", "Verbose debugging"};
    public static final String[] g_presets = new String[]{"Custom", "Connected nodes", "Cluster node types", "Parent node"};
    protected Vector m_rules;
    protected MyJTable m_table;
    protected static final int COMMAND = 0;
    protected static final int EXPORT = 1;
    protected static final int IMPORT = 2;
    protected static final int CUTPOINT = 3;
    protected static final String[] m_textfield_tags = new String[]{"aa:command", "aa:export", "aa:import", "aa:cutpoint"};
    protected static final String[] m_textfield_titles = new String[]{"Command to execute AA:", "Exported file used by command:", "Imported file created by command:", "AA Cutpoint:"};
    protected static final String[] m_textfield_resets = new String[]{"java.exe -classpath . aa.AA", "junk.mbd", "junk.rsf", "0.0"};
    protected static String[] m_textfield_defaults = new String[]{"java.exe -classpath . aa.AA", "junk.mbd", "junk.rsf", "0.0"};
    protected static String[] m_textfield_currents = new String[]{"java.exe -classpath . aa.AA", "junk.mbd", "junk.rsf", "0.0"};
    protected static final int DELETEEXPORT = 0;
    protected static final int DELETEIMPORT = 1;
    protected static final int LEAVES = 2;
    protected static final int FEEDBACK = 3;
    protected static final String[] m_checkbox_tags = new String[]{"aa:deleteExport", "aa:deleteImport", "aa:leaves", "aa:feedback"};
    protected static final String[] m_checkbox_titles = new String[]{"Delete export file", "Delete import file", "Cluster leaves", "Feedback"};
    protected static final boolean[] m_checkbox_resets = new boolean[]{false, false, true, true};
    protected static boolean[] m_checkbox_defaults = new boolean[]{false, false, true, true};
    protected static boolean[] m_checkbox_currents = new boolean[]{false, false, true, true};
    protected static final int BUTTON_OK = 0;
    protected static final int BUTTON_CANCEL = 1;
    protected static final int BUTTON_ADD = 2;
    protected static final int BUTTON_HELP = 3;
    protected static final int BUTTON_UNDO = 4;
    protected static final int BUTTON_DEFAULT = 5;
    protected static final int BUTTON_SET = 6;
    protected static final int BUTTON_RESET = 7;
    protected static final String[] m_button_titles = new String[]{"Ok", "Cancel", "Add rule", "Help", null, "Default", "Set", "Reset"};
    protected static final String[] m_button_tips = new String[]{null, null, "Add a new rule", null, "Enable/disable undo", "Use remembered default", "Set default to current", "Set default to initial"};
    protected JComboBox m_metric = new JComboBox<String>(g_metrics);
    protected JComboBox m_algorithm = new JComboBox<String>(g_algorithms);
    protected JComboBox m_debug = new JComboBox<String>(g_debugs);
    protected JComboBox m_presets = new JComboBox<String>(g_presets);
    protected String m_ret;

    protected static String parameterString(int i) {
        return m_textfield_currents[i];
    }

    protected static boolean parameterBoolean(int i) {
        return m_checkbox_currents[i];
    }

    @Override
    public String getTag() {
        return "aa:";
    }

    @Override
    public void reset() {
        int i;
        String[] textfield_resets = m_textfield_resets;
        String[] textfield_defaults = m_textfield_defaults;
        String[] textfield_currents = m_textfield_currents;
        boolean[] checkbox_resets = m_checkbox_resets;
        boolean[] checkbox_defaults = m_checkbox_defaults;
        boolean[] checkbox_currents = m_checkbox_currents;
        for (i = 0; i < textfield_resets.length; ++i) {
            String string;
            textfield_defaults[i] = string = textfield_resets[i];
            textfield_currents[i] = string;
        }
        for (i = 0; i < checkbox_resets.length; ++i) {
            boolean bool;
            checkbox_defaults[i] = bool = checkbox_resets[i];
            checkbox_currents[i] = bool;
        }
    }

    @Override
    public void loadLayoutOption(int mode, String attribute, String value) {
        int i;
        String[] textfield_tags = m_textfield_tags;
        for (i = 0; i < textfield_tags.length; ++i) {
            if (!attribute.equals(textfield_tags[i])) continue;
            switch (mode) {
                case 0: {
                    AAClusterLayout.m_textfield_defaults[i] = value;
                }
                case 1: {
                    AAClusterLayout.m_textfield_currents[i] = value;
                }
            }
            return;
        }
        String[] checkbox_tags = m_checkbox_tags;
        for (i = 0; i < checkbox_tags.length; ++i) {
            if (!attribute.equals(checkbox_tags[i])) continue;
            boolean bool = value.charAt(0) == 't';
            switch (mode) {
                case 0: {
                    AAClusterLayout.m_checkbox_defaults[i] = bool;
                }
                case 1: {
                    AAClusterLayout.m_checkbox_currents[i] = bool;
                }
            }
            return;
        }
    }

    @Override
    public void saveLayoutOptions(int mode, PrintWriter ps) {
        int i;
        boolean[] emit_booleans;
        String[] emit_strings;
        boolean[] prior_booleans;
        String[] prior_strings;
        switch (mode) {
            case 0: {
                prior_strings = m_textfield_resets;
                prior_booleans = m_checkbox_resets;
                emit_strings = m_textfield_defaults;
                emit_booleans = m_checkbox_defaults;
                break;
            }
            case 1: {
                prior_strings = m_textfield_defaults;
                prior_booleans = m_checkbox_defaults;
                emit_strings = m_textfield_currents;
                emit_booleans = m_checkbox_currents;
                break;
            }
            default: {
                return;
            }
        }
        for (i = 0; i < m_textfield_tags.length; ++i) {
            String string = emit_strings[i];
            if (string.equals(prior_strings[i])) continue;
            ps.println(m_textfield_tags[i] + "=" + string);
        }
        for (i = 0; i < m_checkbox_tags.length; ++i) {
            boolean bool = emit_booleans[i];
            if (bool == prior_booleans[i]) continue;
            ps.println(m_checkbox_tags[i] + "=" + (bool ? "true" : "false"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void log(String message) {
        if (AAClusterLayout.parameterBoolean(3)) {
            AAClusterLayout aAClusterLayout = this;
            synchronized (aAClusterLayout) {
                System.err.println(Util.toLocaleString() + ": " + message);
            }
        }
    }

    protected void message(String string) {
        this.log(string);
        JOptionPane.showMessageDialog(this.m_ls.getFrame(), string, "Error", 0);
    }

    public AAClusterLayout(LandscapeEditorCore ls, LandscapeLayouter fallback) {
        super(ls, fallback);
        this.m_rules = new Vector();
        MyTableModel tableModel = new MyTableModel();
        MyJTable table = new MyJTable(tableModel);
        tableModel.setJTable(table);
        this.m_table = table;
        this.m_debug.setSelectedIndex(1);
    }

    @Override
    public String getName() {
        return "AA Cluster";
    }

    @Override
    public String getMenuLabel() {
        return "AA Cluster";
    }

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    public boolean isLayouter() {
        return false;
    }

    public boolean configure(LandscapeEditorCore ls, String message) {
        AAClusterConfigure configure = new AAClusterConfigure(this, message);
        boolean ok = configure.ok();
        configure.dispose();
        return ok;
    }

    @Override
    public boolean configure(LandscapeEditorCore ls) {
        return this.configure(ls, null);
    }

    protected void addKeyword(Vector v, int typeIndex, LandscapeClassObject parent, LandscapeObject object, String attributeItem, String useItem) {
        String name;
        switch (typeIndex) {
            case 4: 
            case 5: 
            case 6: {
                object = parent;
            }
        }
        int length = useItem.length();
        int cnt = 0;
        int index = 0;
        while ((name = object.getLsAttributeNameAt(index)) != null) {
            if (name.length() > 0 && (attributeItem == null || name.equalsIgnoreCase(attributeItem))) {
                ++cnt;
                String result = g_null;
                block10: for (int i = 0; i < length; ++i) {
                    char c = useItem.charAt(i);
                    if (c != '%' || ++i == length) {
                        result = result + c;
                        continue;
                    }
                    c = useItem.charAt(i);
                    switch (c) {
                        case 'c': {
                            result = result + parent.getId();
                            continue block10;
                        }
                        case 'a': {
                            result = result + name;
                            continue block10;
                        }
                        case 'v': {
                            result = result + object.getLsAttributeValueAt(index);
                            continue block10;
                        }
                        case '%': {
                            result = result + '%';
                            continue block10;
                        }
                        default: {
                            result = result + (37 + c);
                        }
                    }
                }
                v.addElement(result.replaceAll("[ \t\n\r\f]", g_null));
            }
            ++index;
        }
        if (cnt == 0 && attributeItem == null && useItem.indexOf(37) < 0) {
            v.addElement(useItem.replaceAll("[ \t\n\r\f]", g_null));
        }
    }

    protected void navigate(Vector v, int typeIndex, RelationInstance ri, EntityInstance e, Object relationItem, Object targetItem, String attributeItem, String useItem) {
        RelationClass rc = ri.getRelationClass();
        if (relationItem == null ? !ri.isRelationShown() : relationItem != rc) {
            return;
        }
        if (targetItem == null) {
            this.addKeyword(v, typeIndex, rc, ri, attributeItem, useItem);
            return;
        }
        EntityClass ec = (EntityClass)e.getParentClass();
        if (targetItem != ec && targetItem instanceof EntityClass) {
            return;
        }
        this.addKeyword(v, typeIndex, ec, e, attributeItem, useItem);
    }

    protected boolean write(Vector selectedBoxes, String exportname) {
        Diagram dg = this.m_ls.getDiagram();
        PrintWriter ps = null;
        try {
            this.log("Exporting " + exportname);
            FileOutputStream os = new FileOutputStream(exportname);
            ps = new PrintWriter(os);
        }
        catch (Exception error) {
            this.message("Exception creating output stream " + exportname + ": " + error.getMessage());
            return false;
        }
        boolean leaves = AAClusterLayout.parameterBoolean(2);
        Vector v = new Vector();
        try {
            Enumeration en = selectedBoxes.elements();
            while (en.hasMoreElements()) {
                EntityInstance e = (EntityInstance)en.nextElement();
                EntityClass ec = (EntityClass)e.getParentClass();
                v.removeAllElements();
                Enumeration en1 = this.m_rules.elements();
                block8: while (en1.hasMoreElements()) {
                    RelationInstance ri;
                    Enumeration en2;
                    Object targetItem;
                    Rule rule = (Rule)en1.nextElement();
                    JComboBox type = rule.getValueAt(0);
                    int typeIndex = type.getSelectedIndex();
                    JComboBox source = rule.getValueAt(1);
                    Object sourceItem = source.getSelectedItem();
                    if (sourceItem != null && sourceItem != ec && sourceItem instanceof EntityClass) continue;
                    JComboBox relation = rule.getValueAt(2);
                    JComboBox target = rule.getValueAt(3);
                    JComboBox attribute = rule.getValueAt(4);
                    String attributeItem = (String)attribute.getSelectedItem();
                    if (attributeItem == g_all) {
                        attributeItem = null;
                    }
                    JComboBox use = rule.getValueAt(5);
                    String useItem = (String)use.getSelectedItem();
                    Object relationItem = relation.getSelectedItem();
                    if (relationItem == g_null) {
                        relationItem = null;
                    }
                    if (relationItem == null) {
                        this.addKeyword(v, typeIndex, ec, e, attributeItem, useItem);
                        continue;
                    }
                    if (!(relationItem instanceof RelationClass)) {
                        relationItem = null;
                    }
                    if ((targetItem = target.getSelectedItem()) == g_null) {
                        targetItem = null;
                    }
                    switch (typeIndex) {
                        case 1: 
                        case 3: 
                        case 4: 
                        case 6: {
                            if (leaves) {
                                en2 = e.srcRelationElements();
                                if (en2 != null) {
                                    while (en2.hasMoreElements()) {
                                        ri = (RelationInstance)en2.nextElement();
                                        this.navigate(v, typeIndex, ri, ri.getDst(), relationItem, targetItem, attributeItem, useItem);
                                    }
                                }
                            } else {
                                en2 = e.srcLiftedRelationElements();
                                if (en2 != null) {
                                    while (en2.hasMoreElements()) {
                                        ri = (RelationInstance)en2.nextElement();
                                        this.navigate(v, typeIndex, ri, ri.getDrawDst(), relationItem, targetItem, attributeItem, useItem);
                                    }
                                }
                            }
                            if (typeIndex != 3) break;
                            continue block8;
                        }
                    }
                    if (leaves) {
                        en2 = e.dstRelationElements();
                        if (en2 == null) continue;
                        while (en2.hasMoreElements()) {
                            ri = (RelationInstance)en2.nextElement();
                            this.navigate(v, typeIndex, ri, ri.getSrc(), relationItem, targetItem, attributeItem, useItem);
                        }
                        continue;
                    }
                    en2 = e.dstLiftedRelationElements();
                    if (en2 == null) continue;
                    while (en2.hasMoreElements()) {
                        ri = (RelationInstance)en2.nextElement();
                        this.navigate(v, typeIndex, ri, ri.getDrawSrc(), relationItem, targetItem, attributeItem, useItem);
                    }
                }
                ps.print(e.getId());
                SortVector.byString(v);
                String last = null;
                en1 = v.elements();
                while (en1.hasMoreElements()) {
                    String result = (String)en1.nextElement();
                    if (result.equals(last)) continue;
                    ps.print(" " + result);
                    last = result;
                }
                ps.print("\n");
            }
            ps.close();
            if (ps.checkError()) {
                this.message("An unknown error occurred writing output");
                return false;
            }
            this.log("Export written");
        }
        catch (Exception error) {
            this.message("Exception writing output: " + error.getMessage());
            return false;
        }
        return true;
    }

    boolean waitFor(Process process) {
        try {
            int ret = process.waitFor();
            this.log("Process returned exit value of " + ret);
        }
        catch (Exception error) {
            this.message("WaitFor failed: " + error.getMessage());
            return false;
        }
        return true;
    }

    protected boolean read(String importname, EntityInstance container, boolean collapse) {
        EntityInstance e;
        BufferedReader in;
        Diagram diagram = this.m_ls.getDiagram();
        boolean ok = false;
        Hashtable<String, EntityInstance> clusters = new Hashtable<String, EntityInstance>(20);
        this.log("Importing '" + importname + "'");
        try {
            FileReader fileReader = new FileReader(importname);
            in = new BufferedReader(fileReader);
        }
        catch (Exception error) {
            this.message("Exception opening " + importname + ": " + error.getMessage());
            return false;
        }
        int line = 0;
        String str = g_null;
        try {
            block6: while ((str = in.readLine()) != null) {
                ++line;
                String keyword = str.substring(0, 8);
                if (!keyword.equals("contain ")) {
                    this.message("Expected to see 'contain ' but saw '" + keyword + "' in " + importname + " at line " + line);
                    break;
                }
                int index = str.indexOf(32, 8);
                if (index < 1) {
                    this.message("First token missing in " + importname + " at line " + line);
                    break;
                }
                String firstToken = str.substring(8, index);
                String secondToken = str.substring(index + 1);
                if (secondToken.length() < 1) {
                    this.message("First token missing in " + importname + " at line " + line);
                    break;
                }
                if (firstToken.equals(secondToken)) continue;
                EntityInstance cluster = (EntityInstance)clusters.get(firstToken);
                if (cluster == null) {
                    cluster = diagram.updateNewEntity(null, container);
                    cluster.setLabel(firstToken);
                    clusters.put(firstToken, cluster);
                }
                if ((e = (EntityInstance)clusters.get(secondToken)) == null) {
                    e = diagram.getCache(secondToken);
                }
                if (e == null) {
                    e = diagram.updateNewEntity(null, cluster);
                    e.setLabel(secondToken);
                    clusters.put(secondToken, e);
                    continue;
                }
                EntityInstance parent = e.getContainedBy();
                diagram.updateMoveEntityContainment(cluster, e);
                if (!collapse) continue;
                while (true) {
                    e = parent;
                    parent = e.getContainedBy();
                    if (e.getFirstChild() != null) continue block6;
                    diagram.updateCutEntity(e);
                }
            }
        }
        catch (Exception error) {
            this.message("Exception reading " + importname + ": " + error.getMessage());
        }
        if (str == null) {
            Enumeration en = clusters.elements();
            while (en.hasMoreElements()) {
                e = (EntityInstance)en.nextElement();
                diagram.doRelayoutAll(e, false);
            }
            ok = true;
        }
        clusters.clear();
        try {
            in.close();
        }
        catch (Exception error) {
            this.message("Exception closing " + importname + ": " + error.getMessage());
            return false;
        }
        return ok;
    }

    @Override
    public boolean doLayout1(Vector masterBoxes, EntityInstance parent) {
        int size;
        double dcutpoint;
        int icutpoint;
        String importname;
        String command;
        String exportname;
        Vector selectedBoxes;
        boolean leaves;
        block42: {
            String string;
            leaves = AAClusterLayout.parameterBoolean(2);
            if (!leaves) {
                selectedBoxes = masterBoxes;
            } else {
                selectedBoxes = new Vector();
                Enumeration en = masterBoxes.elements();
                while (en.hasMoreElements()) {
                    EntityInstance e = (EntityInstance)en.nextElement();
                    e.gatherLeaves(selectedBoxes);
                }
            }
            do {
                exportname = AAClusterLayout.parameterString(1);
                command = AAClusterLayout.parameterString(0);
                importname = AAClusterLayout.parameterString(2);
                String cutpoint = AAClusterLayout.parameterString(3);
                icutpoint = 0;
                dcutpoint = -1.0;
                string = null;
                if (exportname.length() == 0) {
                    string = "Please specify an export file to write to";
                } else if (importname.length() != 0 && command.length() == 0) {
                    string = "Please specify the command to execute AA";
                } else if (command.length() != 0 && importname.length() == 0) {
                    string = "Please specify an import file to read from";
                } else if (this.m_rules.isEmpty()) {
                    string = "Please specify rules for generating attribute values";
                } else {
                    try {
                        icutpoint = Integer.parseInt(cutpoint);
                        if (icutpoint < 2) {
                            string = "Cutpoint specifies less than two clusters are to be formed";
                            icutpoint = 0;
                        }
                    }
                    catch (Throwable exception) {
                        icutpoint = 0;
                        dcutpoint = -2.0;
                    }
                    if (dcutpoint == -2.0) {
                        try {
                            dcutpoint = Double.parseDouble(cutpoint);
                            if (dcutpoint < 0.0 || dcutpoint > 1.0) {
                                string = "Double precision cutpoint must be between 0.0 and 1.0";
                            }
                        }
                        catch (Throwable exception) {
                            string = "Cutpoint '" + cutpoint + "' must be an integer or double precision value";
                        }
                    }
                }
                if (string == null) break block42;
            } while (this.configure(this.m_ls, string));
            return true;
        }
        if (!exportname.endsWith(".mbd")) {
            exportname = exportname + ".mbd";
        }
        if (!importname.endsWith(".rsf")) {
            importname = importname + ".rsf";
        }
        if ((size = selectedBoxes.size()) < 3) {
            this.m_ret = "Too few entities to reasonably cluster";
            return true;
        }
        this.log("Using AA to cluster " + size + " items");
        if (!this.write(selectedBoxes, exportname)) {
            return false;
        }
        if (command.length() == 0) {
            this.m_ret = "AA output written to file";
            return true;
        }
        String s = command + " " + exportname + " " + importname;
        Process process = null;
        String s1 = icutpoint != 0 ? g_null + icutpoint : g_null + dcutpoint;
        s = s + " -c" + s1;
        int index = this.m_debug.getSelectedIndex();
        if (index > 0) {
            s = s + " -d" + index;
        }
        if ((index = this.m_metric.getSelectedIndex()) > 0) {
            s = s + " -s" + index;
        }
        if ((index = this.m_algorithm.getSelectedIndex()) > 0) {
            s = s + " -a" + index;
        }
        this.log("Executing [" + s + "]");
        try {
            Runtime runtime = Runtime.getRuntime();
            if (runtime == null) {
                this.message("No runtime available");
                return false;
            }
            process = runtime.exec(s);
            EchoOutput output = new EchoOutput("AA Stdout", process.getInputStream());
            new Thread(output).start();
            output = new EchoOutput("AA Stderr", process.getErrorStream());
            new Thread(output).start();
        }
        catch (Exception error) {
            this.log("Exception executing [" + s + "] " + error.getMessage());
            return false;
        }
        if (!this.waitFor(process)) {
            return false;
        }
        if (!this.read(importname = importname.substring(0, importname.length() - 4) + s1 + ".rsf", parent, leaves)) {
            return false;
        }
        this.log("Import loaded");
        if (AAClusterLayout.parameterBoolean(1)) {
            try {
                File importfile = new File(importname);
                if (!importfile.delete()) {
                    this.message("Unable to delete '" + importfile + "'");
                } else {
                    this.log("Deleted " + importfile);
                }
            }
            catch (Exception error) {
                this.message("Exception deleting '" + importname + "' " + error.getMessage());
            }
        }
        if (exportname.length() != 0 && AAClusterLayout.parameterBoolean(0)) {
            try {
                File exportfile = new File(exportname);
                if (!exportfile.delete()) {
                    this.message("Unable to delete '" + exportfile + "'");
                } else {
                    this.log("Deleted " + exportfile);
                }
            }
            catch (Exception error) {
                this.message("Exception deleting '" + exportname + "' " + error.getMessage());
            }
        }
        this.m_ret = "Graph redrawn using AA Cluster Layout";
        return true;
    }

    @Override
    public String doLayout(Diagram dg) {
        LandscapeEditorCore ls = this.m_ls;
        Vector masterBoxes = dg.getClusterGroup();
        if (masterBoxes == null) {
            Util.beep();
            return "No group selected";
        }
        EntityInstance parent = this.parentOfSet(masterBoxes);
        if (parent == null) {
            return "Cluster layout requires that all things laid out share same parent";
        }
        this.m_ret = "AA Cluster layout aborted";
        ls.doLayout1(this, masterBoxes, parent, false);
        return this.m_ret;
    }

    @Override
    public void processKeyEvent(int key, int modifiers, Object object) {
        if (!this.configure(this.m_ls)) {
            return;
        }
        Diagram dg = this.m_ls.getDiagram();
        if (dg != null) {
            String rmsg = this.doLayout(dg);
            this.m_ls.doFeedback(rmsg);
        }
    }

    class EchoOutput
    implements Runnable {
        InputStream m_inputStream = null;
        String m_source;

        EchoOutput(String source, InputStream inputStream) {
            this.m_inputStream = inputStream;
            this.m_source = source;
        }

        @Override
        public void run() {
            String source = this.m_source;
            try {
                String s;
                InputStreamReader isReader = new InputStreamReader(this.m_inputStream);
                BufferedReader reader = new BufferedReader(isReader);
                while ((s = reader.readLine()) != null) {
                    AAClusterLayout.this.log(source + ": " + s);
                }
                reader.close();
            }
            catch (Exception error) {
                AAClusterLayout.this.log(source + " input error: " + error.getMessage());
            }
        }
    }

    class AAClusterConfigure
    extends JDialog
    implements ActionListener {
        protected JTextField[] m_textfields;
        protected JCheckBox[] m_checkboxes;
        protected JButton[] m_buttons;
        protected JLabel m_message;
        protected boolean m_isok;

        public AAClusterConfigure(AAClusterLayout layout, String message) {
            JLabel label;
            int i;
            super(layout.getLs().getFrame(), layout.getName() + " Configuration", true);
            this.m_isok = false;
            Font font = FontCache.getDialogFont();
            Font bold = font.deriveFont(1);
            Container contentPane = this.getContentPane();
            contentPane.setLayout(new BorderLayout());
            this.setForeground(ColorCache.get(0, 0, 0));
            this.setBackground(ColorCache.get(192, 192, 192));
            this.setFont(font);
            JPanel topPanel = new JPanel();
            topPanel.setLayout(new BorderLayout());
            JPanel labelPanel = new JPanel();
            GridLayout gridLayout = new GridLayout(8, 1, 0, 10);
            labelPanel.setLayout(gridLayout);
            JPanel valuePanel = new JPanel();
            gridLayout = new GridLayout(8, 1, 0, 10);
            valuePanel.setLayout(gridLayout);
            this.m_textfields = new JTextField[m_textfield_tags.length];
            for (i = 0; i < m_textfield_tags.length; ++i) {
                JTextField textfield;
                this.m_textfields[i] = textfield = new JTextField(m_textfield_currents[i], 60);
                label = new JLabel(m_textfield_titles[i], 4);
                label.setFont(bold);
                labelPanel.add(label);
                textfield.setFont(font);
                valuePanel.add(textfield);
            }
            label = new JLabel("Similarity metric:", 4);
            label.setFont(bold);
            labelPanel.add(label);
            AAClusterLayout.this.m_metric.setFont(bold);
            valuePanel.add(AAClusterLayout.this.m_metric);
            label = new JLabel("Cluster algorithm:", 4);
            label.setFont(bold);
            labelPanel.add(label);
            AAClusterLayout.this.m_algorithm.setFont(bold);
            valuePanel.add(AAClusterLayout.this.m_algorithm);
            label = new JLabel("Tracing within AA:", 4);
            label.setFont(bold);
            labelPanel.add(label);
            AAClusterLayout.this.m_debug.setFont(bold);
            valuePanel.add(AAClusterLayout.this.m_debug);
            label = new JLabel("Preset rules:", 4);
            label.setFont(bold);
            labelPanel.add(label);
            AAClusterLayout.this.m_presets.addActionListener(this);
            AAClusterLayout.this.m_presets.setFont(bold);
            valuePanel.add(AAClusterLayout.this.m_presets);
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new FlowLayout(1, 15, 15));
            this.m_checkboxes = new JCheckBox[m_checkbox_tags.length];
            for (i = 0; i < m_checkbox_tags.length; ++i) {
                JCheckBox checkbox;
                this.m_checkboxes[i] = checkbox = new JCheckBox(m_checkbox_titles[i], m_checkbox_currents[i]);
                checkbox.setFont(font);
                buttonPanel.add(checkbox);
            }
            topPanel.add("West", labelPanel);
            topPanel.add("East", valuePanel);
            topPanel.add("South", buttonPanel);
            MyJTable table = AAClusterLayout.this.m_table;
            table.setFont(font);
            JTableHeader tableHeader = table.getTableHeader();
            tableHeader.setFont(bold);
            FontMetrics fm = this.getFontMetrics(font);
            table.setRowHeight(fm.getHeight() + 4);
            table.setVisible(true);
            JScrollPane scrollPane = new JScrollPane(table);
            scrollPane.setVisible(true);
            JPanel bottomPanel = new JPanel();
            bottomPanel.setLayout(new BorderLayout());
            if (message == null) {
                message = AAClusterLayout.this.m_ls.getDiagram().undoEnabled() ? "You might wish to disable undo/redo operations" : "You might wish to enable undo/redo operations";
            }
            this.m_message = new JLabel(message, 0);
            this.m_message.setFont(font);
            this.m_message.setForeground(Color.RED);
            this.m_message.setSize(400, 50);
            this.m_message.setPreferredSize(new Dimension(400, 50));
            buttonPanel = new JPanel();
            buttonPanel.setLayout(new FlowLayout(1, 15, 15));
            this.m_buttons = new JButton[m_button_titles.length];
            for (i = 0; i < m_button_titles.length; ++i) {
                JButton button;
                String string = m_button_titles[i];
                if (string == null) {
                    string = AAClusterLayout.this.undoLabel();
                }
                this.m_buttons[i] = button = new JButton(string);
                button.setFont(bold);
                String tip = m_button_tips[i];
                if (tip != null) {
                    button.setToolTipText(tip);
                }
                button.addActionListener(this);
                buttonPanel.add(button);
            }
            bottomPanel.add("North", this.m_message);
            bottomPanel.add("South", buttonPanel);
            contentPane.add("North", topPanel);
            contentPane.add("Center", scrollPane);
            contentPane.add("South", bottomPanel);
            this.pack();
            this.setVisible(true);
        }

        public boolean ok() {
            return this.m_isok;
        }

        protected void setPreset(int choice) {
            AAClusterLayout.this.m_rules.removeAllElements();
            switch (choice) {
                case 0: {
                    break;
                }
                case 1: {
                    Rule rule = new Rule();
                    rule.connectedNodeId();
                    AAClusterLayout.this.m_rules.add(rule);
                    rule = new Rule();
                    rule.nodeId();
                    AAClusterLayout.this.m_rules.add(rule);
                    break;
                }
                case 2: {
                    Rule rule = new Rule();
                    rule.classId();
                    AAClusterLayout.this.m_rules.add(rule);
                    break;
                }
                case 3: {
                    Rule rule = new Rule();
                    rule.parentId();
                    AAClusterLayout.this.m_rules.add(rule);
                }
            }
            AAClusterLayout.this.m_table.revalidate();
            AAClusterLayout.this.m_table.repaint();
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            int i;
            Object source = ev.getSource();
            int state = -1;
            for (i = 0; i < m_button_titles.length; ++i) {
                if (source != this.m_buttons[i]) continue;
                state = i;
                break;
            }
            switch (state) {
                case 7: {
                    for (i = 0; i < m_textfield_tags.length; ++i) {
                        AAClusterLayout.m_textfield_defaults[i] = m_textfield_resets[i];
                    }
                    for (i = 0; i < m_checkbox_tags.length; ++i) {
                        AAClusterLayout.m_checkbox_defaults[i] = m_checkbox_resets[i];
                    }
                }
                case 5: {
                    for (i = 0; i < m_textfield_tags.length; ++i) {
                        this.m_textfields[i].setText(m_textfield_defaults[i]);
                    }
                    for (i = 0; i < m_checkbox_tags.length; ++i) {
                        this.m_checkboxes[i].setSelected(m_checkbox_defaults[i]);
                    }
                    AAClusterLayout.this.m_metric.setSelectedIndex(0);
                    AAClusterLayout.this.m_algorithm.setSelectedIndex(0);
                    AAClusterLayout.this.m_debug.setSelectedIndex(0);
                    return;
                }
                case 6: {
                    for (i = 0; i < m_textfield_tags.length; ++i) {
                        AAClusterLayout.m_textfield_defaults[i] = this.m_textfields[i].getText();
                    }
                    for (i = 0; i < m_checkbox_tags.length; ++i) {
                        AAClusterLayout.m_checkbox_defaults[i] = this.m_checkboxes[i].isSelected();
                    }
                    return;
                }
                case 4: {
                    LandscapeEditorCore ls = AAClusterLayout.this.m_ls;
                    ls.invertUndo();
                    this.m_buttons[state].setText(AAClusterLayout.this.undoLabel());
                    this.m_message.setText(AAClusterLayout.g_null);
                    return;
                }
                case 2: {
                    AAClusterLayout.this.m_rules.addElement(new Rule());
                    AAClusterLayout.this.m_table.revalidate();
                    AAClusterLayout.this.m_table.repaint();
                    return;
                }
                case 3: {
                    JOptionPane.showMessageDialog(AAClusterLayout.this.m_ls.getFrame(), "The AA clustering algorithm attempts to cluster nodes on the basis of\nattributes that have the same or somewhat similar values in distinct\nentities. Specify the rules here which will produce the input attribute\nvalues on which clustering is to be performed.  Each such rule contains\nsix components:\n\n1) The rule to use when navigating from the entity to be clustered.  If\n   client/supplier is specified restrict navigation to in/out edges. If\n\t  class is specified recover attributes from the entity/relation class.\n2) The entity class for which this rule is to be considered applicable.\n3) The relation class if any to use when navigating to the object from\n   which attributes are to be recovered.\n4) The class of entity reached from such relations if any from which the\n   attributes are to be recovered.\n5) The attribute to be recovered from the resulting entity or relation.\n   Select one of the choices or enter the name of the desired attribute.\n6) The format of the value to be emitted as input to AA. This is a format\n   string in which %c expands to class name, %a to attribute name, %v to\n   attribute value and %% to %.\n\nOutput values derived from any of the specified rules will be emitted.\nUse the [add] button to create new rules, and selecte [Delete] option in\nthe rules first component to delete existing rules.\n\nIf the cutpoint is an integer then AA will attempt to create this number\nof clusters.  If it is a double precision value between 0.0 and 1.0, this\nvalue will be used as the desired cutpoint.", "Help", 0);
                    return;
                }
                case 0: {
                    for (i = 0; i < m_textfield_tags.length; ++i) {
                        AAClusterLayout.m_textfield_currents[i] = this.m_textfields[i].getText();
                    }
                    for (i = 0; i < m_checkbox_tags.length; ++i) {
                        AAClusterLayout.m_checkbox_currents[i] = this.m_checkboxes[i].isSelected();
                    }
                    this.m_isok = true;
                }
                case 1: {
                    break;
                }
                default: {
                    if (source == AAClusterLayout.this.m_presets) {
                        this.setPreset(AAClusterLayout.this.m_presets.getSelectedIndex());
                    }
                    return;
                }
            }
            this.setVisible(false);
        }
    }

    protected class MyJTable
    extends JTable {
        public MyJTable(AbstractTableModel tableModel) {
            super(tableModel);
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            return new CellRenderer();
        }

        @Override
        public TableCellEditor getCellEditor(int row, int column) {
            return new CellEditor(row, column);
        }
    }

    protected class MyTableModel
    extends AbstractTableModel {
        JTable m_table;

        public void setJTable(JTable table) {
            this.m_table = table;
        }

        @Override
        public int getRowCount() {
            return AAClusterLayout.this.m_rules.size();
        }

        @Override
        public int getColumnCount() {
            return 6;
        }

        @Override
        public String getColumnName(int column) {
            return g_columnnames[column];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            Rule rule = (Rule)AAClusterLayout.this.m_rules.elementAt(row);
            JComboBox comboBox = rule.getValueAt(col);
            return comboBox.getItemCount() > 1;
        }

        @Override
        public Object getValueAt(int row, int col) {
            Rule rule = (Rule)AAClusterLayout.this.m_rules.elementAt(row);
            JComboBox comboBox = rule.getValueAt(col);
            return comboBox;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
        }
    }

    class CellEditor
    extends DefaultCellEditor {
        JComboBox m_comboBox;

        public CellEditor(int row, int column) {
            super(((Rule)AAClusterLayout.this.m_rules.elementAt(row)).getValueAt(column));
            this.m_comboBox = (JComboBox)this.editorComponent;
            this.setClickCountToStart(1);
            this.m_comboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CellEditor.this.fireEditingStopped();
                }
            });
        }

        @Override
        public Object getCellEditorValue() {
            return this.m_comboBox;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return this.editorComponent;
        }
    }

    protected class CellRenderer
    extends JTextField
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Object selectedItem = ((JComboBox)value).getSelectedItem();
            String description = selectedItem == null ? AAClusterLayout.g_null : (selectedItem instanceof LandscapeClassObject ? ((LandscapeClassObject)selectedItem).getId() : (String)selectedItem);
            this.setText(description);
            return this;
        }
    }

    class Rule
    implements ActionListener {
        private JComboBox[] m_components = new JComboBox[6];

        private void addAttributeNames(LandscapeObject object, Vector v) {
            String name;
            int index = 0;
            while ((name = object.getLsAttributeNameAt(index)) != null) {
                if (name.length() > 0) {
                    v.addElement(name);
                }
                ++index;
            }
        }

        private void addAllEntityAttributeNames(Vector v) {
            Diagram diagram = AAClusterLayout.this.m_ls.getDiagram();
            if (diagram != null) {
                Enumeration en = diagram.enumEntityClassesInOrder();
                while (en.hasMoreElements()) {
                    EntityClass ec = (EntityClass)en.nextElement();
                    this.addAttributeNames(ec, v);
                }
            }
        }

        private void addAllRelationAttributeNames(Vector v) {
            Diagram diagram = AAClusterLayout.this.m_ls.getDiagram();
            if (diagram != null) {
                Enumeration en = diagram.enumRelationClassesInOrder();
                while (en.hasMoreElements()) {
                    RelationClass rc = (RelationClass)en.nextElement();
                    this.addAttributeNames(rc, v);
                }
            }
        }

        private void setAttributeColumn() {
            JComboBox comboBox = this.getValueAt(4);
            JComboBox typeBox = this.getValueAt(0);
            JComboBox targetBox = this.getValueAt(3);
            Object item = targetBox.getSelectedItem();
            comboBox.removeAllItems();
            comboBox.addItem(AAClusterLayout.g_all);
            switch (typeBox.getSelectedIndex()) {
                case 4: 
                case 5: 
                case 6: {
                    JComboBox relationBox;
                    if (!(item != null && item != AAClusterLayout.g_null || (item = (relationBox = this.getValueAt(2)).getSelectedItem()) != null && item != AAClusterLayout.g_null)) {
                        JComboBox sourceBox = this.getValueAt(1);
                        item = sourceBox.getSelectedItem();
                    }
                    if (item != null) {
                        Vector v = new Vector();
                        if (item == AAClusterLayout.g_all_entities) {
                            this.addAllEntityAttributeNames(v);
                        } else if (item == AAClusterLayout.g_all_relations) {
                            this.addAllRelationAttributeNames(v);
                        } else {
                            this.addAttributeNames((LandscapeObject)item, v);
                        }
                        SortVector.byString(v);
                        String last = null;
                        Enumeration en = v.elements();
                        while (en.hasMoreElements()) {
                            String name = (String)en.nextElement();
                            if (name.equals(last)) continue;
                            comboBox.addItem(name);
                            last = name;
                        }
                    }
                    comboBox.setEditable(false);
                    break;
                }
                default: {
                    comboBox.addItem(AAClusterLayout.g_null);
                    comboBox.setEditable(true);
                }
            }
            comboBox.setSelectedIndex(0);
        }

        private void addEntityClasses(JComboBox comboBox) {
            Diagram diagram = AAClusterLayout.this.m_ls.getDiagram();
            Vector v = new Vector();
            comboBox.addItem(AAClusterLayout.g_all_entities);
            Enumeration en = diagram.enumEntityClasses();
            while (en.hasMoreElements()) {
                v.addElement(en.nextElement());
            }
            SortVector.byString(v);
            en = v.elements();
            while (en.hasMoreElements()) {
                Object item = en.nextElement();
                comboBox.addItem(item);
            }
            comboBox.setSelectedIndex(0);
        }

        private void addRelationClasses(JComboBox comboBox) {
            Diagram diagram = AAClusterLayout.this.m_ls.getDiagram();
            Vector v = new Vector();
            comboBox.addItem(AAClusterLayout.g_all_relations);
            Enumeration en = diagram.enumRelationClasses();
            while (en.hasMoreElements()) {
                v.addElement(en.nextElement());
            }
            SortVector.byString(v);
            en = v.elements();
            while (en.hasMoreElements()) {
                Object item = en.nextElement();
                comboBox.addItem(item);
            }
            comboBox.setSelectedIndex(0);
        }

        private void setTargetColumn() {
            JComboBox comboBox = this.getValueAt(3);
            JComboBox relationBox = this.getValueAt(2);
            int index = relationBox.getSelectedIndex();
            comboBox.removeAllItems();
            comboBox.addItem(AAClusterLayout.g_null);
            if (index > 0) {
                this.addEntityClasses(comboBox);
            }
            comboBox.setSelectedIndex(0);
        }

        private void setRelationColumn() {
            JComboBox comboBox = this.getValueAt(2);
            JComboBox typeBox = this.getValueAt(0);
            comboBox.removeAllItems();
            comboBox.addItem(AAClusterLayout.g_null);
            this.addRelationClasses(comboBox);
            comboBox.setSelectedIndex(0);
        }

        private void setSourceColumn() {
            JComboBox comboBox = this.getValueAt(1);
            Diagram diagram = AAClusterLayout.this.m_ls.getDiagram();
            comboBox.removeAllItems();
            if (diagram == null) {
                comboBox.addItem(AAClusterLayout.g_null);
            } else {
                this.addEntityClasses(comboBox);
            }
        }

        public JComboBox getValueAt(int column) {
            return this.m_components[column];
        }

        public Rule() {
            this.m_components[0] = new JComboBox<String>(g_typenames);
            this.m_components[1] = new JComboBox();
            this.m_components[2] = new JComboBox();
            this.m_components[3] = new JComboBox();
            this.m_components[4] = new JComboBox();
            this.m_components[5] = new JComboBox<String>(g_usenames);
            JComboBox comboBox = this.getValueAt(0);
            comboBox.setSelectedIndex(1);
            comboBox.setMaximumRowCount(g_typenames.length);
            comboBox.addActionListener(this);
            comboBox = this.getValueAt(1);
            comboBox.setMaximumRowCount(12);
            comboBox.addActionListener(this);
            this.setSourceColumn();
            comboBox = this.getValueAt(2);
            comboBox.setMaximumRowCount(12);
            comboBox.addActionListener(this);
            this.setRelationColumn();
            comboBox = this.getValueAt(3);
            comboBox.setMaximumRowCount(12);
            comboBox.addActionListener(this);
            this.setTargetColumn();
            comboBox = this.getValueAt(4);
            comboBox.setMaximumRowCount(12);
            comboBox.addActionListener(this);
            this.setAttributeColumn();
            comboBox = this.getValueAt(5);
            comboBox.setSelectedIndex(0);
            comboBox.setMaximumRowCount(g_usenames.length);
            comboBox.setEditable(true);
            comboBox.addActionListener(this);
        }

        public void connectedNodeId() {
            this.m_components[0].setSelectedIndex(3);
            this.m_components[1].setSelectedIndex(0);
            this.m_components[2].setSelectedIndex(1);
            this.m_components[3].setSelectedIndex(1);
            this.m_components[4].setSelectedItem("id");
            this.m_components[5].setSelectedIndex(2);
        }

        public void nodeId() {
            this.m_components[0].setSelectedIndex(1);
            this.m_components[1].setSelectedIndex(0);
            this.m_components[2].setSelectedIndex(0);
            this.m_components[3].setSelectedIndex(0);
            this.m_components[4].setSelectedItem("id");
            this.m_components[5].setSelectedIndex(2);
        }

        public void classId() {
            this.m_components[0].setSelectedIndex(4);
            this.m_components[1].setSelectedIndex(0);
            this.m_components[2].setSelectedIndex(0);
            this.m_components[3].setSelectedIndex(0);
            this.m_components[4].setSelectedItem("id");
            this.m_components[5].setSelectedIndex(2);
        }

        public void parentId() {
            this.m_components[0].setSelectedIndex(2);
            this.m_components[1].setSelectedIndex(0);
            JComboBox relations = this.m_components[2];
            relations.setSelectedIndex(0);
            for (int i = 2; i < relations.getItemCount(); ++i) {
                RelationClass rc = (RelationClass)relations.getItemAt(i);
                if (rc.getContainsClassOffset() != 0) continue;
                relations.setSelectedIndex(i);
                break;
            }
            this.m_components[3].setSelectedIndex(1);
            this.m_components[4].setSelectedItem("id");
            this.m_components[5].setSelectedIndex(2);
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            Object source = ev.getSource();
            int i = 0;
            while (true) {
                if (i >= 6) {
                    return;
                }
                if (source == this.m_components[i]) break;
                ++i;
            }
            JComboBox comboBox = (JComboBox)source;
            int index = comboBox.getSelectedIndex();
            if (index < 0) {
                return;
            }
            switch (i) {
                case 0: {
                    switch (index) {
                        case 0: {
                            AAClusterLayout.this.m_rules.remove(this);
                            break;
                        }
                        default: {
                            this.setSourceColumn();
                        }
                    }
                }
                case 1: {
                    this.setRelationColumn();
                }
                case 2: {
                    this.setTargetColumn();
                }
                case 3: {
                    this.setAttributeColumn();
                }
            }
            AAClusterLayout.this.m_table.revalidate();
            AAClusterLayout.this.m_table.repaint();
        }
    }
}

