/*
 * Decompiled with CFR 0.152.
 */
package c4e.phidget;

import c4e.phidget.Event;
import c4e.util.HRQ;
import com.phidgets.AdvancedServoPhidget;
import com.phidgets.InterfaceKitPhidget;
import com.phidgets.Phidget;
import com.phidgets.PhidgetException;
import com.phidgets.RFIDPhidget;
import com.phidgets.event.AttachEvent;
import com.phidgets.event.AttachListener;
import com.phidgets.event.CurrentChangeEvent;
import com.phidgets.event.CurrentChangeListener;
import com.phidgets.event.DetachEvent;
import com.phidgets.event.DetachListener;
import com.phidgets.event.ErrorEvent;
import com.phidgets.event.ErrorListener;
import com.phidgets.event.InputChangeEvent;
import com.phidgets.event.InputChangeListener;
import com.phidgets.event.OutputChangeEvent;
import com.phidgets.event.OutputChangeListener;
import com.phidgets.event.SensorChangeEvent;
import com.phidgets.event.SensorChangeListener;
import com.phidgets.event.ServoPositionChangeEvent;
import com.phidgets.event.ServoPositionChangeListener;
import com.phidgets.event.ServoVelocityChangeEvent;
import com.phidgets.event.ServoVelocityChangeListener;
import com.phidgets.event.TagGainEvent;
import com.phidgets.event.TagGainListener;
import com.phidgets.event.TagLossEvent;
import com.phidgets.event.TagLossListener;
import java.util.Date;
import java.util.Scanner;

public class JMConnector {
    private HRQ<Event> hrq = new HRQ(queueSize);
    private String lastException = null;
    private Phidget[] phidget = new Phidget[3];
    private static final int BOARD_COUNT = 3;
    private static int queueSize = 8;
    private static JMConnector singleton = null;

    public static JMConnector getInstance() {
        if (singleton == null) {
            singleton = new JMConnector();
        }
        return singleton;
    }

    private JMConnector() {
        int p = 0;
        while (p < 3) {
            this.phidget[p] = null;
            ++p;
        }
        try {
            this.phidget[0] = new InterfaceKitPhidget();
            this.phidget[1] = new AdvancedServoPhidget();
            this.phidget[2] = new RFIDPhidget();
            p = 0;
            while (p < 3) {
                this.phidget[p].openAny();
                ++p;
            }
            Thread.sleep(1000L);
            this.register();
            p = 0;
            while (p < 3) {
                this.register(p);
                ++p;
            }
        }
        catch (Exception pe) {
            this.lastException = pe.toString();
        }
    }

    private void register() {
        int p = 0;
        while (p < 3) {
            this.phidget[p].addAttachListener(new AttachListener(){

                public void attached(AttachEvent e) {
                    try {
                        JMConnector.this.hrq.enqueue(new Event(new Date().getTime(), 0, e.getSource().getSerialNumber(), e.getSource().getDeviceID(), "", e.getSource()));
                    }
                    catch (PhidgetException pe) {
                        JMConnector.this.lastException = pe.toString();
                    }
                }
            });
            this.phidget[p].addDetachListener(new DetachListener(){

                public void detached(DetachEvent e) {
                    try {
                        JMConnector.this.hrq.enqueue(new Event(new Date().getTime(), 1, e.getSource().getSerialNumber(), e.getSource().getDeviceID(), "", e.getSource()));
                    }
                    catch (PhidgetException pe) {
                        JMConnector.this.lastException = pe.toString();
                    }
                }
            });
            this.phidget[p].addErrorListener(new ErrorListener(){

                public void error(ErrorEvent pe) {
                    JMConnector.this.lastException = pe.toString();
                }
            });
            ++p;
        }
    }

    private void register(int p) {
        if (p == 0) {
            InterfaceKitPhidget board = (InterfaceKitPhidget)this.phidget[p];
            board.addInputChangeListener(new InputChangeListener(){

                public void inputChanged(InputChangeEvent e) {
                    JMConnector.this.hrq.enqueue(new Event(new Date().getTime(), 2, e.getIndex(), e.getState() ? 1 : 0, "", e.getSource()));
                }
            });
            board.addOutputChangeListener(new OutputChangeListener(){

                public void outputChanged(OutputChangeEvent e) {
                    JMConnector.this.hrq.enqueue(new Event(new Date().getTime(), 4, e.getIndex(), e.getState() ? 1 : 0, "", e.getSource()));
                }
            });
            board.addSensorChangeListener(new SensorChangeListener(){

                public void sensorChanged(SensorChangeEvent e) {
                    JMConnector.this.hrq.enqueue(new Event(new Date().getTime(), 3, e.getIndex(), e.getValue(), "", e.getSource()));
                }
            });
        } else if (p == 1) {
            AdvancedServoPhidget board = (AdvancedServoPhidget)this.phidget[p];
            board.addServoPositionChangeListener(new ServoPositionChangeListener(){

                public void servoPositionChanged(ServoPositionChangeEvent e) {
                    JMConnector.this.hrq.enqueue(new Event(new Date().getTime(), 7, e.getIndex(), e.getValue(), "", e.getSource()));
                }
            });
            board.addServoVelocityChangeListener(new ServoVelocityChangeListener(){

                public void servoVelocityChanged(ServoVelocityChangeEvent e) {
                    JMConnector.this.hrq.enqueue(new Event(new Date().getTime(), 8, e.getIndex(), e.getValue(), "", e.getSource()));
                }
            });
            board.addCurrentChangeListener(new CurrentChangeListener(){

                public void currentChanged(CurrentChangeEvent e) {
                    JMConnector.this.hrq.enqueue(new Event(new Date().getTime(), 9, e.getIndex(), e.getValue(), "", e.getSource()));
                }
            });
        } else if (p == 2) {
            RFIDPhidget board = (RFIDPhidget)this.phidget[p];
            board.addTagGainListener(new TagGainListener(){

                public void tagGained(TagGainEvent e) {
                    JMConnector.this.hrq.enqueue(new Event(new Date().getTime(), 5, e.getProtocol(), 0.0, e.getValue(), e.getSource()));
                }
            });
            board.addTagLossListener(new TagLossListener(){

                public void tagLost(TagLossEvent e) {
                    JMConnector.this.hrq.enqueue(new Event(new Date().getTime(), 6, e.getProtocol(), 0.0, e.getValue(), e.getSource()));
                }
            });
            board.addOutputChangeListener(new OutputChangeListener(){

                public void outputChanged(OutputChangeEvent e) {
                    JMConnector.this.hrq.enqueue(new Event(new Date().getTime(), 4, e.getIndex(), e.getState() ? 1 : 0, "", e.getSource()));
                }
            });
        }
    }

    public Event getLastEvent() {
        JMConnector.getInstance();
        Event result = this.hrq.dequeue();
        return result;
    }

    public String getLastException() {
        JMConnector.getInstance();
        String result = this.lastException;
        this.lastException = null;
        return result;
    }

    public Phidget getPhidget(int p) {
        JMConnector.getInstance();
        return this.phidget[p];
    }

    public String shutDown() {
        String result;
        singleton = null;
        try {
            int p = 0;
            while (p < 3) {
                this.phidget[p].close();
                ++p;
            }
            result = "OK";
        }
        catch (Exception e) {
            result = e.toString();
        }
        return result;
    }

    public static int getQueueSize() {
        return queueSize;
    }

    public static void setQueueSize(int queueSize) {
        JMConnector.queueSize = queueSize;
    }

    public HRQ<Event> getHrq() {
        return this.hrq;
    }

    public void setHrq(HRQ<Event> hrq) {
        this.hrq = hrq;
    }

    public static void main(String[] args) throws Exception {
        long POLL = 120000L;
        long start = new Date().getTime();
        Scanner in = new Scanner(System.in);
        JMConnector jm = JMConnector.getInstance();
        do {
            String x;
            double pos;
            Event e;
            Thread.sleep(200L);
            if (jm.getPhidget(2).isAttached()) {
                ((RFIDPhidget)jm.getPhidget(2)).setAntennaOn(true);
            }
            if ((e = jm.getLastEvent()) != null) {
                System.out.println(e);
            }
            if (e != null && e.getWhat() >= 7) {
                AdvancedServoPhidget motor = (AdvancedServoPhidget)jm.getPhidget(1);
                motor.setEngaged(5, true);
                System.out.println("max pos = " + motor.getPositionMax(5));
                System.out.println("max pos = " + motor.getPositionMin(5));
                System.out.println("Enter desired position ... (negative to skip)");
                pos = in.nextDouble();
                if (pos >= 0.0) {
                    motor.setPosition(5, pos);
                }
            } else if (e != null && e.getWhat() >= 5) {
                RFIDPhidget rf = (RFIDPhidget)jm.getPhidget(2);
                rf.setLEDOn(true);
                System.out.println("Enter negative to turn off LED of RFID Board:");
                pos = in.nextDouble();
                if (pos < 0.0) {
                    rf.setLEDOn(false);
                }
            }
            if ((x = jm.getLastException()) == null) continue;
            System.out.println(x);
        } while (new Date().getTime() < start + 120000L);
        jm.shutDown();
    }
}

