/*
 * Decompiled with CFR 0.152.
 */
package c4e.phidget;

import c4e.listener.InterfaceBoard;
import c4e.listener.RFIDBoard;
import c4e.listener.ServoBoard;
import c4e.phidget.Event;
import c4e.util.ToolBox;
import com.phidgets.AdvancedServoPhidget;
import com.phidgets.InterfaceKitPhidget;
import com.phidgets.Phidget;
import com.phidgets.PhidgetException;
import com.phidgets.RFIDPhidget;
import com.phidgets.event.CurrentChangeListener;
import com.phidgets.event.InputChangeListener;
import com.phidgets.event.OutputChangeListener;
import com.phidgets.event.SensorChangeListener;
import com.phidgets.event.ServoPositionChangeListener;
import com.phidgets.event.ServoVelocityChangeListener;
import com.phidgets.event.TagGainListener;
import com.phidgets.event.TagLossListener;

public class HardwareInterface
implements Runnable {
    private boolean debug;
    private Phidget[] phidget;
    private Thread timerThread;
    private static Object eLock;
    private static boolean instantiated;
    private static boolean monitoringState;
    private static boolean killTimerThread;
    private static long timerCallbackDelay;
    private static final int BOARD_COUNT = 3;
    private static final int INTF_BOARD = 0;
    private static final int SRVO_BOARD = 1;
    private static final int RFID_BOARD = 2;

    static {
        instantiated = false;
        monitoringState = false;
        killTimerThread = false;
        timerCallbackDelay = -1L;
    }

    public HardwareInterface() {
        this(false);
    }

    public HardwareInterface(boolean debug) {
        if (instantiated) {
            throw new RuntimeException("This class cannot be instantiatiated twice!");
        }
        instantiated = true;
        this.debug = debug;
        eLock = new Object();
        this.timerThread = new Thread(this);
        try {
            this.phidget = new Phidget[3];
            this.phidget[0] = new InterfaceKitPhidget();
            this.phidget[1] = new AdvancedServoPhidget();
            this.phidget[2] = new RFIDPhidget();
        }
        catch (PhidgetException err) {
            System.out.println("Phidget exception " + (Object)((Object)err));
        }
    }

    public final void setOutputState(int id, boolean value) {
        try {
            ((InterfaceKitPhidget)this.phidget[0]).setOutputState(id, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ((RFIDPhidget)this.phidget[2]).setOutputState(id, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final boolean getOutputState(int id) {
        try {
            return ((InterfaceKitPhidget)this.phidget[0]).getOutputState(id);
        }
        catch (Exception e) {
            return false;
        }
    }

    public final void setAntennaOn(boolean state) {
        try {
            ((RFIDPhidget)this.phidget[2]).setAntennaOn(state);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void setLED(boolean state) {
        try {
            ((RFIDPhidget)this.phidget[2]).setLEDOn(state);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void setServoPosition(int index, double position) {
        try {
            ((AdvancedServoPhidget)this.phidget[1]).setPosition(index, position);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final double getServoPosition(int index) {
        try {
            return ((AdvancedServoPhidget)this.phidget[1]).getPosition(index);
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    public final double getServoPositionMin(int index) {
        try {
            return ((AdvancedServoPhidget)this.phidget[1]).getPositionMin(index);
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    public final double getServoPositionMax(int index) {
        try {
            return ((AdvancedServoPhidget)this.phidget[1]).getPositionMax(index);
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    public final void setServoAcceleration(int index, double acceleration) {
        try {
            ((AdvancedServoPhidget)this.phidget[1]).setAcceleration(index, acceleration);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final double getServoAccelerationMin(int index) {
        try {
            return ((AdvancedServoPhidget)this.phidget[1]).getAccelerationMin(index);
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    public final double getServoAccelerationMax(int index) {
        try {
            return ((AdvancedServoPhidget)this.phidget[1]).getAccelerationMax(index);
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    public final double getServoAcceleration(int index) {
        try {
            return ((AdvancedServoPhidget)this.phidget[1]).getAcceleration(index);
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    public final double getServoCurrent(int index) {
        try {
            return ((AdvancedServoPhidget)this.phidget[1]).getCurrent(index);
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    public final double getServoVelocity(int index) {
        try {
            return ((AdvancedServoPhidget)this.phidget[1]).getVelocity(index);
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    public final void setServoEngageState(int index, boolean state) {
        try {
            ((AdvancedServoPhidget)this.phidget[1]).setEngaged(index, state);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void digitalOutputChanged(Event event) {
        if (this.debug) {
            System.out.println("Digital output changed: " + event);
        }
    }

    public void analogInputChanged(Event event) {
        if (this.debug) {
            System.out.println("Analog input changed: " + event);
        }
    }

    public void digitalInputChanged(Event event) {
        if (this.debug) {
            System.out.println("Digital input changed: " + event);
        }
    }

    public void servoPositionChanged(Event event) {
        if (this.debug) {
            System.out.println("Servo Position changed: " + event);
        }
    }

    public void servoVelocityChanged(Event event) {
        if (this.debug) {
            System.out.println("Servo Velocity changed: " + event);
        }
    }

    public void servoCurrentChanged(Event event) {
        if (this.debug) {
            System.out.println("Servo Current changed: " + event);
        }
    }

    public void tagGained(Event event) {
        if (this.debug) {
            System.out.println("RFID Tag Gained: " + event);
        }
    }

    public void tagLost(Event event) {
        if (this.debug) {
            System.out.println("RFID Tag Lost: " + event);
        }
    }

    public void rfidOutputChanged(Event event) {
        if (this.debug) {
            System.out.println("RFID Output Changed: " + event);
        }
    }

    public void timerCallback() {
        if (this.debug) {
            System.out.println("Timer event fired at: " + System.currentTimeMillis());
        }
    }

    public final InterfaceKitPhidget getInterfaceBoard() {
        InterfaceKitPhidget result = (InterfaceKitPhidget)this.phidget[0];
        try {
            return result.isAttached() ? result : null;
        }
        catch (PhidgetException e) {
            return null;
        }
    }

    public final AdvancedServoPhidget getServoBoard() {
        AdvancedServoPhidget result = (AdvancedServoPhidget)this.phidget[1];
        try {
            return result.isAttached() ? result : null;
        }
        catch (PhidgetException e) {
            return null;
        }
    }

    public final RFIDPhidget getRFIDBoard() {
        RFIDPhidget result = (RFIDPhidget)this.phidget[2];
        try {
            return result.isAttached() ? result : null;
        }
        catch (PhidgetException e) {
            return null;
        }
    }

    public final synchronized void setTimer(long delay) {
        if (delay <= 0L) {
            throw new RuntimeException("Invalid timer delay: " + delay);
        }
        boolean firstTime = timerCallbackDelay == -1L;
        timerCallbackDelay = delay;
        killTimerThread = false;
        if (this.debug) {
            System.out.println("Timer event scheduled after " + timerCallbackDelay + " ms.");
        }
        if (firstTime) {
            this.timerThread.start();
        } else {
            this.timerThread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        while (!killTimerThread) {
            try {
                Thread.sleep(timerCallbackDelay);
                HardwareInterface hardwareInterface = this;
                synchronized (hardwareInterface) {
                    killTimerThread = true;
                    try {
                        this.timerCallback();
                    }
                    catch (Exception userError) {
                        userError.printStackTrace();
                        this.stopMonitoring();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void startMonitoring() {
        if (monitoringState) return;
        monitoringState = true;
        try {
            int p = 0;
            while (true) {
                if (p >= 3) {
                    Thread.sleep(1000L);
                    Object board = new InterfaceBoard(this);
                    ((InterfaceKitPhidget)this.phidget[0]).addInputChangeListener((InputChangeListener)board);
                    ((InterfaceKitPhidget)this.phidget[0]).addOutputChangeListener((OutputChangeListener)board);
                    ((InterfaceKitPhidget)this.phidget[0]).addSensorChangeListener((SensorChangeListener)board);
                    board = new ServoBoard(this);
                    ((AdvancedServoPhidget)this.phidget[1]).addServoPositionChangeListener((ServoPositionChangeListener)board);
                    ((AdvancedServoPhidget)this.phidget[1]).addServoVelocityChangeListener((ServoVelocityChangeListener)board);
                    ((AdvancedServoPhidget)this.phidget[1]).addCurrentChangeListener((CurrentChangeListener)board);
                    board = new RFIDBoard(this);
                    ((RFIDPhidget)this.phidget[2]).addOutputChangeListener((OutputChangeListener)board);
                    ((RFIDPhidget)this.phidget[2]).addTagGainListener((TagGainListener)board);
                    ((RFIDPhidget)this.phidget[2]).addTagLossListener((TagLossListener)board);
                    break;
                }
                this.phidget[p].openAny();
                ++p;
            }
        }
        catch (Exception err) {
            System.out.println("Could not monitor the hardware: " + err);
            System.exit(-1);
        }
        if (this.debug) {
            System.out.println("Hardware monitoring started.");
        }
        Object object = eLock;
        synchronized (object) {
            while (true) {
                if (!monitoringState) {
                    return;
                }
                try {
                    eLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stopMonitoring() {
        if (monitoringState) {
            monitoringState = false;
            killTimerThread = true;
            Object object = eLock;
            synchronized (object) {
                eLock.notifyAll();
            }
            if (this.debug) {
                System.out.println("Hardware monitoring stopped.");
            }
            ToolBox.sleep(2000L);
            System.exit(0);
            try {
                int p = 0;
                while (p < 3) {
                    this.phidget[p].close();
                    ++p;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

