/*
 * Decompiled with CFR 0.152.
 */
package c4e.media;

import java.awt.image.BufferedImage;
import org.bytedeco.javacpp.helper.opencv_core;
import org.bytedeco.javacpp.opencv_core;
import org.bytedeco.javacv.CanvasFrame;
import org.bytedeco.javacv.OpenCVFrameGrabber;

public class Video {
    private OpenCVFrameGrabber grabber;

    public Video(int n) throws Exception {
        this.grabber = new OpenCVFrameGrabber(n);
        this.grabber.start();
    }

    public void play() throws Exception {
        opencv_core.IplImage frame = this.grabber.grab();
        CanvasFrame canvasFrame = new CanvasFrame("C4E Camera Window");
        canvasFrame.setCanvasSize(frame.width(), frame.height());
        canvasFrame.setDefaultCloseOperation(2);
        while (canvasFrame != null && canvasFrame.isVisible() && (frame = this.grabber.grab()) != null) {
            canvasFrame.showImage((opencv_core.AbstractArray)frame);
        }
    }

    public void stop() throws Exception {
        this.grabber.stop();
    }

    public BufferedImage getFrameAsImage() throws Exception {
        opencv_core.IplImage img = this.grabber.grab();
        BufferedImage result = null;
        if (img != null) {
            result = img.getBufferedImage();
        }
        return result;
    }

    public int[][][] getFrameAsArray() throws Exception {
        int[][][] result = null;
        BufferedImage image = this.getFrameAsImage();
        if (image != null) {
            result = new int[image.getHeight()][image.getWidth()][3];
            int y = 0;
            while (y < image.getHeight()) {
                int x = 0;
                while (x < image.getWidth()) {
                    int clr = image.getRGB(x, y);
                    result[y][x][0] = (clr & 0xFF0000) >> 16;
                    result[y][x][1] = (clr & 0xFF00) >> 8;
                    result[y][x][2] = clr & 0xFF;
                    ++x;
                }
                ++y;
            }
        }
        return result;
    }

    protected void finalize() throws Throwable {
        this.stop();
        super.finalize();
    }

    public static void main(String[] args) throws Exception {
        Video clip = new Video(0);
        BufferedImage image = clip.getFrameAsImage();
        System.out.println(image);
        int[][][] r = clip.getFrameAsArray();
        System.out.println(r.length);
        System.out.println(r[0].length);
        System.out.println(r[0][0].length);
        System.out.println(String.valueOf(r[0][0][0]) + "," + r[0][0][1] + "," + r[0][0][2]);
        System.out.println(String.valueOf(r[0][1][0]) + "," + r[0][1][1] + "," + r[0][1][2]);
        System.out.println(String.valueOf(r[1][0][0]) + "," + r[1][0][1] + "," + r[1][0][2]);
        clip.stop();
    }
}

