/*
 * Decompiled with CFR 0.152.
 */
package c4e.media;

import java.nio.ByteBuffer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;

public class ToneEmitter
implements Runnable {
    public static final double NOTE_G_BELOW_C = 196.0;
    public static final double NOTE_A = 220.0;
    public static final double NOTE_ASHARP = 233.0;
    public static final double NOTE_B = 247.0;
    public static final double NOTE_C = 262.0;
    public static final double NOTE_CSHARP = 277.0;
    public static final double NOTE_D = 294.0;
    public static final double NOTE_DSHARP = 311.0;
    public static final double NOTE_E = 330.0;
    public static final double NOTE_F = 349.0;
    public static final double NOTE_FSHARP = 370.0;
    public static final double NOTE_G = 392.0;
    public static final double NOTE_GSHARP = 415.0;
    private double volume = 0.0;
    private double frequency = 261.0;
    public static final int SAMPLING_RATE = 44100;
    public static final int SAMPLE_SIZE = 2;
    public static final double BUFFER_DURATION = 0.025;
    public static final int SINE_PACKET_SIZE = 2207;
    private double fCyclePosition = 0.0;
    private SourceDataLine line = null;
    private ByteBuffer cBuf;
    private boolean alive = true;
    private Thread player = null;

    public ToneEmitter() {
        try {
            AudioFormat format = new AudioFormat(44100.0f, 16, 1, true, true);
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, format, 4414);
            Mixer.Info[] mixerInfo = AudioSystem.getMixerInfo();
            this.line = null;
            int i = 0;
            while (i < mixerInfo.length) {
                Mixer mix = AudioSystem.getMixer(mixerInfo[i]);
                if (!mixerInfo[i].getName().startsWith("default") && mix.isLineSupported(info)) {
                    this.line = (SourceDataLine)mix.getLine(info);
                    break;
                }
                ++i;
            }
            if (this.line == null) {
                throw new LineUnavailableException();
            }
            this.line.open(format);
            this.line.start();
        }
        catch (LineUnavailableException e) {
            throw new RuntimeException("No suitable audio device available");
        }
        this.cBuf = ByteBuffer.allocate(2207);
        this.player = new Thread(this);
        this.player.start();
    }

    public void setFrequency(double frequency) {
        if (frequency <= 0.0) {
            throw new RuntimeException("setFrequency: frequency must be >= 0");
        }
        this.frequency = frequency;
    }

    public double getFrequency() {
        return this.frequency;
    }

    public void setVolume(double volume) {
        if (volume < 0.0 || volume > 1.0) {
            throw new RuntimeException("setVolume: volume must be in the range 0..1");
        }
        this.volume = volume;
    }

    public double getVolume() {
        return this.volume;
    }

    public void shutdown() {
        this.setVolume(0.0);
        this.play(262.0, 1.0);
        this.alive = false;
        try {
            this.player.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void play(double note) {
        this.play(note, 1.0);
    }

    public void play(double note, double duration) {
        this.setFrequency(note);
        try {
            Thread.sleep((int)(duration * 1000.0));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        while (this.alive) {
            double fCycleInc = this.frequency / 44100.0;
            this.cBuf.clear();
            int i = 0;
            while (i < 1103) {
                this.cBuf.putShort((short)(32767.0 * this.volume * Math.sin(Math.PI * 2 * this.fCyclePosition)));
                this.fCyclePosition += fCycleInc;
                if (this.fCyclePosition > 1.0) {
                    this.fCyclePosition -= 1.0;
                }
                ++i;
            }
            this.line.write(this.cBuf.array(), 0, this.cBuf.position());
            try {
                while (this.line.getBufferSize() - this.line.available() > 2207) {
                    Thread.sleep(1L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.line.stop();
    }

    public static void main(String[] args) {
        ToneEmitter emitter = new ToneEmitter();
        emitter.setVolume(0.5);
        emitter.play(247.0);
        emitter.play(220.0);
        emitter.play(196.0);
        emitter.play(220.0);
        emitter.play(247.0);
        emitter.play(247.0);
        emitter.play(247.0);
        emitter.play(220.0);
        emitter.play(220.0);
        emitter.play(220.0);
        emitter.play(247.0);
        emitter.play(294.0);
        emitter.play(294.0);
        emitter.shutdown();
    }
}

