/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions;

import java.io.File;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.Util;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions.Messages;
import org.eclipse.equinox.internal.provisional.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningAction;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.osgi.util.NLS;

public class MarkStartedAction
extends ProvisioningAction {
    public static final String ID = "markStarted";

    public IStatus execute(Map parameters) {
        IProfile profile = (IProfile)parameters.get("profile");
        Manipulator manipulator = (Manipulator)parameters.get("manipulator");
        IInstallableUnit iu = (IInstallableUnit)parameters.get("iu");
        String started = (String)parameters.get("started");
        if (started == null) {
            return Util.createError(NLS.bind((String)Messages.parameter_not_set, (Object)"started", (Object)ID));
        }
        IArtifactKey[] artifacts = iu.getArtifacts();
        if (artifacts == null || artifacts.length == 0) {
            return Util.createError(NLS.bind((String)Messages.iu_contains_no_arifacts, (Object)iu));
        }
        IArtifactKey artifactKey = artifacts[0];
        File bundleFile = Util.getArtifactFile(artifactKey, profile);
        String manifest = Util.getManifest(iu.getTouchpointData());
        if (manifest == null) {
            return Util.createError(NLS.bind((String)Messages.missing_manifest, (Object)iu));
        }
        BundleInfo bundleInfo = Util.createBundleInfo(bundleFile, manifest);
        if (bundleInfo == null) {
            return Util.createError(NLS.bind((String)Messages.failed_bundleinfo, (Object)iu));
        }
        if (bundleInfo.getFragmentHost() != null) {
            return Status.OK_STATUS;
        }
        BundleInfo[] bundles = manipulator.getConfigData().getBundles();
        int i = 0;
        while (i < bundles.length) {
            if (bundles[i].equals((Object)bundleInfo)) {
                this.getMemento().put("previousStarted", (Object)new Boolean(bundles[i].isMarkedAsStarted()));
                bundles[i].setMarkedAsStarted(Boolean.valueOf(started).booleanValue());
                break;
            }
            ++i;
        }
        return Status.OK_STATUS;
    }

    public IStatus undo(Map parameters) {
        Boolean previousStarted = (Boolean)this.getMemento().get("previousStarted");
        if (previousStarted == null) {
            return Status.OK_STATUS;
        }
        IProfile profile = (IProfile)parameters.get("profile");
        Manipulator manipulator = (Manipulator)parameters.get("manipulator");
        IInstallableUnit iu = (IInstallableUnit)parameters.get("iu");
        IArtifactKey[] artifacts = iu.getArtifacts();
        if (artifacts == null || artifacts.length == 0) {
            return Util.createError(NLS.bind((String)Messages.iu_contains_no_arifacts, (Object)iu));
        }
        IArtifactKey artifactKey = artifacts[0];
        File bundleFile = Util.getArtifactFile(artifactKey, profile);
        String manifest = Util.getManifest(iu.getTouchpointData());
        if (manifest == null) {
            return Util.createError(NLS.bind((String)Messages.missing_manifest, (Object)iu));
        }
        BundleInfo bundleInfo = Util.createBundleInfo(bundleFile, manifest);
        if (bundleInfo == null) {
            return Util.createError(NLS.bind((String)Messages.failed_bundleinfo, (Object)iu));
        }
        BundleInfo[] bundles = manipulator.getConfigData().getBundles();
        int i = 0;
        while (i < bundles.length) {
            if (bundles[i].equals((Object)bundleInfo)) {
                bundles[i].setMarkedAsStarted(previousStarted.booleanValue());
                break;
            }
            ++i;
        }
        return Status.OK_STATUS;
    }
}

