/*
 * Decompiled with CFR 0.152.
 */
package net.rim.compress;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.rim.compress.YKContextException;
import net.rim.compress.YKEncode;
import net.rim.compress.YKEncodeOption;
import net.rim.compress.YKInteractiveNotAllowedException;
import net.rim.compress.YKInvalidSideDataException;
import net.rim.compress.YKSideDataOverflowException;
import net.rim.compress.YKSideDataUnderflowException;
import net.rim.compress.YKStatistics;

public class YKOutputStream
extends OutputStream {
    protected OutputStream _outputStream;
    protected YKEncode _encoder;

    protected YKOutputStream() {
        this._encoder = new YKEncode();
    }

    public YKOutputStream(OutputStream outputStream) {
        if (outputStream == null) {
            throw new IllegalArgumentException();
        }
        this._outputStream = outputStream;
        this._encoder = new YKEncode();
    }

    public void setEncodeOption(YKEncodeOption yKEncodeOption) throws IOException {
        if (this._outputStream == null) {
            throw new IOException("setEncodeOption error (closed)");
        }
        this._encoder.setEncodeOption(yKEncodeOption.getOption(), yKEncodeOption.getValue());
    }

    public int getCodecVersion() {
        return YKEncode.getCodecVersion();
    }

    public boolean setCodecVersion(int n) {
        return this._encoder.setCodecVersion(n) != 0;
    }

    public synchronized void write(int n) throws IOException {
        if (this._outputStream == null) {
            throw new IOException("Write error (closed)");
        }
        try {
            byte[] byArray = new byte[]{(byte)n};
            byte[] byArray2 = this._encoder.encode(byArray, 0, 1);
            if (byArray2 != null) {
                this._outputStream.write(byArray2);
            }
        }
        catch (YKSideDataUnderflowException yKSideDataUnderflowException) {
            throw (IOException)new IOException().initCause(yKSideDataUnderflowException);
        }
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IllegalArgumentException();
        }
        if (this._outputStream == null) {
            throw new IOException("Write error (closed)");
        }
        if (n2 == 0) {
            return;
        }
        try {
            byte[] byArray2 = this._encoder.encode(byArray, n, n2);
            if (byArray2 != null) {
                this._outputStream.write(byArray2);
            }
        }
        catch (YKSideDataUnderflowException yKSideDataUnderflowException) {
            throw (IOException)new IOException().initCause(yKSideDataUnderflowException);
        }
    }

    public boolean isGrammarInterrupt() throws IOException {
        if (this._outputStream == null) {
            throw new IOException("isGrammarInterrupt error (closed)");
        }
        return this._encoder.getGrammarInterrupt();
    }

    public synchronized void resetGrammar() throws IOException {
        if (this._outputStream == null) {
            throw new IOException("resetGrammar error (closed)");
        }
        this._encoder.resetGrammar();
    }

    public synchronized void useStaticGrammar() throws IOException {
        if (this._outputStream == null) {
            throw new IOException("useStaticGrammar error (closed)");
        }
        this._encoder.useStaticGrammar();
    }

    public boolean getPassthroughMode() throws IOException {
        if (this._outputStream == null) {
            throw new IOException("getPassthroughMode error (closed)");
        }
        return this._encoder.getPassthroughMode();
    }

    public void setPassthroughMode(boolean bl) throws IOException {
        if (this._outputStream == null) {
            throw new IOException("setPassthroughMode error (closed)");
        }
        if (this._encoder.getPassthroughMode() != bl) {
            byte[] byArray = this._encoder.flush();
            if (byArray != null) {
                this._outputStream.write(byArray);
            }
            this._encoder.setPassthroughMode(bl);
        }
    }

    public synchronized void loadContextMap(byte[] byArray, boolean bl) throws IOException {
        if (this._outputStream == null) {
            throw new IOException("loadContextMap error (closed)");
        }
        try {
            this._encoder.loadContextMap(byArray, bl);
        }
        catch (YKContextException yKContextException) {
            throw (IOException)new IOException().initCause(yKContextException);
        }
    }

    public synchronized void loadSideData(InputStream inputStream) throws IOException {
        try {
            byte[] byArray = new byte[4096];
            int n = inputStream.read(byArray);
            while (n >= 0) {
                if (n > 0) {
                    this._encoder.loadSideData(byArray, 0, n);
                }
                n = inputStream.read(byArray);
            }
        }
        catch (YKInteractiveNotAllowedException yKInteractiveNotAllowedException) {
            throw (IOException)new IOException().initCause(yKInteractiveNotAllowedException);
        }
        catch (YKSideDataOverflowException yKSideDataOverflowException) {
            throw (IOException)new IOException().initCause(yKSideDataOverflowException);
        }
        catch (YKInvalidSideDataException yKInvalidSideDataException) {
            throw (IOException)new IOException().initCause(yKInvalidSideDataException);
        }
    }

    public void flush() throws IOException {
        if (this._outputStream == null) {
            throw new IOException("Flush error (closed)");
        }
        byte[] byArray = this._encoder.flush();
        if (byArray != null) {
            this._outputStream.write(byArray);
        }
        this._outputStream.flush();
    }

    public void close(boolean bl) throws IOException {
        if (this._outputStream == null) {
            throw new IOException("close error (closed)");
        }
        byte[] byArray = this._encoder.uninit();
        this._encoder = null;
        if (byArray != null) {
            this._outputStream.write(byArray);
        }
        if (bl) {
            this._outputStream.close();
        }
        this._outputStream = null;
    }

    public void close() throws IOException {
        this.close(true);
    }

    public YKStatistics getStatistics() throws IOException {
        if (this._outputStream == null) {
            throw new IOException("getStatistics error (closed)");
        }
        return this._encoder.getStatistics();
    }

    private static void usage() {
        System.out.println("YKOutputStream -o outfilename [-t sidedatafilename] [-c|-p infilename]+ [-s]");
        System.out.println("  -c - compress infilename");
        System.out.println("  -p - pass infilename through unchanged");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static void main(String[] var0) throws IOException {
        block32: {
            var1_1 = 12000;
            var2_2 = null;
            var3_3 = false;
            System.loadLibrary("yk");
lbl5:
            // 3 sources

            try {
                for (var4_4 = 0; var4_4 < var0.length; ++var4_4) {
                    block34: {
                        block33: {
                            if (!var0[var4_4].equals("-c")) break block33;
                            if (++var4_4 >= var0.length) {
                                System.out.println("-c file name missing.");
                                YKOutputStream.usage();
                                return;
                            }
                            if (var2_2 == null) {
                                System.out.println("-o must be specified before -c or -p.");
                                YKOutputStream.usage();
                                return;
                            }
                            var2_2.setPassthroughMode(false);
                            var5_6 /* !! */  = new byte[var1_1];
                            var6_7 = new FileInputStream(var0[var4_4]);
                            while ((var7_8 = var6_7.read(var5_6 /* !! */ )) >= 0) {
                                var2_2.write(var5_6 /* !! */ , 0, var7_8);
                                while (var2_2.isGrammarInterrupt()) {
                                    var2_2.resetGrammar();
                                    var2_2.write(var5_6 /* !! */ , 0, var7_8);
                                }
                            }
                            ** GOTO lbl5
                        }
                        if (!var0[var4_4].equals("-p")) break block34;
                        if (++var4_4 >= var0.length) {
                            System.out.println("-p file name missing.");
                            YKOutputStream.usage();
                            return;
                        }
                        if (var2_2 == null) {
                            System.out.println("-o must be specified before -c or -p.");
                            YKOutputStream.usage();
                            return;
                        }
                        var2_2.setPassthroughMode(true);
                        var5_6 /* !! */  = new byte[var1_1];
                        var6_7 = new FileInputStream(var0[var4_4]);
                        while ((var7_8 = var6_7.read(var5_6 /* !! */ )) >= 0) {
                            var2_2.write(var5_6 /* !! */ , 0, var7_8);
                        }
                        ** GOTO lbl5
                    }
                    if (var0[var4_4].equals("-o")) {
                        if (++var4_4 >= var0.length) {
                            System.out.println("-o file name missing.");
                            YKOutputStream.usage();
                            return;
                        }
                        if (var2_2 != null) {
                            System.out.println("-o may only be specified once.");
                            YKOutputStream.usage();
                            return;
                        }
                        var2_2 = new YKOutputStream(new FileOutputStream(var0[var4_4]));
                        var2_2.setEncodeOption(new YKEncodeOption(1, 2));
                        var2_2.setEncodeOption(new YKEncodeOption(0, 256));
                        continue;
                    }
                    if (var0[var4_4].equals("-t")) {
                        if (++var4_4 >= var0.length) {
                            System.out.println("-t file name missing.");
                            YKOutputStream.usage();
                            return;
                        }
                        if (var2_2 == null) {
                            System.out.println("-o must be specified before -t.");
                            YKOutputStream.usage();
                            return;
                        }
                        var5_6 /* !! */  = (byte[])new FileInputStream(var0[var4_4]);
                        var2_2.loadSideData((InputStream)var5_6 /* !! */ );
                        continue;
                    }
                    if (var0[var4_4].equals("-s")) {
                        var3_3 = true;
                        continue;
                    }
                    System.out.println("Unknown option " + var0[var4_4] + ".");
                    YKOutputStream.usage();
                    return;
                }
                if (var2_2 == null || !var3_3) break block32;
                var2_2.setPassthroughMode(var2_2.getPassthroughMode() == false);
                var4_5 = var2_2.getStatistics();
                if (var4_5 != null) {
                    try {
                        System.out.println("S0 (start symbol) length: " + var4_5.getStartSymbolLength());
                        System.out.println("S0 (start symbol) null count: " + var4_5.getStartSymbolNullCount());
                        System.out.println("Symbol count: " + var4_5.getSymbolCount());
                        System.out.println("Shortest symbol length: " + var4_5.getShortestSymbolLength());
                        System.out.println("Longest symbol length: " + var4_5.getLongestSymbolLength());
                        System.out.println("Mean symbol length: " + var4_5.getMeanSymbolLength());
                        System.out.println("Input byte count: " + var4_5.getInputByteCount());
                        System.out.println("Output byte count: " + var4_5.getOutputByteCount());
                        System.out.println("YK encoded input byte count: " + (var4_5.getInputByteCount() - var4_5.getPassthroughByteCount()));
                        System.out.println("YK encoded output byte count: " + var4_5.getYKEncodedByteCount());
                        System.out.println("Passthrough byte count: " + var4_5.getPassthroughByteCount());
                        break block32;
                    }
                    finally {
                        var4_5.dispose();
                    }
                }
                System.out.println("No statistics available");
            }
            finally {
                if (var2_2 != null) {
                    var2_2.close();
                }
            }
        }
    }
}

